/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.setupPy.SetupTask;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SetupTaskDialog
extends DialogWrapper {
    private static final String CARD_OPTIONS = "Options";
    private static final String CARD_COMMAND_LINE = "CommandLine";
    private static final String CURRENT_CARD_PROPERTY = "SetupTaskDialog.currentCard";
    private String myCurrentCard;
    private final JPanel myMainPanel;
    private final JButton myExpandCollapseButton;
    private final JPanel myOptionsPanel;
    private final Map<SetupTask.Option, JComponent> myOptionComponents = new LinkedHashMap<SetupTask.Option, JComponent>();
    private final JTextField myCommandLineField;
    private final LabeledComponent<JTextField> myCommandLinePanel;

    protected SetupTaskDialog(Project project, String taskName, List<SetupTask.Option> options) {
        super(project, true);
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myOptionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 4, 4);
        for (SetupTask.Option option : options) {
            if (option.checkbox) continue;
            this.addComponent(constraints, option);
        }
        for (SetupTask.Option option : options) {
            if (!option.checkbox) continue;
            this.addComponent(constraints, option);
        }
        this.myCommandLineField = new JTextField(50);
        this.myCommandLinePanel = LabeledComponent.create((JComponent)this.myCommandLineField, (String)PyBundle.message("python.packaging.command.line", new Object[0]));
        this.myExpandCollapseButton = new JButton(PyBundle.message("python.packaging.collapse.options", new Object[0]));
        this.myExpandCollapseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SetupTaskDialog.this.myCurrentCard.equals(SetupTaskDialog.CARD_OPTIONS)) {
                    SetupTaskDialog.this.showCommandLine();
                } else {
                    SetupTaskDialog.this.showOptions();
                }
                SetupTaskDialog.this.pack();
            }
        });
        this.myMainPanel.add((Component)this.myExpandCollapseButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(8, 0, 0, 0), 0, 0));
        if (CARD_OPTIONS.equals(PropertiesComponent.getInstance().getValue(CURRENT_CARD_PROPERTY))) {
            this.showOptions();
        } else {
            this.showCommandLine();
        }
        this.init();
        this.setTitle(PyBundle.message("python.packaging.run.setup.task.0", taskName));
    }

    private void showOptions() {
        this.myCurrentCard = CARD_OPTIONS;
        this.myMainPanel.remove((Component)this.myCommandLinePanel);
        this.myMainPanel.add((Component)this.myOptionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 4, 4));
        this.myExpandCollapseButton.setText(PyBundle.message("python.packaging.collapse.options", new Object[0]));
    }

    private void showCommandLine() {
        this.myCurrentCard = CARD_COMMAND_LINE;
        this.myMainPanel.remove(this.myOptionsPanel);
        this.myMainPanel.add((Component)this.myCommandLinePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 4, 4));
        this.myCommandLineField.setText(StringUtil.join(this.getCommandLine(), (String)" "));
        this.myExpandCollapseButton.setText(PyBundle.message("python.packaging.expand.options", new Object[0]));
    }

    private void addComponent(GridBagConstraints constraints, SetupTask.Option option) {
        JComponent component = SetupTaskDialog.createOptionComponent(option);
        this.myOptionsPanel.add((Component)component, constraints);
        this.myOptionComponents.put(option, component);
        ++constraints.gridy;
    }

    private static JComponent createOptionComponent(SetupTask.Option option) {
        if (option.checkbox) {
            return new JCheckBox(option.description, option.negative);
        }
        return LabeledComponent.create((JComponent)new JTextField(50), (String)option.description);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myCurrentCard.equals(CARD_OPTIONS)) {
            if (!this.myOptionComponents.isEmpty()) {
                JComponent component = this.myOptionComponents.values().iterator().next();
                return component instanceof LabeledComponent ? ((LabeledComponent)component).getComponent() : component;
            }
            return super.getPreferredFocusedComponent();
        }
        return this.myCommandLineField;
    }

    public List<String> getCommandLine() {
        if (this.myCurrentCard.equals(CARD_COMMAND_LINE)) {
            return StringUtil.split((String)this.myCommandLineField.getText(), (String)" ");
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (Map.Entry<SetupTask.Option, JComponent> entry : this.myOptionComponents.entrySet()) {
            SetupTask.Option option = entry.getKey();
            if (option.checkbox) {
                JCheckBox checkBox = (JCheckBox)entry.getValue();
                if (checkBox.isSelected() == option.negative) continue;
                result2.add("--" + option.name);
                continue;
            }
            LabeledComponent textField = (LabeledComponent)entry.getValue();
            String text = ((JTextField)textField.getComponent()).getText();
            if (text.isEmpty()) continue;
            result2.add("--" + option.name + text);
        }
        return result2;
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue(CURRENT_CARD_PROPERTY, this.myCurrentCard);
        super.doOKAction();
    }
}

