/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TerminalWidgetKt;
import com.jediterm.terminal.ui.TerminalWidgetListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

@ApiStatus.Internal
public final class ClassicTerminalSessionEditor
extends UserDataHolderBase
implements FileEditor {
    private static final Logger LOG = Logger.getInstance(ClassicTerminalSessionEditor.class);
    private final Project myProject;
    private final TerminalSessionVirtualFileImpl myFile;
    private final TerminalWidgetListener myListener;
    private final Disposable myWidgetParentDisposable;

    public ClassicTerminalSessionEditor(final Project project, final @NotNull TerminalSessionVirtualFileImpl terminalFile) {
        if (terminalFile == null) {
            ClassicTerminalSessionEditor.$$$reportNull$$$0(0);
        }
        this.myWidgetParentDisposable = Disposer.newDisposable((String)"terminal widget parent");
        this.myProject = project;
        this.myFile = terminalFile;
        TerminalWidgetKt.setNewParentDisposable((TerminalWidget)terminalFile.getTerminalWidget(), (Disposable)this.myWidgetParentDisposable);
        this.myListener = widget -> ApplicationManager.getApplication().invokeLater(() -> FileEditorManagerEx.getInstanceEx((Project)this.myProject).closeFile((VirtualFile)this.myFile), this.myProject.getDisposed());
        JBTerminalWidget termWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)this.myFile.getTerminalWidget());
        if (termWidget != null) {
            termWidget.addListener(this.myListener);
        }
        terminalFile.getTerminalWidget().getTerminalTitle().addTitleListener(new TerminalTitleListener(){

            public void onTitleChanged(@NotNull TerminalTitle terminalTitle) {
                if (terminalTitle == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    terminalFile.rename(null, terminalTitle.buildTitle());
                }
                catch (IOException exception) {
                    throw new RuntimeException("Cannot rename");
                }
                FileEditorManager.getInstance((Project)project).updateFilePresentation((VirtualFile)terminalFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalTitle", "org/jetbrains/plugins/terminal/vfs/ClassicTerminalSessionEditor$1", "onTitleChanged"));
            }
        }, (Disposable)this);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myFile.getTerminalWidget().getComponent();
        if (jComponent == null) {
            ClassicTerminalSessionEditor.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myFile.getTerminalWidget().getPreferredFocusableComponent();
        if (jComponent == null) {
            ClassicTerminalSessionEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            ClassicTerminalSessionEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            ClassicTerminalSessionEditor.$$$reportNull$$$0(4);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            ClassicTerminalSessionEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            ClassicTerminalSessionEditor.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    public VirtualFile getFile() {
        TerminalSessionVirtualFileImpl terminalSessionVirtualFileImpl = this.myFile;
        if (terminalSessionVirtualFileImpl == null) {
            ClassicTerminalSessionEditor.$$$reportNull$$$0(7);
        }
        return terminalSessionVirtualFileImpl;
    }

    public void dispose() {
        JBTerminalWidget termWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)this.myFile.getTerminalWidget());
        if (termWidget != null) {
            termWidget.removeListener(this.myListener);
        }
        if (Boolean.TRUE.equals(this.myFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
            ApplicationManager.getApplication().invokeLater(() -> {
                boolean disposedBefore = Disposer.isDisposed((Disposable)this.myFile.getTerminalWidget());
                Disposer.dispose((Disposable)this.myWidgetParentDisposable);
                boolean disposedAfter = Disposer.isDisposed((Disposable)this.myFile.getTerminalWidget());
                if (disposedBefore != disposedAfter) {
                    LOG.error(JBTerminalWidget.class.getSimpleName() + " parent disposable hasn't been changed (disposed before: " + disposedBefore + ", disposed after: " + disposedAfter + ")");
                }
            });
        } else {
            Disposer.dispose((Disposable)this.myWidgetParentDisposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/vfs/ClassicTerminalSessionEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/vfs/ClassicTerminalSessionEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7 -> new IllegalStateException(string);
        };
    }
}

