/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.peer.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.RemoteFilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class VcsContextFactoryImpl
implements VcsContextFactory {
    private static final Logger LOG = Logger.getInstance(VcsContextFactoryImpl.class);

    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile virtualFile) {
        String path;
        if (virtualFile == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(0);
        }
        if ((path = virtualFile.getPath()).isEmpty()) {
            LOG.error(new Throwable("Invalid empty file path in " + String.valueOf(virtualFile) + " (" + virtualFile.getClass().getName() + ")"));
            path = "/";
        }
        FilePath filePath = this.createFilePath(path, virtualFile.isDirectory());
        if (filePath == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(1);
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file) {
        if (file == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(2);
        }
        String path = file.getPath();
        VirtualFile vf = LocalFileSystem.getInstance().findFileByPath(path);
        FilePath filePath = this.createFilePath(path, vf != null ? vf.isDirectory() : file.isDirectory());
        if (filePath == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(3);
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file, boolean isDirectory) {
        if (file == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(4);
        }
        FilePath filePath = this.createFilePath(file.getPath(), isDirectory);
        if (filePath == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(5);
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePath(@NotNull Path file, boolean isDirectory) {
        if (file == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(6);
        }
        return new LocalFilePath(file, isDirectory);
    }

    @NotNull
    public FilePath createFilePathOnNonLocal(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(7);
        }
        return new RemoteFilePath(path, isDirectory);
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile parent, @NotNull String name) {
        if (parent == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(8);
        }
        if (name == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(9);
        }
        FilePath filePath = this.createFilePath(parent, name, false);
        if (filePath == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(10);
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePath(@NotNull VirtualFile parent, @NotNull String fileName, boolean isDirectory) {
        if (parent == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(11);
        }
        if (fileName == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(12);
        }
        FilePath filePath = this.createFilePath(parent.getPath() + "/" + fileName, isDirectory);
        if (filePath == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(13);
        }
        return filePath;
    }

    @NotNull
    public LocalChangeList createLocalChangeList(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(14);
        }
        if (name == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(15);
        }
        LocalChangeListImpl localChangeListImpl = LocalChangeListImpl.createEmptyChangeListImpl((Project)project, (String)name, null);
        if (localChangeListImpl == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(16);
        }
        return localChangeListImpl;
    }

    @NotNull
    public FilePath createFilePath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            VcsContextFactoryImpl.$$$reportNull$$$0(17);
        }
        return new LocalFilePath(path, isDirectory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 10, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/peer/impl/VcsContextFactoryImpl";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/peer/impl/VcsContextFactoryImpl";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePathOn";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFilePathOn";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFilePathOnNonLocal";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLocalChangeList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 10, 13, 16 -> new IllegalStateException(string);
        };
    }
}

