/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.nodes.util.SplitArgsNodeGen;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class SplitArgsNode
extends Node {
    public abstract Object[] execute(Node var1, Object[] var2);

    public final Object[] executeCached(Object[] varargsWitSelf) {
        return this.execute(this, varargsWitSelf);
    }

    @Specialization(guards={"varargsWithSelf.length == 1"})
    static Object[] doEmpty(Object[] varargsWithSelf) {
        return PythonUtils.EMPTY_OBJECT_ARRAY;
    }

    @Specialization(guards={"varargsWithSelf.length == cachedLen", "varargsWithSelf.length < 32"}, limit="3")
    @ExplodeLoop
    static Object[] doCached(Object[] varargsWithSelf, @Cached(value="varargsWithSelf.length") int cachedLen) {
        Object[] splitArgs = new Object[cachedLen - 1];
        for (int i = 0; i < cachedLen - 1; ++i) {
            splitArgs[i] = varargsWithSelf[i + 1];
        }
        return splitArgs;
    }

    @Specialization(replaces={"doCached"})
    static Object[] doGeneric(Object[] varargsWithSelf) {
        Object[] splitArgs = new Object[varargsWithSelf.length - 1];
        PythonUtils.arraycopy(varargsWithSelf, 1, splitArgs, 0, varargsWithSelf.length - 1);
        return splitArgs;
    }

    @NeverDefault
    public static SplitArgsNode create() {
        return SplitArgsNodeGen.create();
    }
}

