/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Properties;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespaceObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import java.util.List;
import java.util.Map;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class JSModuleNamespace
extends JSNonProxy {
    public static final JSModuleNamespace INSTANCE = new JSModuleNamespace();
    public static final JSModuleNamespace DEFERRED_INSTANCE = new JSModuleNamespace();
    public static final TruffleString TO_STRING_TAG = Strings.UC_MODULE;
    public static final TruffleString DEFERRED_TO_STRING_TAG = Strings.constant("Deferred Module");

    private JSModuleNamespace() {
    }

    public static JSModuleNamespaceObject create(JSContext context, JSRealm realm, AbstractModuleRecord module, List<Map.Entry<TruffleString, ExportResolution>> sortedExports, boolean deferred) {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap exportResolutionMap = EconomicMap.create((int)sortedExports.size());
        JSObjectFactory.BoundProto factory = context.getModuleNamespaceFactory(deferred);
        JSModuleNamespaceObject obj = JSModuleNamespaceObject.create(realm, factory, module, (UnmodifiableEconomicMap<TruffleString, ExportResolution>)exportResolutionMap, deferred);
        int propertyFlags = JSAttributes.notConfigurableEnumerableWritable() | 0x40;
        for (Map.Entry<TruffleString, ExportResolution> entry : sortedExports) {
            TruffleString key = entry.getKey();
            if (obj.isSymbolLikeNamespaceKey(key)) continue;
            ExportResolution value = entry.getValue();
            Properties.putWithFlagsUncached(obj, key, value, propertyFlags);
            exportResolutionMap.put((Object)key, (Object)value);
        }
        assert (!JSObject.isExtensible(obj));
        return context.trackAllocation(obj);
    }

    public static Shape makeInitialShape(JSContext context, boolean deferred) {
        TruffleString toStringTag = deferred ? DEFERRED_TO_STRING_TAG : TO_STRING_TAG;
        Shape initialShape = JSShape.newBuilder(context, deferred ? DEFERRED_INSTANCE : INSTANCE, Null.instance, 1).build();
        initialShape = Shape.newBuilder((Shape)initialShape).addConstantProperty((Object)JSObject.HIDDEN_PROTO, (Object)Null.instance, 0).addConstantProperty((Object)Symbol.SYMBOL_TO_STRING_TAG, (Object)toStringTag, JSAttributes.notConfigurableNotEnumerableNotWritable()).build();
        assert (!JSShape.isExtensible(initialShape));
        return initialShape;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(JSDynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        JSModuleNamespaceObject ns = (JSModuleNamespaceObject)store;
        if (ns.isSymbolLikeNamespaceKey(key)) {
            return super.getOwnHelper(store, thisObj, key, encapsulatingNode);
        }
        TruffleString name = (TruffleString)key;
        ExportResolution binding = (ExportResolution)ns.getModuleExportsList().get((Object)name);
        if (binding != null) {
            return JSModuleNamespace.getBindingValue(binding);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getBindingValue(ExportResolution binding) {
        int slot;
        TruffleString bindingName = binding.getBindingName();
        AbstractModuleRecord targetModule = binding.getModule();
        MaterializedFrame targetEnv = targetModule.getEnvironment();
        if (targetEnv == null) {
            throw Errors.createReferenceErrorNotDefined(bindingName, null);
        }
        if (binding.isNamespace()) {
            return targetModule.getModuleNamespace(Module.ImportPhase.Evaluation);
        }
        FrameDescriptor targetEnvDesc = targetEnv.getFrameDescriptor();
        if (JSFrameUtil.hasTemporalDeadZone(targetEnvDesc, slot = JSFrameUtil.findRequiredFrameSlotIndex(targetEnvDesc, bindingName)) && targetEnv.getTag(slot) == FrameSlotKind.Illegal.tag) {
            throw Errors.createReferenceErrorNotDefined(bindingName, null);
        }
        Object value = targetEnv.getValue(slot);
        assert (!(value instanceof ExportResolution)) : value;
        return value;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(JSDynamicObject thisObj, Object key) {
        JSModuleNamespaceObject ns = (JSModuleNamespaceObject)thisObj;
        if (ns.isSymbolLikeNamespaceKey(key)) {
            return super.hasProperty(thisObj, key);
        }
        TruffleString name = (TruffleString)key;
        return ns.getModuleExportsList().containsKey((Object)name);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(JSDynamicObject thisObj, Object key) {
        JSModuleNamespaceObject ns = (JSModuleNamespaceObject)thisObj;
        if (ns.isSymbolLikeNamespaceKey(key)) {
            return super.hasOwnProperty(thisObj, key);
        }
        TruffleString name = (TruffleString)key;
        ExportResolution binding = (ExportResolution)ns.getModuleExportsList().get((Object)name);
        if (binding != null) {
            JSModuleNamespace.getBindingValue(binding);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(JSDynamicObject thisObj, long index, boolean isStrict) {
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(JSDynamicObject thisObj, Object key, boolean isStrict) {
        JSModuleNamespaceObject ns = (JSModuleNamespaceObject)thisObj;
        if (ns.isSymbolLikeNamespaceKey(key)) {
            return super.delete(thisObj, key, isStrict);
        }
        TruffleString name = (TruffleString)key;
        if (ns.getModuleExportsList().containsKey((Object)name)) {
            if (isStrict) {
                throw Errors.createTypeErrorNotConfigurableProperty(key);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean setPrototypeOf(JSDynamicObject thisObj, JSDynamicObject newPrototype) {
        return newPrototype == Null.instance;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean defineOwnProperty(JSDynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        JSModuleNamespaceObject ns = (JSModuleNamespaceObject)thisObj;
        if (ns.isSymbolLikeNamespaceKey(key)) {
            return super.defineOwnProperty(thisObj, key, desc, doThrow);
        }
        PropertyDescriptor current = this.getOwnProperty(thisObj, key);
        if (current != null && !desc.isAccessorDescriptor() && desc.getIfHasWritable(true) && desc.getIfHasEnumerable(true) && !desc.getIfHasConfigurable(false) && (!desc.hasValue() || JSRuntime.isSameValue(desc.getValue(), current.getValue()))) {
            return true;
        }
        return DefinePropertyUtil.reject(doThrow, "not allowed to defineProperty on a namespace object");
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(JSDynamicObject thisObj, Object key) {
        JSModuleNamespaceObject ns = (JSModuleNamespaceObject)thisObj;
        if (ns.isSymbolLikeNamespaceKey(key)) {
            return super.getOwnProperty(thisObj, key);
        }
        TruffleString name = (TruffleString)key;
        ExportResolution binding = (ExportResolution)ns.getModuleExportsList().get((Object)name);
        if (binding != null) {
            Object value = JSModuleNamespace.getBindingValue(binding);
            return PropertyDescriptor.createData(value, true, true, false);
        }
        return null;
    }

    public static boolean isJSModuleNamespace(Object obj) {
        return obj instanceof JSModuleNamespaceObject;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(JSDynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        if (isStrict) {
            throw Errors.createTypeErrorNotExtensible(thisObj, key);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(JSDynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        if (isStrict) {
            throw Errors.createTypeErrorNotExtensible(thisObj, Strings.fromLong(index));
        }
        return false;
    }

    @Override
    public List<Object> getOwnPropertyKeys(JSDynamicObject thisObj, boolean strings, boolean symbols) {
        JSModuleNamespaceObject ns = (JSModuleNamespaceObject)thisObj;
        ns.getModuleExportsList();
        return super.getOwnPropertyKeys(thisObj, strings, symbols);
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }
}

