/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import us.fatehi.utility.property.AbstractProperty;
import us.fatehi.utility.property.Property;
import us.fatehi.utility.property.PropertyName;

class ImmutableDatabaseProperty
extends AbstractProperty {
    private static final long serialVersionUID = -7150431683440256142L;
    private static final Comparator<Property> comparator = Comparator.nullsLast(Comparator.comparing(Property::getDescription, String.CASE_INSENSITIVE_ORDER));
    private static final Set<Map.Entry<Pattern, String>> acronyms;

    private static String buildDescription(String name) {
        String description = name;
        String get = "get";
        if (description.startsWith("get")) {
            description = description.substring("get".length());
        }
        for (Map.Entry<Pattern, String> acronym : acronyms) {
            String lowerCaseAcronymAsWord = " " + acronym.getValue().toLowerCase();
            description = acronym.getKey().matcher(description).replaceAll(lowerCaseAcronymAsWord);
        }
        int strLen = description.length();
        StringBuilder buffer = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char ch = description.charAt(i);
            if (Character.isUpperCase(ch)) {
                buffer.append(' ').append(Character.toLowerCase(ch));
                continue;
            }
            buffer.append(ch);
        }
        description = buffer.toString();
        for (Map.Entry<Pattern, String> acronym : acronyms) {
            description = acronym.getKey().matcher(description).replaceAll(acronym.getValue());
        }
        description = description.strip();
        return description;
    }

    ImmutableDatabaseProperty(String name, Object value) {
        super(new PropertyName(name, ImmutableDatabaseProperty.buildDescription(name)), (Serializable)value);
    }

    public int compareTo(Property otherProperty) {
        return Objects.compare(this, otherProperty, comparator);
    }

    public String toString() {
        return this.getDescription() + " = " + String.valueOf(this.getValue());
    }

    static {
        HashMap<Pattern, String> acronymsMap = new HashMap<Pattern, String>();
        List<String> acronymsList = Arrays.asList("JDBC", "ANSI", "SQL", "URL", "TYPE_FORWARD_ONLY", "TYPE_SCROLL_INSENSITIVE", "TYPE_SCROLL_SENSITIVE");
        for (String acronym : acronymsList) {
            Pattern pattern = Pattern.compile(acronym, 2);
            acronymsMap.put(pattern, acronym);
        }
        acronyms = Set.copyOf(acronymsMap.entrySet());
    }
}

