#ifndef UOS_RECOVERY_DIMFILETRANSTASK_H
#define UOS_RECOVERY_DIMFILETRANSTASK_H


#include "AsyncTask.h"
#include <QTimer>

class DimFileTransTask : public AsyncTask
{
    Q_OBJECT

public:
    DimFileTransTask();
    virtual ~DimFileTransTask();
    virtual bool buildArgumentsForBackup() override;
    virtual bool buildArgumentsForRestore(const QString &fromDir) override;
    virtual void doResult() override;
    bool doTrans(const QString &dimFile, const QString &destPath, const QString &loopDevice);

    // 0---读取dim文件、1---制作压缩镜像
    enum TranStep {
        ReadDimFile = 0,
        SquashfsImg
    };

signals:
    void progressChanged(const QJsonObject &value);

public slots:
    void readResultSlot();
    void taskFinishedSlot();
    virtual void readStandardOutput() override;
    virtual void readAllStandardError() override;

private:
    bool beforeReadDimFile();
    bool beforeSquashfsImgFile();
    bool afterSquashfsImgFile();

private:
    QTimer *m_readResult = nullptr;
    QString m_dimFile = "";
    QString m_imgFile = "";
    QString m_squashfsImgFile = "";
    QString m_loopDevice = "";
    QString m_loopDevMountPath = "";
    QString m_destPath = "";
    int m_currentProgressValue = 0;
    TranStep m_tranStep = ReadDimFile;
};


#endif //UOS_RECOVERY_DIMFILETRANSTASK_H
