// Code generated by "./generator ./system/org.freedesktop.policykit1"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package policykit1

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type Authority interface {
	authority // interface org.freedesktop.PolicyKit1.Authority
	proxy.Object
}

type objectAuthority struct {
	interfaceAuthority // interface org.freedesktop.PolicyKit1.Authority
	proxy.ImplObject
}

func NewAuthority(conn *dbus.Conn) Authority {
	obj := new(objectAuthority)
	obj.ImplObject.Init_(conn, "org.freedesktop.PolicyKit1", "/org/freedesktop/PolicyKit1/Authority")
	return obj
}

type authority interface {
	GoEnumerateActions(flags dbus.Flags, ch chan *dbus.Call, locale string) *dbus.Call
	EnumerateActions(flags dbus.Flags, locale string) ([]ActionDescription, error)
	GoCheckAuthorization(flags dbus.Flags, ch chan *dbus.Call, subject Subject, action_id string, details map[string]string, flags0 uint32, cancellation_id string) *dbus.Call
	CheckAuthorization(flags dbus.Flags, subject Subject, action_id string, details map[string]string, flags0 uint32, cancellation_id string) (AuthorizationResult, error)
	GoCancelCheckAuthorization(flags dbus.Flags, ch chan *dbus.Call, cancellation_id string) *dbus.Call
	CancelCheckAuthorization(flags dbus.Flags, cancellation_id string) error
	GoRegisterAuthenticationAgent(flags dbus.Flags, ch chan *dbus.Call, subject Subject, locale string, object_path string) *dbus.Call
	RegisterAuthenticationAgent(flags dbus.Flags, subject Subject, locale string, object_path string) error
	GoRegisterAuthenticationAgentWithOptions(flags dbus.Flags, ch chan *dbus.Call, subject Subject, locale string, object_path string, options map[string]dbus.Variant) *dbus.Call
	RegisterAuthenticationAgentWithOptions(flags dbus.Flags, subject Subject, locale string, object_path string, options map[string]dbus.Variant) error
	GoUnregisterAuthenticationAgent(flags dbus.Flags, ch chan *dbus.Call, subject Subject, object_path string) *dbus.Call
	UnregisterAuthenticationAgent(flags dbus.Flags, subject Subject, object_path string) error
	GoAuthenticationAgentResponse(flags dbus.Flags, ch chan *dbus.Call, cookie string, identity Identity) *dbus.Call
	AuthenticationAgentResponse(flags dbus.Flags, cookie string, identity Identity) error
	GoAuthenticationAgentResponse2(flags dbus.Flags, ch chan *dbus.Call, uid uint32, cookie string, identity Identity) *dbus.Call
	AuthenticationAgentResponse2(flags dbus.Flags, uid uint32, cookie string, identity Identity) error
	GoEnumerateTemporaryAuthorizations(flags dbus.Flags, ch chan *dbus.Call, subject Subject) *dbus.Call
	EnumerateTemporaryAuthorizations(flags dbus.Flags, subject Subject) (TemporaryAuthorization, error)
	GoRevokeTemporaryAuthorizations(flags dbus.Flags, ch chan *dbus.Call, subject Subject) *dbus.Call
	RevokeTemporaryAuthorizations(flags dbus.Flags, subject Subject) error
	GoRevokeTemporaryAuthorizationById(flags dbus.Flags, ch chan *dbus.Call, id string) *dbus.Call
	RevokeTemporaryAuthorizationById(flags dbus.Flags, id string) error
	ConnectChanged(cb func()) (dbusutil.SignalHandlerId, error)
	BackendName() proxy.PropString
	BackendVersion() proxy.PropString
	BackendFeatures() proxy.PropUint32
}

type interfaceAuthority struct{}

func (v *interfaceAuthority) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceAuthority) GetInterfaceName_() string {
	return "org.freedesktop.PolicyKit1.Authority"
}

// method EnumerateActions

func (v *interfaceAuthority) GoEnumerateActions(flags dbus.Flags, ch chan *dbus.Call, locale string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".EnumerateActions", flags, ch, locale)
}

func (*interfaceAuthority) StoreEnumerateActions(call *dbus.Call) (action_descriptions []ActionDescription, err error) {
	err = call.Store(&action_descriptions)
	return
}

func (v *interfaceAuthority) EnumerateActions(flags dbus.Flags, locale string) ([]ActionDescription, error) {
	return v.StoreEnumerateActions(
		<-v.GoEnumerateActions(flags, make(chan *dbus.Call, 1), locale).Done)
}

// method CheckAuthorization

func (v *interfaceAuthority) GoCheckAuthorization(flags dbus.Flags, ch chan *dbus.Call, subject Subject, action_id string, details map[string]string, flags0 uint32, cancellation_id string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CheckAuthorization", flags, ch, subject, action_id, details, flags0, cancellation_id)
}

func (*interfaceAuthority) StoreCheckAuthorization(call *dbus.Call) (result AuthorizationResult, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceAuthority) CheckAuthorization(flags dbus.Flags, subject Subject, action_id string, details map[string]string, flags0 uint32, cancellation_id string) (AuthorizationResult, error) {
	return v.StoreCheckAuthorization(
		<-v.GoCheckAuthorization(flags, make(chan *dbus.Call, 1), subject, action_id, details, flags0, cancellation_id).Done)
}

// method CancelCheckAuthorization

func (v *interfaceAuthority) GoCancelCheckAuthorization(flags dbus.Flags, ch chan *dbus.Call, cancellation_id string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CancelCheckAuthorization", flags, ch, cancellation_id)
}

func (v *interfaceAuthority) CancelCheckAuthorization(flags dbus.Flags, cancellation_id string) error {
	return (<-v.GoCancelCheckAuthorization(flags, make(chan *dbus.Call, 1), cancellation_id).Done).Err
}

// method RegisterAuthenticationAgent

func (v *interfaceAuthority) GoRegisterAuthenticationAgent(flags dbus.Flags, ch chan *dbus.Call, subject Subject, locale string, object_path string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterAuthenticationAgent", flags, ch, subject, locale, object_path)
}

func (v *interfaceAuthority) RegisterAuthenticationAgent(flags dbus.Flags, subject Subject, locale string, object_path string) error {
	return (<-v.GoRegisterAuthenticationAgent(flags, make(chan *dbus.Call, 1), subject, locale, object_path).Done).Err
}

// method RegisterAuthenticationAgentWithOptions

func (v *interfaceAuthority) GoRegisterAuthenticationAgentWithOptions(flags dbus.Flags, ch chan *dbus.Call, subject Subject, locale string, object_path string, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterAuthenticationAgentWithOptions", flags, ch, subject, locale, object_path, options)
}

func (v *interfaceAuthority) RegisterAuthenticationAgentWithOptions(flags dbus.Flags, subject Subject, locale string, object_path string, options map[string]dbus.Variant) error {
	return (<-v.GoRegisterAuthenticationAgentWithOptions(flags, make(chan *dbus.Call, 1), subject, locale, object_path, options).Done).Err
}

// method UnregisterAuthenticationAgent

func (v *interfaceAuthority) GoUnregisterAuthenticationAgent(flags dbus.Flags, ch chan *dbus.Call, subject Subject, object_path string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnregisterAuthenticationAgent", flags, ch, subject, object_path)
}

func (v *interfaceAuthority) UnregisterAuthenticationAgent(flags dbus.Flags, subject Subject, object_path string) error {
	return (<-v.GoUnregisterAuthenticationAgent(flags, make(chan *dbus.Call, 1), subject, object_path).Done).Err
}

// method AuthenticationAgentResponse

func (v *interfaceAuthority) GoAuthenticationAgentResponse(flags dbus.Flags, ch chan *dbus.Call, cookie string, identity Identity) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AuthenticationAgentResponse", flags, ch, cookie, identity)
}

func (v *interfaceAuthority) AuthenticationAgentResponse(flags dbus.Flags, cookie string, identity Identity) error {
	return (<-v.GoAuthenticationAgentResponse(flags, make(chan *dbus.Call, 1), cookie, identity).Done).Err
}

// method AuthenticationAgentResponse2

func (v *interfaceAuthority) GoAuthenticationAgentResponse2(flags dbus.Flags, ch chan *dbus.Call, uid uint32, cookie string, identity Identity) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AuthenticationAgentResponse2", flags, ch, uid, cookie, identity)
}

func (v *interfaceAuthority) AuthenticationAgentResponse2(flags dbus.Flags, uid uint32, cookie string, identity Identity) error {
	return (<-v.GoAuthenticationAgentResponse2(flags, make(chan *dbus.Call, 1), uid, cookie, identity).Done).Err
}

// method EnumerateTemporaryAuthorizations

func (v *interfaceAuthority) GoEnumerateTemporaryAuthorizations(flags dbus.Flags, ch chan *dbus.Call, subject Subject) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".EnumerateTemporaryAuthorizations", flags, ch, subject)
}

func (*interfaceAuthority) StoreEnumerateTemporaryAuthorizations(call *dbus.Call) (temporary_authorizations TemporaryAuthorization, err error) {
	err = call.Store(&temporary_authorizations)
	return
}

func (v *interfaceAuthority) EnumerateTemporaryAuthorizations(flags dbus.Flags, subject Subject) (TemporaryAuthorization, error) {
	return v.StoreEnumerateTemporaryAuthorizations(
		<-v.GoEnumerateTemporaryAuthorizations(flags, make(chan *dbus.Call, 1), subject).Done)
}

// method RevokeTemporaryAuthorizations

func (v *interfaceAuthority) GoRevokeTemporaryAuthorizations(flags dbus.Flags, ch chan *dbus.Call, subject Subject) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RevokeTemporaryAuthorizations", flags, ch, subject)
}

func (v *interfaceAuthority) RevokeTemporaryAuthorizations(flags dbus.Flags, subject Subject) error {
	return (<-v.GoRevokeTemporaryAuthorizations(flags, make(chan *dbus.Call, 1), subject).Done).Err
}

// method RevokeTemporaryAuthorizationById

func (v *interfaceAuthority) GoRevokeTemporaryAuthorizationById(flags dbus.Flags, ch chan *dbus.Call, id string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RevokeTemporaryAuthorizationById", flags, ch, id)
}

func (v *interfaceAuthority) RevokeTemporaryAuthorizationById(flags dbus.Flags, id string) error {
	return (<-v.GoRevokeTemporaryAuthorizationById(flags, make(chan *dbus.Call, 1), id).Done).Err
}

// signal Changed

func (v *interfaceAuthority) ConnectChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Changed", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Changed",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property BackendName s

func (v *interfaceAuthority) BackendName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "BackendName",
	}
}

// property BackendVersion s

func (v *interfaceAuthority) BackendVersion() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "BackendVersion",
	}
}

// property BackendFeatures u

func (v *interfaceAuthority) BackendFeatures() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "BackendFeatures",
	}
}
