/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.charcode.UnicodeCharacterSet;
import com.icl.saxon.output.XMLEmitter;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class TEXTEmitter
extends XMLEmitter {
    private String mediaType = "text/plain";

    public void startDocument() throws TransformerException {
        String string = this.outputProperties.getProperty("media-type");
        if (string != null) {
            this.mediaType = string;
        }
        if (this.characterSet == null) {
            this.characterSet = UnicodeCharacterSet.getInstance();
        }
        this.empty = true;
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        int n3 = n;
        while (n3 < n + n2) {
            if (!this.characterSet.inCharset(cArray[n3])) {
                throw new TransformerException("Output character not available in this encoding (decimal " + cArray[n3] + ")");
            }
            ++n3;
        }
        try {
            this.writer.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
    }

    public void endElement(int n) throws TransformerException {
    }

    public void processingInstruction(String string, String string2) throws TransformerException {
    }

    public void comment(char[] cArray, int n, int n2) throws TransformerException {
    }
}

