/* Generated by re2c */
// re2rust -W $INPUT -o $OUTPUT --no-unsafe

// This example is based on a public domain C lex grammar originally
// hosted at http://www.quut.com/c/ANSI-C-grammar-l.html
// It has, however, been significantly modified.

// A real C lexer in a modern compiler typically postprocesses a tokenization
// step performed by the preprocessor. This example isn't actually practically
// usable as-is, and would require significant work to turn into part of a real
// C compiler.

// As with the original from quut.com, this grammar presupposes translation for
// phases 1 to 5 have already been performed, though it also still handles
// comments. It does handle string concatenation though in a sort of
// half-hearted manner.

// We specify unicode here to make the code in this example more interesting.
// We use the "ignore" Unicode encoding policy (which is the default anyway)
// because the Rust input routine we use is already checking for surrogates.


use std::fmt;

// Errors type
#[derive(Debug, Clone)]
struct LexError {
    message: String,
    token_text: String,
    line: usize,
    column: usize,
}

impl fmt::Display for LexError {
    fn fmt(&self, f: &mut fmt::Formatter) -> Result<(), fmt::Error> {
        write!(f, "{}: {} ({}:{})",
            self.message, self.token_text, self.line, self.column)
    }
}

// The default definitions for the Error methods are fine.
impl std::error::Error for LexError { }

#[derive(Debug, Clone)]
#[allow(dead_code)] // silence 'field in not used' warnings
struct Position {
    // What line are we on? (starts on line 0.)
    line_num: usize,
    // What is the index of the first character on the line?
    bol: usize,
    // What is the index of the current token?
    start: usize,
    // What is the index of the end of the current token?
    end: usize,
}

// All the different kinds of tokens.
#[derive(Debug, Clone, Eq, PartialEq)]
enum TName {
    // General
    //Error(String),
    Comment,
    Whitespace,
    Newline,
    // Ids.
    Id,
    TypeId,
    EnumId,
    // Constants
    IntConst,
    FloatConst,
    StringLiteral,
    // Keywords
    Alignas,
    Alignof,
    Atomic,
    Bool,
    Complex,
    Generic,
    Imaginary,
    Noreturn,
    StaticAssert,
    ThreadLocal,
    Auto,
    Break,
    Case,
    Char,
    Const,
    Continue,
    Default,
    Do,
    Double,
    Else,
    Enum,
    Extern,
    Float,
    For,
    Goto,
    If,
    Inline,
    Int,
    Long,
    Register,
    Restrict,
    Return,
    Short,
    Signed,
    Sizeof,
    Static,
    Struct,
    Switch,
    Typedef,
    Union,
    Unsigned,
    Void,
    Volatile,
    While,
    // Punctuators
    Ellipsis,
    RSAsgn,
    LSAsgn,
    AddAsgn,
    SubAsgn,
    MulAsgn,
    DivAsgn,
    ModAsgn,
    BAndAsgn,
    BXorAsgn,
    BOrAsgn,
    RShift,
    LShift,
    Incr,
    Decr,
    Arrow,
    LAnd,
    LOr,
    LE,
    GE,
    Eq,
    NEq,
    Semi,
    OBrace,
    CBrace,
    Comma,
    Colon,
    Asgn,
    OParen,
    CParen,
    OBrack,
    CBrack,
    Dot,
    Amper,
    LNot,
    BNot,
    Sub,
    Add,
    Aster,
    Div,
    Mod,
    LT,
    GT,
    BXor,
    BOr,
    Ques,
}

#[derive(Debug, Clone)]
#[allow(dead_code)] // silence 'field in not used' warnings
struct Token {
    tname: TName,
    text: String,
    position: Position,
}

#[derive(Debug, Clone)]
enum SymType {
    #[allow(dead_code)] // silence 'variant is never constructed' warning
    TypeName,
    #[allow(dead_code)] // silence 'variant is never constructed' warning
    EnumConst,
    Identifier,
}

// C lexers (unfortunately) need information from the symbol table to return
// the correct token type, because an identifier could be a type name. (This
// ambiguity is a big source of trouble in C.) This is a fake "sym_type" that
// always returns Identifer. It needs to be fixed to actually hook into the
// parser's symbol table if this lexer is used in the real world.
fn sym_type(_ident: &str) -> SymType {
    SymType::Identifier
}

#[derive(Debug, Clone)]
struct Input {
    data: Vec<u8>,
    cursor: usize,
    token: usize,
    marker: usize,
    line: usize,
    bol: usize,
    eof: bool,
}

impl Input {
    fn new(s: String) -> Input {
        let data = s.into_bytes();
        Input {
            data: data,
            cursor: 0,
            token: 0,
            marker: 0,
            line: 0,
            bol: 0,
            eof: false,
        }
    }
    // text of the current token
    fn current_ttext(&self) -> String {
        // for maximum performance, this should actually be from_utf8_unchecked
        String::from_utf8(self.data[self.token..self.cursor].to_vec()).unwrap()
    }

    fn token(&mut self, tname: TName) -> Result<Option<Token>, LexError> {
        let text = self.current_ttext();

        let position = Position {
            line_num: self.line,
            bol: self.bol,
            start: self.token,
            end: self.cursor,
        };

        let lines = match tname {
            TName::Comment => text.lines().count() - 1,
            // We may have multiple string literals separated by
            // newlines or the like to fuse.
            TName::StringLiteral => text.lines().count() - 1,
            TName::Newline => 1,
            _ => 0,
        };

        if tname == TName::Newline {
            self.bol = self.cursor;
        } else if lines > 0 {
            // the unwrap should only fail if we have a bad bug.
            self.bol = self.data[0..self.cursor]
                .iter().rposition(|bytes| *bytes == b'\n')
                .unwrap();
        };

        self.line += lines;

        Ok(Some(Token {
            tname,
            text,
            position,
        }))
    }

    fn error(&self, s: &str) -> Result<Option<Token>, LexError> {
        Err(LexError {
            message: s.to_string(),
            token_text: self.current_ttext(),
            line: self.line,
            column: self.cursor - self.bol,
        })
    }

    // Tells us whether an identifier is a type name, an enum constant, or an
    // ordinary identifier.
    fn check_type(&mut self) -> Result<Option<Token>, LexError> {
        let text = self.current_ttext();
        match sym_type(&text) {
            SymType::TypeName   => self.token(TName::TypeId),
            SymType::EnumConst  => self.token(TName::EnumId),
            SymType::Identifier => self.token(TName::Id),
        }
    }
}

// Some of this lexer was taken from the C lex grammar at
// http://www.quut.com/c/ANSI-C-grammar-l.html
fn next_token(input: &mut Input) -> Result<Option<Token>, LexError> {
    if input.eof { return Ok(None) }

    input.token = input.cursor;
    
{
	#[allow(unused_assignments)]
	let mut yych : u8 = 0;
	let mut yyaccept : usize = 0;
	let mut yystate : usize = 0;
	'yyl: loop {
		match yystate {
			0 => {
				yych = input.data[input.cursor];
				input.cursor += 1;
				match yych {
					0x00 => {
						yystate = 1;
						continue 'yyl;
					}
					0x09 |
					0x0B ..= 0x0C |
					0x20 => {
						yystate = 4;
						continue 'yyl;
					}
					0x0A => {
						yystate = 6;
						continue 'yyl;
					}
					0x21 => {
						yystate = 7;
						continue 'yyl;
					}
					0x22 => {
						yystate = 9;
						continue 'yyl;
					}
					0x25 => {
						yystate = 11;
						continue 'yyl;
					}
					0x26 => {
						yystate = 13;
						continue 'yyl;
					}
					0x27 => {
						yystate = 15;
						continue 'yyl;
					}
					0x28 => {
						yystate = 16;
						continue 'yyl;
					}
					0x29 => {
						yystate = 17;
						continue 'yyl;
					}
					0x2A => {
						yystate = 18;
						continue 'yyl;
					}
					0x2B => {
						yystate = 20;
						continue 'yyl;
					}
					0x2C => {
						yystate = 22;
						continue 'yyl;
					}
					0x2D => {
						yystate = 23;
						continue 'yyl;
					}
					0x2E => {
						yystate = 25;
						continue 'yyl;
					}
					0x2F => {
						yystate = 27;
						continue 'yyl;
					}
					0x30 => {
						yystate = 29;
						continue 'yyl;
					}
					0x31 ..= 0x39 => {
						yystate = 31;
						continue 'yyl;
					}
					0x3A => {
						yystate = 33;
						continue 'yyl;
					}
					0x3B => {
						yystate = 34;
						continue 'yyl;
					}
					0x3C => {
						yystate = 35;
						continue 'yyl;
					}
					0x3D => {
						yystate = 37;
						continue 'yyl;
					}
					0x3E => {
						yystate = 39;
						continue 'yyl;
					}
					0x3F => {
						yystate = 41;
						continue 'yyl;
					}
					0x41 ..= 0x4B |
					0x4D ..= 0x54 |
					0x56 ..= 0x5A |
					0x68 |
					0x6A ..= 0x6B |
					0x6D ..= 0x71 |
					0x78 ..= 0x7A => {
						yystate = 42;
						continue 'yyl;
					}
					0x4C |
					0x55 => {
						yystate = 45;
						continue 'yyl;
					}
					0x5B => {
						yystate = 46;
						continue 'yyl;
					}
					0x5D => {
						yystate = 47;
						continue 'yyl;
					}
					0x5E => {
						yystate = 48;
						continue 'yyl;
					}
					0x5F => {
						yystate = 50;
						continue 'yyl;
					}
					0x61 => {
						yystate = 51;
						continue 'yyl;
					}
					0x62 => {
						yystate = 52;
						continue 'yyl;
					}
					0x63 => {
						yystate = 53;
						continue 'yyl;
					}
					0x64 => {
						yystate = 54;
						continue 'yyl;
					}
					0x65 => {
						yystate = 55;
						continue 'yyl;
					}
					0x66 => {
						yystate = 56;
						continue 'yyl;
					}
					0x67 => {
						yystate = 57;
						continue 'yyl;
					}
					0x69 => {
						yystate = 58;
						continue 'yyl;
					}
					0x6C => {
						yystate = 59;
						continue 'yyl;
					}
					0x72 => {
						yystate = 60;
						continue 'yyl;
					}
					0x73 => {
						yystate = 61;
						continue 'yyl;
					}
					0x74 => {
						yystate = 62;
						continue 'yyl;
					}
					0x75 => {
						yystate = 63;
						continue 'yyl;
					}
					0x76 => {
						yystate = 64;
						continue 'yyl;
					}
					0x77 => {
						yystate = 65;
						continue 'yyl;
					}
					0x7B => {
						yystate = 66;
						continue 'yyl;
					}
					0x7C => {
						yystate = 67;
						continue 'yyl;
					}
					0x7D => {
						yystate = 69;
						continue 'yyl;
					}
					0x7E => {
						yystate = 70;
						continue 'yyl;
					}
					_ => {
						yystate = 2;
						continue 'yyl;
					}
				}
			}
			1 => { input.eof = true; return Ok(None); }
			2 => {
				yystate = 3;
				continue 'yyl;
			}
			3 => { return input.error("bad character") }
			4 => {
				yych = input.data[input.cursor];
				match yych {
					0x09 |
					0x0B ..= 0x0C |
					0x20 => {
						input.cursor += 1;
						yystate = 4;
						continue 'yyl;
					}
					_ => {
						yystate = 5;
						continue 'yyl;
					}
				}
			}
			5 => { return input.token(TName::Whitespace) }
			6 => { return input.token(TName::Newline) }
			7 => {
				yych = input.data[input.cursor];
				match yych {
					0x3D => {
						input.cursor += 1;
						yystate = 71;
						continue 'yyl;
					}
					_ => {
						yystate = 8;
						continue 'yyl;
					}
				}
			}
			8 => { return input.token(TName::LNot) }
			9 => {
				yyaccept = 0;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x01 ..= 0x09 |
					0x0B ..= 0x21 |
					0x23 ..= 0x5B |
					0x5D ..= 0x7F => {
						input.cursor += 1;
						yystate = 9;
						continue 'yyl;
					}
					0x22 => {
						input.cursor += 1;
						yystate = 72;
						continue 'yyl;
					}
					0x5C => {
						input.cursor += 1;
						yystate = 74;
						continue 'yyl;
					}
					0xC2 ..= 0xDF => {
						input.cursor += 1;
						yystate = 76;
						continue 'yyl;
					}
					0xE0 => {
						input.cursor += 1;
						yystate = 77;
						continue 'yyl;
					}
					0xE1 ..= 0xEF => {
						input.cursor += 1;
						yystate = 78;
						continue 'yyl;
					}
					0xF0 => {
						input.cursor += 1;
						yystate = 79;
						continue 'yyl;
					}
					0xF1 ..= 0xF3 => {
						input.cursor += 1;
						yystate = 80;
						continue 'yyl;
					}
					0xF4 => {
						input.cursor += 1;
						yystate = 81;
						continue 'yyl;
					}
					_ => {
						yystate = 10;
						continue 'yyl;
					}
				}
			}
			10 => {
        return input.error("unterminated string")
    }
			11 => {
				yych = input.data[input.cursor];
				match yych {
					0x3D => {
						input.cursor += 1;
						yystate = 82;
						continue 'yyl;
					}
					_ => {
						yystate = 12;
						continue 'yyl;
					}
				}
			}
			12 => { return input.token(TName::Mod) }
			13 => {
				yych = input.data[input.cursor];
				match yych {
					0x26 => {
						input.cursor += 1;
						yystate = 83;
						continue 'yyl;
					}
					0x3D => {
						input.cursor += 1;
						yystate = 84;
						continue 'yyl;
					}
					_ => {
						yystate = 14;
						continue 'yyl;
					}
				}
			}
			14 => { return input.token(TName::Amper) }
			15 => {
				yyaccept = 1;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x01 ..= 0x09 |
					0x0B ..= 0x26 |
					0x28 ..= 0x7F |
					0xC2 ..= 0xF4 => {
						yystate = 86;
						continue 'yyl;
					}
					_ => {
						yystate = 3;
						continue 'yyl;
					}
				}
			}
			16 => { return input.token(TName::OParen) }
			17 => { return input.token(TName::CParen) }
			18 => {
				yych = input.data[input.cursor];
				match yych {
					0x3D => {
						input.cursor += 1;
						yystate = 95;
						continue 'yyl;
					}
					_ => {
						yystate = 19;
						continue 'yyl;
					}
				}
			}
			19 => { return input.token(TName::Aster) }
			20 => {
				yych = input.data[input.cursor];
				match yych {
					0x2B => {
						input.cursor += 1;
						yystate = 96;
						continue 'yyl;
					}
					0x3D => {
						input.cursor += 1;
						yystate = 97;
						continue 'yyl;
					}
					_ => {
						yystate = 21;
						continue 'yyl;
					}
				}
			}
			21 => { return input.token(TName::Add) }
			22 => { return input.token(TName::Comma) }
			23 => {
				yych = input.data[input.cursor];
				match yych {
					0x2D => {
						input.cursor += 1;
						yystate = 98;
						continue 'yyl;
					}
					0x3D => {
						input.cursor += 1;
						yystate = 99;
						continue 'yyl;
					}
					0x3E => {
						input.cursor += 1;
						yystate = 100;
						continue 'yyl;
					}
					_ => {
						yystate = 24;
						continue 'yyl;
					}
				}
			}
			24 => { return input.token(TName::Sub) }
			25 => {
				yyaccept = 2;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x2E => {
						input.cursor += 1;
						yystate = 101;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 102;
						continue 'yyl;
					}
					_ => {
						yystate = 26;
						continue 'yyl;
					}
				}
			}
			26 => { return input.token(TName::Dot) }
			27 => {
				yych = input.data[input.cursor];
				match yych {
					0x2A => {
						input.cursor += 1;
						yystate = 104;
						continue 'yyl;
					}
					0x2F => {
						input.cursor += 1;
						yystate = 106;
						continue 'yyl;
					}
					0x3D => {
						input.cursor += 1;
						yystate = 108;
						continue 'yyl;
					}
					_ => {
						yystate = 28;
						continue 'yyl;
					}
				}
			}
			28 => { return input.token(TName::Div) }
			29 => {
				yyaccept = 3;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x58 |
					0x78 => {
						input.cursor += 1;
						yystate = 117;
						continue 'yyl;
					}
					_ => {
						yystate = 112;
						continue 'yyl;
					}
				}
			}
			30 => { return input.token(TName::IntConst) }
			31 => {
				yyaccept = 4;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x2E => {
						input.cursor += 1;
						yystate = 109;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 31;
						continue 'yyl;
					}
					0x45 |
					0x65 => {
						input.cursor += 1;
						yystate = 114;
						continue 'yyl;
					}
					0x4C => {
						input.cursor += 1;
						yystate = 119;
						continue 'yyl;
					}
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 120;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 121;
						continue 'yyl;
					}
					_ => {
						yystate = 32;
						continue 'yyl;
					}
				}
			}
			32 => { return input.token(TName::IntConst) }
			33 => { return input.token(TName::Colon) }
			34 => { return input.token(TName::Semi) }
			35 => {
				yych = input.data[input.cursor];
				match yych {
					0x3C => {
						input.cursor += 1;
						yystate = 122;
						continue 'yyl;
					}
					0x3D => {
						input.cursor += 1;
						yystate = 124;
						continue 'yyl;
					}
					_ => {
						yystate = 36;
						continue 'yyl;
					}
				}
			}
			36 => { return input.token(TName::LT) }
			37 => {
				yych = input.data[input.cursor];
				match yych {
					0x3D => {
						input.cursor += 1;
						yystate = 125;
						continue 'yyl;
					}
					_ => {
						yystate = 38;
						continue 'yyl;
					}
				}
			}
			38 => { return input.token(TName::Asgn) }
			39 => {
				yych = input.data[input.cursor];
				match yych {
					0x3D => {
						input.cursor += 1;
						yystate = 126;
						continue 'yyl;
					}
					0x3E => {
						input.cursor += 1;
						yystate = 127;
						continue 'yyl;
					}
					_ => {
						yystate = 40;
						continue 'yyl;
					}
				}
			}
			40 => { return input.token(TName::GT) }
			41 => { return input.token(TName::Ques) }
			42 => {
				yych = input.data[input.cursor];
				yystate = 43;
				continue 'yyl;
			}
			43 => {
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 44;
						continue 'yyl;
					}
				}
			}
			44 => { return input.check_type() }
			45 => {
				yyaccept = 5;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x22 => {
						input.cursor += 1;
						yystate = 9;
						continue 'yyl;
					}
					0x27 => {
						input.cursor += 1;
						yystate = 129;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			46 => { return input.token(TName::OBrack) }
			47 => { return input.token(TName::CBrack) }
			48 => {
				yych = input.data[input.cursor];
				match yych {
					0x3D => {
						input.cursor += 1;
						yystate = 130;
						continue 'yyl;
					}
					_ => {
						yystate = 49;
						continue 'yyl;
					}
				}
			}
			49 => { return input.token(TName::BXor) }
			50 => {
				yych = input.data[input.cursor];
				match yych {
					0x41 => {
						input.cursor += 1;
						yystate = 131;
						continue 'yyl;
					}
					0x42 => {
						input.cursor += 1;
						yystate = 132;
						continue 'yyl;
					}
					0x43 => {
						input.cursor += 1;
						yystate = 133;
						continue 'yyl;
					}
					0x47 => {
						input.cursor += 1;
						yystate = 134;
						continue 'yyl;
					}
					0x49 => {
						input.cursor += 1;
						yystate = 135;
						continue 'yyl;
					}
					0x4E => {
						input.cursor += 1;
						yystate = 136;
						continue 'yyl;
					}
					0x53 => {
						input.cursor += 1;
						yystate = 137;
						continue 'yyl;
					}
					0x54 => {
						input.cursor += 1;
						yystate = 138;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			51 => {
				yych = input.data[input.cursor];
				match yych {
					0x75 => {
						input.cursor += 1;
						yystate = 139;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			52 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 140;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			53 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 141;
						continue 'yyl;
					}
					0x68 => {
						input.cursor += 1;
						yystate = 142;
						continue 'yyl;
					}
					0x6F => {
						input.cursor += 1;
						yystate = 143;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			54 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 144;
						continue 'yyl;
					}
					0x6F => {
						input.cursor += 1;
						yystate = 145;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			55 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 147;
						continue 'yyl;
					}
					0x6E => {
						input.cursor += 1;
						yystate = 148;
						continue 'yyl;
					}
					0x78 => {
						input.cursor += 1;
						yystate = 149;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			56 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 150;
						continue 'yyl;
					}
					0x6F => {
						input.cursor += 1;
						yystate = 151;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			57 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 152;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			58 => {
				yych = input.data[input.cursor];
				match yych {
					0x66 => {
						input.cursor += 1;
						yystate = 153;
						continue 'yyl;
					}
					0x6E => {
						input.cursor += 1;
						yystate = 155;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			59 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 156;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			60 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 157;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			61 => {
				yych = input.data[input.cursor];
				match yych {
					0x68 => {
						input.cursor += 1;
						yystate = 158;
						continue 'yyl;
					}
					0x69 => {
						input.cursor += 1;
						yystate = 159;
						continue 'yyl;
					}
					0x74 => {
						input.cursor += 1;
						yystate = 160;
						continue 'yyl;
					}
					0x77 => {
						input.cursor += 1;
						yystate = 161;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			62 => {
				yych = input.data[input.cursor];
				match yych {
					0x79 => {
						input.cursor += 1;
						yystate = 162;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			63 => {
				yyaccept = 5;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x22 => {
						input.cursor += 1;
						yystate = 9;
						continue 'yyl;
					}
					0x27 => {
						input.cursor += 1;
						yystate = 129;
						continue 'yyl;
					}
					0x38 => {
						input.cursor += 1;
						yystate = 163;
						continue 'yyl;
					}
					0x6E => {
						input.cursor += 1;
						yystate = 164;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			64 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 165;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			65 => {
				yych = input.data[input.cursor];
				match yych {
					0x68 => {
						input.cursor += 1;
						yystate = 166;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			66 => { return input.token(TName::OBrace) }
			67 => {
				yych = input.data[input.cursor];
				match yych {
					0x3D => {
						input.cursor += 1;
						yystate = 167;
						continue 'yyl;
					}
					0x7C => {
						input.cursor += 1;
						yystate = 168;
						continue 'yyl;
					}
					_ => {
						yystate = 68;
						continue 'yyl;
					}
				}
			}
			68 => { return input.token(TName::BOr) }
			69 => { return input.token(TName::CBrace) }
			70 => { return input.token(TName::BNot) }
			71 => { return input.token(TName::NEq) }
			72 => {
				yyaccept = 6;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x09 ..= 0x0C |
					0x20 => {
						input.cursor += 1;
						yystate = 72;
						continue 'yyl;
					}
					0x22 => {
						input.cursor += 1;
						yystate = 169;
						continue 'yyl;
					}
					0x4C |
					0x55 => {
						input.cursor += 1;
						yystate = 170;
						continue 'yyl;
					}
					0x75 => {
						input.cursor += 1;
						yystate = 171;
						continue 'yyl;
					}
					_ => {
						yystate = 73;
						continue 'yyl;
					}
				}
			}
			73 => {
        return input.token(TName::StringLiteral)
    }
			74 => {
				yych = input.data[input.cursor];
				match yych {
					0x22 |
					0x27 |
					0x30 ..= 0x37 |
					0x3F |
					0x5C |
					0x61 ..= 0x62 |
					0x66 |
					0x6E |
					0x72 |
					0x74 |
					0x76 => {
						input.cursor += 1;
						yystate = 9;
						continue 'yyl;
					}
					0x78 => {
						input.cursor += 1;
						yystate = 172;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			75 => {
				input.cursor = input.marker;
				match yyaccept {
					0 => {
						yystate = 10;
						continue 'yyl;
					}
					1 => {
						yystate = 3;
						continue 'yyl;
					}
					2 => {
						yystate = 26;
						continue 'yyl;
					}
					3 => {
						yystate = 30;
						continue 'yyl;
					}
					4 => {
						yystate = 32;
						continue 'yyl;
					}
					5 => {
						yystate = 44;
						continue 'yyl;
					}
					6 => {
						yystate = 73;
						continue 'yyl;
					}
					7 => {
						yystate = 87;
						continue 'yyl;
					}
					8 => {
						yystate = 103;
						continue 'yyl;
					}
					9 => {
						yystate = 105;
						continue 'yyl;
					}
					10 => {
						yystate = 107;
						continue 'yyl;
					}
					11 => {
						yystate = 110;
						continue 'yyl;
					}
					12 => {
						yystate = 202;
						continue 'yyl;
					}
					_ => {
						yystate = 262;
						continue 'yyl;
					}
				}
			}
			76 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 9;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			77 => {
				yych = input.data[input.cursor];
				match yych {
					0xA0 ..= 0xBF => {
						input.cursor += 1;
						yystate = 76;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			78 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 76;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			79 => {
				yych = input.data[input.cursor];
				match yych {
					0x90 ..= 0xBF => {
						input.cursor += 1;
						yystate = 78;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			80 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 78;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			81 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0x8F => {
						input.cursor += 1;
						yystate = 78;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			82 => { return input.token(TName::ModAsgn) }
			83 => { return input.token(TName::LAnd) }
			84 => { return input.token(TName::BAndAsgn) }
			85 => {
				yyaccept = 7;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				yystate = 86;
				continue 'yyl;
			}
			86 => {
				match yych {
					0x01 ..= 0x09 |
					0x0B ..= 0x26 |
					0x28 ..= 0x5B |
					0x5D ..= 0x7F => {
						input.cursor += 1;
						yystate = 85;
						continue 'yyl;
					}
					0x27 => {
						input.cursor += 1;
						yystate = 173;
						continue 'yyl;
					}
					0x5C => {
						input.cursor += 1;
						yystate = 88;
						continue 'yyl;
					}
					0xC2 ..= 0xDF => {
						input.cursor += 1;
						yystate = 89;
						continue 'yyl;
					}
					0xE0 => {
						input.cursor += 1;
						yystate = 90;
						continue 'yyl;
					}
					0xE1 ..= 0xEF => {
						input.cursor += 1;
						yystate = 91;
						continue 'yyl;
					}
					0xF0 => {
						input.cursor += 1;
						yystate = 92;
						continue 'yyl;
					}
					0xF1 ..= 0xF3 => {
						input.cursor += 1;
						yystate = 93;
						continue 'yyl;
					}
					0xF4 => {
						input.cursor += 1;
						yystate = 94;
						continue 'yyl;
					}
					_ => {
						yystate = 87;
						continue 'yyl;
					}
				}
			}
			87 => {
        return input.error("unterminated character constant")
    }
			88 => {
				yych = input.data[input.cursor];
				match yych {
					0x22 |
					0x27 |
					0x30 ..= 0x37 |
					0x3F |
					0x5C |
					0x61 ..= 0x62 |
					0x66 |
					0x6E |
					0x72 |
					0x74 |
					0x76 => {
						input.cursor += 1;
						yystate = 85;
						continue 'yyl;
					}
					0x78 => {
						input.cursor += 1;
						yystate = 174;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			89 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 85;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			90 => {
				yych = input.data[input.cursor];
				match yych {
					0xA0 ..= 0xBF => {
						input.cursor += 1;
						yystate = 89;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			91 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 89;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			92 => {
				yych = input.data[input.cursor];
				match yych {
					0x90 ..= 0xBF => {
						input.cursor += 1;
						yystate = 91;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			93 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 91;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			94 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0x8F => {
						input.cursor += 1;
						yystate = 91;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			95 => { return input.token(TName::MulAsgn) }
			96 => { return input.token(TName::Incr) }
			97 => { return input.token(TName::AddAsgn) }
			98 => { return input.token(TName::Decr) }
			99 => { return input.token(TName::SubAsgn) }
			100 => { return input.token(TName::Arrow) }
			101 => {
				yych = input.data[input.cursor];
				match yych {
					0x2E => {
						input.cursor += 1;
						yystate = 175;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			102 => {
				yyaccept = 8;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 102;
						continue 'yyl;
					}
					0x45 |
					0x65 => {
						input.cursor += 1;
						yystate = 176;
						continue 'yyl;
					}
					0x46 |
					0x4C |
					0x66 |
					0x6C => {
						input.cursor += 1;
						yystate = 177;
						continue 'yyl;
					}
					_ => {
						yystate = 103;
						continue 'yyl;
					}
				}
			}
			103 => { return input.token(TName::FloatConst) }
			104 => {
				yyaccept = 9;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x01 ..= 0x29 |
					0x2B ..= 0x7F => {
						input.cursor += 1;
						yystate = 104;
						continue 'yyl;
					}
					0x2A => {
						input.cursor += 1;
						yystate = 178;
						continue 'yyl;
					}
					0xC2 ..= 0xDF => {
						input.cursor += 1;
						yystate = 179;
						continue 'yyl;
					}
					0xE0 => {
						input.cursor += 1;
						yystate = 180;
						continue 'yyl;
					}
					0xE1 ..= 0xEF => {
						input.cursor += 1;
						yystate = 181;
						continue 'yyl;
					}
					0xF0 => {
						input.cursor += 1;
						yystate = 182;
						continue 'yyl;
					}
					0xF1 ..= 0xF3 => {
						input.cursor += 1;
						yystate = 183;
						continue 'yyl;
					}
					0xF4 => {
						input.cursor += 1;
						yystate = 184;
						continue 'yyl;
					}
					_ => {
						yystate = 105;
						continue 'yyl;
					}
				}
			}
			105 => {
        return input.error("unterminated comment")
    }
			106 => {
				yyaccept = 10;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x01 ..= 0x09 |
					0x0B ..= 0x7F => {
						input.cursor += 1;
						yystate = 106;
						continue 'yyl;
					}
					0xC2 ..= 0xDF => {
						input.cursor += 1;
						yystate = 185;
						continue 'yyl;
					}
					0xE0 => {
						input.cursor += 1;
						yystate = 186;
						continue 'yyl;
					}
					0xE1 ..= 0xEF => {
						input.cursor += 1;
						yystate = 187;
						continue 'yyl;
					}
					0xF0 => {
						input.cursor += 1;
						yystate = 188;
						continue 'yyl;
					}
					0xF1 ..= 0xF3 => {
						input.cursor += 1;
						yystate = 189;
						continue 'yyl;
					}
					0xF4 => {
						input.cursor += 1;
						yystate = 190;
						continue 'yyl;
					}
					_ => {
						yystate = 107;
						continue 'yyl;
					}
				}
			}
			107 => { return input.token(TName::Comment) }
			108 => { return input.token(TName::DivAsgn) }
			109 => {
				yyaccept = 11;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 102;
						continue 'yyl;
					}
					0x45 |
					0x65 => {
						input.cursor += 1;
						yystate = 191;
						continue 'yyl;
					}
					0x46 |
					0x4C |
					0x66 |
					0x6C => {
						input.cursor += 1;
						yystate = 192;
						continue 'yyl;
					}
					_ => {
						yystate = 110;
						continue 'yyl;
					}
				}
			}
			110 => { return input.token(TName::FloatConst) }
			111 => {
				yyaccept = 3;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				yystate = 112;
				continue 'yyl;
			}
			112 => {
				match yych {
					0x2E => {
						input.cursor += 1;
						yystate = 109;
						continue 'yyl;
					}
					0x30 ..= 0x37 => {
						input.cursor += 1;
						yystate = 111;
						continue 'yyl;
					}
					0x38 ..= 0x39 => {
						input.cursor += 1;
						yystate = 113;
						continue 'yyl;
					}
					0x45 |
					0x65 => {
						input.cursor += 1;
						yystate = 114;
						continue 'yyl;
					}
					0x4C => {
						input.cursor += 1;
						yystate = 115;
						continue 'yyl;
					}
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 116;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 118;
						continue 'yyl;
					}
					_ => {
						yystate = 30;
						continue 'yyl;
					}
				}
			}
			113 => {
				yych = input.data[input.cursor];
				match yych {
					0x2E => {
						input.cursor += 1;
						yystate = 109;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 113;
						continue 'yyl;
					}
					0x45 |
					0x65 => {
						input.cursor += 1;
						yystate = 114;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			114 => {
				yych = input.data[input.cursor];
				match yych {
					0x2B |
					0x2D => {
						input.cursor += 1;
						yystate = 193;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 194;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			115 => {
				yych = input.data[input.cursor];
				match yych {
					0x4C => {
						input.cursor += 1;
						yystate = 196;
						continue 'yyl;
					}
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 197;
						continue 'yyl;
					}
					_ => {
						yystate = 30;
						continue 'yyl;
					}
				}
			}
			116 => {
				yych = input.data[input.cursor];
				match yych {
					0x4C => {
						input.cursor += 1;
						yystate = 198;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 199;
						continue 'yyl;
					}
					_ => {
						yystate = 30;
						continue 'yyl;
					}
				}
			}
			117 => {
				yych = input.data[input.cursor];
				match yych {
					0x2E => {
						input.cursor += 1;
						yystate = 200;
						continue 'yyl;
					}
					0x30 ..= 0x39 |
					0x41 ..= 0x46 |
					0x61 ..= 0x66 => {
						input.cursor += 1;
						yystate = 201;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			118 => {
				yych = input.data[input.cursor];
				match yych {
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 197;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 196;
						continue 'yyl;
					}
					_ => {
						yystate = 30;
						continue 'yyl;
					}
				}
			}
			119 => {
				yych = input.data[input.cursor];
				match yych {
					0x4C => {
						input.cursor += 1;
						yystate = 203;
						continue 'yyl;
					}
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 204;
						continue 'yyl;
					}
					_ => {
						yystate = 32;
						continue 'yyl;
					}
				}
			}
			120 => {
				yych = input.data[input.cursor];
				match yych {
					0x4C => {
						input.cursor += 1;
						yystate = 205;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 206;
						continue 'yyl;
					}
					_ => {
						yystate = 32;
						continue 'yyl;
					}
				}
			}
			121 => {
				yych = input.data[input.cursor];
				match yych {
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 204;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 203;
						continue 'yyl;
					}
					_ => {
						yystate = 32;
						continue 'yyl;
					}
				}
			}
			122 => {
				yych = input.data[input.cursor];
				match yych {
					0x3D => {
						input.cursor += 1;
						yystate = 207;
						continue 'yyl;
					}
					_ => {
						yystate = 123;
						continue 'yyl;
					}
				}
			}
			123 => { return input.token(TName::LShift) }
			124 => { return input.token(TName::LE) }
			125 => { return input.token(TName::Eq) }
			126 => { return input.token(TName::GE) }
			127 => {
				yych = input.data[input.cursor];
				match yych {
					0x3D => {
						input.cursor += 1;
						yystate = 208;
						continue 'yyl;
					}
					_ => {
						yystate = 128;
						continue 'yyl;
					}
				}
			}
			128 => { return input.token(TName::RShift) }
			129 => {
				yych = input.data[input.cursor];
				match yych {
					0x01 ..= 0x09 |
					0x0B ..= 0x26 |
					0x28 ..= 0x7F |
					0xC2 ..= 0xF4 => {
						yystate = 86;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			130 => { return input.token(TName::BXorAsgn) }
			131 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 209;
						continue 'yyl;
					}
					0x74 => {
						input.cursor += 1;
						yystate = 210;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			132 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 211;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			133 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 212;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			134 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 213;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			135 => {
				yych = input.data[input.cursor];
				match yych {
					0x6D => {
						input.cursor += 1;
						yystate = 214;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			136 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 215;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			137 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 216;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			138 => {
				yych = input.data[input.cursor];
				match yych {
					0x68 => {
						input.cursor += 1;
						yystate = 217;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			139 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 218;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			140 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 219;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			141 => {
				yych = input.data[input.cursor];
				match yych {
					0x73 => {
						input.cursor += 1;
						yystate = 220;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			142 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 221;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			143 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 222;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			144 => {
				yych = input.data[input.cursor];
				match yych {
					0x66 => {
						input.cursor += 1;
						yystate = 223;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			145 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x74 |
					0x76 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					0x75 => {
						input.cursor += 1;
						yystate = 224;
						continue 'yyl;
					}
					_ => {
						yystate = 146;
						continue 'yyl;
					}
				}
			}
			146 => { return input.token(TName::Do) }
			147 => {
				yych = input.data[input.cursor];
				match yych {
					0x73 => {
						input.cursor += 1;
						yystate = 225;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			148 => {
				yych = input.data[input.cursor];
				match yych {
					0x75 => {
						input.cursor += 1;
						yystate = 226;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			149 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 227;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			150 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 228;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			151 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 229;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			152 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 231;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			153 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 154;
						continue 'yyl;
					}
				}
			}
			154 => { return input.token(TName::If) }
			155 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 232;
						continue 'yyl;
					}
					0x74 => {
						input.cursor += 1;
						yystate = 233;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			156 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 235;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			157 => {
				yych = input.data[input.cursor];
				match yych {
					0x67 => {
						input.cursor += 1;
						yystate = 236;
						continue 'yyl;
					}
					0x73 => {
						input.cursor += 1;
						yystate = 237;
						continue 'yyl;
					}
					0x74 => {
						input.cursor += 1;
						yystate = 238;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			158 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 239;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			159 => {
				yych = input.data[input.cursor];
				match yych {
					0x67 => {
						input.cursor += 1;
						yystate = 240;
						continue 'yyl;
					}
					0x7A => {
						input.cursor += 1;
						yystate = 241;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			160 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 242;
						continue 'yyl;
					}
					0x72 => {
						input.cursor += 1;
						yystate = 243;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			161 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 244;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			162 => {
				yych = input.data[input.cursor];
				match yych {
					0x70 => {
						input.cursor += 1;
						yystate = 245;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			163 => {
				yych = input.data[input.cursor];
				match yych {
					0x22 => {
						input.cursor += 1;
						yystate = 9;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			164 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 246;
						continue 'yyl;
					}
					0x73 => {
						input.cursor += 1;
						yystate = 247;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			165 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 248;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 249;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			166 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 250;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			167 => { return input.token(TName::BOrAsgn) }
			168 => { return input.token(TName::LOr) }
			169 => {
				yych = input.data[input.cursor];
				match yych {
					0x01 ..= 0x09 |
					0x0B ..= 0x21 |
					0x23 ..= 0x5B |
					0x5D ..= 0x7F => {
						input.cursor += 1;
						yystate = 169;
						continue 'yyl;
					}
					0x22 => {
						input.cursor += 1;
						yystate = 72;
						continue 'yyl;
					}
					0x5C => {
						input.cursor += 1;
						yystate = 251;
						continue 'yyl;
					}
					0xC2 ..= 0xDF => {
						input.cursor += 1;
						yystate = 252;
						continue 'yyl;
					}
					0xE0 => {
						input.cursor += 1;
						yystate = 253;
						continue 'yyl;
					}
					0xE1 ..= 0xEF => {
						input.cursor += 1;
						yystate = 254;
						continue 'yyl;
					}
					0xF0 => {
						input.cursor += 1;
						yystate = 255;
						continue 'yyl;
					}
					0xF1 ..= 0xF3 => {
						input.cursor += 1;
						yystate = 256;
						continue 'yyl;
					}
					0xF4 => {
						input.cursor += 1;
						yystate = 257;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			170 => {
				yych = input.data[input.cursor];
				match yych {
					0x22 => {
						input.cursor += 1;
						yystate = 169;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			171 => {
				yych = input.data[input.cursor];
				match yych {
					0x22 => {
						input.cursor += 1;
						yystate = 169;
						continue 'yyl;
					}
					0x38 => {
						input.cursor += 1;
						yystate = 170;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			172 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x46 |
					0x61 ..= 0x66 => {
						input.cursor += 1;
						yystate = 9;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			173 => { return input.token(TName::IntConst) }
			174 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x46 |
					0x61 ..= 0x66 => {
						input.cursor += 1;
						yystate = 85;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			175 => { return input.token(TName::Ellipsis) }
			176 => {
				yych = input.data[input.cursor];
				match yych {
					0x2B |
					0x2D => {
						input.cursor += 1;
						yystate = 258;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 259;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			177 => {
				yystate = 103;
				continue 'yyl;
			}
			178 => {
				yych = input.data[input.cursor];
				match yych {
					0x01 ..= 0x29 |
					0x2B ..= 0x2E |
					0x30 ..= 0x7F => {
						input.cursor += 1;
						yystate = 104;
						continue 'yyl;
					}
					0x2A => {
						input.cursor += 1;
						yystate = 260;
						continue 'yyl;
					}
					0x2F => {
						input.cursor += 1;
						yystate = 261;
						continue 'yyl;
					}
					0xC2 ..= 0xDF => {
						input.cursor += 1;
						yystate = 179;
						continue 'yyl;
					}
					0xE0 => {
						input.cursor += 1;
						yystate = 180;
						continue 'yyl;
					}
					0xE1 ..= 0xEF => {
						input.cursor += 1;
						yystate = 181;
						continue 'yyl;
					}
					0xF0 => {
						input.cursor += 1;
						yystate = 182;
						continue 'yyl;
					}
					0xF1 ..= 0xF3 => {
						input.cursor += 1;
						yystate = 183;
						continue 'yyl;
					}
					0xF4 => {
						input.cursor += 1;
						yystate = 184;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			179 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 104;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			180 => {
				yych = input.data[input.cursor];
				match yych {
					0xA0 ..= 0xBF => {
						input.cursor += 1;
						yystate = 179;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			181 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 179;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			182 => {
				yych = input.data[input.cursor];
				match yych {
					0x90 ..= 0xBF => {
						input.cursor += 1;
						yystate = 181;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			183 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 181;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			184 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0x8F => {
						input.cursor += 1;
						yystate = 181;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			185 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 106;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			186 => {
				yych = input.data[input.cursor];
				match yych {
					0xA0 ..= 0xBF => {
						input.cursor += 1;
						yystate = 185;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			187 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 185;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			188 => {
				yych = input.data[input.cursor];
				match yych {
					0x90 ..= 0xBF => {
						input.cursor += 1;
						yystate = 187;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			189 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 187;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			190 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0x8F => {
						input.cursor += 1;
						yystate = 187;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			191 => {
				yych = input.data[input.cursor];
				match yych {
					0x2B |
					0x2D => {
						input.cursor += 1;
						yystate = 263;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 264;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			192 => {
				yystate = 110;
				continue 'yyl;
			}
			193 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 194;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			194 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 194;
						continue 'yyl;
					}
					0x46 |
					0x4C |
					0x66 |
					0x6C => {
						input.cursor += 1;
						yystate = 265;
						continue 'yyl;
					}
					_ => {
						yystate = 195;
						continue 'yyl;
					}
				}
			}
			195 => { return input.token(TName::FloatConst) }
			196 => {
				yych = input.data[input.cursor];
				match yych {
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 197;
						continue 'yyl;
					}
					_ => {
						yystate = 30;
						continue 'yyl;
					}
				}
			}
			197 => {
				yystate = 30;
				continue 'yyl;
			}
			198 => {
				yych = input.data[input.cursor];
				match yych {
					0x4C => {
						input.cursor += 1;
						yystate = 197;
						continue 'yyl;
					}
					_ => {
						yystate = 30;
						continue 'yyl;
					}
				}
			}
			199 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 197;
						continue 'yyl;
					}
					_ => {
						yystate = 30;
						continue 'yyl;
					}
				}
			}
			200 => {
				yych = input.data[input.cursor];
				match yych {
					0x50 |
					0x70 => {
						yystate = 75;
						continue 'yyl;
					}
					_ => {
						yystate = 267;
						continue 'yyl;
					}
				}
			}
			201 => {
				yyaccept = 12;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x2E => {
						input.cursor += 1;
						yystate = 268;
						continue 'yyl;
					}
					0x30 ..= 0x39 |
					0x41 ..= 0x46 |
					0x61 ..= 0x66 => {
						input.cursor += 1;
						yystate = 201;
						continue 'yyl;
					}
					0x4C => {
						input.cursor += 1;
						yystate = 269;
						continue 'yyl;
					}
					0x50 |
					0x70 => {
						input.cursor += 1;
						yystate = 270;
						continue 'yyl;
					}
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 271;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 272;
						continue 'yyl;
					}
					_ => {
						yystate = 202;
						continue 'yyl;
					}
				}
			}
			202 => { return input.token(TName::IntConst) }
			203 => {
				yych = input.data[input.cursor];
				match yych {
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 204;
						continue 'yyl;
					}
					_ => {
						yystate = 32;
						continue 'yyl;
					}
				}
			}
			204 => {
				yystate = 32;
				continue 'yyl;
			}
			205 => {
				yych = input.data[input.cursor];
				match yych {
					0x4C => {
						input.cursor += 1;
						yystate = 204;
						continue 'yyl;
					}
					_ => {
						yystate = 32;
						continue 'yyl;
					}
				}
			}
			206 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 204;
						continue 'yyl;
					}
					_ => {
						yystate = 32;
						continue 'yyl;
					}
				}
			}
			207 => { return input.token(TName::LSAsgn) }
			208 => { return input.token(TName::RSAsgn) }
			209 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 273;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			210 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 274;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			211 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 275;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			212 => {
				yych = input.data[input.cursor];
				match yych {
					0x6D => {
						input.cursor += 1;
						yystate = 276;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			213 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 277;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			214 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 278;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			215 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 279;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			216 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 280;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			217 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 281;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			218 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 282;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			219 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 284;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			220 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 285;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			221 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 287;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			222 => {
				yych = input.data[input.cursor];
				match yych {
					0x73 => {
						input.cursor += 1;
						yystate = 289;
						continue 'yyl;
					}
					0x74 => {
						input.cursor += 1;
						yystate = 290;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			223 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 291;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			224 => {
				yych = input.data[input.cursor];
				match yych {
					0x62 => {
						input.cursor += 1;
						yystate = 292;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			225 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 293;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			226 => {
				yych = input.data[input.cursor];
				match yych {
					0x6D => {
						input.cursor += 1;
						yystate = 295;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			227 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 297;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			228 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 298;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			229 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 230;
						continue 'yyl;
					}
				}
			}
			230 => { return input.token(TName::For) }
			231 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 299;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			232 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 301;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			233 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 234;
						continue 'yyl;
					}
				}
			}
			234 => { return input.token(TName::Int) }
			235 => {
				yych = input.data[input.cursor];
				match yych {
					0x67 => {
						input.cursor += 1;
						yystate = 302;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			236 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 304;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			237 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 305;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			238 => {
				yych = input.data[input.cursor];
				match yych {
					0x75 => {
						input.cursor += 1;
						yystate = 306;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			239 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 307;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			240 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 308;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			241 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 309;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			242 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 310;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			243 => {
				yych = input.data[input.cursor];
				match yych {
					0x75 => {
						input.cursor += 1;
						yystate = 311;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			244 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 312;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			245 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 313;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			246 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 314;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			247 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 315;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			248 => {
				yych = input.data[input.cursor];
				match yych {
					0x64 => {
						input.cursor += 1;
						yystate = 316;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			249 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 318;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			250 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 319;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			251 => {
				yych = input.data[input.cursor];
				match yych {
					0x22 |
					0x27 |
					0x30 ..= 0x37 |
					0x3F |
					0x5C |
					0x61 ..= 0x62 |
					0x66 |
					0x6E |
					0x72 |
					0x74 |
					0x76 => {
						input.cursor += 1;
						yystate = 169;
						continue 'yyl;
					}
					0x78 => {
						input.cursor += 1;
						yystate = 320;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			252 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 169;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			253 => {
				yych = input.data[input.cursor];
				match yych {
					0xA0 ..= 0xBF => {
						input.cursor += 1;
						yystate = 252;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			254 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 252;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			255 => {
				yych = input.data[input.cursor];
				match yych {
					0x90 ..= 0xBF => {
						input.cursor += 1;
						yystate = 254;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			256 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0xBF => {
						input.cursor += 1;
						yystate = 254;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			257 => {
				yych = input.data[input.cursor];
				match yych {
					0x80 ..= 0x8F => {
						input.cursor += 1;
						yystate = 254;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			258 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 259;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			259 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 259;
						continue 'yyl;
					}
					0x46 |
					0x4C |
					0x66 |
					0x6C => {
						input.cursor += 1;
						yystate = 177;
						continue 'yyl;
					}
					_ => {
						yystate = 103;
						continue 'yyl;
					}
				}
			}
			260 => {
				yyaccept = 9;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x01 ..= 0x29 |
					0x2B ..= 0x2E |
					0x30 ..= 0x7F => {
						input.cursor += 1;
						yystate = 104;
						continue 'yyl;
					}
					0x2A => {
						input.cursor += 1;
						yystate = 260;
						continue 'yyl;
					}
					0x2F => {
						input.cursor += 1;
						yystate = 321;
						continue 'yyl;
					}
					0xC2 ..= 0xDF => {
						input.cursor += 1;
						yystate = 179;
						continue 'yyl;
					}
					0xE0 => {
						input.cursor += 1;
						yystate = 180;
						continue 'yyl;
					}
					0xE1 ..= 0xEF => {
						input.cursor += 1;
						yystate = 181;
						continue 'yyl;
					}
					0xF0 => {
						input.cursor += 1;
						yystate = 182;
						continue 'yyl;
					}
					0xF1 ..= 0xF3 => {
						input.cursor += 1;
						yystate = 183;
						continue 'yyl;
					}
					0xF4 => {
						input.cursor += 1;
						yystate = 184;
						continue 'yyl;
					}
					_ => {
						yystate = 105;
						continue 'yyl;
					}
				}
			}
			261 => {
				yystate = 262;
				continue 'yyl;
			}
			262 => {
        return input.token(TName::Comment)
    }
			263 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 264;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			264 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 264;
						continue 'yyl;
					}
					0x46 |
					0x4C |
					0x66 |
					0x6C => {
						input.cursor += 1;
						yystate = 192;
						continue 'yyl;
					}
					_ => {
						yystate = 110;
						continue 'yyl;
					}
				}
			}
			265 => {
				yystate = 195;
				continue 'yyl;
			}
			266 => {
				yych = input.data[input.cursor];
				yystate = 267;
				continue 'yyl;
			}
			267 => {
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x46 |
					0x61 ..= 0x66 => {
						input.cursor += 1;
						yystate = 266;
						continue 'yyl;
					}
					0x50 |
					0x70 => {
						input.cursor += 1;
						yystate = 322;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			268 => {
				yych = input.data[input.cursor];
				match yych {
					0x50 |
					0x70 => {
						input.cursor += 1;
						yystate = 323;
						continue 'yyl;
					}
					_ => {
						yystate = 267;
						continue 'yyl;
					}
				}
			}
			269 => {
				yych = input.data[input.cursor];
				match yych {
					0x4C => {
						input.cursor += 1;
						yystate = 324;
						continue 'yyl;
					}
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 325;
						continue 'yyl;
					}
					_ => {
						yystate = 202;
						continue 'yyl;
					}
				}
			}
			270 => {
				yych = input.data[input.cursor];
				match yych {
					0x2B |
					0x2D => {
						input.cursor += 1;
						yystate = 326;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 327;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			271 => {
				yych = input.data[input.cursor];
				match yych {
					0x4C => {
						input.cursor += 1;
						yystate = 329;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 330;
						continue 'yyl;
					}
					_ => {
						yystate = 202;
						continue 'yyl;
					}
				}
			}
			272 => {
				yych = input.data[input.cursor];
				match yych {
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 325;
						continue 'yyl;
					}
					0x6C => {
						input.cursor += 1;
						yystate = 324;
						continue 'yyl;
					}
					_ => {
						yystate = 202;
						continue 'yyl;
					}
				}
			}
			273 => {
				yych = input.data[input.cursor];
				match yych {
					0x67 => {
						input.cursor += 1;
						yystate = 331;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			274 => {
				yych = input.data[input.cursor];
				match yych {
					0x6D => {
						input.cursor += 1;
						yystate = 332;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			275 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 333;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			276 => {
				yych = input.data[input.cursor];
				match yych {
					0x70 => {
						input.cursor += 1;
						yystate = 335;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			277 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 336;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			278 => {
				yych = input.data[input.cursor];
				match yych {
					0x67 => {
						input.cursor += 1;
						yystate = 337;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			279 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 338;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			280 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 339;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			281 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 340;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			282 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 283;
						continue 'yyl;
					}
				}
			}
			283 => { return input.token(TName::Auto) }
			284 => {
				yych = input.data[input.cursor];
				match yych {
					0x6B => {
						input.cursor += 1;
						yystate = 341;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			285 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 286;
						continue 'yyl;
					}
				}
			}
			286 => { return input.token(TName::Case) }
			287 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 288;
						continue 'yyl;
					}
				}
			}
			288 => { return input.token(TName::Char) }
			289 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 343;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			290 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 345;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			291 => {
				yych = input.data[input.cursor];
				match yych {
					0x75 => {
						input.cursor += 1;
						yystate = 346;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			292 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 347;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			293 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 294;
						continue 'yyl;
					}
				}
			}
			294 => { return input.token(TName::Else) }
			295 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 296;
						continue 'yyl;
					}
				}
			}
			296 => { return input.token(TName::Enum) }
			297 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 348;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			298 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 349;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			299 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 300;
						continue 'yyl;
					}
				}
			}
			300 => { return input.token(TName::Goto) }
			301 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 351;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			302 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 303;
						continue 'yyl;
					}
				}
			}
			303 => { return input.token(TName::Long) }
			304 => {
				yych = input.data[input.cursor];
				match yych {
					0x73 => {
						input.cursor += 1;
						yystate = 352;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			305 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 353;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			306 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 354;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			307 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 355;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			308 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 357;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			309 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 358;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			310 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 359;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			311 => {
				yych = input.data[input.cursor];
				match yych {
					0x63 => {
						input.cursor += 1;
						yystate = 360;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			312 => {
				yych = input.data[input.cursor];
				match yych {
					0x63 => {
						input.cursor += 1;
						yystate = 361;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			313 => {
				yych = input.data[input.cursor];
				match yych {
					0x64 => {
						input.cursor += 1;
						yystate = 362;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			314 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 363;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			315 => {
				yych = input.data[input.cursor];
				match yych {
					0x67 => {
						input.cursor += 1;
						yystate = 365;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			316 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 317;
						continue 'yyl;
					}
				}
			}
			317 => { return input.token(TName::Void) }
			318 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 366;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			319 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 367;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			320 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x46 |
					0x61 ..= 0x66 => {
						input.cursor += 1;
						yystate = 169;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			321 => {
				yyaccept = 13;
				input.marker = input.cursor;
				yych = input.data[input.cursor];
				match yych {
					0x01 ..= 0x29 |
					0x2B ..= 0x7F => {
						input.cursor += 1;
						yystate = 104;
						continue 'yyl;
					}
					0x2A => {
						input.cursor += 1;
						yystate = 178;
						continue 'yyl;
					}
					0xC2 ..= 0xDF => {
						input.cursor += 1;
						yystate = 179;
						continue 'yyl;
					}
					0xE0 => {
						input.cursor += 1;
						yystate = 180;
						continue 'yyl;
					}
					0xE1 ..= 0xEF => {
						input.cursor += 1;
						yystate = 181;
						continue 'yyl;
					}
					0xF0 => {
						input.cursor += 1;
						yystate = 182;
						continue 'yyl;
					}
					0xF1 ..= 0xF3 => {
						input.cursor += 1;
						yystate = 183;
						continue 'yyl;
					}
					0xF4 => {
						input.cursor += 1;
						yystate = 184;
						continue 'yyl;
					}
					_ => {
						yystate = 262;
						continue 'yyl;
					}
				}
			}
			322 => {
				yych = input.data[input.cursor];
				match yych {
					0x2B |
					0x2D => {
						input.cursor += 1;
						yystate = 369;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 370;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			323 => {
				yych = input.data[input.cursor];
				match yych {
					0x2B |
					0x2D => {
						input.cursor += 1;
						yystate = 372;
						continue 'yyl;
					}
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 373;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			324 => {
				yych = input.data[input.cursor];
				match yych {
					0x55 |
					0x75 => {
						input.cursor += 1;
						yystate = 325;
						continue 'yyl;
					}
					_ => {
						yystate = 202;
						continue 'yyl;
					}
				}
			}
			325 => {
				yystate = 202;
				continue 'yyl;
			}
			326 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 327;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			327 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 327;
						continue 'yyl;
					}
					0x46 |
					0x4C |
					0x66 |
					0x6C => {
						input.cursor += 1;
						yystate = 375;
						continue 'yyl;
					}
					_ => {
						yystate = 328;
						continue 'yyl;
					}
				}
			}
			328 => { return input.token(TName::FloatConst) }
			329 => {
				yych = input.data[input.cursor];
				match yych {
					0x4C => {
						input.cursor += 1;
						yystate = 325;
						continue 'yyl;
					}
					_ => {
						yystate = 202;
						continue 'yyl;
					}
				}
			}
			330 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 325;
						continue 'yyl;
					}
					_ => {
						yystate = 202;
						continue 'yyl;
					}
				}
			}
			331 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 376;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			332 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 377;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			333 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 334;
						continue 'yyl;
					}
				}
			}
			334 => { return input.token(TName::Bool) }
			335 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 378;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			336 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 379;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			337 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 380;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			338 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 381;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			339 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 382;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			340 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 383;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			341 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 342;
						continue 'yyl;
					}
				}
			}
			342 => { return input.token(TName::Break) }
			343 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 344;
						continue 'yyl;
					}
				}
			}
			344 => { return input.token(TName::Const) }
			345 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 384;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			346 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 385;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			347 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 386;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			348 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 388;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			349 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 350;
						continue 'yyl;
					}
				}
			}
			350 => { return input.token(TName::Float) }
			351 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 390;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			352 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 392;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			353 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 393;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			354 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 394;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			355 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 356;
						continue 'yyl;
					}
				}
			}
			356 => { return input.token(TName::Short) }
			357 => {
				yych = input.data[input.cursor];
				match yych {
					0x64 => {
						input.cursor += 1;
						yystate = 396;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			358 => {
				yych = input.data[input.cursor];
				match yych {
					0x66 => {
						input.cursor += 1;
						yystate = 398;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			359 => {
				yych = input.data[input.cursor];
				match yych {
					0x63 => {
						input.cursor += 1;
						yystate = 400;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			360 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 402;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			361 => {
				yych = input.data[input.cursor];
				match yych {
					0x68 => {
						input.cursor += 1;
						yystate = 404;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			362 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 406;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			363 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 364;
						continue 'yyl;
					}
				}
			}
			364 => { return input.token(TName::Union) }
			365 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 407;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			366 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 408;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			367 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 368;
						continue 'yyl;
					}
				}
			}
			368 => { return input.token(TName::While) }
			369 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 370;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			370 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 370;
						continue 'yyl;
					}
					0x46 |
					0x4C |
					0x66 |
					0x6C => {
						input.cursor += 1;
						yystate = 409;
						continue 'yyl;
					}
					_ => {
						yystate = 371;
						continue 'yyl;
					}
				}
			}
			371 => { return input.token(TName::FloatConst) }
			372 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 373;
						continue 'yyl;
					}
					_ => {
						yystate = 75;
						continue 'yyl;
					}
				}
			}
			373 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 => {
						input.cursor += 1;
						yystate = 373;
						continue 'yyl;
					}
					0x46 |
					0x4C |
					0x66 |
					0x6C => {
						input.cursor += 1;
						yystate = 410;
						continue 'yyl;
					}
					_ => {
						yystate = 374;
						continue 'yyl;
					}
				}
			}
			374 => { return input.token(TName::FloatConst) }
			375 => {
				yystate = 328;
				continue 'yyl;
			}
			376 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 411;
						continue 'yyl;
					}
					0x6F => {
						input.cursor += 1;
						yystate = 412;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			377 => {
				yych = input.data[input.cursor];
				match yych {
					0x63 => {
						input.cursor += 1;
						yystate = 413;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			378 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 415;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			379 => {
				yych = input.data[input.cursor];
				match yych {
					0x69 => {
						input.cursor += 1;
						yystate = 416;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			380 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 417;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			381 => {
				yych = input.data[input.cursor];
				match yych {
					0x75 => {
						input.cursor += 1;
						yystate = 418;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			382 => {
				yych = input.data[input.cursor];
				match yych {
					0x63 => {
						input.cursor += 1;
						yystate = 419;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			383 => {
				yych = input.data[input.cursor];
				match yych {
					0x64 => {
						input.cursor += 1;
						yystate = 420;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			384 => {
				yych = input.data[input.cursor];
				match yych {
					0x75 => {
						input.cursor += 1;
						yystate = 421;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			385 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 422;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			386 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 387;
						continue 'yyl;
					}
				}
			}
			387 => { return input.token(TName::Double) }
			388 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 389;
						continue 'yyl;
					}
				}
			}
			389 => { return input.token(TName::Extern) }
			390 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 391;
						continue 'yyl;
					}
				}
			}
			391 => { return input.token(TName::Inline) }
			392 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 424;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			393 => {
				yych = input.data[input.cursor];
				match yych {
					0x63 => {
						input.cursor += 1;
						yystate = 425;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			394 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 395;
						continue 'yyl;
					}
				}
			}
			395 => { return input.token(TName::Return) }
			396 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 397;
						continue 'yyl;
					}
				}
			}
			397 => { return input.token(TName::Signed) }
			398 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 399;
						continue 'yyl;
					}
				}
			}
			399 => { return input.token(TName::Sizeof) }
			400 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 401;
						continue 'yyl;
					}
				}
			}
			401 => { return input.token(TName::Static) }
			402 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 403;
						continue 'yyl;
					}
				}
			}
			403 => { return input.token(TName::Struct) }
			404 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 405;
						continue 'yyl;
					}
				}
			}
			405 => { return input.token(TName::Switch) }
			406 => {
				yych = input.data[input.cursor];
				match yych {
					0x66 => {
						input.cursor += 1;
						yystate = 426;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			407 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 428;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			408 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 429;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			409 => {
				yystate = 371;
				continue 'yyl;
			}
			410 => {
				yystate = 374;
				continue 'yyl;
			}
			411 => {
				yych = input.data[input.cursor];
				match yych {
					0x73 => {
						input.cursor += 1;
						yystate = 430;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			412 => {
				yych = input.data[input.cursor];
				match yych {
					0x66 => {
						input.cursor += 1;
						yystate = 432;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			413 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 414;
						continue 'yyl;
					}
				}
			}
			414 => { return input.token(TName::Atomic) }
			415 => {
				yych = input.data[input.cursor];
				match yych {
					0x78 => {
						input.cursor += 1;
						yystate = 434;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			416 => {
				yych = input.data[input.cursor];
				match yych {
					0x63 => {
						input.cursor += 1;
						yystate = 436;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			417 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 438;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			418 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 439;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			419 => {
				yych = input.data[input.cursor];
				match yych {
					0x5F => {
						input.cursor += 1;
						yystate = 440;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			420 => {
				yych = input.data[input.cursor];
				match yych {
					0x5F => {
						input.cursor += 1;
						yystate = 441;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			421 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 442;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			422 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 423;
						continue 'yyl;
					}
				}
			}
			423 => { return input.token(TName::Default) }
			424 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 444;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			425 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 446;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			426 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 427;
						continue 'yyl;
					}
				}
			}
			427 => { return input.token(TName::Typedef) }
			428 => {
				yych = input.data[input.cursor];
				match yych {
					0x64 => {
						input.cursor += 1;
						yystate = 448;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			429 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 450;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			430 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 431;
						continue 'yyl;
					}
				}
			}
			431 => { return input.token(TName::Alignas) }
			432 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 433;
						continue 'yyl;
					}
				}
			}
			433 => { return input.token(TName::Alignof) }
			434 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 435;
						continue 'yyl;
					}
				}
			}
			435 => { return input.token(TName::Complex) }
			436 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 437;
						continue 'yyl;
					}
				}
			}
			437 => { return input.token(TName::Generic) }
			438 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 452;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			439 => {
				yych = input.data[input.cursor];
				match yych {
					0x6E => {
						input.cursor += 1;
						yystate = 453;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			440 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 455;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			441 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 456;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			442 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 443;
						continue 'yyl;
					}
				}
			}
			443 => { return input.token(TName::Continue) }
			444 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 445;
						continue 'yyl;
					}
				}
			}
			445 => { return input.token(TName::Register) }
			446 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 447;
						continue 'yyl;
					}
				}
			}
			447 => { return input.token(TName::Restrict) }
			448 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 449;
						continue 'yyl;
					}
				}
			}
			449 => { return input.token(TName::Unsigned) }
			450 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 451;
						continue 'yyl;
					}
				}
			}
			451 => { return input.token(TName::Volatile) }
			452 => {
				yych = input.data[input.cursor];
				match yych {
					0x79 => {
						input.cursor += 1;
						yystate = 457;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			453 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 454;
						continue 'yyl;
					}
				}
			}
			454 => { return input.token(TName::Noreturn) }
			455 => {
				yych = input.data[input.cursor];
				match yych {
					0x73 => {
						input.cursor += 1;
						yystate = 459;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			456 => {
				yych = input.data[input.cursor];
				match yych {
					0x6F => {
						input.cursor += 1;
						yystate = 460;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			457 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 458;
						continue 'yyl;
					}
				}
			}
			458 => { return input.token(TName::Imaginary) }
			459 => {
				yych = input.data[input.cursor];
				match yych {
					0x73 => {
						input.cursor += 1;
						yystate = 461;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			460 => {
				yych = input.data[input.cursor];
				match yych {
					0x63 => {
						input.cursor += 1;
						yystate = 462;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			461 => {
				yych = input.data[input.cursor];
				match yych {
					0x65 => {
						input.cursor += 1;
						yystate = 463;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			462 => {
				yych = input.data[input.cursor];
				match yych {
					0x61 => {
						input.cursor += 1;
						yystate = 464;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			463 => {
				yych = input.data[input.cursor];
				match yych {
					0x72 => {
						input.cursor += 1;
						yystate = 465;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			464 => {
				yych = input.data[input.cursor];
				match yych {
					0x6C => {
						input.cursor += 1;
						yystate = 466;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			465 => {
				yych = input.data[input.cursor];
				match yych {
					0x74 => {
						input.cursor += 1;
						yystate = 468;
						continue 'yyl;
					}
					_ => {
						yystate = 43;
						continue 'yyl;
					}
				}
			}
			466 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 467;
						continue 'yyl;
					}
				}
			}
			467 => { return input.token(TName::ThreadLocal) }
			468 => {
				yych = input.data[input.cursor];
				match yych {
					0x30 ..= 0x39 |
					0x41 ..= 0x5A |
					0x5F |
					0x61 ..= 0x7A => {
						input.cursor += 1;
						yystate = 42;
						continue 'yyl;
					}
					_ => {
						yystate = 469;
						continue 'yyl;
					}
				}
			}
			469 => { return input.token(TName::StaticAssert) }
			_ => {
				panic!("internal lexer error")
			}
		}
	}
}


}

const DEBUG: bool = false;
macro_rules! log {
    ($($fmt:expr)? $(, $args:expr)*) => {
        if DEBUG { println!($($fmt)? $(, $args)*) }
    }
}

fn main() -> std::io::Result<()> {
    use std::env;
    use std::fs;

    // Treats the first command line argument as a filename and returns file
    // contents as a string. If there is no filename, returns a pre-defined
    // example string (this is used for testing).
    let args: Vec<String> = env::args().collect();

    // We append a '\0' at the end of the string to act as a sentinel.
    let mut str: String;
    if args.len() < 2 {
        str = "int main() { return 0; }\0".to_string(); // example C program
    } else {
        str = fs::read_to_string(&args[1])?;
        str.push('\0');
    }

    let mut input = Input::new(str);

    loop {
        match next_token(&mut input) {
            Ok(Some(token)) => log!("{:#?}", token),
            Ok(None) => {
                log!("EOF");
                break;
            },
            Err(error) => {
                log!("error: {:#?}", error);
                break;
            },
        };
    };

    Ok(())
}
