/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElisionFilter
extends TokenFilter {
    private CharArraySet articles = null;
    private TermAttribute termAtt;
    private static char[] apostrophes = new char[]{'\'', '\u2019'};

    public void setArticles(Set<?> articles) {
        this.articles = articles instanceof CharArraySet ? (CharArraySet)articles : new CharArraySet(articles, true);
    }

    protected ElisionFilter(TokenStream input) {
        super(input);
        this.articles = new CharArraySet(Arrays.asList("l", "m", "t", "qu", "n", "s", "j"), true);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public ElisionFilter(TokenStream input, Set<?> articles) {
        super(input);
        this.setArticles(articles);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public ElisionFilter(TokenStream input, String[] articles) {
        super(input);
        this.articles = new CharArraySet(Arrays.asList(articles), true);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] termBuffer = this.termAtt.termBuffer();
            int termLength = this.termAtt.termLength();
            int minPoz = Integer.MAX_VALUE;
            block0: for (int i = 0; i < apostrophes.length; ++i) {
                char apos = apostrophes[i];
                for (int poz = 0; poz < termLength; ++poz) {
                    if (termBuffer[poz] != apos) continue;
                    minPoz = Math.min(poz, minPoz);
                    continue block0;
                }
            }
            if (minPoz != Integer.MAX_VALUE && this.articles.contains(this.termAtt.termBuffer(), 0, minPoz)) {
                this.termAtt.setTermBuffer(this.termAtt.termBuffer(), minPoz + 1, this.termAtt.termLength() - (minPoz + 1));
            }
            return true;
        }
        return false;
    }
}

