# Copyright 2017-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.7

EAPI=8

CRATES=""
# Required for tests but not included by pycargoebuild.
CRATES+="
	itoa@0.3.4
"

# https://github.com/mozilla/sccache?tab=readme-ov-file#build-requirements
RUST_MIN_VER="1.85.0"

inherit cargo optfeature systemd

DESCRIPTION="ccache/distcc like tool with support for rust and cloud storage"
HOMEPAGE="https://github.com/mozilla/sccache"
SRC_URI="
	https://github.com/mozilla/${PN}/archive/v${PV}.tar.gz -> ${P}.tar.gz
	https://github.com/gentoo-crate-dist/sccache/releases/download/v${PV}/sccache-${PV}-crates.tar.xz
"

LICENSE="Apache-2.0"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 BSD-2 BSD CC0-1.0 ISC MIT MPL-2.0 Unicode-DFS-2016 ZLIB
"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~loong ~ppc64"
IUSE="azure dist-client dist-server gcs memcached redis s3 webdav"

BDEPEND="virtual/pkgconfig"
DEPEND="
	app-arch/zstd
	virtual/zlib:=
	dist-server? ( dev-libs/openssl:= )
	gcs? ( dev-libs/openssl:= )
"
RDEPEND="
	${DEPEND}
	dev-util/shadowman
"
# Needed for eselect calls in pkg_*
IDEPEND="dev-util/shadowman"

QA_FLAGS_IGNORED="usr/bin/sccache*"

pkg_setup() {
	export OPENSSL_NO_VENDOR=1
	export PKG_CONFIG_ALLOW_CROSS=1
	export ZSTD_SYS_USE_PKG_CONFIG=1
	rust_pkg_setup
}

src_configure() {
	local myfeatures=(
		$(usev azure)
		$(usev dist-client)
		$(usev dist-server)
		$(usev gcs)
		$(usev memcached)
		$(usev redis)
		$(usev s3)
		$(usev webdav)
	)

	cargo_src_configure --no-default-features
}

src_install() {
	cargo_src_install

	keepdir /etc/sccache

	dodoc -r docs

	if use dist-server; then
		newinitd "${FILESDIR}"/server.initd sccache-server
		newconfd "${FILESDIR}"/server.confd sccache-server

		newinitd "${FILESDIR}"/scheduler.initd sccache-scheduler
		newconfd "${FILESDIR}"/scheduler.confd sccache-scheduler

		systemd_dounit "${FILESDIR}"/sccache-server.service
		systemd_dounit "${FILESDIR}"/sccache-scheduler.service
	fi
}

pkg_postinst() {
	use memcached && optfeature "memcached backend support" net-misc/memcached
	use redis && optfeature "redis backend support" dev-db/redis

	if [[ -z ${ROOT} ]]; then
		eselect compiler-shadow update sccache
	fi
}

pkg_prerm() {
	if [[ -z ${REPLACE_BY_VERSION} && -z ${ROOT} ]]; then
		eselect compiler-shadow remove sccache
	fi
}
