# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DESCRIPTION="Default linker configuration for clang"
HOMEPAGE="https://clang.llvm.org/"
S=${WORKDIR}

LICENSE="public-domain"
SLOT="${PV}"
IUSE="default-lld"

RDEPEND="
	default-lld? ( llvm-core/lld:${PV} )
	!default-lld? ( sys-devel/binutils )
"

src_install() {
	insinto "/etc/clang/${SLOT}"
	newins - gentoo-linker.cfg <<-EOF
		# This file is initially generated by ${CATEGORY}/${PN}.
		# It is used to control the default linker used by clang.

		-fuse-ld=$(usex default-lld lld bfd)
	EOF
}
