/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.bool;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIElementAlignment;
import org.jkiss.dbeaver.ui.UIElementFontStyle;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;
import org.jkiss.dbeaver.ui.controls.bool.BooleanState;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyle;
import org.jkiss.utils.CommonUtils;

public class BooleanStyleSet {
    private static final String PREF_BOOLEAN_STYLE = "ui.render.boolean.style";
    private static final String PROP_LEGACY_STYLE_ICON = "ICON";
    private static final String PROP_LEGACY_STYLE_TEXTBOX = "TEXTBOX";
    private static final String PROP_LEGACY_STYLE_CHECKBOX = "CHECKBOX";
    private static final String PROP_LEGACY_STYLE_TRUE_FALSE = "TRUE_FALSE";
    private static final String PROP_LEGACY_STYLE_YES_NO = "YES_NO";
    private static final String PROP_MODE = "mode";
    private static final String PROP_TEXT = "text";
    private static final String PROP_ALIGN = "align";
    private static final String PROP_FONT = "font";
    private static final String PROP_COLOR = "color";
    private static final String COLOR_DEFAULT = "default";
    private final BooleanStyle checkedStyle;
    private final BooleanStyle uncheckedStyle;
    private final BooleanStyle nullStyle;
    private final RGB defaultColor;

    public BooleanStyleSet(@NotNull BooleanStyle checkedStyle, @NotNull BooleanStyle uncheckedStyle, @NotNull BooleanStyle nullStyle, @NotNull RGB defaultColor) {
        this.checkedStyle = checkedStyle;
        this.uncheckedStyle = uncheckedStyle;
        this.nullStyle = nullStyle;
        this.defaultColor = defaultColor;
        Assert.isLegal((checkedStyle.getMode() == uncheckedStyle.getMode() && uncheckedStyle.getMode() == nullStyle.getMode() ? 1 : 0) != 0, (String)"Mixed style modes");
    }

    @NotNull
    public BooleanStyle getStyle(@Nullable Boolean value) {
        return value == null ? this.nullStyle : (value != false ? this.checkedStyle : this.uncheckedStyle);
    }

    @NotNull
    public BooleanStyle getStyle(@NotNull BooleanState state) {
        return state.choose(this.checkedStyle, this.uncheckedStyle, this.nullStyle);
    }

    @NotNull
    public BooleanStyle getCheckedStyle() {
        return this.checkedStyle;
    }

    @NotNull
    public BooleanStyle getUncheckedStyle() {
        return this.uncheckedStyle;
    }

    @NotNull
    public BooleanStyle getNullStyle() {
        return this.nullStyle;
    }

    @NotNull
    public BooleanMode getMode() {
        return this.checkedStyle.getMode();
    }

    @NotNull
    public RGB getDefaultColor() {
        return this.defaultColor;
    }

    public static BooleanStyleSet getDefaultStyles(@NotNull DBPPreferenceStore store) {
        BooleanMode mode = (BooleanMode)CommonUtils.valueOf(BooleanMode.class, (String)store.getString("ui.render.boolean.style.mode"));
        return BooleanStyleSet.getDefaultStyles(store, mode);
    }

    @NotNull
    public static BooleanStyleSet getDefaultStyles(@NotNull DBPPreferenceStore store, @Nullable BooleanMode mode) {
        RGB defaultColor = UIStyles.getDefaultTextForeground().getRGB();
        if (mode != null) {
            return new BooleanStyleSet(BooleanStyleSet.getDefaultStyle(store, mode, BooleanState.CHECKED, defaultColor), BooleanStyleSet.getDefaultStyle(store, mode, BooleanState.UNCHECKED, defaultColor), BooleanStyleSet.getDefaultStyle(store, mode, BooleanState.NULL, defaultColor), defaultColor);
        }
        return new BooleanStyleSet(BooleanStyleSet.getDefaultStyleLegacy(store, BooleanState.CHECKED, defaultColor), BooleanStyleSet.getDefaultStyleLegacy(store, BooleanState.UNCHECKED, defaultColor), BooleanStyleSet.getDefaultStyleLegacy(store, BooleanState.NULL, defaultColor), defaultColor);
    }

    @NotNull
    public static BooleanStyleSet getDefaultStyleSet() {
        RGB defaultColor = UIStyles.getDefaultTextForeground().getRGB();
        return new BooleanStyleSet(BooleanStyleSet.getDefaultStyle(BooleanState.CHECKED, defaultColor), BooleanStyleSet.getDefaultStyle(BooleanState.UNCHECKED, defaultColor), BooleanStyleSet.getDefaultStyle(BooleanState.NULL, defaultColor), defaultColor);
    }

    public static void setDefaultStyles(@NotNull DBPPreferenceStore store, @NotNull BooleanStyleSet set) {
        store.setValue("ui.render.boolean.style.mode", set.getMode().name());
        BooleanStyleSet.setDefaultStyle(store, set.getCheckedStyle(), BooleanState.CHECKED, set.getDefaultColor());
        BooleanStyleSet.setDefaultStyle(store, set.getUncheckedStyle(), BooleanState.UNCHECKED, set.getDefaultColor());
        BooleanStyleSet.setDefaultStyle(store, set.getNullStyle(), BooleanState.NULL, set.getDefaultColor());
    }

    public static void installStyleChangeListener(@NotNull Control control, @NotNull IPropertyChangeListener listener) {
        DBPPreferenceListener preferenceListener = e -> listener.propertyChange(new PropertyChangeEvent(e.getSource(), e.getProperty(), e.getOldValue(), e.getNewValue()));
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(listener);
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener(preferenceListener);
        DBWorkbench.getPlatform().getDataSourceProviderRegistry().getGlobalDataSourcePreferenceStore().addPropertyChangeListener(preferenceListener);
        control.addDisposeListener(e -> {
            DBWorkbench.getPlatform().getDataSourceProviderRegistry().getGlobalDataSourcePreferenceStore().removePropertyChangeListener(preferenceListener);
            DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener(preferenceListener);
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(listener);
        });
    }

    @NotNull
    private static BooleanStyle getDefaultStyle(@NotNull DBPPreferenceStore store, @NotNull BooleanMode mode, @NotNull BooleanState state, @NotNull RGB defaultColor) {
        String namespace = "ui.render.boolean.style." + state.getId() + ".";
        if (mode == BooleanMode.TEXT) {
            String text = store.getString(namespace + PROP_TEXT);
            UIElementAlignment alignment = (UIElementAlignment)CommonUtils.valueOf(UIElementAlignment.class, (String)store.getString(namespace + PROP_ALIGN), (Enum)UIElementAlignment.CENTER);
            UIElementFontStyle font = (UIElementFontStyle)CommonUtils.valueOf(UIElementFontStyle.class, (String)store.getString(namespace + PROP_FONT), (Enum)UIElementFontStyle.NORMAL);
            RGB color = BooleanStyleSet.convertStringToColor(store.getString(namespace + PROP_COLOR), defaultColor);
            return BooleanStyle.usingText(text.trim(), alignment, color, font);
        }
        UIElementAlignment alignment = (UIElementAlignment)CommonUtils.valueOf(UIElementAlignment.class, (String)store.getString(namespace + PROP_ALIGN), (Enum)UIElementAlignment.CENTER);
        return BooleanStyle.usingIcon(state.getIcon(), alignment);
    }

    private static BooleanStyle getDefaultStyle(@NotNull BooleanState state, @NotNull RGB color) {
        return BooleanStyle.usingText(state.choose("[v]", "[\u2000]", "[NULL]"), UIElementAlignment.CENTER, color, UIElementFontStyle.NORMAL);
    }

    @NotNull
    private static BooleanStyle getDefaultStyleLegacy(@NotNull DBPPreferenceStore store, @NotNull BooleanState state, @NotNull RGB color) {
        return switch (CommonUtils.toString((Object)store.getString(PREF_BOOLEAN_STYLE), (String)PROP_LEGACY_STYLE_TRUE_FALSE)) {
            case PROP_LEGACY_STYLE_ICON -> BooleanStyle.usingIcon(state.choose(UIIcon.CHECK_ON, UIIcon.CHECK_OFF, UIIcon.CHECK_QUEST), UIElementAlignment.CENTER);
            case PROP_LEGACY_STYLE_CHECKBOX -> BooleanStyle.usingText(state.choose("\u2611", "\u2610", "\u2612"), UIElementAlignment.CENTER, color, UIElementFontStyle.NORMAL);
            case PROP_LEGACY_STYLE_TRUE_FALSE -> BooleanStyle.usingText(state.choose("true", "false", "[NULL]"), UIElementAlignment.CENTER, color, UIElementFontStyle.NORMAL);
            case PROP_LEGACY_STYLE_YES_NO -> BooleanStyle.usingText(state.choose("yes", "no", "[NULL]"), UIElementAlignment.CENTER, color, UIElementFontStyle.NORMAL);
            default -> BooleanStyle.usingText(state.choose("[v]", "[\u2000]", "[NULL]"), UIElementAlignment.CENTER, color, UIElementFontStyle.NORMAL);
        };
    }

    private static void setDefaultStyle(@NotNull DBPPreferenceStore store, @NotNull BooleanStyle style, @NotNull BooleanState state, @NotNull RGB defaultColor) {
        String namespace = "ui.render.boolean.style." + state.getId() + ".";
        if (style.getMode() == BooleanMode.TEXT) {
            store.setValue(namespace + PROP_TEXT, style.getText().trim());
            store.setValue(namespace + PROP_ALIGN, style.getAlignment().name());
            store.setValue(namespace + PROP_FONT, style.getFontStyle().name());
            store.setValue(namespace + PROP_COLOR, BooleanStyleSet.convertColorToString(style.getColor(), defaultColor));
        } else {
            store.setValue(namespace + PROP_ALIGN, style.getAlignment().name());
        }
    }

    @NotNull
    private static String convertColorToString(@NotNull RGB color, @NotNull RGB defaultColor) {
        return color == defaultColor ? COLOR_DEFAULT : StringConverter.asString((RGB)color);
    }

    @NotNull
    private static RGB convertStringToColor(@NotNull String color, @NotNull RGB defaultColor) {
        return COLOR_DEFAULT.equals(color) ? defaultColor : StringConverter.asRGB((String)color, (RGB)defaultColor);
    }
}

