// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of malware scans. Each member account can view the malware scans
// for their own accounts. An administrator can view the malware scans for all the
// member accounts.
//
// There might be regional differences because some data sources might not be
// available in all the Amazon Web Services Regions where GuardDuty is presently
// supported. For more information, see [Regions and endpoints].
//
// [Regions and endpoints]: https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html
func (c *Client) DescribeMalwareScans(ctx context.Context, params *DescribeMalwareScansInput, optFns ...func(*Options)) (*DescribeMalwareScansOutput, error) {
	if params == nil {
		params = &DescribeMalwareScansInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeMalwareScans", params, optFns, c.addOperationDescribeMalwareScansMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeMalwareScansOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeMalwareScansInput struct {

	// The unique ID of the detector that the request is associated with.
	//
	// This member is required.
	DetectorId *string

	// Represents the criteria to be used in the filter for describing scan entries.
	FilterCriteria *types.FilterCriteria

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 50. The maximum value is 50.
	MaxResults *int32

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls to
	// the action, fill nextToken in the request with the value of NextToken from the
	// previous response to continue listing data.
	NextToken *string

	// Represents the criteria used for sorting scan entries. The [attributeName]attributeName is
	// required and it must be scanStartTime .
	//
	// [attributeName]: https://docs.aws.amazon.com/guardduty/latest/APIReference/API_SortCriteria.html#guardduty-Type-SortCriteria-attributeName
	SortCriteria *types.SortCriteria

	noSmithyDocumentSerde
}

type DescribeMalwareScansOutput struct {

	// Contains information about malware scans.
	//
	// This member is required.
	Scans []types.Scan

	// The pagination parameter to be used on the next list operation to retrieve more
	// items.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeMalwareScansMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeMalwareScans{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeMalwareScans{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeMalwareScans"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeMalwareScansValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeMalwareScans(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeMalwareScansAPIClient is a client that implements the
// DescribeMalwareScans operation.
type DescribeMalwareScansAPIClient interface {
	DescribeMalwareScans(context.Context, *DescribeMalwareScansInput, ...func(*Options)) (*DescribeMalwareScansOutput, error)
}

var _ DescribeMalwareScansAPIClient = (*Client)(nil)

// DescribeMalwareScansPaginatorOptions is the paginator options for
// DescribeMalwareScans
type DescribeMalwareScansPaginatorOptions struct {
	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 50. The maximum value is 50.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeMalwareScansPaginator is a paginator for DescribeMalwareScans
type DescribeMalwareScansPaginator struct {
	options   DescribeMalwareScansPaginatorOptions
	client    DescribeMalwareScansAPIClient
	params    *DescribeMalwareScansInput
	nextToken *string
	firstPage bool
}

// NewDescribeMalwareScansPaginator returns a new DescribeMalwareScansPaginator
func NewDescribeMalwareScansPaginator(client DescribeMalwareScansAPIClient, params *DescribeMalwareScansInput, optFns ...func(*DescribeMalwareScansPaginatorOptions)) *DescribeMalwareScansPaginator {
	if params == nil {
		params = &DescribeMalwareScansInput{}
	}

	options := DescribeMalwareScansPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeMalwareScansPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeMalwareScansPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeMalwareScans page.
func (p *DescribeMalwareScansPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeMalwareScansOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeMalwareScans(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeMalwareScans(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeMalwareScans",
	}
}
