// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/aiplatform/v1beta1/publisher_model.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An enum representing the open source category of a PublisherModel.
type PublisherModel_OpenSourceCategory int32

const (
	// The open source category is unspecified, which should not be used.
	PublisherModel_OPEN_SOURCE_CATEGORY_UNSPECIFIED PublisherModel_OpenSourceCategory = 0
	// Used to indicate the PublisherModel is not open sourced.
	PublisherModel_PROPRIETARY PublisherModel_OpenSourceCategory = 1
	// Used to indicate the PublisherModel is a Google-owned open source model
	// w/ Google checkpoint.
	PublisherModel_GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT PublisherModel_OpenSourceCategory = 2
	// Used to indicate the PublisherModel is a 3p-owned open source model w/
	// Google checkpoint.
	PublisherModel_THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT PublisherModel_OpenSourceCategory = 3
	// Used to indicate the PublisherModel is a Google-owned pure open source
	// model.
	PublisherModel_GOOGLE_OWNED_OSS PublisherModel_OpenSourceCategory = 4
	// Used to indicate the PublisherModel is a 3p-owned pure open source model.
	PublisherModel_THIRD_PARTY_OWNED_OSS PublisherModel_OpenSourceCategory = 5
)

// Enum value maps for PublisherModel_OpenSourceCategory.
var (
	PublisherModel_OpenSourceCategory_name = map[int32]string{
		0: "OPEN_SOURCE_CATEGORY_UNSPECIFIED",
		1: "PROPRIETARY",
		2: "GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT",
		3: "THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT",
		4: "GOOGLE_OWNED_OSS",
		5: "THIRD_PARTY_OWNED_OSS",
	}
	PublisherModel_OpenSourceCategory_value = map[string]int32{
		"OPEN_SOURCE_CATEGORY_UNSPECIFIED":             0,
		"PROPRIETARY":                                  1,
		"GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT":      2,
		"THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT": 3,
		"GOOGLE_OWNED_OSS":                             4,
		"THIRD_PARTY_OWNED_OSS":                        5,
	}
)

func (x PublisherModel_OpenSourceCategory) Enum() *PublisherModel_OpenSourceCategory {
	p := new(PublisherModel_OpenSourceCategory)
	*p = x
	return p
}

func (x PublisherModel_OpenSourceCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublisherModel_OpenSourceCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_enumTypes[0].Descriptor()
}

func (PublisherModel_OpenSourceCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_enumTypes[0]
}

func (x PublisherModel_OpenSourceCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublisherModel_OpenSourceCategory.Descriptor instead.
func (PublisherModel_OpenSourceCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 0}
}

// An enum representing the launch stage of a PublisherModel.
type PublisherModel_LaunchStage int32

const (
	// The model launch stage is unspecified.
	PublisherModel_LAUNCH_STAGE_UNSPECIFIED PublisherModel_LaunchStage = 0
	// Used to indicate the PublisherModel is at Experimental launch stage,
	// available to a small set of customers.
	PublisherModel_EXPERIMENTAL PublisherModel_LaunchStage = 1
	// Used to indicate the PublisherModel is at Private Preview launch stage,
	// only available to a small set of customers, although a larger set of
	// customers than an Experimental launch. Previews are the first launch
	// stage used to get feedback from customers.
	PublisherModel_PRIVATE_PREVIEW PublisherModel_LaunchStage = 2
	// Used to indicate the PublisherModel is at Public Preview launch stage,
	// available to all customers, although not supported for production
	// workloads.
	PublisherModel_PUBLIC_PREVIEW PublisherModel_LaunchStage = 3
	// Used to indicate the PublisherModel is at GA launch stage, available to
	// all customers and ready for production workload.
	PublisherModel_GA PublisherModel_LaunchStage = 4
)

// Enum value maps for PublisherModel_LaunchStage.
var (
	PublisherModel_LaunchStage_name = map[int32]string{
		0: "LAUNCH_STAGE_UNSPECIFIED",
		1: "EXPERIMENTAL",
		2: "PRIVATE_PREVIEW",
		3: "PUBLIC_PREVIEW",
		4: "GA",
	}
	PublisherModel_LaunchStage_value = map[string]int32{
		"LAUNCH_STAGE_UNSPECIFIED": 0,
		"EXPERIMENTAL":             1,
		"PRIVATE_PREVIEW":          2,
		"PUBLIC_PREVIEW":           3,
		"GA":                       4,
	}
)

func (x PublisherModel_LaunchStage) Enum() *PublisherModel_LaunchStage {
	p := new(PublisherModel_LaunchStage)
	*p = x
	return p
}

func (x PublisherModel_LaunchStage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublisherModel_LaunchStage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_enumTypes[1].Descriptor()
}

func (PublisherModel_LaunchStage) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_enumTypes[1]
}

func (x PublisherModel_LaunchStage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublisherModel_LaunchStage.Descriptor instead.
func (PublisherModel_LaunchStage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 1}
}

// An enum representing the state of the PublicModelVersion.
type PublisherModel_VersionState int32

const (
	// The version state is unspecified.
	PublisherModel_VERSION_STATE_UNSPECIFIED PublisherModel_VersionState = 0
	// Used to indicate the version is stable.
	PublisherModel_VERSION_STATE_STABLE PublisherModel_VersionState = 1
	// Used to indicate the version is unstable.
	PublisherModel_VERSION_STATE_UNSTABLE PublisherModel_VersionState = 2
)

// Enum value maps for PublisherModel_VersionState.
var (
	PublisherModel_VersionState_name = map[int32]string{
		0: "VERSION_STATE_UNSPECIFIED",
		1: "VERSION_STATE_STABLE",
		2: "VERSION_STATE_UNSTABLE",
	}
	PublisherModel_VersionState_value = map[string]int32{
		"VERSION_STATE_UNSPECIFIED": 0,
		"VERSION_STATE_STABLE":      1,
		"VERSION_STATE_UNSTABLE":    2,
	}
)

func (x PublisherModel_VersionState) Enum() *PublisherModel_VersionState {
	p := new(PublisherModel_VersionState)
	*p = x
	return p
}

func (x PublisherModel_VersionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublisherModel_VersionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_enumTypes[2].Descriptor()
}

func (PublisherModel_VersionState) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_enumTypes[2]
}

func (x PublisherModel_VersionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublisherModel_VersionState.Descriptor instead.
func (PublisherModel_VersionState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 2}
}

// A Model Garden Publisher Model.
type PublisherModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the PublisherModel.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Immutable. The version ID of the PublisherModel.
	// A new version is committed when a new model version is uploaded under an
	// existing model id. It is an auto-incrementing decimal number in string
	// representation.
	VersionId string `protobuf:"bytes,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Required. Indicates the open source category of the publisher model.
	OpenSourceCategory PublisherModel_OpenSourceCategory `protobuf:"varint,7,opt,name=open_source_category,json=openSourceCategory,proto3,enum=google.cloud.aiplatform.v1beta1.PublisherModel_OpenSourceCategory" json:"open_source_category,omitempty"`
	// Optional. The parent that this model was customized from. E.g., Vision API,
	// Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
	Parent *PublisherModel_Parent `protobuf:"bytes,14,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Supported call-to-action options.
	SupportedActions *PublisherModel_CallToAction `protobuf:"bytes,19,opt,name=supported_actions,json=supportedActions,proto3" json:"supported_actions,omitempty"`
	// Optional. Additional information about the model's Frameworks.
	Frameworks []string `protobuf:"bytes,23,rep,name=frameworks,proto3" json:"frameworks,omitempty"`
	// Optional. Indicates the launch stage of the model.
	LaunchStage PublisherModel_LaunchStage `protobuf:"varint,29,opt,name=launch_stage,json=launchStage,proto3,enum=google.cloud.aiplatform.v1beta1.PublisherModel_LaunchStage" json:"launch_stage,omitempty"`
	// Optional. Indicates the state of the model version.
	VersionState PublisherModel_VersionState `protobuf:"varint,37,opt,name=version_state,json=versionState,proto3,enum=google.cloud.aiplatform.v1beta1.PublisherModel_VersionState" json:"version_state,omitempty"`
	// Optional. Output only. Immutable. Used to indicate this model has a
	// publisher model and provide the template of the publisher model resource
	// name.
	PublisherModelTemplate string `protobuf:"bytes,30,opt,name=publisher_model_template,json=publisherModelTemplate,proto3" json:"publisher_model_template,omitempty"`
	// Optional. The schemata that describes formats of the PublisherModel's
	// predictions and explanations as given and returned via
	// [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
	PredictSchemata *PredictSchemata `protobuf:"bytes,31,opt,name=predict_schemata,json=predictSchemata,proto3" json:"predict_schemata,omitempty"`
}

func (x *PublisherModel) Reset() {
	*x = PublisherModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel) ProtoMessage() {}

func (x *PublisherModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel.ProtoReflect.Descriptor instead.
func (*PublisherModel) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0}
}

func (x *PublisherModel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PublisherModel) GetVersionId() string {
	if x != nil {
		return x.VersionId
	}
	return ""
}

func (x *PublisherModel) GetOpenSourceCategory() PublisherModel_OpenSourceCategory {
	if x != nil {
		return x.OpenSourceCategory
	}
	return PublisherModel_OPEN_SOURCE_CATEGORY_UNSPECIFIED
}

func (x *PublisherModel) GetParent() *PublisherModel_Parent {
	if x != nil {
		return x.Parent
	}
	return nil
}

func (x *PublisherModel) GetSupportedActions() *PublisherModel_CallToAction {
	if x != nil {
		return x.SupportedActions
	}
	return nil
}

func (x *PublisherModel) GetFrameworks() []string {
	if x != nil {
		return x.Frameworks
	}
	return nil
}

func (x *PublisherModel) GetLaunchStage() PublisherModel_LaunchStage {
	if x != nil {
		return x.LaunchStage
	}
	return PublisherModel_LAUNCH_STAGE_UNSPECIFIED
}

func (x *PublisherModel) GetVersionState() PublisherModel_VersionState {
	if x != nil {
		return x.VersionState
	}
	return PublisherModel_VERSION_STATE_UNSPECIFIED
}

func (x *PublisherModel) GetPublisherModelTemplate() string {
	if x != nil {
		return x.PublisherModelTemplate
	}
	return ""
}

func (x *PublisherModel) GetPredictSchemata() *PredictSchemata {
	if x != nil {
		return x.PredictSchemata
	}
	return nil
}

// Reference to a resource.
type PublisherModel_ResourceReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Reference:
	//
	//	*PublisherModel_ResourceReference_Uri
	//	*PublisherModel_ResourceReference_ResourceName
	//	*PublisherModel_ResourceReference_UseCase
	//	*PublisherModel_ResourceReference_Description
	Reference isPublisherModel_ResourceReference_Reference `protobuf_oneof:"reference"`
}

func (x *PublisherModel_ResourceReference) Reset() {
	*x = PublisherModel_ResourceReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_ResourceReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_ResourceReference) ProtoMessage() {}

func (x *PublisherModel_ResourceReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_ResourceReference.ProtoReflect.Descriptor instead.
func (*PublisherModel_ResourceReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 0}
}

func (m *PublisherModel_ResourceReference) GetReference() isPublisherModel_ResourceReference_Reference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (x *PublisherModel_ResourceReference) GetUri() string {
	if x, ok := x.GetReference().(*PublisherModel_ResourceReference_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *PublisherModel_ResourceReference) GetResourceName() string {
	if x, ok := x.GetReference().(*PublisherModel_ResourceReference_ResourceName); ok {
		return x.ResourceName
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/publisher_model.proto.
func (x *PublisherModel_ResourceReference) GetUseCase() string {
	if x, ok := x.GetReference().(*PublisherModel_ResourceReference_UseCase); ok {
		return x.UseCase
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/publisher_model.proto.
func (x *PublisherModel_ResourceReference) GetDescription() string {
	if x, ok := x.GetReference().(*PublisherModel_ResourceReference_Description); ok {
		return x.Description
	}
	return ""
}

type isPublisherModel_ResourceReference_Reference interface {
	isPublisherModel_ResourceReference_Reference()
}

type PublisherModel_ResourceReference_Uri struct {
	// The URI of the resource.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type PublisherModel_ResourceReference_ResourceName struct {
	// The resource name of the Google Cloud resource.
	ResourceName string `protobuf:"bytes,2,opt,name=resource_name,json=resourceName,proto3,oneof"`
}

type PublisherModel_ResourceReference_UseCase struct {
	// Use case (CUJ) of the resource.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/publisher_model.proto.
	UseCase string `protobuf:"bytes,3,opt,name=use_case,json=useCase,proto3,oneof"`
}

type PublisherModel_ResourceReference_Description struct {
	// Description of the resource.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/publisher_model.proto.
	Description string `protobuf:"bytes,4,opt,name=description,proto3,oneof"`
}

func (*PublisherModel_ResourceReference_Uri) isPublisherModel_ResourceReference_Reference() {}

func (*PublisherModel_ResourceReference_ResourceName) isPublisherModel_ResourceReference_Reference() {
}

func (*PublisherModel_ResourceReference_UseCase) isPublisherModel_ResourceReference_Reference() {}

func (*PublisherModel_ResourceReference_Description) isPublisherModel_ResourceReference_Reference() {}

// The information about the parent of a model.
type PublisherModel_Parent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
	// Natural Language API.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The Google Cloud resource name or the URI reference.
	Reference *PublisherModel_ResourceReference `protobuf:"bytes,2,opt,name=reference,proto3" json:"reference,omitempty"`
}

func (x *PublisherModel_Parent) Reset() {
	*x = PublisherModel_Parent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_Parent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_Parent) ProtoMessage() {}

func (x *PublisherModel_Parent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_Parent.ProtoReflect.Descriptor instead.
func (*PublisherModel_Parent) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 1}
}

func (x *PublisherModel_Parent) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PublisherModel_Parent) GetReference() *PublisherModel_ResourceReference {
	if x != nil {
		return x.Reference
	}
	return nil
}

// A named piece of documentation.
type PublisherModel_Documentation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK & SAMPLES, JAVA,
	// NODE.JS, etc..
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Required. Content of this piece of document (in Markdown format).
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *PublisherModel_Documentation) Reset() {
	*x = PublisherModel_Documentation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_Documentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_Documentation) ProtoMessage() {}

func (x *PublisherModel_Documentation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_Documentation.ProtoReflect.Descriptor instead.
func (*PublisherModel_Documentation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 2}
}

func (x *PublisherModel_Documentation) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *PublisherModel_Documentation) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

// Actions could take on this Publisher Model.
type PublisherModel_CallToAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. To view Rest API docs.
	ViewRestApi *PublisherModel_CallToAction_ViewRestApi `protobuf:"bytes,1,opt,name=view_rest_api,json=viewRestApi,proto3" json:"view_rest_api,omitempty"`
	// Optional. Open notebook of the PublisherModel.
	OpenNotebook *PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,2,opt,name=open_notebook,json=openNotebook,proto3" json:"open_notebook,omitempty"`
	// Optional. Open notebooks of the PublisherModel.
	OpenNotebooks *PublisherModel_CallToAction_OpenNotebooks `protobuf:"bytes,12,opt,name=open_notebooks,json=openNotebooks,proto3,oneof" json:"open_notebooks,omitempty"`
	// Optional. Create application using the PublisherModel.
	CreateApplication *PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,3,opt,name=create_application,json=createApplication,proto3" json:"create_application,omitempty"`
	// Optional. Open fine-tuning pipeline of the PublisherModel.
	OpenFineTuningPipeline *PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,4,opt,name=open_fine_tuning_pipeline,json=openFineTuningPipeline,proto3" json:"open_fine_tuning_pipeline,omitempty"`
	// Optional. Open fine-tuning pipelines of the PublisherModel.
	OpenFineTuningPipelines *PublisherModel_CallToAction_OpenFineTuningPipelines `protobuf:"bytes,13,opt,name=open_fine_tuning_pipelines,json=openFineTuningPipelines,proto3,oneof" json:"open_fine_tuning_pipelines,omitempty"`
	// Optional. Open prompt-tuning pipeline of the PublisherModel.
	OpenPromptTuningPipeline *PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,5,opt,name=open_prompt_tuning_pipeline,json=openPromptTuningPipeline,proto3" json:"open_prompt_tuning_pipeline,omitempty"`
	// Optional. Open Genie / Playground.
	OpenGenie *PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,6,opt,name=open_genie,json=openGenie,proto3" json:"open_genie,omitempty"`
	// Optional. Deploy the PublisherModel to Vertex Endpoint.
	Deploy *PublisherModel_CallToAction_Deploy `protobuf:"bytes,7,opt,name=deploy,proto3" json:"deploy,omitempty"`
	// Optional. Deploy PublisherModel to Google Kubernetes Engine.
	DeployGke *PublisherModel_CallToAction_DeployGke `protobuf:"bytes,14,opt,name=deploy_gke,json=deployGke,proto3" json:"deploy_gke,omitempty"`
	// Optional. Open in Generation AI Studio.
	OpenGenerationAiStudio *PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,8,opt,name=open_generation_ai_studio,json=openGenerationAiStudio,proto3" json:"open_generation_ai_studio,omitempty"`
	// Optional. Request for access.
	RequestAccess *PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,9,opt,name=request_access,json=requestAccess,proto3" json:"request_access,omitempty"`
	// Optional. Open evaluation pipeline of the PublisherModel.
	OpenEvaluationPipeline *PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,11,opt,name=open_evaluation_pipeline,json=openEvaluationPipeline,proto3" json:"open_evaluation_pipeline,omitempty"`
}

func (x *PublisherModel_CallToAction) Reset() {
	*x = PublisherModel_CallToAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_CallToAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_CallToAction) ProtoMessage() {}

func (x *PublisherModel_CallToAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_CallToAction.ProtoReflect.Descriptor instead.
func (*PublisherModel_CallToAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 3}
}

func (x *PublisherModel_CallToAction) GetViewRestApi() *PublisherModel_CallToAction_ViewRestApi {
	if x != nil {
		return x.ViewRestApi
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetOpenNotebook() *PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.OpenNotebook
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetOpenNotebooks() *PublisherModel_CallToAction_OpenNotebooks {
	if x != nil {
		return x.OpenNotebooks
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetCreateApplication() *PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.CreateApplication
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetOpenFineTuningPipeline() *PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.OpenFineTuningPipeline
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetOpenFineTuningPipelines() *PublisherModel_CallToAction_OpenFineTuningPipelines {
	if x != nil {
		return x.OpenFineTuningPipelines
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetOpenPromptTuningPipeline() *PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.OpenPromptTuningPipeline
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetOpenGenie() *PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.OpenGenie
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetDeploy() *PublisherModel_CallToAction_Deploy {
	if x != nil {
		return x.Deploy
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetDeployGke() *PublisherModel_CallToAction_DeployGke {
	if x != nil {
		return x.DeployGke
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetOpenGenerationAiStudio() *PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.OpenGenerationAiStudio
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetRequestAccess() *PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.RequestAccess
	}
	return nil
}

func (x *PublisherModel_CallToAction) GetOpenEvaluationPipeline() *PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.OpenEvaluationPipeline
	}
	return nil
}

// The regional resource name or the URI. Key is region, e.g.,
// us-central1, europe-west2, global, etc..
type PublisherModel_CallToAction_RegionalResourceReferences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	References map[string]*PublisherModel_ResourceReference `protobuf:"bytes,1,rep,name=references,proto3" json:"references,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. Title of the resource.
	ResourceTitle *string `protobuf:"bytes,3,opt,name=resource_title,json=resourceTitle,proto3,oneof" json:"resource_title,omitempty"`
	// Optional. Use case (CUJ) of the resource.
	ResourceUseCase *string `protobuf:"bytes,4,opt,name=resource_use_case,json=resourceUseCase,proto3,oneof" json:"resource_use_case,omitempty"`
	// Optional. Description of the resource.
	ResourceDescription *string `protobuf:"bytes,5,opt,name=resource_description,json=resourceDescription,proto3,oneof" json:"resource_description,omitempty"`
}

func (x *PublisherModel_CallToAction_RegionalResourceReferences) Reset() {
	*x = PublisherModel_CallToAction_RegionalResourceReferences{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_CallToAction_RegionalResourceReferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_CallToAction_RegionalResourceReferences) ProtoMessage() {}

func (x *PublisherModel_CallToAction_RegionalResourceReferences) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_CallToAction_RegionalResourceReferences.ProtoReflect.Descriptor instead.
func (*PublisherModel_CallToAction_RegionalResourceReferences) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *PublisherModel_CallToAction_RegionalResourceReferences) GetReferences() map[string]*PublisherModel_ResourceReference {
	if x != nil {
		return x.References
	}
	return nil
}

func (x *PublisherModel_CallToAction_RegionalResourceReferences) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *PublisherModel_CallToAction_RegionalResourceReferences) GetResourceTitle() string {
	if x != nil && x.ResourceTitle != nil {
		return *x.ResourceTitle
	}
	return ""
}

func (x *PublisherModel_CallToAction_RegionalResourceReferences) GetResourceUseCase() string {
	if x != nil && x.ResourceUseCase != nil {
		return *x.ResourceUseCase
	}
	return ""
}

func (x *PublisherModel_CallToAction_RegionalResourceReferences) GetResourceDescription() string {
	if x != nil && x.ResourceDescription != nil {
		return *x.ResourceDescription
	}
	return ""
}

// Rest API docs.
type PublisherModel_CallToAction_ViewRestApi struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Documentations []*PublisherModel_Documentation `protobuf:"bytes,1,rep,name=documentations,proto3" json:"documentations,omitempty"`
	// Required. The title of the view rest API.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
}

func (x *PublisherModel_CallToAction_ViewRestApi) Reset() {
	*x = PublisherModel_CallToAction_ViewRestApi{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_CallToAction_ViewRestApi) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_CallToAction_ViewRestApi) ProtoMessage() {}

func (x *PublisherModel_CallToAction_ViewRestApi) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_CallToAction_ViewRestApi.ProtoReflect.Descriptor instead.
func (*PublisherModel_CallToAction_ViewRestApi) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 3, 1}
}

func (x *PublisherModel_CallToAction_ViewRestApi) GetDocumentations() []*PublisherModel_Documentation {
	if x != nil {
		return x.Documentations
	}
	return nil
}

func (x *PublisherModel_CallToAction_ViewRestApi) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

// Open notebooks.
type PublisherModel_CallToAction_OpenNotebooks struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Regional resource references to notebooks.
	Notebooks []*PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,1,rep,name=notebooks,proto3" json:"notebooks,omitempty"`
}

func (x *PublisherModel_CallToAction_OpenNotebooks) Reset() {
	*x = PublisherModel_CallToAction_OpenNotebooks{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_CallToAction_OpenNotebooks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_CallToAction_OpenNotebooks) ProtoMessage() {}

func (x *PublisherModel_CallToAction_OpenNotebooks) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_CallToAction_OpenNotebooks.ProtoReflect.Descriptor instead.
func (*PublisherModel_CallToAction_OpenNotebooks) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 3, 2}
}

func (x *PublisherModel_CallToAction_OpenNotebooks) GetNotebooks() []*PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.Notebooks
	}
	return nil
}

// Open fine tuning pipelines.
type PublisherModel_CallToAction_OpenFineTuningPipelines struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Regional resource references to fine tuning pipelines.
	FineTuningPipelines []*PublisherModel_CallToAction_RegionalResourceReferences `protobuf:"bytes,1,rep,name=fine_tuning_pipelines,json=fineTuningPipelines,proto3" json:"fine_tuning_pipelines,omitempty"`
}

func (x *PublisherModel_CallToAction_OpenFineTuningPipelines) Reset() {
	*x = PublisherModel_CallToAction_OpenFineTuningPipelines{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_CallToAction_OpenFineTuningPipelines) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_CallToAction_OpenFineTuningPipelines) ProtoMessage() {}

func (x *PublisherModel_CallToAction_OpenFineTuningPipelines) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_CallToAction_OpenFineTuningPipelines.ProtoReflect.Descriptor instead.
func (*PublisherModel_CallToAction_OpenFineTuningPipelines) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 3, 3}
}

func (x *PublisherModel_CallToAction_OpenFineTuningPipelines) GetFineTuningPipelines() []*PublisherModel_CallToAction_RegionalResourceReferences {
	if x != nil {
		return x.FineTuningPipelines
	}
	return nil
}

// Model metadata that is needed for UploadModel or
// DeployModel/CreateEndpoint requests.
type PublisherModel_CallToAction_Deploy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prediction (for example, the machine) resources that the
	// DeployedModel uses.
	//
	// Types that are assignable to PredictionResources:
	//
	//	*PublisherModel_CallToAction_Deploy_DedicatedResources
	//	*PublisherModel_CallToAction_Deploy_AutomaticResources
	//	*PublisherModel_CallToAction_Deploy_SharedResources
	PredictionResources isPublisherModel_CallToAction_Deploy_PredictionResources `protobuf_oneof:"prediction_resources"`
	// Optional. Default model display name.
	ModelDisplayName string `protobuf:"bytes,1,opt,name=model_display_name,json=modelDisplayName,proto3" json:"model_display_name,omitempty"`
	// Optional. Large model reference. When this is set, model_artifact_spec
	// is not needed.
	LargeModelReference *LargeModelReference `protobuf:"bytes,2,opt,name=large_model_reference,json=largeModelReference,proto3" json:"large_model_reference,omitempty"`
	// Optional. The specification of the container that is to be used when
	// deploying this Model in Vertex AI. Not present for Large Models.
	ContainerSpec *ModelContainerSpec `protobuf:"bytes,3,opt,name=container_spec,json=containerSpec,proto3" json:"container_spec,omitempty"`
	// Optional. The path to the directory containing the Model artifact and
	// any of its supporting files.
	ArtifactUri string `protobuf:"bytes,4,opt,name=artifact_uri,json=artifactUri,proto3" json:"artifact_uri,omitempty"`
	// Required. The title of the regional resource reference.
	Title string `protobuf:"bytes,8,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The signed URI for ephemeral Cloud Storage access to model
	// artifact.
	PublicArtifactUri string `protobuf:"bytes,9,opt,name=public_artifact_uri,json=publicArtifactUri,proto3" json:"public_artifact_uri,omitempty"`
}

func (x *PublisherModel_CallToAction_Deploy) Reset() {
	*x = PublisherModel_CallToAction_Deploy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_CallToAction_Deploy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_CallToAction_Deploy) ProtoMessage() {}

func (x *PublisherModel_CallToAction_Deploy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_CallToAction_Deploy.ProtoReflect.Descriptor instead.
func (*PublisherModel_CallToAction_Deploy) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 3, 4}
}

func (m *PublisherModel_CallToAction_Deploy) GetPredictionResources() isPublisherModel_CallToAction_Deploy_PredictionResources {
	if m != nil {
		return m.PredictionResources
	}
	return nil
}

func (x *PublisherModel_CallToAction_Deploy) GetDedicatedResources() *DedicatedResources {
	if x, ok := x.GetPredictionResources().(*PublisherModel_CallToAction_Deploy_DedicatedResources); ok {
		return x.DedicatedResources
	}
	return nil
}

func (x *PublisherModel_CallToAction_Deploy) GetAutomaticResources() *AutomaticResources {
	if x, ok := x.GetPredictionResources().(*PublisherModel_CallToAction_Deploy_AutomaticResources); ok {
		return x.AutomaticResources
	}
	return nil
}

func (x *PublisherModel_CallToAction_Deploy) GetSharedResources() string {
	if x, ok := x.GetPredictionResources().(*PublisherModel_CallToAction_Deploy_SharedResources); ok {
		return x.SharedResources
	}
	return ""
}

func (x *PublisherModel_CallToAction_Deploy) GetModelDisplayName() string {
	if x != nil {
		return x.ModelDisplayName
	}
	return ""
}

func (x *PublisherModel_CallToAction_Deploy) GetLargeModelReference() *LargeModelReference {
	if x != nil {
		return x.LargeModelReference
	}
	return nil
}

func (x *PublisherModel_CallToAction_Deploy) GetContainerSpec() *ModelContainerSpec {
	if x != nil {
		return x.ContainerSpec
	}
	return nil
}

func (x *PublisherModel_CallToAction_Deploy) GetArtifactUri() string {
	if x != nil {
		return x.ArtifactUri
	}
	return ""
}

func (x *PublisherModel_CallToAction_Deploy) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *PublisherModel_CallToAction_Deploy) GetPublicArtifactUri() string {
	if x != nil {
		return x.PublicArtifactUri
	}
	return ""
}

type isPublisherModel_CallToAction_Deploy_PredictionResources interface {
	isPublisherModel_CallToAction_Deploy_PredictionResources()
}

type PublisherModel_CallToAction_Deploy_DedicatedResources struct {
	// A description of resources that are dedicated to the DeployedModel,
	// and that need a higher degree of manual configuration.
	DedicatedResources *DedicatedResources `protobuf:"bytes,5,opt,name=dedicated_resources,json=dedicatedResources,proto3,oneof"`
}

type PublisherModel_CallToAction_Deploy_AutomaticResources struct {
	// A description of resources that to large degree are decided by Vertex
	// AI, and require only a modest additional configuration.
	AutomaticResources *AutomaticResources `protobuf:"bytes,6,opt,name=automatic_resources,json=automaticResources,proto3,oneof"`
}

type PublisherModel_CallToAction_Deploy_SharedResources struct {
	// The resource name of the shared DeploymentResourcePool to deploy on.
	// Format:
	// `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
	SharedResources string `protobuf:"bytes,7,opt,name=shared_resources,json=sharedResources,proto3,oneof"`
}

func (*PublisherModel_CallToAction_Deploy_DedicatedResources) isPublisherModel_CallToAction_Deploy_PredictionResources() {
}

func (*PublisherModel_CallToAction_Deploy_AutomaticResources) isPublisherModel_CallToAction_Deploy_PredictionResources() {
}

func (*PublisherModel_CallToAction_Deploy_SharedResources) isPublisherModel_CallToAction_Deploy_PredictionResources() {
}

// Configurations for PublisherModel GKE deployment
type PublisherModel_CallToAction_DeployGke struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. GKE deployment configuration in yaml format.
	GkeYamlConfigs []string `protobuf:"bytes,1,rep,name=gke_yaml_configs,json=gkeYamlConfigs,proto3" json:"gke_yaml_configs,omitempty"`
}

func (x *PublisherModel_CallToAction_DeployGke) Reset() {
	*x = PublisherModel_CallToAction_DeployGke{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherModel_CallToAction_DeployGke) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModel_CallToAction_DeployGke) ProtoMessage() {}

func (x *PublisherModel_CallToAction_DeployGke) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModel_CallToAction_DeployGke.ProtoReflect.Descriptor instead.
func (*PublisherModel_CallToAction_DeployGke) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP(), []int{0, 3, 5}
}

func (x *PublisherModel_CallToAction_DeployGke) GetGkeYamlConfigs() []string {
	if x != nil {
		return x.GkeYamlConfigs
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_publisher_model_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb6, 0x29, 0x0a, 0x0e, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x79, 0x0a,
	0x14, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4f, 0x70, 0x65,
	0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6f, 0x70, 0x65, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x53, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6e, 0x0a,
	0x11, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a,
	0x0a, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x12, 0x63, 0x0a, 0x0c, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x61,
	0x67, 0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68,
	0x53, 0x74, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6c, 0x61, 0x75, 0x6e,
	0x63, 0x68, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x66, 0x0a, 0x0d, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x40, 0x0a, 0x18, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x60, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x74, 0x61, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x74, 0x61, 0x1a, 0xa4, 0x01, 0x0a, 0x11, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x25, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x5f, 0x63, 0x61, 0x73, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x07, 0x75, 0x73,
	0x65, 0x43, 0x61, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0b, 0x0a,
	0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x96, 0x01, 0x0a, 0x06, 0x50,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x64, 0x0a,
	0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x1a, 0x49, 0x0a, 0x0d, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a, 0xf9,
	0x1b, 0x0a, 0x0c, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x71, 0x0a, 0x0d, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x70, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x73, 0x74, 0x41, 0x70, 0x69,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x73, 0x74, 0x41,
	0x70, 0x69, 0x12, 0x81, 0x01, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c,
	0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6f, 0x70, 0x65, 0x6e, 0x4e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x7b, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65,
	0x6e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x8b, 0x01, 0x0a, 0x12, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x97, 0x01, 0x0a, 0x19, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6e, 0x65, 0x5f,
	0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x16, 0x6f, 0x70, 0x65, 0x6e, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x9b, 0x01, 0x0a, 0x1a,
	0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f,
	0x70, 0x65, 0x6e, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x17, 0x6f,
	0x70, 0x65, 0x6e, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x9b, 0x01, 0x0a, 0x1b, 0x6f, 0x70,
	0x65, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x6f,
	0x70, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x7b, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x6e, 0x5f,
	0x67, 0x65, 0x6e, 0x69, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c,
	0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x47,
	0x65, 0x6e, 0x69, 0x65, 0x12, 0x60, 0x0a, 0x06, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0x6a, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x5f, 0x67, 0x6b, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c,
	0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x47,
	0x6b, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x47,
	0x6b, 0x65, 0x12, 0x97, 0x01, 0x0a, 0x19, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x69, 0x5f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x6f, 0x70, 0x65, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x69, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x83, 0x01, 0x0a,
	0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x12, 0x96, 0x01, 0x0a, 0x18, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x65, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x16, 0x6f, 0x70, 0x65, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x1a, 0xaf, 0x04, 0x0a, 0x1a,
	0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x8c, 0x01, 0x0a, 0x0a, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x69, 0x74,
	0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x55, 0x73, 0x65, 0x43, 0x61, 0x73, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x14, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02,
	0x52, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x1a, 0x80, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x57,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x14,
	0x0a, 0x12, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f,
	0x63, 0x61, 0x73, 0x65, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x94, 0x01,
	0x0a, 0x0b, 0x56, 0x69, 0x65, 0x77, 0x52, 0x65, 0x73, 0x74, 0x41, 0x70, 0x69, 0x12, 0x6a, 0x0a,
	0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x1a, 0x8b, 0x01, 0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x6e, 0x4e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0x7a, 0x0a, 0x09, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x54,
	0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x1a, 0xac, 0x01, 0x0a, 0x17, 0x4f, 0x70, 0x65, 0x6e, 0x46, 0x69, 0x6e, 0x65, 0x54,
	0x75, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x90,
	0x01, 0x0a, 0x15, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x57,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x66, 0x69,
	0x6e, 0x65, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x1a, 0x98, 0x05, 0x0a, 0x06, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0x66, 0x0a, 0x13,
	0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x64, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x48, 0x00,
	0x52, 0x12, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x66, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x63, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x48, 0x00, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x10,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x12, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6d, 0x0a, 0x15,
	0x6c, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61,
	0x72, 0x67, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x0e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0c,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x55, 0x72, 0x69, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12,
	0x33, 0x0a, 0x13, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x55, 0x72, 0x69, 0x42, 0x16, 0x0a, 0x14, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x3a, 0x0a, 0x09,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x47, 0x6b, 0x65, 0x12, 0x2d, 0x0a, 0x10, 0x67, 0x6b, 0x65,
	0x5f, 0x79, 0x61, 0x6d, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x67, 0x6b, 0x65, 0x59, 0x61, 0x6d,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x6f, 0x70, 0x65,
	0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x42, 0x1d, 0x0a, 0x1b, 0x5f,
	0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x22, 0xdb, 0x01, 0x0a, 0x12, 0x4f,
	0x70, 0x65, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x12, 0x24, 0x0a, 0x20, 0x4f, 0x50, 0x45, 0x4e, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x50, 0x52,
	0x49, 0x45, 0x54, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x2b, 0x0a, 0x27, 0x47, 0x4f, 0x4f, 0x47,
	0x4c, 0x45, 0x5f, 0x4f, 0x57, 0x4e, 0x45, 0x44, 0x5f, 0x4f, 0x53, 0x53, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x50, 0x4f,
	0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x30, 0x0a, 0x2c, 0x54, 0x48, 0x49, 0x52, 0x44, 0x5f, 0x50,
	0x41, 0x52, 0x54, 0x59, 0x5f, 0x4f, 0x57, 0x4e, 0x45, 0x44, 0x5f, 0x4f, 0x53, 0x53, 0x5f, 0x57,
	0x49, 0x54, 0x48, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b,
	0x50, 0x4f, 0x49, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x4f, 0x4f, 0x47, 0x4c,
	0x45, 0x5f, 0x4f, 0x57, 0x4e, 0x45, 0x44, 0x5f, 0x4f, 0x53, 0x53, 0x10, 0x04, 0x12, 0x19, 0x0a,
	0x15, 0x54, 0x48, 0x49, 0x52, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x59, 0x5f, 0x4f, 0x57, 0x4e,
	0x45, 0x44, 0x5f, 0x4f, 0x53, 0x53, 0x10, 0x05, 0x22, 0x6e, 0x0a, 0x0b, 0x4c, 0x61, 0x75, 0x6e,
	0x63, 0x68, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4c, 0x41, 0x55, 0x4e, 0x43,
	0x48, 0x5f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x58, 0x50, 0x45, 0x52, 0x49, 0x4d,
	0x45, 0x4e, 0x54, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x52, 0x49, 0x56, 0x41,
	0x54, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e,
	0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x50, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x10, 0x03,
	0x12, 0x06, 0x0a, 0x02, 0x47, 0x41, 0x10, 0x04, 0x22, 0x63, 0x0a, 0x0c, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x56, 0x45, 0x52, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x56, 0x45, 0x52, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10,
	0x01, 0x12, 0x1a, 0x0a, 0x16, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x3a, 0x54, 0xea,
	0x41, 0x51, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x25, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x7d, 0x42, 0xea, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x13, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_publisher_model_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_aiplatform_v1beta1_publisher_model_proto_goTypes = []interface{}{
	(PublisherModel_OpenSourceCategory)(0),                         // 0: google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory
	(PublisherModel_LaunchStage)(0),                                // 1: google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage
	(PublisherModel_VersionState)(0),                               // 2: google.cloud.aiplatform.v1beta1.PublisherModel.VersionState
	(*PublisherModel)(nil),                                         // 3: google.cloud.aiplatform.v1beta1.PublisherModel
	(*PublisherModel_ResourceReference)(nil),                       // 4: google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
	(*PublisherModel_Parent)(nil),                                  // 5: google.cloud.aiplatform.v1beta1.PublisherModel.Parent
	(*PublisherModel_Documentation)(nil),                           // 6: google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
	(*PublisherModel_CallToAction)(nil),                            // 7: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
	(*PublisherModel_CallToAction_RegionalResourceReferences)(nil), // 8: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	(*PublisherModel_CallToAction_ViewRestApi)(nil),                // 9: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
	(*PublisherModel_CallToAction_OpenNotebooks)(nil),              // 10: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
	(*PublisherModel_CallToAction_OpenFineTuningPipelines)(nil),    // 11: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
	(*PublisherModel_CallToAction_Deploy)(nil),                     // 12: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
	(*PublisherModel_CallToAction_DeployGke)(nil),                  // 13: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
	nil,                         // 14: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences.ReferencesEntry
	(*PredictSchemata)(nil),     // 15: google.cloud.aiplatform.v1beta1.PredictSchemata
	(*DedicatedResources)(nil),  // 16: google.cloud.aiplatform.v1beta1.DedicatedResources
	(*AutomaticResources)(nil),  // 17: google.cloud.aiplatform.v1beta1.AutomaticResources
	(*LargeModelReference)(nil), // 18: google.cloud.aiplatform.v1beta1.LargeModelReference
	(*ModelContainerSpec)(nil),  // 19: google.cloud.aiplatform.v1beta1.ModelContainerSpec
}
var file_google_cloud_aiplatform_v1beta1_publisher_model_proto_depIdxs = []int32{
	0,  // 0: google.cloud.aiplatform.v1beta1.PublisherModel.open_source_category:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory
	5,  // 1: google.cloud.aiplatform.v1beta1.PublisherModel.parent:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.Parent
	7,  // 2: google.cloud.aiplatform.v1beta1.PublisherModel.supported_actions:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
	1,  // 3: google.cloud.aiplatform.v1beta1.PublisherModel.launch_stage:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage
	2,  // 4: google.cloud.aiplatform.v1beta1.PublisherModel.version_state:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.VersionState
	15, // 5: google.cloud.aiplatform.v1beta1.PublisherModel.predict_schemata:type_name -> google.cloud.aiplatform.v1beta1.PredictSchemata
	4,  // 6: google.cloud.aiplatform.v1beta1.PublisherModel.Parent.reference:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
	9,  // 7: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.view_rest_api:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
	8,  // 8: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.open_notebook:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	10, // 9: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.open_notebooks:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
	8,  // 10: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.create_application:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	8,  // 11: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.open_fine_tuning_pipeline:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	11, // 12: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.open_fine_tuning_pipelines:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
	8,  // 13: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.open_prompt_tuning_pipeline:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	8,  // 14: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.open_genie:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	12, // 15: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.deploy:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
	13, // 16: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.deploy_gke:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
	8,  // 17: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.open_generation_ai_studio:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	8,  // 18: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.request_access:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	8,  // 19: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.open_evaluation_pipeline:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	14, // 20: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences.references:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences.ReferencesEntry
	6,  // 21: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi.documentations:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
	8,  // 22: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks.notebooks:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	8,  // 23: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines.fine_tuning_pipelines:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
	16, // 24: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.dedicated_resources:type_name -> google.cloud.aiplatform.v1beta1.DedicatedResources
	17, // 25: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.automatic_resources:type_name -> google.cloud.aiplatform.v1beta1.AutomaticResources
	18, // 26: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.large_model_reference:type_name -> google.cloud.aiplatform.v1beta1.LargeModelReference
	19, // 27: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.container_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelContainerSpec
	4,  // 28: google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences.ReferencesEntry.value:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
	29, // [29:29] is the sub-list for method output_type
	29, // [29:29] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_publisher_model_proto_init() }
func file_google_cloud_aiplatform_v1beta1_publisher_model_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_publisher_model_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_machine_resources_proto_init()
	file_google_cloud_aiplatform_v1beta1_model_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_ResourceReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_Parent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_Documentation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_CallToAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_CallToAction_RegionalResourceReferences); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_CallToAction_ViewRestApi); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_CallToAction_OpenNotebooks); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_CallToAction_OpenFineTuningPipelines); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_CallToAction_Deploy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherModel_CallToAction_DeployGke); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*PublisherModel_ResourceReference_Uri)(nil),
		(*PublisherModel_ResourceReference_ResourceName)(nil),
		(*PublisherModel_ResourceReference_UseCase)(nil),
		(*PublisherModel_ResourceReference_Description)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[5].OneofWrappers = []interface{}{}
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*PublisherModel_CallToAction_Deploy_DedicatedResources)(nil),
		(*PublisherModel_CallToAction_Deploy_AutomaticResources)(nil),
		(*PublisherModel_CallToAction_Deploy_SharedResources)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_publisher_model_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_publisher_model_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_publisher_model_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_publisher_model_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_publisher_model_proto = out.File
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_depIdxs = nil
}
