// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/discoveryengine/v1/user_event.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// UserEvent captures all metadata information Discovery Engine API needs to
// know about how end users interact with customers' website.
type UserEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. User event type. Allowed values are:
	//
	// Generic values:
	//
	// * `search`: Search for Documents.
	// * `view-item`: Detailed page view of a Document.
	// * `view-item-list`: View of a panel or ordered list of Documents.
	// * `view-home-page`: View of the home page.
	// * `view-category-page`: View of a category page, e.g. Home > Men > Jeans
	//
	// Retail-related values:
	//
	// * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
	// * `purchase`: Purchase an item(s)
	//
	// Media-related values:
	//
	// * `media-play`: Start/resume watching a video, playing a song, etc.
	// * `media-complete`: Finished or stopped midway through a video, song, etc.
	EventType string `protobuf:"bytes,1,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Required. A unique identifier for tracking visitors.
	//
	// For example, this could be implemented with an HTTP cookie, which should be
	// able to uniquely identify a visitor on a single device. This unique
	// identifier should not change if the visitor log in/out of the website.
	//
	// Do not set the field to the same fixed ID for different users. This mixes
	// the event history of those users together, which results in degraded model
	// quality.
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	//
	// The field should not contain PII or user-data. We recommend to use Google
	// Analytics [Client
	// ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
	// for this field.
	UserPseudoId string `protobuf:"bytes,2,opt,name=user_pseudo_id,json=userPseudoId,proto3" json:"user_pseudo_id,omitempty"`
	// Only required for
	// [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1.UserEventService.ImportUserEvents]
	// method. Timestamp of when the user event happened.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// Information about the end user.
	UserInfo *UserInfo `protobuf:"bytes,4,opt,name=user_info,json=userInfo,proto3" json:"user_info,omitempty"`
	// Should set to true if the request is made directly from the end user, in
	// which case the
	// [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1.UserInfo.user_agent]
	// can be populated from the HTTP request.
	//
	// This flag should be set only if the API request is made directly from the
	// end user such as a mobile app (and not if a gateway or a server is
	// processing and pushing the user events).
	//
	// This should not be set when using the JavaScript tag in
	// [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent].
	DirectUserRequest bool `protobuf:"varint,5,opt,name=direct_user_request,json=directUserRequest,proto3" json:"direct_user_request,omitempty"`
	// A unique identifier for tracking a visitor session with a length limit of
	// 128 bytes. A session is an aggregation of an end user behavior in a time
	// span.
	//
	// A general guideline to populate the session_id:
	//
	// 1. If user has no activity for 30 min, a new session_id should be assigned.
	// 2. The session_id should be unique across users, suggest use uuid or add
	// [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1.UserEvent.user_pseudo_id]
	// as prefix.
	SessionId string `protobuf:"bytes,6,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// Page metadata such as categories and other critical information for certain
	// event types such as `view-category-page`.
	PageInfo *PageInfo `protobuf:"bytes,7,opt,name=page_info,json=pageInfo,proto3" json:"page_info,omitempty"`
	// Token to attribute an API response to user action(s) to trigger the event.
	//
	// Highly recommended for user events that are the result of
	// [RecommendationService.Recommend][]. This field enables accurate
	// attribution of recommendation model performance.
	//
	// The value must be one of:
	//
	// * [RecommendResponse.attribution_token][] for events that are the result of
	// [RecommendationService.Recommend][].
	// * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token] for events that are the result of
	// [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search].
	//
	// This token enables us to accurately attribute page view or conversion
	// completion back to the event and the particular predict response containing
	// this clicked/purchased product. If user clicks on product K in the
	// recommendation results, pass [RecommendResponse.attribution_token][] as a
	// URL parameter to product K's page. When recording events on product K's
	// page, log the [RecommendResponse.attribution_token][] to this field.
	AttributionToken string `protobuf:"bytes,8,opt,name=attribution_token,json=attributionToken,proto3" json:"attribution_token,omitempty"`
	// The filter syntax consists of an expression language for constructing a
	// predicate from one or more fields of the documents being filtered.
	//
	// One example is for `search` events, the associated
	// [SearchRequest][google.cloud.discoveryengine.v1.SearchRequest] may contain
	// a filter expression in
	// [SearchRequest.filter][google.cloud.discoveryengine.v1.SearchRequest.filter]
	// conforming to https://google.aip.dev/160#filtering.
	//
	// Similarly, for `view-item-list` events that are generated from a
	// [RecommendRequest][], this field may be populated directly from
	// [RecommendRequest.filter][] conforming to
	// https://google.aip.dev/160#filtering.
	//
	// The value must be a UTF-8 encoded string with a length limit of 1,000
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	Filter string `protobuf:"bytes,9,opt,name=filter,proto3" json:"filter,omitempty"`
	// List of [Document][google.cloud.discoveryengine.v1.Document]s associated
	// with this user event.
	//
	// This field is optional except for the following event types:
	//
	// * `view-item`
	// * `add-to-cart`
	// * `purchase`
	// * `media-play`
	// * `media-complete`
	//
	// In a `search` event, this field represents the documents returned to the
	// end user on the current page (the end user may have not finished browsing
	// the whole page yet). When a new page is returned to the end user, after
	// pagination/filtering/ordering even for the same query, a new `search` event
	// with different
	// [UserEvent.documents][google.cloud.discoveryengine.v1.UserEvent.documents]
	// is desired.
	Documents []*DocumentInfo `protobuf:"bytes,10,rep,name=documents,proto3" json:"documents,omitempty"`
	// Panel metadata associated with this user event.
	Panel *PanelInfo `protobuf:"bytes,11,opt,name=panel,proto3" json:"panel,omitempty"`
	// [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
	// details related to the event.
	//
	// This field should be set for `search` event.
	SearchInfo *SearchInfo `protobuf:"bytes,12,opt,name=search_info,json=searchInfo,proto3" json:"search_info,omitempty"`
	// [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1.CompletionService.CompleteQuery]
	// details related to the event.
	//
	// This field should be set for `search` event when autocomplete function is
	// enabled and the user clicks a suggestion for search.
	CompletionInfo *CompletionInfo `protobuf:"bytes,13,opt,name=completion_info,json=completionInfo,proto3" json:"completion_info,omitempty"`
	// The transaction metadata (if any) associated with this user event.
	TransactionInfo *TransactionInfo `protobuf:"bytes,14,opt,name=transaction_info,json=transactionInfo,proto3" json:"transaction_info,omitempty"`
	// A list of identifiers for the independent experiment groups this user event
	// belongs to. This is used to distinguish between user events associated with
	// different experiment setups on the customer end.
	TagIds []string `protobuf:"bytes,15,rep,name=tag_ids,json=tagIds,proto3" json:"tag_ids,omitempty"`
	// The promotion IDs if this is an event associated with promotions.
	// Currently, this field is restricted to at most one ID.
	PromotionIds []string `protobuf:"bytes,16,rep,name=promotion_ids,json=promotionIds,proto3" json:"promotion_ids,omitempty"`
	// Extra user event features to include in the recommendation model.
	// These attributes must NOT contain data that needs to be parsed or processed
	// further, e.g. JSON or other encodings.
	//
	// If you provide custom attributes for ingested user events, also include
	// them in the user events that you associate with prediction requests. Custom
	// attribute formatting must be consistent between imported events and events
	// provided with prediction requests. This lets the Discovery Engine API use
	// those custom attributes when training models and serving predictions, which
	// helps improve recommendation quality.
	//
	// This field needs to pass all below criteria, otherwise an
	// `INVALID_ARGUMENT` error is returned:
	//
	//   - The key must be a UTF-8 encoded string with a length limit of 5,000
	//     characters.
	//   - For text attributes, at most 400 values are allowed. Empty values are not
	//     allowed. Each value must be a UTF-8 encoded string with a length limit of
	//     256 characters.
	//   - For number attributes, at most 400 values are allowed.
	//
	// For product recommendations, an example of extra user information is
	// `traffic_channel`, which is how a user arrives at the site. Users can
	// arrive
	// at the site by coming to the site directly, coming through Google
	// search, or in other ways.
	Attributes map[string]*CustomAttribute `protobuf:"bytes,17,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Media-specific info.
	MediaInfo *MediaInfo `protobuf:"bytes,18,opt,name=media_info,json=mediaInfo,proto3" json:"media_info,omitempty"`
}

func (x *UserEvent) Reset() {
	*x = UserEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserEvent) ProtoMessage() {}

func (x *UserEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserEvent.ProtoReflect.Descriptor instead.
func (*UserEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_user_event_proto_rawDescGZIP(), []int{0}
}

func (x *UserEvent) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (x *UserEvent) GetUserPseudoId() string {
	if x != nil {
		return x.UserPseudoId
	}
	return ""
}

func (x *UserEvent) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *UserEvent) GetUserInfo() *UserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

func (x *UserEvent) GetDirectUserRequest() bool {
	if x != nil {
		return x.DirectUserRequest
	}
	return false
}

func (x *UserEvent) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

func (x *UserEvent) GetPageInfo() *PageInfo {
	if x != nil {
		return x.PageInfo
	}
	return nil
}

func (x *UserEvent) GetAttributionToken() string {
	if x != nil {
		return x.AttributionToken
	}
	return ""
}

func (x *UserEvent) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *UserEvent) GetDocuments() []*DocumentInfo {
	if x != nil {
		return x.Documents
	}
	return nil
}

func (x *UserEvent) GetPanel() *PanelInfo {
	if x != nil {
		return x.Panel
	}
	return nil
}

func (x *UserEvent) GetSearchInfo() *SearchInfo {
	if x != nil {
		return x.SearchInfo
	}
	return nil
}

func (x *UserEvent) GetCompletionInfo() *CompletionInfo {
	if x != nil {
		return x.CompletionInfo
	}
	return nil
}

func (x *UserEvent) GetTransactionInfo() *TransactionInfo {
	if x != nil {
		return x.TransactionInfo
	}
	return nil
}

func (x *UserEvent) GetTagIds() []string {
	if x != nil {
		return x.TagIds
	}
	return nil
}

func (x *UserEvent) GetPromotionIds() []string {
	if x != nil {
		return x.PromotionIds
	}
	return nil
}

func (x *UserEvent) GetAttributes() map[string]*CustomAttribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *UserEvent) GetMediaInfo() *MediaInfo {
	if x != nil {
		return x.MediaInfo
	}
	return nil
}

// Detailed page information.
type PageInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique ID of a web page view.
	//
	// This should be kept the same for all user events triggered from the same
	// pageview. For example, an item detail page view could trigger multiple
	// events as the user is browsing the page. The `pageview_id` property should
	// be kept the same for all these events so that they can be grouped together
	// properly.
	//
	// When using the client side event reporting with JavaScript pixel and Google
	// Tag Manager, this value is filled in automatically.
	PageviewId string `protobuf:"bytes,1,opt,name=pageview_id,json=pageviewId,proto3" json:"pageview_id,omitempty"`
	// The most specific category associated with a category page.
	//
	// To represent full path of category, use '>' sign to separate different
	// hierarchies. If '>' is part of the category name, please replace it with
	// other character(s).
	//
	// Category pages include special pages such as sales or promotions. For
	// instance, a special sale page may have the category hierarchy:
	// `"pageCategory" : "Sales > 2017 Black Friday Deals"`.
	//
	// Required for `view-category-page` events. Other event types should not set
	// this field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	PageCategory string `protobuf:"bytes,2,opt,name=page_category,json=pageCategory,proto3" json:"page_category,omitempty"`
	// Complete URL (window.location.href) of the user's current page.
	//
	// When using the client side event reporting with JavaScript pixel and Google
	// Tag Manager, this value is filled in automatically. Maximum length 5,000
	// characters.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// The referrer URL of the current page.
	//
	// When using the client side event reporting with JavaScript pixel and Google
	// Tag Manager, this value is filled in automatically. However, some browser
	// privacy restrictions may cause this field to be empty.
	ReferrerUri string `protobuf:"bytes,4,opt,name=referrer_uri,json=referrerUri,proto3" json:"referrer_uri,omitempty"`
}

func (x *PageInfo) Reset() {
	*x = PageInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PageInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PageInfo) ProtoMessage() {}

func (x *PageInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PageInfo.ProtoReflect.Descriptor instead.
func (*PageInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_user_event_proto_rawDescGZIP(), []int{1}
}

func (x *PageInfo) GetPageviewId() string {
	if x != nil {
		return x.PageviewId
	}
	return ""
}

func (x *PageInfo) GetPageCategory() string {
	if x != nil {
		return x.PageCategory
	}
	return ""
}

func (x *PageInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *PageInfo) GetReferrerUri() string {
	if x != nil {
		return x.ReferrerUri
	}
	return ""
}

// Detailed search information.
type SearchInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user's search query.
	//
	// See
	// [SearchRequest.query][google.cloud.discoveryengine.v1.SearchRequest.query]
	// for definition.
	//
	// The value must be a UTF-8 encoded string with a length limit of 5,000
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	//
	// At least one of
	// [search_query][google.cloud.discoveryengine.v1.SearchInfo.search_query] or
	// [PageInfo.page_category][google.cloud.discoveryengine.v1.PageInfo.page_category]
	// is required for `search` events. Other event types should not set this
	// field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	SearchQuery string `protobuf:"bytes,1,opt,name=search_query,json=searchQuery,proto3" json:"search_query,omitempty"`
	// The order in which products are returned, if applicable.
	//
	// See
	// [SearchRequest.order_by][google.cloud.discoveryengine.v1.SearchRequest.order_by]
	// for definition and syntax.
	//
	// The value must be a UTF-8 encoded string with a length limit of 1,000
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	//
	// This can only be set for `search` events. Other event types should not set
	// this field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	OrderBy string `protobuf:"bytes,2,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// An integer that specifies the current offset for pagination (the 0-indexed
	// starting location, amongst the products deemed by the API as relevant).
	//
	// See
	// [SearchRequest.offset][google.cloud.discoveryengine.v1.SearchRequest.offset]
	// for definition.
	//
	// If this field is negative, an `INVALID_ARGUMENT` is returned.
	//
	// This can only be set for `search` events. Other event types should not set
	// this field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	Offset *int32 `protobuf:"varint,3,opt,name=offset,proto3,oneof" json:"offset,omitempty"`
}

func (x *SearchInfo) Reset() {
	*x = SearchInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchInfo) ProtoMessage() {}

func (x *SearchInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchInfo.ProtoReflect.Descriptor instead.
func (*SearchInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_user_event_proto_rawDescGZIP(), []int{2}
}

func (x *SearchInfo) GetSearchQuery() string {
	if x != nil {
		return x.SearchQuery
	}
	return ""
}

func (x *SearchInfo) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchInfo) GetOffset() int32 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return 0
}

// Detailed completion information including completion attribution token and
// clicked completion info.
type CompletionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End user selected
	// [CompleteQueryResponse.QuerySuggestion.suggestion][google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.suggestion].
	SelectedSuggestion string `protobuf:"bytes,1,opt,name=selected_suggestion,json=selectedSuggestion,proto3" json:"selected_suggestion,omitempty"`
	// End user selected
	// [CompleteQueryResponse.QuerySuggestion.suggestion][google.cloud.discoveryengine.v1.CompleteQueryResponse.QuerySuggestion.suggestion]
	// position, starting from 0.
	SelectedPosition int32 `protobuf:"varint,2,opt,name=selected_position,json=selectedPosition,proto3" json:"selected_position,omitempty"`
}

func (x *CompletionInfo) Reset() {
	*x = CompletionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompletionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompletionInfo) ProtoMessage() {}

func (x *CompletionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompletionInfo.ProtoReflect.Descriptor instead.
func (*CompletionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_user_event_proto_rawDescGZIP(), []int{3}
}

func (x *CompletionInfo) GetSelectedSuggestion() string {
	if x != nil {
		return x.SelectedSuggestion
	}
	return ""
}

func (x *CompletionInfo) GetSelectedPosition() int32 {
	if x != nil {
		return x.SelectedPosition
	}
	return 0
}

// A transaction represents the entire purchase transaction.
type TransactionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Total non-zero value associated with the transaction. This value
	// may include shipping, tax, or other adjustments to the total value that you
	// want to include.
	Value *float32 `protobuf:"fixed32,1,opt,name=value,proto3,oneof" json:"value,omitempty"`
	// Required. Currency code. Use three-character ISO-4217 code.
	Currency string `protobuf:"bytes,2,opt,name=currency,proto3" json:"currency,omitempty"`
	// The transaction ID with a length limit of 128 characters.
	TransactionId string `protobuf:"bytes,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	// All the taxes associated with the transaction.
	Tax *float32 `protobuf:"fixed32,4,opt,name=tax,proto3,oneof" json:"tax,omitempty"`
	// All the costs associated with the products. These can be manufacturing
	// costs, shipping expenses not borne by the end user, or any other costs,
	// such that:
	//
	// * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
	// [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
	// [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
	Cost *float32 `protobuf:"fixed32,5,opt,name=cost,proto3,oneof" json:"cost,omitempty"`
	// The total discount(s) value applied to this transaction.
	// This figure should be excluded from
	// [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
	//
	// For example, if a user paid
	// [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
	// amount, then nominal (pre-discount) value of the transaction is the sum of
	// [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]
	// and
	// [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
	//
	// This means that profit is calculated the same way, regardless of the
	// discount value, and that
	// [TransactionInfo.discount_value][google.cloud.discoveryengine.v1.TransactionInfo.discount_value]
	// can be larger than
	// [TransactionInfo.value][google.cloud.discoveryengine.v1.TransactionInfo.value]:
	//
	// * Profit = [value][google.cloud.discoveryengine.v1.TransactionInfo.value] -
	// [tax][google.cloud.discoveryengine.v1.TransactionInfo.tax] -
	// [cost][google.cloud.discoveryengine.v1.TransactionInfo.cost]
	DiscountValue *float32 `protobuf:"fixed32,6,opt,name=discount_value,json=discountValue,proto3,oneof" json:"discount_value,omitempty"`
}

func (x *TransactionInfo) Reset() {
	*x = TransactionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionInfo) ProtoMessage() {}

func (x *TransactionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionInfo.ProtoReflect.Descriptor instead.
func (*TransactionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_user_event_proto_rawDescGZIP(), []int{4}
}

func (x *TransactionInfo) GetValue() float32 {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return 0
}

func (x *TransactionInfo) GetCurrency() string {
	if x != nil {
		return x.Currency
	}
	return ""
}

func (x *TransactionInfo) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

func (x *TransactionInfo) GetTax() float32 {
	if x != nil && x.Tax != nil {
		return *x.Tax
	}
	return 0
}

func (x *TransactionInfo) GetCost() float32 {
	if x != nil && x.Cost != nil {
		return *x.Cost
	}
	return 0
}

func (x *TransactionInfo) GetDiscountValue() float32 {
	if x != nil && x.DiscountValue != nil {
		return *x.DiscountValue
	}
	return 0
}

// Detailed document information associated with a user event.
type DocumentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A required descriptor of the associated
	// [Document][google.cloud.discoveryengine.v1.Document].
	//
	// * If [id][google.cloud.discoveryengine.v1.DocumentInfo.id] is specified,
	// then the default values for
	// `{location}`, `{collection_id}`, `{data_store_id}`, and `{branch_id}` are
	// used when annotating with the stored Document.
	//
	// * If [name][google.cloud.discoveryengine.v1.DocumentInfo.name] is
	// specified, then the provided values (default values allowed) for
	// `{location}`, `{collection_id}`, `{data_store_id}`, and
	// `{branch_id}` are used when annotating with the stored Document.
	//
	// Types that are assignable to DocumentDescriptor:
	//
	//	*DocumentInfo_Id
	//	*DocumentInfo_Name
	//	*DocumentInfo_Uri
	DocumentDescriptor isDocumentInfo_DocumentDescriptor `protobuf_oneof:"document_descriptor"`
	// Quantity of the Document associated with the user event. Defaults to 1.
	//
	// For example, this field will be 2 if two quantities of the same Document
	// are involved in a `add-to-cart` event.
	//
	// Required for events of the following event types:
	//
	// * `add-to-cart`
	// * `purchase`
	Quantity *int32 `protobuf:"varint,3,opt,name=quantity,proto3,oneof" json:"quantity,omitempty"`
	// The promotion IDs associated with this Document.
	// Currently, this field is restricted to at most one ID.
	PromotionIds []string `protobuf:"bytes,4,rep,name=promotion_ids,json=promotionIds,proto3" json:"promotion_ids,omitempty"`
}

func (x *DocumentInfo) Reset() {
	*x = DocumentInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentInfo) ProtoMessage() {}

func (x *DocumentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentInfo.ProtoReflect.Descriptor instead.
func (*DocumentInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_user_event_proto_rawDescGZIP(), []int{5}
}

func (m *DocumentInfo) GetDocumentDescriptor() isDocumentInfo_DocumentDescriptor {
	if m != nil {
		return m.DocumentDescriptor
	}
	return nil
}

func (x *DocumentInfo) GetId() string {
	if x, ok := x.GetDocumentDescriptor().(*DocumentInfo_Id); ok {
		return x.Id
	}
	return ""
}

func (x *DocumentInfo) GetName() string {
	if x, ok := x.GetDocumentDescriptor().(*DocumentInfo_Name); ok {
		return x.Name
	}
	return ""
}

func (x *DocumentInfo) GetUri() string {
	if x, ok := x.GetDocumentDescriptor().(*DocumentInfo_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *DocumentInfo) GetQuantity() int32 {
	if x != nil && x.Quantity != nil {
		return *x.Quantity
	}
	return 0
}

func (x *DocumentInfo) GetPromotionIds() []string {
	if x != nil {
		return x.PromotionIds
	}
	return nil
}

type isDocumentInfo_DocumentDescriptor interface {
	isDocumentInfo_DocumentDescriptor()
}

type DocumentInfo_Id struct {
	// The [Document][google.cloud.discoveryengine.v1.Document] resource ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type DocumentInfo_Name struct {
	// The [Document][google.cloud.discoveryengine.v1.Document] resource full
	// name, of the form:
	// `projects/{project_id}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

type DocumentInfo_Uri struct {
	// The [Document][google.cloud.discoveryengine.v1.Document] URI - only
	// allowed for website data stores.
	Uri string `protobuf:"bytes,6,opt,name=uri,proto3,oneof"`
}

func (*DocumentInfo_Id) isDocumentInfo_DocumentDescriptor() {}

func (*DocumentInfo_Name) isDocumentInfo_DocumentDescriptor() {}

func (*DocumentInfo_Uri) isDocumentInfo_DocumentDescriptor() {}

// Detailed panel information associated with a user event.
type PanelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The panel ID.
	PanelId string `protobuf:"bytes,2,opt,name=panel_id,json=panelId,proto3" json:"panel_id,omitempty"`
	// The display name of the panel.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The ordered position of the panel, if shown to the user with other panels.
	// If set, then
	// [total_panels][google.cloud.discoveryengine.v1.PanelInfo.total_panels] must
	// also be set.
	PanelPosition *int32 `protobuf:"varint,4,opt,name=panel_position,json=panelPosition,proto3,oneof" json:"panel_position,omitempty"`
	// The total number of panels, including this one, shown to the user.
	// Must be set if
	// [panel_position][google.cloud.discoveryengine.v1.PanelInfo.panel_position]
	// is set.
	TotalPanels *int32 `protobuf:"varint,5,opt,name=total_panels,json=totalPanels,proto3,oneof" json:"total_panels,omitempty"`
}

func (x *PanelInfo) Reset() {
	*x = PanelInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PanelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PanelInfo) ProtoMessage() {}

func (x *PanelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PanelInfo.ProtoReflect.Descriptor instead.
func (*PanelInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_user_event_proto_rawDescGZIP(), []int{6}
}

func (x *PanelInfo) GetPanelId() string {
	if x != nil {
		return x.PanelId
	}
	return ""
}

func (x *PanelInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PanelInfo) GetPanelPosition() int32 {
	if x != nil && x.PanelPosition != nil {
		return *x.PanelPosition
	}
	return 0
}

func (x *PanelInfo) GetTotalPanels() int32 {
	if x != nil && x.TotalPanels != nil {
		return *x.TotalPanels
	}
	return 0
}

// Media-specific user event information.
type MediaInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The media progress time in seconds, if applicable.
	// For example, if the end user has finished 90 seconds of a playback video,
	// then
	// [MediaInfo.media_progress_duration.seconds][google.protobuf.Duration.seconds]
	// should be set to 90.
	MediaProgressDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=media_progress_duration,json=mediaProgressDuration,proto3" json:"media_progress_duration,omitempty"`
	// Media progress should be computed using only the
	// [media_progress_duration][google.cloud.discoveryengine.v1.MediaInfo.media_progress_duration]
	// relative to the media total length.
	//
	// This value must be between `[0, 1.0]` inclusive.
	//
	// If this is not a playback or the progress cannot be computed (e.g. ongoing
	// livestream), this field should be unset.
	MediaProgressPercentage *float32 `protobuf:"fixed32,2,opt,name=media_progress_percentage,json=mediaProgressPercentage,proto3,oneof" json:"media_progress_percentage,omitempty"`
}

func (x *MediaInfo) Reset() {
	*x = MediaInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MediaInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MediaInfo) ProtoMessage() {}

func (x *MediaInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MediaInfo.ProtoReflect.Descriptor instead.
func (*MediaInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_user_event_proto_rawDescGZIP(), []int{7}
}

func (x *MediaInfo) GetMediaProgressDuration() *durationpb.Duration {
	if x != nil {
		return x.MediaProgressDuration
	}
	return nil
}

func (x *MediaInfo) GetMediaProgressPercentage() float32 {
	if x != nil && x.MediaProgressPercentage != nil {
		return *x.MediaProgressPercentage
	}
	return 0
}

var File_google_cloud_discoveryengine_v1_user_event_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1_user_event_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa3,
	0x09, 0x0a, 0x09, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x29, 0x0a, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x73, 0x65, 0x75, 0x64, 0x6f, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x75,
	0x73, 0x65, 0x72, 0x50, 0x73, 0x65, 0x75, 0x64, 0x6f, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2e,
	0x0a, 0x13, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x46, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x09, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x40, 0x0a, 0x05, 0x70, 0x61, 0x6e, 0x65, 0x6c,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x05, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x12, 0x4c, 0x0a, 0x0b, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x58, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x5b, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x17,
	0x0a, 0x07, 0x74, 0x61, 0x67, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x06, 0x74, 0x61, 0x67, 0x49, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x5a, 0x0a, 0x0a,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x0a, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x64, 0x69, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x49,
	0x6e, 0x66, 0x6f, 0x1a, 0x6f, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x46, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x85, 0x01, 0x0a, 0x08, 0x50, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x67, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x61, 0x67, 0x65, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x72, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x72, 0x55, 0x72, 0x69, 0x22, 0x72, 0x0a, 0x0a,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x22, 0x6e, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x2f, 0x0a, 0x13, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x12, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x83, 0x02, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x03,
	0x74, 0x61, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x48, 0x01, 0x52, 0x03, 0x74, 0x61, 0x78,
	0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x02, 0x48, 0x02, 0x52, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x02, 0x48, 0x03, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x74, 0x61, 0x78, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x63,
	0x6f, 0x73, 0x74, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe2, 0x01, 0x0a, 0x0c, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x10, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x02, 0x69, 0x64, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x12, 0x1f, 0x0a, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x88,
	0x01, 0x01, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x42, 0x0b,
	0x0a, 0x09, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0xc6, 0x01, 0x0a, 0x09,
	0x50, 0x61, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x08, 0x70, 0x61, 0x6e,
	0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e,
	0x70, 0x61, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x50, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01,
	0x52, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x73, 0x88, 0x01, 0x01,
	0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61,
	0x6e, 0x65, 0x6c, 0x73, 0x22, 0xbd, 0x01, 0x0a, 0x09, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x51, 0x0a, 0x17, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x19, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x17, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x61, 0x67, 0x65, 0x42, 0x81, 0x02, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x55, 0x73,
	0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f,
	0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1_user_event_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1_user_event_proto_rawDescData = file_google_cloud_discoveryengine_v1_user_event_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1_user_event_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1_user_event_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1_user_event_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1_user_event_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1_user_event_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_discoveryengine_v1_user_event_proto_goTypes = []interface{}{
	(*UserEvent)(nil),             // 0: google.cloud.discoveryengine.v1.UserEvent
	(*PageInfo)(nil),              // 1: google.cloud.discoveryengine.v1.PageInfo
	(*SearchInfo)(nil),            // 2: google.cloud.discoveryengine.v1.SearchInfo
	(*CompletionInfo)(nil),        // 3: google.cloud.discoveryengine.v1.CompletionInfo
	(*TransactionInfo)(nil),       // 4: google.cloud.discoveryengine.v1.TransactionInfo
	(*DocumentInfo)(nil),          // 5: google.cloud.discoveryengine.v1.DocumentInfo
	(*PanelInfo)(nil),             // 6: google.cloud.discoveryengine.v1.PanelInfo
	(*MediaInfo)(nil),             // 7: google.cloud.discoveryengine.v1.MediaInfo
	nil,                           // 8: google.cloud.discoveryengine.v1.UserEvent.AttributesEntry
	(*timestamppb.Timestamp)(nil), // 9: google.protobuf.Timestamp
	(*UserInfo)(nil),              // 10: google.cloud.discoveryengine.v1.UserInfo
	(*durationpb.Duration)(nil),   // 11: google.protobuf.Duration
	(*CustomAttribute)(nil),       // 12: google.cloud.discoveryengine.v1.CustomAttribute
}
var file_google_cloud_discoveryengine_v1_user_event_proto_depIdxs = []int32{
	9,  // 0: google.cloud.discoveryengine.v1.UserEvent.event_time:type_name -> google.protobuf.Timestamp
	10, // 1: google.cloud.discoveryengine.v1.UserEvent.user_info:type_name -> google.cloud.discoveryengine.v1.UserInfo
	1,  // 2: google.cloud.discoveryengine.v1.UserEvent.page_info:type_name -> google.cloud.discoveryengine.v1.PageInfo
	5,  // 3: google.cloud.discoveryengine.v1.UserEvent.documents:type_name -> google.cloud.discoveryengine.v1.DocumentInfo
	6,  // 4: google.cloud.discoveryengine.v1.UserEvent.panel:type_name -> google.cloud.discoveryengine.v1.PanelInfo
	2,  // 5: google.cloud.discoveryengine.v1.UserEvent.search_info:type_name -> google.cloud.discoveryengine.v1.SearchInfo
	3,  // 6: google.cloud.discoveryengine.v1.UserEvent.completion_info:type_name -> google.cloud.discoveryengine.v1.CompletionInfo
	4,  // 7: google.cloud.discoveryengine.v1.UserEvent.transaction_info:type_name -> google.cloud.discoveryengine.v1.TransactionInfo
	8,  // 8: google.cloud.discoveryengine.v1.UserEvent.attributes:type_name -> google.cloud.discoveryengine.v1.UserEvent.AttributesEntry
	7,  // 9: google.cloud.discoveryengine.v1.UserEvent.media_info:type_name -> google.cloud.discoveryengine.v1.MediaInfo
	11, // 10: google.cloud.discoveryengine.v1.MediaInfo.media_progress_duration:type_name -> google.protobuf.Duration
	12, // 11: google.cloud.discoveryengine.v1.UserEvent.AttributesEntry.value:type_name -> google.cloud.discoveryengine.v1.CustomAttribute
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1_user_event_proto_init() }
func file_google_cloud_discoveryengine_v1_user_event_proto_init() {
	if File_google_cloud_discoveryengine_v1_user_event_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PageInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompletionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PanelInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MediaInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*DocumentInfo_Id)(nil),
		(*DocumentInfo_Name)(nil),
		(*DocumentInfo_Uri)(nil),
	}
	file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[6].OneofWrappers = []interface{}{}
	file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes[7].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1_user_event_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1_user_event_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1_user_event_proto_depIdxs,
		MessageInfos:      file_google_cloud_discoveryengine_v1_user_event_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1_user_event_proto = out.File
	file_google_cloud_discoveryengine_v1_user_event_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1_user_event_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1_user_event_proto_depIdxs = nil
}
