// Code generated by smithy-go-codegen DO NOT EDIT.

package imagebuilder

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/imagebuilder/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of image recipes.
func (c *Client) ListImageRecipes(ctx context.Context, params *ListImageRecipesInput, optFns ...func(*Options)) (*ListImageRecipesOutput, error) {
	if params == nil {
		params = &ListImageRecipesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListImageRecipes", params, optFns, c.addOperationListImageRecipesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListImageRecipesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListImageRecipesInput struct {

	// Use the following filters to streamline results:
	//
	//   - name
	//
	//   - parentImage
	//
	//   - platform
	Filters []types.Filter

	// The maximum items to return in a request.
	MaxResults *int32

	// A token to specify where to start paginating. This is the nextToken from a
	// previously truncated response.
	NextToken *string

	// The owner defines which image recipes you want to list. By default, this
	// request will only show image recipes owned by your account. You can use this
	// field to specify if you want to view image recipes owned by yourself, by Amazon,
	// or those image recipes that have been shared with you by other customers.
	Owner types.Ownership

	noSmithyDocumentSerde
}

type ListImageRecipesOutput struct {

	// The list of image pipelines.
	ImageRecipeSummaryList []types.ImageRecipeSummary

	// The next token used for paginated responses. When this field isn't empty, there
	// are additional elements that the service hasn't included in this request. Use
	// this token with the next request to retrieve additional objects.
	NextToken *string

	// The request ID that uniquely identifies this request.
	RequestId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListImageRecipesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListImageRecipes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListImageRecipes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListImageRecipes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListImageRecipes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListImageRecipesPaginatorOptions is the paginator options for ListImageRecipes
type ListImageRecipesPaginatorOptions struct {
	// The maximum items to return in a request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListImageRecipesPaginator is a paginator for ListImageRecipes
type ListImageRecipesPaginator struct {
	options   ListImageRecipesPaginatorOptions
	client    ListImageRecipesAPIClient
	params    *ListImageRecipesInput
	nextToken *string
	firstPage bool
}

// NewListImageRecipesPaginator returns a new ListImageRecipesPaginator
func NewListImageRecipesPaginator(client ListImageRecipesAPIClient, params *ListImageRecipesInput, optFns ...func(*ListImageRecipesPaginatorOptions)) *ListImageRecipesPaginator {
	if params == nil {
		params = &ListImageRecipesInput{}
	}

	options := ListImageRecipesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListImageRecipesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListImageRecipesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListImageRecipes page.
func (p *ListImageRecipesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListImageRecipesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListImageRecipes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListImageRecipesAPIClient is a client that implements the ListImageRecipes
// operation.
type ListImageRecipesAPIClient interface {
	ListImageRecipes(context.Context, *ListImageRecipesInput, ...func(*Options)) (*ListImageRecipesOutput, error)
}

var _ ListImageRecipesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListImageRecipes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListImageRecipes",
	}
}
