// Code generated by smithy-go-codegen DO NOT EDIT.

package wellarchitected

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/wellarchitected/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List review template shares.
func (c *Client) ListTemplateShares(ctx context.Context, params *ListTemplateSharesInput, optFns ...func(*Options)) (*ListTemplateSharesOutput, error) {
	if params == nil {
		params = &ListTemplateSharesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTemplateShares", params, optFns, c.addOperationListTemplateSharesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTemplateSharesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTemplateSharesInput struct {

	// The review template ARN.
	//
	// This member is required.
	TemplateArn *string

	// The maximum number of results to return for this request.
	MaxResults *int32

	// The token to use to retrieve the next set of results.
	NextToken *string

	// The Amazon Web Services account ID, organization ID, or organizational unit
	// (OU) ID with which the profile is shared.
	SharedWithPrefix *string

	// The status of the share request.
	Status types.ShareStatus

	noSmithyDocumentSerde
}

type ListTemplateSharesOutput struct {

	// The token to use to retrieve the next set of results.
	NextToken *string

	// The review template ARN.
	TemplateArn *string

	// A review template share summary return object.
	TemplateShareSummaries []types.TemplateShareSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTemplateSharesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTemplateShares{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTemplateShares{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTemplateShares"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListTemplateSharesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTemplateShares(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTemplateSharesPaginatorOptions is the paginator options for
// ListTemplateShares
type ListTemplateSharesPaginatorOptions struct {
	// The maximum number of results to return for this request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTemplateSharesPaginator is a paginator for ListTemplateShares
type ListTemplateSharesPaginator struct {
	options   ListTemplateSharesPaginatorOptions
	client    ListTemplateSharesAPIClient
	params    *ListTemplateSharesInput
	nextToken *string
	firstPage bool
}

// NewListTemplateSharesPaginator returns a new ListTemplateSharesPaginator
func NewListTemplateSharesPaginator(client ListTemplateSharesAPIClient, params *ListTemplateSharesInput, optFns ...func(*ListTemplateSharesPaginatorOptions)) *ListTemplateSharesPaginator {
	if params == nil {
		params = &ListTemplateSharesInput{}
	}

	options := ListTemplateSharesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTemplateSharesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTemplateSharesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTemplateShares page.
func (p *ListTemplateSharesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTemplateSharesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTemplateShares(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTemplateSharesAPIClient is a client that implements the ListTemplateShares
// operation.
type ListTemplateSharesAPIClient interface {
	ListTemplateShares(context.Context, *ListTemplateSharesInput, ...func(*Options)) (*ListTemplateSharesOutput, error)
}

var _ ListTemplateSharesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTemplateShares(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTemplateShares",
	}
}
