# Awesome Electron [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://rawgit.com/sindresorhus/awesome-electron/master/electron-logo.svg" align="right" width="100">](https://electronjs.org)

> Useful resources for creating apps with [Electron](https://electronjs.org)

You might also like [awesome-nodejs](https://github.com/sindresorhus/awesome-nodejs).


---

<p align="center">⚡️</p>
<p align="center"><b>Support this project and improve your JavaScript skills with this awesome <a href="https://ES6.io/friend/AWESOME">ES6 course</a> by Wes Bos.</b><br>Try his free <a href="https://javascript30.com/friend/AWESOME">JavaScript 30 course</a> for a taste of what to expect. You might also like his <a href="https://ReactForBeginners.com/friend/AWESOME">React</a> and <a href="https://SublimeTextBook.com/friend/AWESOME">Sublime</a> course.</p>

---


## Contents

- [Apps](#apps)
- [Boilerplates](#boilerplates)
- [Tools](#tools)
- [Components](#components)
- [Documentation](#documentation)
- [Articles](#articles)
- [Books](#books)
- [Videos](#videos)
- [Podcasts](#podcasts)
- [Community](#community)
- [Tips](#tips)


## Apps

Made with Electron.

### Open Source

###### Featured

- [Beaker](https://github.com/beakerbrowser/beaker) - Browser with peer-to-peer web protocols.
- [Hyper](https://github.com/zeit/hyper) - Terminal.
- [WebTorrent](https://github.com/feross/webtorrent-app) - Streaming torrent client.
- [Kap](https://github.com/wulkano/kap) - Screen recorder with GIF support.
- [Min](https://github.com/minbrowser/min) - Minimal web browser.
- [Mancy](https://github.com/princejwesley/Mancy) - JavaScript REPL.
- [SpaceRadar](https://github.com/zz85/space-radar) - Interactive disk space and memory visualization.
- [Nocturn](https://github.com/k0kubun/Nocturn) - Twitter client.
- [Mojibar](https://github.com/muan/mojibar) - Emoji searcher in your menubar.
- [Playback](https://github.com/mafintosh/playback) - Video player.
- [Upterm](https://github.com/railsware/upterm) - Terminal.
- [Atom](https://github.com/atom/atom) - Code editor.
- [Visual Studio Code](https://github.com/Microsoft/vscode) - Cross-platform IDE.
- [Brave](https://github.com/brave/browser-laptop) - Privacy-focused web browser.

###### Other

- [Git-it](https://github.com/jlord/git-it-electron) - Teaches you Git and GitHub.
- [Caprine](https://github.com/sindresorhus/caprine) - Unofficial Facebook Messenger app.
- [Simplenote](https://github.com/Automattic/simplenote-electron) - Note keeper.
- [nuTorrent](https://github.com/LeeChSien/nuTorrent) - BitTorrent client.
- [Abricotine](https://github.com/brrd/Abricotine) - Markdown editor with inline preview.
- [Medis](https://github.com/luin/medis) - Redis database management.
- [Kakapo](https://github.com/bluedaniel/kakapo-app) - Ambient sound mixer for relaxation or productivity.
- [SmartMirror](https://github.com/evancohen/smart-mirror) - Voice controlled smart mirror.
- [Koko](https://github.com/hachibasu/koko) - IRC client.
- [KeeWeb](https://github.com/keeweb/keeweb) - Unofficial KeePass app.
- [Gitify](https://github.com/ekonstantinidis/gitify) - GitHub notifications in your menubar.
- [Friends](https://github.com/moose-team/friends) - P2P chat.
- [Cumulus](https://github.com/gillesdemey/Cumulus) - SoundCloud player in your menubar.
- [Kitematic](https://kitematic.com) - Docker container management.
- [FatFileFinder](https://github.com/pwambach/fat-file-finder) - Find large files on your machine.
- [ScreenCat](https://github.com/maxogden/screencat) - Screen sharing & remote collaboration.
- [Gulp](https://github.com/sindresorhus/gulp-app) - Run Gulp tasks from your menubar.
- [Mapbox Studio](https://github.com/mapbox/mapbox-studio) - Map designer.
- [LevelUI](https://github.com/hij1nx/levelui) - LevelDB management.
- [Kart](https://github.com/maddox/kart) - Front-end for RetroArch.
- [Vmd](https://github.com/yoshuawuyts/vmd) - Preview Markdown files.
- [Kyoku](https://github.com/cheeaun/kyoku) - Displays current iTunes song.
- [GReader](https://github.com/Nekle/greader) - Collect and read offline readme files of GitHub repos.
- [Leanote](https://github.com/leanote/desktop-app) - Cloud notepad.
- [Snapper](https://github.com/pt2121/Snapper) - Screen capturing & recording for Android devices.
- [Imagemin](https://github.com/imagemin/imagemin-app) - Minify images.
- [We Build SG](https://github.com/webuildsg/osx) - Upcoming events & recently updated repos from webuild.sg.
- [Piglet](https://github.com/jenslind/piglet) - Run Grunt tasks from your menubar.
- [Yoda](https://github.com/whoisandie/yoda) - Browse and download YouTube videos.
- [Loop Drop](https://github.com/mmckegg/loop-drop-app) - MIDI looper and synth for live electronic music performances.
- [Toby](https://github.com/frankhale/toby) - YouTube player.
- [Kaku](https://github.com/EragonJ/Kaku) - Music player.
- [Yeoman](https://github.com/yeoman/yeoman-app) - Scaffold projects using Yeoman.
- [Markn](https://github.com/minodisk/markn) - Markdown viewer.
- [Shiba](https://github.com/rhysd/Shiba) - Live Markdown preview with linting.
- [Yays](https://github.com/Bahlaouane-Hamza/Yays) - YouTube music player in your menubar.
- [TimoFM](https://github.com/sapjax/TimoFM) - DoubanFM music player.
- [Monu](https://github.com/maxogden/monu) - Process monitoring.
- [Tèsèvè](https://teseve.github.io) - Static webserver.
- [DevDocs](https://github.com/egoist/devdocs-app) - Unofficial DevDocs.io app.
- [Trendy](https://rhysd.github.io/Trendy/) - Trending GitHub repos in your menubar.
- [google-music-electron](https://github.com/twolfson/google-music-electron) - Unofficial Google music app.
- [Pomodoro](https://g07cha.github.io/pomodoro/) - Timer based on the Pomodoro Technique.
- [Sia-UI](http://sia.tech) - Decentralized file storage system based on cryptocurrency technology.
- [MarkRight](https://github.com/dvcrn/markright) - GitHub flavored Markdown editor with live preview.
- [Mongotron](https://github.com/officert/mongotron) - MongoDB management tool.
- [Colonizers](https://github.com/colonizers/colonizers-desktop) - "Catan" inspired board game.
- [Eintopf](https://github.com/mazehall/eintopf) - Manage development projects with Docker.
- [WhatsDesktop](https://github.com/mawie81/whatsdesktop) - Unofficial WhatsApp app.
- [Sqlectron](https://github.com/sqlectron/sqlectron-gui) - SQL client.
- [docker-indicator](https://github.com/khornberg/docker-indicator) - Unofficial Docker menubar app.
- [Light Table](https://github.com/LightTable/LightTable) - Code editor with instant feedback.
- [Tubehead](https://github.com/makotot/Tubehead) - YouTube music player in your menubar.
- [Google Play Music Desktop Player](https://github.com/MarshallOfSound/Google-Play-Music-Desktop-Player-UNOFFICIAL-) - Unofficial Google Play Music app.
- [Chrome DevTools](https://github.com/auchenberg/chrome-devtools-app) - Chrome DevTools packaged as an app.
- [Yeobara](https://github.com/yeobara/yeobara-desktop) - Meetup check-in with beacon.
- [Proton](https://github.com/steventhanna/proton) - Markdown editor with live preview.
- [James](https://github.com/uxebu/james) - HTTP proxy to view and intercept browser requests.
- [DTCP](https://github.com/alchen/DTCP) - Twitter client.
- [Inbox](https://github.com/fgnass/inbox-app) - Unofficial Google Inbox app.
- [alienbox](http://a9.io/alienbox/) - Reddit inbox & notifier in your menubar.
- [tweet-rec](https://github.com/midnightSuyama/tweet-rec) - Tweet recording player.
- [Snippet Bar](https://github.com/teesloane/snippet-bar) - Copy-paste & re-use text snippets in your menubar.
- [Electronic WeChat](https://github.com/geeeeeeeeek/electronic-wechat) - Unofficial WeChat app.
- [dida](https://github.com/xwartz/dida) - Add tasks to TickTick (滴答清单).
- [FromScratch](https://github.com/kilian/fromscratch) - Autosaving scratchpad.
- [Hawkpass](https://github.com/kalpetros/hawkpass-desktop) - Password generator.
- [Gokotta](https://github.com/Zhangdroid/Gokotta) - Music player.
- [Shake](https://github.com/lumios/shake) - Japanese Earthquake Early Warning Notifier.
- [Fog](https://github.com/vitorgalvao/fog) - Unofficial Overcast podcast app.
- [Wmail](https://github.com/Thomas101/wmail) - Unofficial Gmail & Google Inbox app.
- [Boostnote](https://github.com/BoostIO/Boostnote) - Markdown note & code snippet app for developers.
- [Before Dawn](https://github.com/muffinista/before-dawn) - Screensaver tool.
- [Active Collab](https://github.com/nurtext/active-collab-desktop) - Unofficial Active Collab app.
- [Hain](https://github.com/appetizermonster/hain) - Launcher for Windows.
- [Catify](https://github.com/MeoBeoI/Catify) - Utility for Spotify.
- [Minira](https://github.com/jenslind/minira) - JIRA issues in your menubar.
- [Ansel](https://github.com/m0g/ansel) - Image organizer.
- [Build Checker App](https://github.com/willmendesneto/build-checker-app) - Check CI-server build statuses.
- [Backer Timetracker](https://github.com/MayGo/backer-timetracker) - Tracks your time.
- [Ghost](https://github.com/tryghost/ghost-desktop) - Professional publishing platform.
- [Mattermost](https://github.com/mattermost/desktop) - Mattermost client.
- [PupaFM](https://github.com/xwartz/PupaFM) - DoubanFM music player.
- [MediumDesk](https://github.com/sivragav/mediumdesk) - Unofficial Medium app.
- [Lightgallery](https://github.com/sachinchoolur/lightgallery-desktop) - Image viewer.
- [Crypter](https://github.com/HR/Crypter) - Secure encryption client.
- [YakYak](https://github.com/yakyak/yakyak) - Unofficial Google Hangouts app.
- [Museeks](https://github.com/KeitIG/museeks) - Music player.
- [VOX](https://github.com/fresk-nc/VOX) - Unofficial VOX music player.
- [Sabaki](http://sabaki.yichuanshen.de) - Go/Baduk/Weiqi board.
- [Marky](https://github.com/vesparny/marky) - Markdown editor.
- [Deco](https://github.com/decosoftware/deco-ide) - React Native IDE.
- [Toshocat](https://github.com/tofuness/Toshocat) - Anime/Manga Progress Tracker.
- [iStats](https://github.com/ningt/iStats) - CPU and memory stats on your menubar.
- [Wire](https://github.com/wireapp/wire-desktop) - Messenger and calling app.
- [Ramme](https://github.com/terkelg/ramme) - Unofficial Instagram app.
- [Moonview](https://github.com/teesloane/moonview) - Ambient notepad.
- [Temps](https://jackd248.github.io/temps/) - Weather forecast in your menubar.
- [DBGlass](https://github.com/web-pal/DBGlass) - PostgreSQL client.
- [Slide Beacon](https://github.com/dermike/slide-beacon-app) - Physical web beacon broadcast.
- [Rambox](https://github.com/saenzramiro/rambox) - Chat and email app that combines multiple services like Discord, Hangouts, Gmail and Outlook.
- [Extraterm](https://github.com/sedwards2009/extraterm) - Terminal.
- [Materialette](https://github.com/mike-schultz/materialette) - Material design color palette in your menubar.
- [Dext](https://github.com/vutran/dext) - Launcher.
- [PB for Desktop](https://github.com/sidneys/pb-for-desktop) - Pushbullet client.
- [GroupMe](https://github.com/dcrousso/GroupMe) - Unofficial GroupMe app.
- [ndm](https://github.com/720kb/ndm) - npm desktop manager.
- [GIFBar](https://github.com/dcrousso/GIFBar) - Search GIFs in your menubar.
- [Stacer](https://github.com/oguzhaninan/Stacer) - Ubuntu system optimizer.
- [Zazu](https://github.com/tinytacoteam/zazu) - Launcher.
- [Inpad](https://github.com/sarah-seo/Inpad) - Notes app with GitHub-flavored Markdown.
- [Cerebro](https://github.com/KELiON/cerebro) - Launcher with inline previews.
- [Desktop Dimmer](https://github.com/sidneys/desktop-dimmer) - Control the brightness of any display.
- [LosslessCut](https://github.com/mifi/lossless-cut) - Lossless video trimming & cutting.
- [Wexond](https://github.com/sential/wexond) - Web browser with material UI and extensions API.
- [Buka](https://github.com/oguzhaninan/Buka) - E-book management.
- [Insomnia](https://github.com/getinsomnia/insomnia) - Create and manage HTTP requests.
- [Tusk](https://github.com/champloohq/tusk) - Unofficial Evernote app.
- [ProtonMail Desktop](https://github.com/protonmail-desktop/application) - Unofficial ProtonMail app.
- [Comma Chameleon](https://github.com/theodi/comma-chameleon) - CSV editor.
- [Buttercup Desktop](https://github.com/buttercup/buttercup-desktop) - Password manager.
- [Mailspring](https://github.com/Foundry376/Mailspring) - Extensible email client. (Fork of Nylas Mail)
- [Manta](https://github.com/hql287/Manta) - Invoicing for freelancers with beautiful and customizable templates.
- [Headset](https://github.com/headsetapp/headset-electron) - Discover, collect, and listen to music from YouTube.
- [Nuclear](https://github.com/nukeop/nuclear) - Music player that streams from free sources.
- [Inboxer](https://github.com/denysdovhan/inboxer) - Unofficial Google Inbox app.

### Closed Source

- [GitKraken](http://www.gitkraken.com) - Git client.
- [1Clipboard](http://1clipboard.io) - Universal clipboard manager.
- [Franz](http://meetfranz.com) - Skype, Slack, Hangouts, WhatsApp, Grape, Telegram, FB Messenger, Hipchat in the same app.
- [Postman](https://www.getpostman.com) - Create and send HTTP requests.
- [Slack](https://medium.com/ben-and-dion/how-slack-built-a-well-loved-product-going-against-peter-thiel-and-native-app-fashion-2abbbe5a022f) - Desktop version.
- [Avocode](http://avocode.com) - Share design and collaborate.
- [Prepros](https://prepros.io) - Compile almost any preprocessing language with live browser refresh.
- [Stremio](http://www.strem.io) - Media center.
- [Typetalk](http://www.typetalk.in) - Share and discuss ideas with your team through instant messaging.
- [Pingendo](http://pingendo.com) - Bootstrap prototyping.
- [Spreaker Studio](https://www.spreaker.com/download) - Audio recording and broadcasting.
- [MockingBot](https://mockingbot.com) - Prototyping tool for designing apps.
- [Caret](http://caret.io) - Markdown editor.
- [Wagon](https://www.wagonhq.com) - SQL editor.
- [Wantedly Chat](https://www.wantedly.com/chat) - Business team chat. *(Japanese)*
- [Remember](https://rememberapp.co.kr) - Business card management. *(Korean)*
- [Pubu](https://pubu.im) - Real-time chat for team communication. *(Chinese)*
- [BearyChat](https://bearychat.com) - Team messaging service. *(Chinese)*
- [MongoDB Compass](https://www.mongodb.com/products/compass) - Official MongoDB app.
- [Freeter](https://freeter.io) - Organizer for freelancers & creatives.
- [WhatsApp](https://www.whatsapp.com/download/) - Official WhatsApp app.
- [CatLight](https://catlight.io) - Build status notifier.
- [Paws](http://friendlyfox.es/paws/) - Trello client.
- [Automint](http://automint.in) - CRM for automobile businesses.
- [CrossCloud](https://medium.com/@crosscloud/what-is-new-in-crosscloud-1-0-c00404e7bf9f) - Secure sync for multiple cloud storages.
- [Discord](https://discordapp.com) - Voice and text chat for gamers.
- [Cocos Creator](http://cocos2d-x.org/products#creator) - Game editor for creating web and native games for Cocos2D-x.
- [Inkdrop](https://www.inkdrop.info) - Markdown notebook for hackers.
- [Exodus](https://www.exodus.io) - Secure, manage, and exchange blockchain assets like Bitcoin and Ethereum.
- [Hackolade](http://hackolade.com) - Data modeling for NoSQL and multi-model databases.
- [ScreenSquid](http://screensquid.com) - Record and playback website visitor sessions.
- [CashNotify](https://cashnotify.com) - Monitor your Stripe accounts from your menu bar.
- [Mockoon](https://mockoon.com) - Mock servers in seconds.
- [Twitch](https://app.twitch.tv) - Official Twitch app.
- [Fenêtre](https://fenêt.re) - Picture-in-picture for your Mac.
- [Cleaver](https://getcleaver.com) - Provision servers and deploy web apps.

### Samples

- [Electron API usage](https://github.com/hokein/electron-sample-apps) - Sample apps illustrating usage of Electron APIs.
- [Screen Recorder](https://github.com/hokein/electron-screen-recorder) - WebRTC screen recorder.
- [Activity Monitor](https://electronjs.org/blog/simple-samples#activity-monitor) - Shows a doughnut chart of the CPU system, user, and idle activity time.
- [Hash](https://electronjs.org/blog/simple-samples#hash) - Shows the hash values of entered text using different algorithms.
- [Prices](https://electronjs.org/blog/simple-samples#prices) - Shows the current price of oil, gold, and silver using the Yahoo Finance API.
- [Touch Bar API](https://github.com/Rawnly/touchbar-api-sample) - Example of macOS Touch Bar integration.


## Boilerplates

- [electron-boilerplate](https://github.com/sindresorhus/electron-boilerplate) *(by sindresorhus)* - Boilerplate to kickstart creating an app.
- [generator-electron](https://github.com/sindresorhus/generator-electron) - Scaffold out an app boilerplate.
- [electron-boilerplate](https://github.com/szwacz/electron-boilerplate) *(by szwacz)* - Comprehensive boilerplate which even generates installers.
- [electron-react-boilerplate](https://github.com/chentsulin/electron-react-boilerplate) - Boilerplate based on React and webpack.
- [descjop](https://github.com/karad/lein_template_descjop) - ClojureScript boilerplate for creating an app.
- [electron-quick-start](https://github.com/electron/electron-quick-start) - Clone the repo to try a simple app.
- [bozon](https://github.com/railsware/bozon) - Scaffold, run, test, and package your app.
- [electron-vue](https://github.com/SimulatedGREG/electron-vue) - Easily build your app with Vue and common plugins.
- [electron-next-skeleton](https://github.com/leo/electron-next-skeleton) - Boilerplate to build your app with Next.js.
- [electron-sandbox](https://github.com/kewde/electron-sandbox) - Boilerplate and tutorial for creating secure apps (sandbox & communication over IPC).
- [angular-electron](https://github.com/maximegris/angular-electron) - Angular 5, Electron, TypeScript, SASS, Hot Reload.


## Tools

### For Electron

- [electron-builder](https://github.com/electron-userland/electron-builder) - Create installers.
- [devtron](https://github.com/electron/devtron) - Official DevTools extension.
- [electron-packager](https://github.com/electron-userland/electron-packager) - Package and distribute your app.
- [electron-debug](https://github.com/sindresorhus/electron-debug) - Adds useful debug features.
- [electron-is-dev](https://github.com/sindresorhus/electron-is-dev) - Check if Electron is running in development.
- [electron-localshortcut](https://github.com/parro-it/electron-localshortcut) - Add keyboard shortcuts locally to a window.
- [electron-gh-release](https://github.com/jenslind/electron-gh-releases) - Auto-update by releasing on GitHub.
- [electron-release](https://github.com/jenslind/electron-release) - Publish a new release of your app to GitHub.
- [electron-updater](https://github.com/evolvelabs/electron-updater) - Auto-updater leveraging npm to deploy updates.
- [fix-path](https://github.com/sindresorhus/fix-path) - Fix the $PATH on macOS when run from a GUI app. Useful when spawning a child process.
- [auto-launch](https://github.com/Teamwork/node-auto-launch) - Launch apps at system startup.
- [nuts](https://github.com/GitbookIO/nuts) - Releases server with auto-updater and GitHub as a backend.
- [electron-dl](https://github.com/sindresorhus/electron-dl) - Simplified file downloads.
- [electron-release-server](https://github.com/ArekSredzki/electron-release-server) - Self-hosted release server with front-end & auto-updater support.
- [electron-rebuild](https://github.com/electron/electron-rebuild) - Rebuild native Node.js modules against the currently installed Electron version.
- [electron-compile](https://github.com/electron/electron-compile) - Use ES2015, CoffeeScript, Less, Stylus in your app without a precompilation step.
- [electron-positioner](https://github.com/jenslind/electron-positioner) - Position windows at common spots.
- [electron-window-state](https://github.com/mawie81/electron-window-state) - Persist window sizes and positions.
- [electron-drag](https://github.com/kapetan/electron-drag) - Improved window dragging.
- [debug-menu](https://github.com/parro-it/debug-menu) - Chrome-like "inspect element" context-menu.
- [electron-installer-debian](https://github.com/unindented/electron-installer-debian) - Create a Debian package.
- [electron-installer-redhat](https://github.com/unindented/electron-installer-redhat) - Create a Red Hat package.
- [electron-installer-windows](https://github.com/unindented/electron-installer-windows) - Create a Windows package.
- [electron-sudo](https://github.com/automation-stack/electron-sudo) - Subprocesses with administrative privileges.
- [electron-json-storage](https://github.com/jviotti/electron-json-storage) - Write and read user settings.
- [electron-download](https://github.com/electron-userland/electron-download) - Download the Electron release zip from GitHub.
- [ipc-stream](https://github.com/jprichardson/electron-ipc-stream) - Duplex stream over IPC.
- [is-electron-renderer](https://github.com/jprichardson/is-electron-renderer) - Check if your code is running in `main` or `renderer`.
- [electron-osx-sign](https://github.com/electron-userland/electron-osx-sign) - Code-signing for macOS apps.
- [electron-detach](https://github.com/parro-it/electron-detach) - Restart an Electron app as a detached process.
- [ember-electron](https://github.com/felixrieseberg/ember-electron) - Build, test, and package Ember apps.
- [electrify](https://github.com/arboleya/electrify) - Package Meteor apps.
- [spectron](https://github.com/electron/spectron) - Test Electron apps using ChromeDriver.
- [babel-preset-electron](https://github.com/emorikawa/babel-preset-electron) - Babel preset that only compiles what's necessary for a particular Electron version.
- [electron-is](https://github.com/delvedor/electron-is) - Utility functions.
- [electron-osx-appearance](https://github.com/danhp/electron-osx-appearance) - Simplified API for accessing macOS's appearance settings.
- [electron-store](https://github.com/sindresorhus/electron-store) - Save and load data like user preferences, app state, cache, etc.
- [electron-context-menu](https://github.com/sindresorhus/electron-context-menu) - Extensible context menu.
- [electron-require](https://github.com/brrd/electron-require) - Simplified require.
- [NeDB](https://github.com/louischatriot/nedb) - Embedded persistent or in-memory database.
- [electron-devtools-installer](https://github.com/GPMDP/electron-devtools-installer) - Install DevTools extensions from the Chrome Web Store.
- [electron-log](https://github.com/megahertz/electron-log) - Simple logging.
- [electron-redux](https://github.com/hardchor/electron-redux) - Synchronize Redux state across windows.
- [electron-vibrancy](https://github.com/arkenthera/electron-vibrancy) - Add vibrancy (blur) to windows.
- [electron-about-window](https://github.com/rhysd/electron-about-window) - 'About This App' window.
- [elemon](https://github.com/manidlou/elemon) - Live-reload your app during development.
- [electron-is-accelerator](https://github.com/brrd/electron-is-accelerator) - Check if a string is a valid accelerator.
- [electron-pdf-window](https://github.com/gerhardberger/electron-pdf-window) - View PDF files in browser windows.
- [electron-router](https://github.com/m0n0l0c0/electron-router) - Router tidying up IPC message passing.
- [electron-settings](https://github.com/nathanbuchar/electron-settings) - Reads and writes user settings to disk.
- [got](https://github.com/sindresorhus/got) - Simplified HTTP requests.
- [electron-unhandled](https://github.com/sindresorhus/electron-unhandled) - Catch unhandled errors and promise rejections.
- [electron-process-manager](https://github.com/getstation/electron-process-manager) - Process manager UI (like Chrome's task manager).
- [ipc-flux](https://github.com/harryparkdotio/ipc-flux) - Flux-like state and action management across processes.
- [electron-util](https://github.com/sindresorhus/electron-util) - Useful utilities for developing apps and modules.
- [electron-reloader](https://github.com/sindresorhus/electron-reloader) - Simple auto-reloading during development.

### Using Electron

- [devtool](https://github.com/Jam3/devtool) - Debug Node.js with Chrome DevTools.
- [nativefier](https://github.com/jiahaog/nativefier) - Create an app of any website.
- [electron-stream](https://github.com/juliangruber/electron-stream) - Streaming wrapper.
- [Nightmare](http://www.nightmarejs.org) - High-level browser automation library (alternative to PhantomJS).
- [electron-pdf](https://github.com/fraserxu/electron-pdf) - Generate PDF from URL, HTML, or Markdown files on the command-line.
- [Geojsonapp](https://github.com/mick/geojsonapp) - Preview GeoJSON locally.
- [electron-mocha](https://github.com/jprichardson/electron-mocha) - Run Mocha tests in Electron.
- [electron-har](https://github.com/shyiko/electron-har) - Command-line tool for generating HTTP Archive (HAR).
- [electron-windows-store](https://github.com/catalystcode/electron-windows-store) - Turn Electron apps into Windows Store AppX packages.
- [Reactotron](https://github.com/reactotron/reactotron) - Inspect your React and React Native apps.


## Components

- [Photon](http://photonkit.com) - UI toolkit for building beautiful apps.
- [React PhotonKit](https://github.com/react-photonkit/react-photonkit) - Photon components built with React.
- [menubar](https://github.com/maxogden/menubar) - Menubar app framework.
- [cookies](https://github.com/hstove/electron-cookies) - Adds support for `document.cookie`.
- [window](https://github.com/jprichardson/electron-window) - Create and manage windows.
- [React Desktop](https://github.com/gabrielbull/react-desktop) - UI toolkit for macOS and Windows built with React.
- [electron-input-menu](https://github.com/parro-it/electron-input-menu) - Context menu for input elements.
- [chrome-tabs](https://github.com/adamschwartz/chrome-tabs) - Chrome like tabs.
- [titlebar](https://github.com/kapetan/titlebar) - Emulate the macOS window titlebar.
- [Brightwheel](https://github.com/loranallensmith/brightwheel) - Build and manage UI components with Photon and Etch.
- [Xel](https://xel-toolkit.org) - Widget toolkit for building native-like apps.


## Documentation

- [Quick Start](https://electronjs.org/docs/tutorial/quick-start)
- [Official docs](https://electronjs.org/docs)
- [Essential Electron](http://jlord.us/essential-electron/) - Concise overview.


## Articles

- [Electron Fundamentals](http://maxogden.com/electron-fundamentals.html)
- [Building a desktop application with Electron](https://medium.com/@bojzi/building-a-desktop-application-with-electron-204203eeb658)
- [Codesigning your app for macOS](http://jbavari.github.io/blog/2015/08/14/codesigning-electron-applications/)
- [Auto-updating apps for macOS and Windows: The complete guide](https://medium.com/@svilen/auto-updating-apps-for-windows-and-osx-using-electron-the-complete-guide-4aa7a50b904c)
- [How To Make Your Electron App Sexy](https://blog.dcpos.ch/how-to-make-your-electron-app-sexy)
- [Electron Rocks!](http://electron.rocks) - Blog about working with Electron.
- [Building a desktop app with Electron, React, and Redux](https://anadea.info/blog/building-desktop-app-with-electron)
- [Introducing BrowserView for Electron](https://blog.figma.com/introducing-browserview-for-electron-7b40b4b493d5) - New Electron API to embed web apps with fewer bugs and improved performance.
- [Migrating Slack’s Desktop App to BrowserView](https://slack.engineering/growing-pains-migrating-slacks-desktop-app-to-browserview-2759690d9c7b) - Slack rewrote their Electron app with `BrowserView`, Redux, Rx, and TypeScript, to fix its performance problems.
- [Bringing Native Performance to Electron](https://blog.realm.io/native-performance-electron-realm/) - Realm rewrote their database browser app with Electron for cross-platform support.
- [Electron on the App Store](https://medium.com/@yoannm/pushing-electron-on-the-mac-appstore-early-stages-7dcb85936f92) - A 5-part series about the journey of making and publishing an Electron app to the Mac App Store.


## Books

- [Developing an Electron Edge](https://bleedingedgepress.com/developing-an-electron-edge/) - [Preview](https://read.amazon.com/kp/embed?asin=B01G7TTKSK&asin=B01G7TTKSK&preview=newtab&linkCode=kpe&ref_=cm_sw_r_kb_dp_DLhOxb0XZ3MEC) 💲
- [Electron in Action](https://www.manning.com/books/electron-in-action?a_aid=electroninaction) - [Preview](https://manning-content.s3.amazonaws.com/download/5/1f50f4f-800b-40a5-a726-6ab236efeaf0/Kinney_Electron_MEAP_V10_ch1.pdf) 💲
- [Cross-Platform Desktop Applications](https://www.manning.com/books/cross-platform-desktop-applications) 💲


## Videos

- [Getting Started with Electron 1.x](https://www.youtube.com/watch?v=jKzBJAowmGg)
- [Packaging and Distributing Electron Desktop Apps](https://www.youtube.com/watch?v=dz5SnmBzBXc)
- [Multi Window Electron Desktop Apps](https://www.youtube.com/watch?v=K-H2amwQ_pU)
- [The State of Electron](https://www.youtube.com/watch?v=RaPmi-33rfc)
- [Cross-Platform Desktop Apps with Electron](https://www.youtube.com/watch?v=9xX_G0l5jLU)
- [Building Native Desktop apps using Electron](https://www.youtube.com/watch?v=nXIrFq5-FC8)
- [The New Desktop: Electron, React, & Pixel-Perfect Native-Feeling Experiences](https://www.youtube.com/watch?v=jRPUB-D1Wx0)
- [Building Desktop Apps with Node.js and Electron](https://www.youtube.com/watch?v=rbSvc8_BHaw)
- [Electron Fundamentals course - Pluralsight](https://www.pluralsight.com/courses/electron-fundamentals) 💲
- [Electron: Building Cross Platform Desktop Apps - Lynda](https://www.lynda.com/Electron-tutorials/Electron-Building-Cross-Platform-Desktop-Apps/518051-2.html) 💲
- [Automatically Build and Publish Node and Electron Applications for Linux](https://pusher.com/sessions/meetup/london-node-user-group/automatically-build-and-publish-node-and-electron-applications-for-linux)
- [Build a desktop application with Electron - Egghead](https://egghead.io/courses/build-a-desktop-application-with-electron) 💲
- [Build Cross-Platform Desktop Apps with Electron - Frontend Masters](https://frontendmasters.com/courses/electron/) 💲
- [Electron Meetup SF, November 2017](https://www.youtube.com/watch?v=DDjVaHPvRdM) - Includes some good talks on improving app startup time, debugging crashes, etc.


## Podcasts

- [JavaScript Jabber: Electron with Jessica Lord and Amy Palamountain](https://devchat.tv/js-jabber/193-jsj-electron-with-jessica-lord-and-amy-palamountain)
- [Hanselminutes: Creating cross-platform Electron apps with Jessica Lord](http://hanselminutes.com/534/creating-cross-platform-electron-apps-with-jessica-lord)
- [JavaScript Air: Electron Apps with @jlord and @emorikawa](https://javascriptair.com/episodes/2016-07-06)
- [The Changelog #216: GitHub's Electron with Zeke Sikelianos](https://changelog.com/216/)
- [Full Stack Radio #48: Jessica Lord - Building Desktop Apps with Electron](http://www.fullstackradio.com/48)
- [NodeUp: Electron with Jessica Lord](http://nodeup.com/onehundredseven)


## Community

- [Discuss](https://discuss.atom.io/c/electron)
- [Reddit](https://www.reddit.com/r/electronjs)
- [Stack Overflow](http://stackoverflow.com/questions/tagged/electron)
- [`@electronjs` on Twitter](https://twitter.com/electronjs)
- [`#atom-shell` on Freenode](http://webchat.freenode.net/?channels=atom-shell)
- [`#electron` on Atom Slack](http://atom-slack.herokuapp.com)
- [electron-jp](https://electron-jp-slackin.herokuapp.com) *(Japanese)*
- [electron-br](https://electron-br.slack.com) *(Brazilian Portuguese)*
- [electron-kr](http://www.meetup.com/electronkr) *(Korean)*
- [electron-pl](https://electronpl.github.io) *(Polish)*
- [`@electron_ru` on Telegram](https://telegram.me/electron_ru) *(Russian)*
- [`electronjs` on Facebook](https://www.facebook.com/groups/electronjs/)
- [Product Hunt](https://www.producthunt.com/@sindresorhus/collections/electron-apps)


## Tips

Contribute some ;)


## Contribute

Contributions welcome! Read the [contribution guidelines](contributing.md) first.


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Sindre Sorhus](http://sindresorhus.com) has waived all copyright and related or neighboring rights to this work.
