/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.interaction;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.interaction.InteractionCommand;
import com.jsql.view.swing.interaction.CreateTabHelper;
import com.jsql.view.swing.tab.TabHeader;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.ComponentOrientation;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.EmptyStackException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class CreateAdminPageTab
extends CreateTabHelper
implements InteractionCommand {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final String url;

    public CreateAdminPageTab(Object[] interactionParams) {
        this.url = (String)interactionParams[0];
    }

    @Override
    public void execute() {
        String htmlSource = "";
        try {
            htmlSource = Jsoup.clean(Jsoup.connect(this.url).ignoreContentType(true).ignoreHttpErrors(true).get().html().replaceAll("<img[^>]*>", "").replaceAll("<input[^>]*type=\"?hidden\"?[^>]*>", "").replaceAll("<input[^>]*type=\"?(submit|button)\"?[^>]*>", "<div style=\"background-color:#eeeeee;text-align:center;border:1px solid black;width:100px;\">button</div>").replaceAll("<input[^>]*>", "<div style=\"text-align:center;border:1px solid black;width:100px;\">input</div>"), Safelist.relaxed().addTags("center", "div", "span").addAttributes(":all", "style"));
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Failure opening page: {}", (Object)e.getMessage());
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        final JTextPane browser = new JTextPane();
        browser.setContentType("text/html");
        browser.setEditable(false);
        browser.setCaretPosition(0);
        try {
            browser.setText(htmlSource);
        }
        catch (IndexOutOfBoundsException | EmptyStackException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        JMenuItem itemCopyUrl = new JMenuItem(I18nUtil.valueByKey("CONTEXT_MENU_COPY_PAGE_URL"));
        I18nViewUtil.addComponentForKey("CONTEXT_MENU_COPY_PAGE_URL", itemCopyUrl);
        JMenuItem itemCopy = new JMenuItem();
        itemCopy.setAction(browser.getActionMap().get("copy-to-clipboard"));
        itemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        itemCopy.setMnemonic('C');
        itemCopy.setText(I18nUtil.valueByKey("CONTEXT_MENU_COPY"));
        I18nViewUtil.addComponentForKey("CONTEXT_MENU_COPY", itemCopy);
        JMenuItem itemSelectAll = new JMenuItem();
        itemSelectAll.setAction(browser.getActionMap().get("select-all"));
        itemSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        itemSelectAll.setText(I18nUtil.valueByKey("CONTEXT_MENU_SELECT_ALL"));
        I18nViewUtil.addComponentForKey("CONTEXT_MENU_SELECT_ALL", itemSelectAll);
        itemSelectAll.setMnemonic('A');
        final JPopupMenu menu = new JPopupMenu();
        menu.add(itemCopyUrl);
        menu.add(new JSeparator());
        menu.add(itemCopy);
        menu.add(itemSelectAll);
        menu.applyComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()));
        itemCopyUrl.addActionListener(actionEvent -> {
            StringSelection stringSelection = new StringSelection(this.url);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        });
        itemSelectAll.addActionListener(actionEvent -> browser.selectAll());
        browser.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                browser.getCaret().setVisible(true);
                browser.getCaret().setSelectionVisible(true);
            }
        });
        browser.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                browser.requestFocusInWindow();
                if (evt.isPopupTrigger()) {
                    menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    try {
                        menu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                    catch (IllegalComponentStateException e) {
                        LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                    }
                    menu.setLocation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? evt.getXOnScreen() - menu.getWidth() : evt.getXOnScreen(), evt.getYOnScreen());
                }
            }
        });
        JScrollPane scroller = new JScrollPane(browser);
        MediatorHelper.tabResults().addTab(this.url.replaceAll(".*/", "") + " ", scroller);
        try {
            MediatorHelper.tabResults().setSelectedComponent(scroller);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        MediatorHelper.tabResults().setToolTipTextAt(MediatorHelper.tabResults().indexOfComponent(scroller), String.format("<html>%s</html>", this.url));
        TabHeader header = new TabHeader(this.url.replaceAll(".*/", ""), UiUtil.ADMIN.getIcon());
        MediatorHelper.tabResults().setTabComponentAt(MediatorHelper.tabResults().indexOfComponent(scroller), header);
        browser.setCaretPosition(0);
        MediatorHelper.tabResults().updateUI();
    }
}

