/*
 * Copyright (C) 2021 UBports Foundation
 *
 * This file is part of Lomiri Weather App
 *
 * Lomiri Weather App is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * Lomiri Weather App is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.12
import Lomiri.Components 1.3

Page {
    id: generalPage
    header: PageHeader {
        id: header
        title: i18n.tr("About")
    }

    Flickable {
        id: generalFlickable
        clip: true
        flickableDirection: Flickable.AutoFlickIfNeeded
        boundsBehavior: Flickable.StopAtBounds

        anchors {
            topMargin: units.gu(2) + header.height
            fill: parent
        }

        contentHeight: generalColumn.childrenRect.height + units.gu(2)

        Column {
            id: generalColumn

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }

            Item {
                id: appIcon
                width: parent.width
                height: app_icon.height + units.gu(4)

                LomiriShape {
                    id: app_icon

                    width: Math.min(generalPage.width/4, 256)
                    height: width
                    anchors.centerIn: parent

                    source: Image {
                        id: icon_image
                        source: Qt.resolvedUrl("/weather-app.svg")
                    }
                    radius: "medium"
                    aspect: LomiriShape.DropShadow
                }
            }

            ListItem {
                id: appLabel
                height: appLayout.height
                divider.visible: false
                ListItemLayout {
                    id: appLayout
                    title.text: i18n.tr("Weather app")
                    title.font.pixelSize: units.gu(2.5)
                    title.horizontalAlignment: Text.AlignHCenter
                    subtitle.text: i18n.tr("Version %1").arg(Qt.application.version)
                    subtitle.font.pixelSize: units.gu(1.75)
                    subtitle.horizontalAlignment: Text.AlignHCenter
                }
            }

            Rectangle {
                id: spacer1
                width: parent.width
                height: units.gu(2)
                color: "transparent"
            }

            Label {
                id: headlineLinksLabel
                text: i18n.tr("Links")
                font.bold: true
                anchors {
                    left: parent.left
                    leftMargin: units.gu(2)
                }
            }

            Rectangle {
                id: spacer2
                width: parent.width
                height: units.gu(1)
                color: "transparent"
            }

            Repeater {
                id: listViewGeneral

                model: [
                { name: i18n.tr("Get the sourcecode"), url: "https://gitlab.com/ubports/development/apps/lomiri-weather-app/" },
                { name: i18n.tr("Report issues"),  url: "https://gitlab.com/ubports/development/apps/lomiri-weather-app/-/issues" },
                { name: i18n.tr("Help translate"), url: "https://hosted.weblate.org/projects/lomiri/weather-app/" },
                ]

                delegate: ListItem {
                    divider.visible: false
                    height: layoutAbout.height
                    ListItemLayout {
                        id: layoutAbout
                        title.text : modelData.name
                        ProgressionSlot {color: theme.palette.normal.baseText; }
                    }
                    onClicked: Qt.openUrlExternally(modelData.url)
                }
            }

            Rectangle {
                id: spacer3
                width: parent.width
                height: units.gu(4)
                color: "transparent"
            }

            Label {
                id: headlineCreditsLabel
                text: i18n.tr("Credits")
                font.bold: true
                anchors {
                    left: parent.left
                    leftMargin: units.gu(2)
                }
            }

            Rectangle {
                id: spacer4
                width: parent.width
                height: units.gu(1)
                color: "transparent"
            }

            Repeater {
                id: listViewCredits

                model: [
                    {
                        name: i18n.tr("Weather data by") + " open-meteo.com",
                        // licence: i18n.tr("Licence: commercial data"),
                        // summary: i18n.tr("Provides weather data via API"),
                        url: "https://open-meteo.com/"
                    },
                    {
                        name: i18n.tr("Rainradar by") + " Rainviewer.com",
                        // licence: i18n.tr("Licence: free, depending on data source"),
                        // summary: i18n.tr("Provides a collection of weather data from free sources"),
                        url: "https://www.rainviewer.com/"
                    },
                    {
                        name: i18n.tr("Coordinate lookup by") + " geoip.ubuntu.com",
                        // licence: i18n.tr("Licence: Canonical terms and conditions"),
                        // summary: i18n.tr("Allows to retreive coordinates for a given location name"),
                        url: "https://wiki.ubuntu.com/mapuntu/API"
                    },
                    {
                        name: i18n.tr("Location data lookup by") + " geonames.org",
                        // licence: i18n.tr("Licence: CC BY 4.0"),
                        // summary: i18n.tr("Allows to retreive administrative data e.g. country name for a given location"),
                        url: "http://www.geonames.org/"
                    },
                    {
                        name: i18n.tr("Sun and moon calculations by") + " suncalc.js",
                        // licence: i18n.tr("Licence: BSD"),
                        // summary: i18n.tr("Javascript library for calculating sun and moon related data"),
                        url: "https://github.com/mourner/suncalc"
                    },
                    {
                        name: i18n.tr("Timezone converting by") + " moment.js",
                        // licence: i18n.tr("Licence: MIT"),
                        // summary: i18n.tr("Moment with MomentTimezone is using build-in IANA timezone data"),
                        url: "https://momentjs.com/"
                    }
                ]

                delegate: ListItem {
                    divider.visible: false
                    height: layoutCredits.height
                    ListItemLayout {
                        id: layoutCredits
                        title.text : modelData.name
                        ProgressionSlot {color: theme.palette.normal.baseText; }
                    }
                    onClicked: Qt.openUrlExternally(modelData.url)
                }
            }
        }
    }
}
