//go:build !tinygo.wasm

//
//Copyright The containerd Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// Code generated by protoc-gen-go-plugin. DO NOT EDIT.
// versions:
// 	protoc-gen-go-plugin v0.1.0
// 	protoc               v3.20.1
// source: pkg/api/api.proto

package api

import (
	context "context"
	wazero "github.com/tetratelabs/wazero"
	wasi_snapshot_preview1 "github.com/tetratelabs/wazero/imports/wasi_snapshot_preview1"
)

type wazeroConfigOption func(plugin *WazeroConfig)

type WazeroNewRuntime func(context.Context) (wazero.Runtime, error)

type WazeroConfig struct {
	newRuntime   func(context.Context) (wazero.Runtime, error)
	moduleConfig wazero.ModuleConfig
}

func WazeroRuntime(newRuntime WazeroNewRuntime) wazeroConfigOption {
	return func(h *WazeroConfig) {
		h.newRuntime = newRuntime
	}
}

func DefaultWazeroRuntime() WazeroNewRuntime {
	return func(ctx context.Context) (wazero.Runtime, error) {
		r := wazero.NewRuntime(ctx)
		if _, err := wasi_snapshot_preview1.Instantiate(ctx, r); err != nil {
			return nil, err
		}

		return r, nil
	}
}

func WazeroModuleConfig(moduleConfig wazero.ModuleConfig) wazeroConfigOption {
	return func(h *WazeroConfig) {
		h.moduleConfig = moduleConfig
	}
}
