// Code generated by go generate; DO NOT EDIT.
package finegrained

import "errors"

type Permission int

const (
    Invalid Permission = iota
    NoAccess Permission = iota
    ActionsRead Permission = iota
    ActionsWrite Permission = iota
    AdministrationRead Permission = iota
    AdministrationWrite Permission = iota
    CodeScanningAlertsRead Permission = iota
    CodeScanningAlertsWrite Permission = iota
    CodespacesRead Permission = iota
    CodespacesWrite Permission = iota
    CodespacesLifecycleRead Permission = iota
    CodespacesLifecycleWrite Permission = iota
    CodespacesMetadataRead Permission = iota
    CodespacesMetadataWrite Permission = iota
    CodespacesSecretsRead Permission = iota
    CodespacesSecretsWrite Permission = iota
    CommitStatusesRead Permission = iota
    CommitStatusesWrite Permission = iota
    ContentsRead Permission = iota
    ContentsWrite Permission = iota
    CustomPropertiesRead Permission = iota
    CustomPropertiesWrite Permission = iota
    DependabotAlertsRead Permission = iota
    DependabotAlertsWrite Permission = iota
    DependabotSecretsRead Permission = iota
    DependabotSecretsWrite Permission = iota
    DeploymentsRead Permission = iota
    DeploymentsWrite Permission = iota
    EnvironmentsRead Permission = iota
    EnvironmentsWrite Permission = iota
    IssuesRead Permission = iota
    IssuesWrite Permission = iota
    MergeQueuesRead Permission = iota
    MergeQueuesWrite Permission = iota
    MetadataRead Permission = iota
    MetadataWrite Permission = iota
    PagesRead Permission = iota
    PagesWrite Permission = iota
    PullRequestsRead Permission = iota
    PullRequestsWrite Permission = iota
    RepoSecurityRead Permission = iota
    RepoSecurityWrite Permission = iota
    SecretScanningRead Permission = iota
    SecretScanningWrite Permission = iota
    SecretsRead Permission = iota
    SecretsWrite Permission = iota
    VariablesRead Permission = iota
    VariablesWrite Permission = iota
    WebhooksRead Permission = iota
    WebhooksWrite Permission = iota
    WorkflowsRead Permission = iota
    WorkflowsWrite Permission = iota
    BlockUserRead Permission = iota
    BlockUserWrite Permission = iota
    CodespaceUserSecretsRead Permission = iota
    CodespaceUserSecretsWrite Permission = iota
    EmailRead Permission = iota
    EmailWrite Permission = iota
    FollowersRead Permission = iota
    FollowersWrite Permission = iota
    GpgKeysRead Permission = iota
    GpgKeysWrite Permission = iota
    GistsRead Permission = iota
    GistsWrite Permission = iota
    GitKeysRead Permission = iota
    GitKeysWrite Permission = iota
    LimitsRead Permission = iota
    LimitsWrite Permission = iota
    PlanRead Permission = iota
    PlanWrite Permission = iota
    PrivateInvitesRead Permission = iota
    PrivateInvitesWrite Permission = iota
    ProfileRead Permission = iota
    ProfileWrite Permission = iota
    SigningKeysRead Permission = iota
    SigningKeysWrite Permission = iota
    StarringRead Permission = iota
    StarringWrite Permission = iota
    WatchingRead Permission = iota
    WatchingWrite Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        NoAccess: "no_access",
        ActionsRead: "actions:read",
        ActionsWrite: "actions:write",
        AdministrationRead: "administration:read",
        AdministrationWrite: "administration:write",
        CodeScanningAlertsRead: "code_scanning_alerts:read",
        CodeScanningAlertsWrite: "code_scanning_alerts:write",
        CodespacesRead: "codespaces:read",
        CodespacesWrite: "codespaces:write",
        CodespacesLifecycleRead: "codespaces_lifecycle:read",
        CodespacesLifecycleWrite: "codespaces_lifecycle:write",
        CodespacesMetadataRead: "codespaces_metadata:read",
        CodespacesMetadataWrite: "codespaces_metadata:write",
        CodespacesSecretsRead: "codespaces_secrets:read",
        CodespacesSecretsWrite: "codespaces_secrets:write",
        CommitStatusesRead: "commit_statuses:read",
        CommitStatusesWrite: "commit_statuses:write",
        ContentsRead: "contents:read",
        ContentsWrite: "contents:write",
        CustomPropertiesRead: "custom_properties:read",
        CustomPropertiesWrite: "custom_properties:write",
        DependabotAlertsRead: "dependabot_alerts:read",
        DependabotAlertsWrite: "dependabot_alerts:write",
        DependabotSecretsRead: "dependabot_secrets:read",
        DependabotSecretsWrite: "dependabot_secrets:write",
        DeploymentsRead: "deployments:read",
        DeploymentsWrite: "deployments:write",
        EnvironmentsRead: "environments:read",
        EnvironmentsWrite: "environments:write",
        IssuesRead: "issues:read",
        IssuesWrite: "issues:write",
        MergeQueuesRead: "merge_queues:read",
        MergeQueuesWrite: "merge_queues:write",
        MetadataRead: "metadata:read",
        MetadataWrite: "metadata:write",
        PagesRead: "pages:read",
        PagesWrite: "pages:write",
        PullRequestsRead: "pull_requests:read",
        PullRequestsWrite: "pull_requests:write",
        RepoSecurityRead: "repo_security:read",
        RepoSecurityWrite: "repo_security:write",
        SecretScanningRead: "secret_scanning:read",
        SecretScanningWrite: "secret_scanning:write",
        SecretsRead: "secrets:read",
        SecretsWrite: "secrets:write",
        VariablesRead: "variables:read",
        VariablesWrite: "variables:write",
        WebhooksRead: "webhooks:read",
        WebhooksWrite: "webhooks:write",
        WorkflowsRead: "workflows:read",
        WorkflowsWrite: "workflows:write",
        BlockUserRead: "block_user:read",
        BlockUserWrite: "block_user:write",
        CodespaceUserSecretsRead: "codespace_user_secrets:read",
        CodespaceUserSecretsWrite: "codespace_user_secrets:write",
        EmailRead: "email:read",
        EmailWrite: "email:write",
        FollowersRead: "followers:read",
        FollowersWrite: "followers:write",
        GpgKeysRead: "gpg_keys:read",
        GpgKeysWrite: "gpg_keys:write",
        GistsRead: "gists:read",
        GistsWrite: "gists:write",
        GitKeysRead: "git_keys:read",
        GitKeysWrite: "git_keys:write",
        LimitsRead: "limits:read",
        LimitsWrite: "limits:write",
        PlanRead: "plan:read",
        PlanWrite: "plan:write",
        PrivateInvitesRead: "private_invites:read",
        PrivateInvitesWrite: "private_invites:write",
        ProfileRead: "profile:read",
        ProfileWrite: "profile:write",
        SigningKeysRead: "signing_keys:read",
        SigningKeysWrite: "signing_keys:write",
        StarringRead: "starring:read",
        StarringWrite: "starring:write",
        WatchingRead: "watching:read",
        WatchingWrite: "watching:write",
    }

    StringToPermission = map[string]Permission{
        "no_access": NoAccess,
        "actions:read": ActionsRead,
        "actions:write": ActionsWrite,
        "administration:read": AdministrationRead,
        "administration:write": AdministrationWrite,
        "code_scanning_alerts:read": CodeScanningAlertsRead,
        "code_scanning_alerts:write": CodeScanningAlertsWrite,
        "codespaces:read": CodespacesRead,
        "codespaces:write": CodespacesWrite,
        "codespaces_lifecycle:read": CodespacesLifecycleRead,
        "codespaces_lifecycle:write": CodespacesLifecycleWrite,
        "codespaces_metadata:read": CodespacesMetadataRead,
        "codespaces_metadata:write": CodespacesMetadataWrite,
        "codespaces_secrets:read": CodespacesSecretsRead,
        "codespaces_secrets:write": CodespacesSecretsWrite,
        "commit_statuses:read": CommitStatusesRead,
        "commit_statuses:write": CommitStatusesWrite,
        "contents:read": ContentsRead,
        "contents:write": ContentsWrite,
        "custom_properties:read": CustomPropertiesRead,
        "custom_properties:write": CustomPropertiesWrite,
        "dependabot_alerts:read": DependabotAlertsRead,
        "dependabot_alerts:write": DependabotAlertsWrite,
        "dependabot_secrets:read": DependabotSecretsRead,
        "dependabot_secrets:write": DependabotSecretsWrite,
        "deployments:read": DeploymentsRead,
        "deployments:write": DeploymentsWrite,
        "environments:read": EnvironmentsRead,
        "environments:write": EnvironmentsWrite,
        "issues:read": IssuesRead,
        "issues:write": IssuesWrite,
        "merge_queues:read": MergeQueuesRead,
        "merge_queues:write": MergeQueuesWrite,
        "metadata:read": MetadataRead,
        "metadata:write": MetadataWrite,
        "pages:read": PagesRead,
        "pages:write": PagesWrite,
        "pull_requests:read": PullRequestsRead,
        "pull_requests:write": PullRequestsWrite,
        "repo_security:read": RepoSecurityRead,
        "repo_security:write": RepoSecurityWrite,
        "secret_scanning:read": SecretScanningRead,
        "secret_scanning:write": SecretScanningWrite,
        "secrets:read": SecretsRead,
        "secrets:write": SecretsWrite,
        "variables:read": VariablesRead,
        "variables:write": VariablesWrite,
        "webhooks:read": WebhooksRead,
        "webhooks:write": WebhooksWrite,
        "workflows:read": WorkflowsRead,
        "workflows:write": WorkflowsWrite,
        "block_user:read": BlockUserRead,
        "block_user:write": BlockUserWrite,
        "codespace_user_secrets:read": CodespaceUserSecretsRead,
        "codespace_user_secrets:write": CodespaceUserSecretsWrite,
        "email:read": EmailRead,
        "email:write": EmailWrite,
        "followers:read": FollowersRead,
        "followers:write": FollowersWrite,
        "gpg_keys:read": GpgKeysRead,
        "gpg_keys:write": GpgKeysWrite,
        "gists:read": GistsRead,
        "gists:write": GistsWrite,
        "git_keys:read": GitKeysRead,
        "git_keys:write": GitKeysWrite,
        "limits:read": LimitsRead,
        "limits:write": LimitsWrite,
        "plan:read": PlanRead,
        "plan:write": PlanWrite,
        "private_invites:read": PrivateInvitesRead,
        "private_invites:write": PrivateInvitesWrite,
        "profile:read": ProfileRead,
        "profile:write": ProfileWrite,
        "signing_keys:read": SigningKeysRead,
        "signing_keys:write": SigningKeysWrite,
        "starring:read": StarringRead,
        "starring:write": StarringWrite,
        "watching:read": WatchingRead,
        "watching:write": WatchingWrite,
    }

    PermissionIDs = map[Permission]int{
        NoAccess: 1,
        ActionsRead: 2,
        ActionsWrite: 3,
        AdministrationRead: 4,
        AdministrationWrite: 5,
        CodeScanningAlertsRead: 6,
        CodeScanningAlertsWrite: 7,
        CodespacesRead: 8,
        CodespacesWrite: 9,
        CodespacesLifecycleRead: 10,
        CodespacesLifecycleWrite: 11,
        CodespacesMetadataRead: 12,
        CodespacesMetadataWrite: 13,
        CodespacesSecretsRead: 14,
        CodespacesSecretsWrite: 15,
        CommitStatusesRead: 16,
        CommitStatusesWrite: 17,
        ContentsRead: 18,
        ContentsWrite: 19,
        CustomPropertiesRead: 20,
        CustomPropertiesWrite: 21,
        DependabotAlertsRead: 22,
        DependabotAlertsWrite: 23,
        DependabotSecretsRead: 24,
        DependabotSecretsWrite: 25,
        DeploymentsRead: 26,
        DeploymentsWrite: 27,
        EnvironmentsRead: 28,
        EnvironmentsWrite: 29,
        IssuesRead: 30,
        IssuesWrite: 31,
        MergeQueuesRead: 32,
        MergeQueuesWrite: 33,
        MetadataRead: 34,
        MetadataWrite: 35,
        PagesRead: 36,
        PagesWrite: 37,
        PullRequestsRead: 38,
        PullRequestsWrite: 39,
        RepoSecurityRead: 40,
        RepoSecurityWrite: 41,
        SecretScanningRead: 42,
        SecretScanningWrite: 43,
        SecretsRead: 44,
        SecretsWrite: 45,
        VariablesRead: 46,
        VariablesWrite: 47,
        WebhooksRead: 48,
        WebhooksWrite: 49,
        WorkflowsRead: 50,
        WorkflowsWrite: 51,
        BlockUserRead: 52,
        BlockUserWrite: 53,
        CodespaceUserSecretsRead: 54,
        CodespaceUserSecretsWrite: 55,
        EmailRead: 56,
        EmailWrite: 57,
        FollowersRead: 58,
        FollowersWrite: 59,
        GpgKeysRead: 60,
        GpgKeysWrite: 61,
        GistsRead: 62,
        GistsWrite: 63,
        GitKeysRead: 64,
        GitKeysWrite: 65,
        LimitsRead: 66,
        LimitsWrite: 67,
        PlanRead: 68,
        PlanWrite: 69,
        PrivateInvitesRead: 70,
        PrivateInvitesWrite: 71,
        ProfileRead: 72,
        ProfileWrite: 73,
        SigningKeysRead: 74,
        SigningKeysWrite: 75,
        StarringRead: 76,
        StarringWrite: 77,
        WatchingRead: 78,
        WatchingWrite: 79,
    }

    IdToPermission = map[int]Permission{
        1: NoAccess,
        2: ActionsRead,
        3: ActionsWrite,
        4: AdministrationRead,
        5: AdministrationWrite,
        6: CodeScanningAlertsRead,
        7: CodeScanningAlertsWrite,
        8: CodespacesRead,
        9: CodespacesWrite,
        10: CodespacesLifecycleRead,
        11: CodespacesLifecycleWrite,
        12: CodespacesMetadataRead,
        13: CodespacesMetadataWrite,
        14: CodespacesSecretsRead,
        15: CodespacesSecretsWrite,
        16: CommitStatusesRead,
        17: CommitStatusesWrite,
        18: ContentsRead,
        19: ContentsWrite,
        20: CustomPropertiesRead,
        21: CustomPropertiesWrite,
        22: DependabotAlertsRead,
        23: DependabotAlertsWrite,
        24: DependabotSecretsRead,
        25: DependabotSecretsWrite,
        26: DeploymentsRead,
        27: DeploymentsWrite,
        28: EnvironmentsRead,
        29: EnvironmentsWrite,
        30: IssuesRead,
        31: IssuesWrite,
        32: MergeQueuesRead,
        33: MergeQueuesWrite,
        34: MetadataRead,
        35: MetadataWrite,
        36: PagesRead,
        37: PagesWrite,
        38: PullRequestsRead,
        39: PullRequestsWrite,
        40: RepoSecurityRead,
        41: RepoSecurityWrite,
        42: SecretScanningRead,
        43: SecretScanningWrite,
        44: SecretsRead,
        45: SecretsWrite,
        46: VariablesRead,
        47: VariablesWrite,
        48: WebhooksRead,
        49: WebhooksWrite,
        50: WorkflowsRead,
        51: WorkflowsWrite,
        52: BlockUserRead,
        53: BlockUserWrite,
        54: CodespaceUserSecretsRead,
        55: CodespaceUserSecretsWrite,
        56: EmailRead,
        57: EmailWrite,
        58: FollowersRead,
        59: FollowersWrite,
        60: GpgKeysRead,
        61: GpgKeysWrite,
        62: GistsRead,
        63: GistsWrite,
        64: GitKeysRead,
        65: GitKeysWrite,
        66: LimitsRead,
        67: LimitsWrite,
        68: PlanRead,
        69: PlanWrite,
        70: PrivateInvitesRead,
        71: PrivateInvitesWrite,
        72: ProfileRead,
        73: ProfileWrite,
        74: SigningKeysRead,
        75: SigningKeysWrite,
        76: StarringRead,
        77: StarringWrite,
        78: WatchingRead,
        79: WatchingWrite,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
