/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing;

import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeNameValidator;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.editing.AddPropertyForm;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.openide.WizardDescriptor;

public class AddPropertyFormController
extends ValidatingController<AddPropertyForm> {
    public static final String UNIQUE_NAME = "uniqueName";
    public static final String TYPE_DESCRIPTOR = "typeDescriptor";
    public static final String DISPLAY_NAME = "displayName";
    public static final String IS_EDIT_MODE = "isEditMode";

    protected String getFirstError(AddPropertyForm component) {
        String name = component.getDisplayName();
        if (name.trim().length() == 0) {
            return "Display name is required";
        }
        String id = component.getUniqueName();
        if ((id = id.trim()).length() == 0) {
            return "Unique type name is required";
        }
        String error = TypeNameValidator.checkName((String)id);
        if (error != null) {
            return error;
        }
        if (component.getDataType() == null) {
            return "Data type is required";
        }
        return null;
    }

    protected AddPropertyForm createComponent() {
        final AddPropertyForm f = new AddPropertyForm();
        f.addChangeListener(this.changeListener());
        f.addDisplayNameFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!AddPropertyFormController.this.isEditMode()) {
                    String id = f.getUniqueName();
                    String displayName = f.getDisplayName();
                    if (id.trim().isEmpty() && !displayName.isEmpty()) {
                        f.setUniqueName(AddPropertyFormController.this.createID(displayName));
                    }
                }
            }
        });
        return f;
    }

    protected boolean isEditMode() {
        return this.getDescriptor().getProperty(IS_EDIT_MODE) == Boolean.TRUE;
    }

    private String createID(String displayName) {
        displayName = displayName.replaceAll(" ", "");
        displayName = displayName.toLowerCase();
        return "properties." + displayName;
    }

    protected void readSettings(WizardDescriptor settings) {
        AddPropertyForm component = (AddPropertyForm)this.component();
        TypeDescriptor[] types = TypeRegistry.getDefault().getTypes();
        component.setDataTypes(types);
        component.setDataType((TypeDescriptor)settings.getProperty(TYPE_DESCRIPTOR));
        component.setDisplayName((String)settings.getProperty(DISPLAY_NAME));
        component.setUniqueName((String)settings.getProperty(UNIQUE_NAME));
    }

    protected void storeSettings(WizardDescriptor settings) {
        AddPropertyForm component = (AddPropertyForm)this.component();
        settings.putProperty(UNIQUE_NAME, (Object)component.getUniqueName());
        settings.putProperty(TYPE_DESCRIPTOR, (Object)component.getDataType());
        settings.putProperty(DISPLAY_NAME, (Object)component.getDisplayName());
    }
}

