/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run;

import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class TabularRowCounter {
    private static final Logger LOG = Logger.getLogger(TabularRowCounter.class.getName());

    public long getRowCount(Map<TabularTransformSource, List<TabularGraphFileImporter>> importers) throws Exception {
        LOG.fine("Row counts:");
        return importers.entrySet().stream().mapToLong(entry -> this.getRowCount((TabularTransformSource)entry.getKey(), (List)entry.getValue())).sum();
    }

    private long getRowCount(TabularTransformSource source, List<TabularGraphFileImporter> importers) {
        return importers.stream().mapToLong(importer -> this.getRowCount(source, (TabularGraphFileImporter)importer)).sum();
    }

    private long getRowCount(TabularTransformSource source, TabularGraphFileImporter importer) {
        long rows = 0L;
        try {
            rows = importer.getRowCount();
            TabularGraph tabularGraph = MappingRegistry.getDefault().get(source.getTabularGraphName());
            if ((rows -= (long)tabularGraph.getDataStartRowIndex()) < 0L) {
                rows = 0L;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        LOG.log(Level.FINE, "   {0}: {1}", new Object[]{rows, importer.getFile()});
        return rows;
    }
}

