/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractAttr;
import com.kenai.jbosh.BOSHException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AttrVersion
extends AbstractAttr<String>
implements Comparable {
    private static final AttrVersion DEFAULT;
    private final int major;
    private final int minor;

    private AttrVersion(String val) throws BOSHException {
        super(val);
        int idx = val.indexOf(46);
        if (idx <= 0) {
            throw new BOSHException("Illegal ver attribute value (not in major.minor form): " + val);
        }
        String majorStr = val.substring(0, idx);
        try {
            this.major = Integer.parseInt(majorStr);
        }
        catch (NumberFormatException nfx) {
            throw new BOSHException("Could not parse ver attribute value (major ver): " + majorStr, nfx);
        }
        if (this.major < 0) {
            throw new BOSHException("Major version may not be < 0");
        }
        String minorStr = val.substring(idx + 1);
        try {
            this.minor = Integer.parseInt(minorStr);
        }
        catch (NumberFormatException nfx) {
            throw new BOSHException("Could not parse ver attribute value (minor ver): " + minorStr, nfx);
        }
        if (this.minor < 0) {
            throw new BOSHException("Minor version may not be < 0");
        }
    }

    static AttrVersion getSupportedVersion() {
        return DEFAULT;
    }

    static AttrVersion createFromString(String str) throws BOSHException {
        if (str == null) {
            return null;
        }
        return new AttrVersion(str);
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    @Override
    public int compareTo(Object otherObj) {
        if (otherObj instanceof AttrVersion) {
            AttrVersion other = (AttrVersion)otherObj;
            if (this.major < other.major) {
                return -1;
            }
            if (this.major > other.major) {
                return 1;
            }
            if (this.minor < other.minor) {
                return -1;
            }
            if (this.minor > other.minor) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    static {
        try {
            DEFAULT = AttrVersion.createFromString("1.8");
        }
        catch (BOSHException boshx) {
            throw new IllegalStateException(boshx);
        }
    }
}

