/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.binding;

import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.view.customization.api.Binding;
import com.paterva.maltego.view.customization.api.Customizable;
import com.paterva.maltego.view.customization.ui.binding.BindingPanel;
import java.awt.Component;
import java.util.List;
import org.openide.WizardDescriptor;
import org.openide.util.Utilities;

public class BindingController
extends ValidatingController<BindingPanel> {
    private List<Customizable> _customizables;
    private Customizable _customizable;
    private String _script;
    private boolean _readonly;

    public BindingController(Binding binding, List<Customizable> customizables, boolean readonly) {
        this._customizables = customizables;
        this._customizable = binding.getCustomizable();
        this._script = binding.getScript().getText();
        this._readonly = readonly;
    }

    protected BindingPanel createComponent() {
        BindingPanel bindingPanel = new BindingPanel();
        bindingPanel.setCustomizables(this._customizables);
        bindingPanel.setSelectedCustomizable(this._customizable != null ? this._customizable : this._customizables.get(0));
        bindingPanel.setScript(this._script);
        bindingPanel.setReadonly(this._readonly);
        return bindingPanel;
    }

    public boolean update(Binding binding) {
        BindingPanel component = (BindingPanel)this.component();
        Customizable newCustomizable = component.getSelectedCustomizable();
        String newScript = component.getScript();
        Customizable oldCustomizable = binding.getCustomizable();
        String oldScript = binding.getScript().getText();
        if (Utilities.compareObjects((Object)oldCustomizable, (Object)newCustomizable) && Utilities.compareObjects((Object)oldScript, (Object)newScript)) {
            return false;
        }
        binding.setCustomizable(newCustomizable);
        binding.getScript().setText(newScript);
        return true;
    }

    protected String getFirstError(BindingPanel component) {
        return super.getFirstError((Component)component);
    }

    protected void readSettings(WizardDescriptor settings) {
    }

    protected void storeSettings(WizardDescriptor settings) {
    }
}

