/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.PandoraConnection;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.lucene.LuceneSchema;
import com.pinkmatter.pandora.lucene.PandoraConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuceneConnection
implements PandoraConnection {
    private boolean _init = false;
    private SearcherManager _searcherManager;
    private TrackingIndexWriter _writer;
    private final File _indexPath;
    private static final Logger LOG = LoggerFactory.getLogger(LuceneConnection.class);
    private LuceneSchema _schema;
    private long _version = 0L;

    private LuceneConnection(boolean inMemory, File indexPath) throws PandoraException {
        this._indexPath = indexPath;
        this.init(inMemory);
    }

    public static LuceneConnection createFileConnection(File indexPath) throws PandoraException {
        if (indexPath == null) {
            throw new IllegalArgumentException("Could not open Pandora index. No index path specified.");
        }
        return new LuceneConnection(false, indexPath);
    }

    public static LuceneConnection createInMemoryConnection() throws PandoraException {
        return new LuceneConnection(true, null);
    }

    private void init(boolean inMemory) throws PandoraException {
        try {
            if (!this._init) {
                IndexWriter writer = !inMemory ? LuceneConnection.createWriter(this._indexPath) : LuceneConnection.createMemoryWriter();
                this._writer = new TrackingIndexWriter(writer);
                this._searcherManager = new SearcherManager(writer, true, null);
                this._init = true;
                LOG.debug("Running Pandora using Lucene {} with codec {}", (Object)PandoraConstants.getLuceneVersion(), (Object)PandoraConstants.getCodec().getName());
                if (this._indexPath != null) {
                    LOG.info("Opened Pandora index at {}", (Object)this._indexPath.getAbsolutePath());
                } else {
                    LOG.warn("Opened in-memory Pandora index. Index will not be persisted!");
                }
            }
        }
        catch (IOException ex) {
            throw new PandoraException(String.format("Failed to open Pandora index at %s.", this._indexPath.getAbsolutePath()), (Throwable)ex);
        }
    }

    private static IndexWriter createMemoryWriter() throws IOException {
        return new IndexWriter((Directory)new RAMDirectory(), LuceneConnection.createConfig());
    }

    private static IndexWriter createWriter(File indexPath) throws IOException {
        if (!indexPath.exists() || !indexPath.isDirectory()) {
            throw new IOException(String.format("Failed to open Pandora index at %s. Folder does not exist.", indexPath.getAbsolutePath()));
        }
        FSDirectory dir = FSDirectory.open((Path)indexPath.toPath());
        return new IndexWriter((Directory)dir, LuceneConnection.createConfig());
    }

    private static IndexWriterConfig createConfig() {
        IndexWriterConfig writerConfig = new IndexWriterConfig(PandoraConstants.getTextAnalyzer());
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        writerConfig.setCodec(PandoraConstants.getCodec());
        writerConfig.setUseCompoundFile(true);
        return writerConfig;
    }

    synchronized long addDocument(Document doc) throws IOException {
        ++this._version;
        return this._writer.addDocument((Iterable)doc);
    }

    synchronized long updateDocument(Term term, Document doc) throws IOException {
        ++this._version;
        return this._writer.updateDocument(term, (Iterable)doc);
    }

    synchronized long deleteDocuments(Term term) throws IOException {
        ++this._version;
        return this._writer.deleteDocuments(term);
    }

    synchronized long deleteDocuments(Query query) throws IOException {
        ++this._version;
        return this._writer.deleteDocuments(query);
    }

    long getVersion() {
        return this._version;
    }

    void commit() throws IOException {
        this._writer.getIndexWriter().commit();
    }

    IndexSearcher acquireWithForcedRefresh() throws IOException {
        this._searcherManager.maybeRefreshBlocking();
        return (IndexSearcher)this._searcherManager.acquire();
    }

    IndexSearcher acquireWithRefresh() throws IOException {
        this._searcherManager.maybeRefresh();
        return (IndexSearcher)this._searcherManager.acquire();
    }

    IndexSearcher acquire() throws IOException {
        return (IndexSearcher)this._searcherManager.acquire();
    }

    void release(IndexSearcher searcher) throws PandoraException {
        try {
            this._searcherManager.release((Object)searcher);
        }
        catch (IOException ex) {
            throw new PandoraException("Failed to release searcher.", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws PandoraException {
        try {
            if (this._writer == null) return;
            this.commit();
            this._writer.getIndexWriter().close();
            return;
        }
        catch (IOException ex) {
            throw new PandoraException("Failed to close Pandora index connection.", (Throwable)ex);
        }
        finally {
            try {
                if (this._searcherManager != null) {
                    this._searcherManager.close();
                }
            }
            catch (IOException ex) {
                throw new PandoraException("Failed to close Pandora index connection.", (Throwable)ex);
            }
            finally {
                if (this._indexPath != null) {
                    LOG.info("Closed Pandora index at {}", (Object)this._indexPath.getAbsolutePath());
                } else {
                    LOG.warn("Closed in-memory arhive index");
                }
            }
        }
    }

    LuceneSchema getSchema(boolean refresh) throws PandoraException {
        if (this._schema == null) {
            this._schema = new LuceneSchema(this, false);
        }
        if (refresh) {
            this._schema.refresh();
        }
        return this._schema;
    }
}

