/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.nodes.GraphPrintVisitor;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.ShapeProfiler;
import com.oracle.truffle.object.Transition;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

class Debug {
    static final String INVALID = "!";
    static final String BRANCH = "\u2443";
    static final String LEAF = "\u22a5";
    private static Collection<ShapeImpl> allShapes;
    static final /* synthetic */ boolean $assertionsDisabled;

    Debug() {
    }

    static void trackShape(ShapeImpl newShape) {
        allShapes.add(newShape);
    }

    static void trackObject(DynamicObject obj) {
        if (!$assertionsDisabled && !ObjectStorageOptions.Profile) {
            throw new AssertionError();
        }
        ShapeProfiler.getInstance().track(obj);
    }

    static Iterable<ShapeImpl> getAllShapes() {
        return allShapes;
    }

    static String dumpObject(DynamicObject object, int level, int levelStop) {
        List<Property> properties = object.getShape().getPropertyListInternal(true);
        StringBuilder sb = new StringBuilder(properties.size() * 10);
        sb.append("{\n");
        for (Property property : properties) {
            Debug.indent(sb, level + 1);
            sb.append(property.getKey());
            sb.append('[').append(property.getLocation()).append(']');
            Object value = property.get(object, false);
            if (value instanceof DynamicObject) {
                value = level < levelStop ? Debug.dumpObject((DynamicObject)value, level + 1, levelStop) : value.toString();
            }
            sb.append(": ");
            sb.append(value);
            if (property != properties.get(properties.size() - 1)) {
                sb.append(",");
            }
            sb.append("\n");
        }
        Debug.indent(sb, level);
        sb.append("}");
        return sb.toString();
    }

    private static StringBuilder indent(StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    private static void dumpDOT() throws FileNotFoundException, UnsupportedEncodingException {
        try (PrintWriter out = new PrintWriter(Debug.getOutputFile("dot"), "UTF-8");){
            GraphvizShapeVisitor visitor = new GraphvizShapeVisitor();
            for (ShapeImpl shape : Debug.getAllShapes()) {
                visitor.visitShape(shape);
            }
            out.println(visitor);
        }
    }

    private static void dumpIGV() {
        GraphPrintVisitor printer = new GraphPrintVisitor();
        printer.beginGroup("shapes");
        IGVShapeVisitor visitor = new IGVShapeVisitor(printer);
        for (ShapeImpl shape : Debug.getAllShapes()) {
            if (!Debug.isRootShape(shape)) continue;
            printer.beginGraph(Debug.getId(shape) + " (" + Debug.calcShapeGraphSize(shape) + ") (" + shape.getDynamicType() + ")");
            visitor.visitShape(shape);
            printer.endGraph();
        }
        printer.beginGraph("all shapes");
        for (ShapeImpl shape : Debug.getAllShapes()) {
            if (!Debug.isRootShape(shape)) continue;
            visitor.visitShape(shape);
        }
        printer.endGraph();
        printer.endGroup();
        printer.printToNetwork(false);
    }

    private static String calcShapeGraphSize(ShapeImpl shape) {
        class Visitor
        implements DebugShapeVisitor<Integer> {
            final Set<Shape> visitedShapes = new HashSet<Shape>();
            int invalidShapeCount;
            int branchCount = 1;
            int leafCount;

            Visitor() {
            }

            @Override
            public Integer visitShape(ShapeImpl s, Map<? extends Transition, ? extends ShapeImpl> transitions) {
                if (!this.visitedShapes.add(s)) {
                    return 0;
                }
                int shapeCount = 1;
                if (!s.isValid()) {
                    ++this.invalidShapeCount;
                }
                if (s.isLeaf()) {
                    ++this.leafCount;
                }
                this.branchCount += Math.max(0, transitions.size() - 1);
                for (Map.Entry<? extends Transition, ? extends ShapeImpl> entry : transitions.entrySet()) {
                    shapeCount += ((Integer)this.visitShape(entry.getValue())).intValue();
                }
                return shapeCount;
            }
        }
        Visitor v = new Visitor();
        int shapeCount = (Integer)v.visitShape(shape);
        if (!$assertionsDisabled && shapeCount != v.visitedShapes.size()) {
            throw new AssertionError();
        }
        return shapeCount + (v.invalidShapeCount != 0 ? ", !" + v.invalidShapeCount : "") + ", " + BRANCH + v.branchCount + ", " + LEAF + v.leafCount;
    }

    private static boolean isRootShape(ShapeImpl shape) {
        return shape.getParent() == null;
    }

    private static File getOutputFile(String extension) {
        return Paths.get(ObjectStorageOptions.DumpShapesPath, "shapes." + extension).toFile();
    }

    static String getId(Shape shape) {
        return Integer.toHexString(shape.hashCode());
    }

    static {
        boolean bl = $assertionsDisabled = !Debug.class.desiredAssertionStatus();
        if (ObjectStorageOptions.DumpShapes) {
            allShapes = new ConcurrentLinkedQueue<ShapeImpl>();
        }
        if (ObjectStorageOptions.DumpShapes) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ObjectStorageOptions.DumpShapesDOT) {
                            Debug.dumpDOT();
                        }
                        if (ObjectStorageOptions.DumpShapesIGV) {
                            Debug.dumpIGV();
                        }
                    }
                    catch (FileNotFoundException | UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }));
        }
    }

    static class GraphvizShapeVisitor
    implements DebugShapeVisitor<GraphvizShapeVisitor> {
        private final Set<Shape> drawn;
        private final StringBuilder sb = new StringBuilder();

        GraphvizShapeVisitor() {
            this.drawn = new HashSet<Shape>();
        }

        @Override
        public GraphvizShapeVisitor visitShape(ShapeImpl shape, Map<? extends Transition, ? extends ShapeImpl> transitions) {
            if (!this.drawn.add(shape)) {
                return this;
            }
            String prefix = "s";
            this.sb.append(prefix).append(Debug.getId(shape));
            this.sb.append(" [label=\"");
            if (shape.getLastProperty() != null) {
                this.sb.append(GraphvizShapeVisitor.escapeString(shape.getLastProperty().toString()));
            } else {
                this.sb.append("ROOT");
            }
            this.sb.append("\"");
            this.sb.append(", shape=\"rectangle\"");
            if (!shape.isValid()) {
                this.sb.append(", color=\"red\", style=dotted");
            }
            this.sb.append("];");
            for (Map.Entry<? extends Transition, ? extends ShapeImpl> entry : transitions.entrySet()) {
                ShapeImpl dst = entry.getValue();
                this.visitShape(dst);
                assert (this.drawn.contains(dst));
                this.sb.append(prefix).append(Debug.getId(shape)).append("->").append(prefix).append(Debug.getId(dst));
                this.sb.append(" [label=\"").append(GraphvizShapeVisitor.escapeString(entry.getKey().toString())).append("\"]");
                this.sb.append(";");
            }
            return this;
        }

        private static String escapeString(String str) {
            return str.replaceAll("\\\\", "\\\\").replaceAll("\"", "\\\\\"");
        }

        public String toString() {
            return "digraph{" + this.sb + "}";
        }
    }

    static class IGVShapeVisitor
    implements DebugShapeVisitor<IGVShapeVisitor> {
        private final GraphPrintVisitor graphPrinter;

        IGVShapeVisitor(GraphPrintVisitor printer) {
            this.graphPrinter = printer;
        }

        @Override
        public IGVShapeVisitor visitShape(ShapeImpl shape, final Map<? extends Transition, ? extends ShapeImpl> transitions) {
            this.graphPrinter.visit(shape, new GraphPrintVisitor.GraphPrintHandler(){

                @Override
                public void visit(Object node, GraphPrintVisitor.GraphPrintAdapter printer) {
                    if (!printer.visited(node)) {
                        String name;
                        ShapeImpl s = (ShapeImpl)node;
                        printer.createElementForNode(s);
                        if (Debug.isRootShape(s)) {
                            name = "ROOT(" + s.getDynamicType() + ")";
                        } else {
                            name = s.getTransitionFromParent().toString();
                            if (!s.isValid()) {
                                name = Debug.INVALID + name;
                            }
                        }
                        printer.setNodeProperty(s, "name", name);
                        printer.setNodeProperty(s, "valid", s.isValid());
                        printer.setNodeProperty(s, "leaf", s.isLeaf());
                        printer.setNodeProperty(s, "identityHashCode", Integer.toHexString(System.identityHashCode(s)));
                        printer.setNodeProperty(s, "dynamicType", s.getDynamicType());
                        printer.setNodeProperty(s, "flags", s.getFlags());
                        printer.setNodeProperty(s, "shared", s.isShared());
                        for (Map.Entry entry : transitions.entrySet()) {
                            ShapeImpl dst = (ShapeImpl)entry.getValue();
                            this.visitShape(dst);
                            assert (printer.visited(dst));
                            printer.connectNodes(s, dst, ((Transition)entry.getKey()).toString());
                        }
                    }
                }
            });
            return this;
        }
    }

    static interface DebugShapeVisitor<R> {
        default public R visitShape(ShapeImpl shape) {
            return this.visitShape(shape, Collections.unmodifiableMap(shape.getTransitionMapForRead()));
        }

        public R visitShape(ShapeImpl var1, Map<? extends Transition, ? extends ShapeImpl> var2);
    }
}

