/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import com.paterva.maltego.util.ui.components.MaltegoSpecComboRenderer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ComboDecorator {
    public static void decorate(JComboBox combo, boolean editable) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (int i = 0; i < combo.getItemCount(); ++i) {
            items.add(combo.getItemAt(i));
        }
        ComboDecorator.decorate(combo, editable, items);
    }

    public static void decorate(final JComboBox combo, boolean editable, final List<Object> items) {
        combo.setEditable(editable);
        combo.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
        final JTextField textField = (JTextField)combo.getEditor().getEditorComponent();
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SwingUtilities.invokeLater(() -> ComboDecorator.comboFilter(textField.getText(), combo, items));
            }
        });
    }

    private static void comboFilter(String enteredText, JComboBox combo, List<Object> items) {
        ArrayList<Object> entriesFiltered = new ArrayList<Object>();
        for (Object item : items) {
            String comboDisplayValue = MaltegoSpecComboRenderer.getComboDisplayValue(item);
            if (comboDisplayValue == null || !comboDisplayValue.toLowerCase().contains(enteredText.toLowerCase())) continue;
            entriesFiltered.add(item);
        }
        if (entriesFiltered.size() > 0) {
            combo.setModel(new DefaultComboBoxModel<Object>(entriesFiltered.toArray()));
            combo.setSelectedItem(enteredText);
            combo.showPopup();
        } else {
            combo.hidePopup();
        }
    }
}

