/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.fonts;

import com.paterva.maltego.util.ui.fonts.FontSizeDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.Preferences;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class FontSizeRegistry {
    private static final String PROP_FONT_SIZE = "fontSize";
    private static FontSizeRegistry _default;
    private final PropertyChangeSupport _pcs = new PropertyChangeSupport(this);

    private FontSizeRegistry() {
    }

    public static synchronized FontSizeRegistry getDefault() {
        if (_default == null && (_default = (FontSizeRegistry)Lookup.getDefault().lookup(FontSizeRegistry.class)) == null) {
            _default = new FontSizeRegistry();
        }
        return _default;
    }

    public List<FontSizeDescriptor> getAll() {
        ArrayList<FontSizeDescriptor> all = new ArrayList<FontSizeDescriptor>(Lookup.getDefault().lookupAll(FontSizeDescriptor.class));
        Collections.sort(all, new FontSizeComparer());
        return all;
    }

    public int getFontSize(String fontSizeDescriptorName) {
        List<FontSizeDescriptor> allClasses = this.getAll();
        for (FontSizeDescriptor clazz : allClasses) {
            if (!clazz.getName().equals(fontSizeDescriptorName)) continue;
            Preferences pref = NbPreferences.forModule(clazz.getClass());
            int lafFontSizes = pref.getInt(fontSizeDescriptorName, clazz.getDefaultFontSize());
            return lafFontSizes;
        }
        throw new IllegalArgumentException("Font size descriptor for '" + fontSizeDescriptorName + "' is not found");
    }

    public void setFontSize(String fontSizeDescriptorName, int fontSize) {
        List<FontSizeDescriptor> allClasses = this.getAll();
        for (FontSizeDescriptor clazz : allClasses) {
            if (!clazz.getName().equals(fontSizeDescriptorName)) continue;
            Preferences pref = NbPreferences.forModule(clazz.getClass());
            int oldFontSize = this.getFontSize(fontSizeDescriptorName);
            if (oldFontSize != fontSize) {
                pref.putInt(fontSizeDescriptorName, fontSize);
                this._pcs.firePropertyChange(PROP_FONT_SIZE, oldFontSize, fontSize);
            }
            return;
        }
        throw new IllegalArgumentException("Font size descriptor for '" + fontSizeDescriptorName + "' is not found");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.removePropertyChangeListener(listener);
    }

    private static class FontSizeComparer
    implements Comparator<FontSizeDescriptor> {
        private FontSizeComparer() {
        }

        @Override
        public int compare(FontSizeDescriptor o1, FontSizeDescriptor o2) {
            return o1.getPosition() - o2.getPosition();
        }
    }
}

