/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre;

import com.paterva.maltego.java.config.app.AppUtils;
import com.paterva.maltego.java.config.jre.JavaInfo;
import com.paterva.maltego.java.config.jre.JavaUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DetectJavas {
    protected String[] SEARCH_ENV = new String[]{"JAVA", "JAVA_HOME", "JAVAHOME", "JAVA_PATH", "JAVAPATH", "JDK", "JDK_HOME", "JDKHOME", "ANT_JAVA"};

    public Map<String, JavaInfo> detectJavas() {
        HashMap<String, JavaInfo> javas = new HashMap<String, JavaInfo>();
        Set<String> pathsToTry = this.getPathsToTry();
        for (String path : pathsToTry) {
            this.tryPath(path, javas);
        }
        if (javas.isEmpty()) {
            this.detectJavasInJreSubfolders(javas, pathsToTry);
        }
        return javas;
    }

    private void tryPath(String path, Map<String, JavaInfo> javas) {
        System.out.println("trying path: " + path);
        File javaHome = new File(path);
        JavaInfo info = JavaUtils.getInfo(javaHome);
        if (info != null && JavaUtils.isValidVersion(info.getVersion())) {
            System.out.println(" runtime: " + info);
            javas.put(path, info);
        }
    }

    private void detectJavasInJreSubfolders(Map<String, JavaInfo> javas, Set<String> pathsToTry) {
        for (String path : pathsToTry) {
            File jrePath = new File(path, "jre");
            if (!jrePath.exists()) {
                System.out.println("does not exist: " + jrePath);
                continue;
            }
            try {
                String canonicalPath = jrePath.getCanonicalPath();
                if (canonicalPath.endsWith(File.separator)) {
                    canonicalPath = canonicalPath.substring(0, canonicalPath.length() - 1);
                }
                if (pathsToTry.contains(canonicalPath) || pathsToTry.contains(canonicalPath + File.separator)) continue;
                this.tryPath(canonicalPath, javas);
            }
            catch (Exception exception) {}
        }
    }

    protected Set<String> getPathsToTry() {
        Set<String> paths = this.getExistingPathsFromEnv();
        String currentPath = this.getCurrentJavaPath();
        if (currentPath != null && currentPath.length() > 0) {
            System.out.println("current java: " + currentPath);
            paths.add(currentPath);
        }
        return paths;
    }

    protected Set<String> getExistingPathsFromEnv() {
        HashSet<String> paths = new HashSet<String>();
        for (String env : this.SEARCH_ENV) {
            String envP = System.getenv(env);
            if (envP == null || envP.length() <= 0) continue;
            try {
                File envF = new File(envP);
                if (!envF.isDirectory()) continue;
                String envPath = envF.getAbsolutePath();
                System.out.println(env + ": " + envPath);
                paths.add(envPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return paths;
    }

    protected String getCurrentJavaPath() {
        return System.getProperty("java.home");
    }

    protected void removeSymLinkDuplicates(Set<String> paths) {
        HashSet<String> toRemove = new HashSet<String>();
        block2: for (String path1 : paths) {
            if (toRemove.contains(path1)) continue;
            File binFile1 = new File(new File(path1, "bin"), "java");
            for (String path2 : paths) {
                if (toRemove.contains(path2) || path1.equals(path2)) continue;
                try {
                    int digits2;
                    boolean isSymbolic2;
                    String absolutePath2;
                    File binFile2 = new File(new File(path2, "bin"), "java");
                    String absolutePath1 = binFile1.getCanonicalPath();
                    if (!absolutePath1.equals(absolutePath2 = binFile2.getCanonicalPath())) continue;
                    System.out.println(path1 + " VS " + path2 + " (" + absolutePath1 + ")");
                    boolean isSymbolic1 = !absolutePath1.startsWith(path1 + "/");
                    boolean bl = isSymbolic2 = !absolutePath2.startsWith(path2 + "/");
                    if (isSymbolic1 && !isSymbolic2) {
                        System.out.println(path1 + " sym " + path2);
                        toRemove.add(path2);
                        continue;
                    }
                    if (!isSymbolic1 && isSymbolic2) {
                        System.out.println(path2 + " sym " + path1);
                        toRemove.add(path1);
                        continue block2;
                    }
                    if (!isSymbolic1 || !isSymbolic2) continue;
                    int digits1 = AppUtils.countDigits(path1);
                    if (digits1 > (digits2 = AppUtils.countDigits(path2))) {
                        System.out.println(path2 + " dig " + path1);
                        toRemove.add(path1);
                        continue block2;
                    }
                    if (digits1 < digits2) {
                        System.out.println(path1 + " dig " + path2);
                        toRemove.add(path2);
                        continue;
                    }
                    if (path1.length() < path2.length()) {
                        System.out.println(path1 + " len " + path2);
                        toRemove.add(path2);
                        continue;
                    }
                    if (path1.length() > path2.length()) {
                        System.out.println(path2 + " len " + path1);
                        toRemove.add(path1);
                        continue block2;
                    }
                    System.out.println(path2 + " rand " + path1);
                    toRemove.add(path1);
                    continue block2;
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        for (String path : toRemove) {
            paths.remove(path);
        }
    }

    protected void removeNonJavaHomes(Set<String> paths) {
        Iterator<String> itr = paths.iterator();
        while (itr.hasNext()) {
            String path = itr.next();
            if (JavaUtils.isJavaHome(new File(path))) continue;
            System.out.println("not jre/jdk: " + path);
            itr.remove();
        }
    }
}

