/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BlockingBodyDataSource;
import org.xlightweb.BodyType;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpHeader;
import org.xlightweb.IHttpMessage;
import org.xlightweb.NonBlockingBodyDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractHttpMessage
implements IHttpMessage {
    private final AtomicReference<NonBlockingBodyDataSource> bodyDataSource = new AtomicReference();

    AbstractHttpMessage() {
    }

    @Override
    public abstract IHttpHeader getMessageHeader();

    @Override
    public final void setAttribute(String name, Object o) {
        this.getMessageHeader().setAttribute(name, o);
    }

    @Override
    public final Object getAttribute(String name) {
        return this.getMessageHeader().getAttribute(name);
    }

    @Override
    public final Enumeration getAttributeNames() {
        return this.getMessageHeader().getAttributeNames();
    }

    @Override
    public final Set<String> getAttributeNameSet() {
        return this.getMessageHeader().getAttributeNameSet();
    }

    final void setBodyDataSource(NonBlockingBodyDataSource body) throws IOException {
        if (body == null) {
            return;
        }
        this.setBodyDataSourceSilence(body);
        if (AbstractHttpConnection.isChunkedTransferEncoding(this.getMessageHeader())) {
            return;
        }
        if (this.getMessageHeader().getContentLength() >= 0) {
            return;
        }
        if (body.isComplete()) {
            this.getMessageHeader().setContentLength(body.available());
        } else {
            this.getMessageHeader().setTransferEncoding("Chunked");
        }
    }

    final void setBodyDataSourceSilence(NonBlockingBodyDataSource body) throws IOException {
        this.bodyDataSource.set(body);
    }

    final int setBodyDataSource(String body, String encoding) throws IOException, UnsupportedEncodingException {
        byte[] bytes = body.getBytes(encoding);
        this.setBodyDataSource(bytes, encoding);
        return bytes.length;
    }

    final void setBodyDataSource(String body) throws IOException {
        if (body != null) {
            try {
                byte[] bytes = body.getBytes(this.getMessageHeader().getCharacterEncoding());
                this.setBodyDataSource(bytes, this.getMessageHeader().getCharacterEncoding());
            }
            catch (UnsupportedEncodingException use) {
                throw new RuntimeException(use.toString());
            }
        }
    }

    final void setBody(File file) throws IOException {
        this.setContentType(AbstractHttpMessage.getContentTypeByFileExtension(file));
        this.setContentLength((int)file.length());
        this.removeHeader("Transfer-Encoding");
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel fc = raf.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(this.getContentLength());
        fc.read(buffer);
        fc.close();
        raf.close();
        buffer.flip();
        this.getNonBlockingBody().append(true, buffer);
        this.getNonBlockingBody().setComplete(true);
    }

    final int setBodyDataSource(byte[] body) throws IOException, UnsupportedEncodingException {
        this.setBodyDataSource(body, null);
        return body.length;
    }

    final void setBodyDataSource(byte[] body, String encoding) throws IOException, UnsupportedEncodingException {
        this.setBodyDataSource(new ByteBuffer[]{ByteBuffer.wrap(body)}, encoding);
    }

    final void setBodyDataSource(ByteBuffer[] body, String encoding) throws IOException, UnsupportedEncodingException {
        this.setBodyDataSource(new NonBlockingBodyDataSource(BodyType.IN_MEMORY, body, encoding));
    }

    @Override
    public final NonBlockingBodyDataSource getNonBlockingBody() throws IOException {
        return this.bodyDataSource.get();
    }

    @Override
    public final BlockingBodyDataSource getBlockingBody() throws IOException {
        if (this.bodyDataSource.get() == null) {
            return null;
        }
        return new BlockingBodyDataSource(this.bodyDataSource.get());
    }

    @Override
    public final boolean hasBody() {
        return this.bodyDataSource.get() != null;
    }

    @Override
    public void addHeaderLine(String line) {
        this.getMessageHeader().addHeaderLine(line);
    }

    @Override
    public void addHeaderlines(String ... lines) {
        this.getMessageHeader().addHeaderlines(lines);
    }

    @Override
    public final void addHeader(String headername, String headervalue) {
        this.getMessageHeader().addHeader(headername, headervalue);
    }

    @Override
    public final void setHeader(String headername, String headervalue) {
        this.getMessageHeader().setHeader(headername, headervalue);
    }

    @Override
    public final void removeHeader(String headername) {
        this.getMessageHeader().removeHeader(headername);
    }

    @Override
    public final boolean containsHeader(String headername) {
        return this.getMessageHeader().containsHeader(headername);
    }

    @Override
    public final Enumeration getHeaderNames() {
        return this.getMessageHeader().getHeaderNames();
    }

    @Override
    public final Set<String> getHeaderNameSet() {
        return this.getMessageHeader().getHeaderNameSet();
    }

    @Override
    public final String getHeader(String headername) {
        return this.getMessageHeader().getHeader(headername);
    }

    @Override
    public final List<String> getHeaderList(String headername) {
        return this.getMessageHeader().getHeaderList(headername);
    }

    @Override
    public final Enumeration getHeaders(String headername) {
        return this.getMessageHeader().getHeaders(headername);
    }

    @Override
    public void setContentType(String type) {
        this.getMessageHeader().setContentType(type);
    }

    @Override
    public String getContentType() {
        return this.getMessageHeader().getContentType();
    }

    @Override
    public String getCharacterEncoding() {
        return this.getMessageHeader().getCharacterEncoding();
    }

    @Override
    public void setContentLength(int length) {
        this.getMessageHeader().setContentLength(length);
    }

    @Override
    public int getContentLength() {
        return this.getMessageHeader().getContentLength();
    }

    @Override
    public String getDisposition() {
        return this.getMessageHeader().getDisposition();
    }

    @Override
    public String getDispositionType() {
        return this.getMessageHeader().getDispositionType();
    }

    @Override
    public String getDispositionParam(String name) {
        return this.getMessageHeader().getDispositionParam(name);
    }

    @Override
    public void setTransferEncoding(String transferEncoding) {
        this.getMessageHeader().setTransferEncoding(transferEncoding);
        this.removeHeader("Content-length");
    }

    @Override
    public String getTransferEncoding() {
        return this.getMessageHeader().getTransferEncoding();
    }

    BodyType getBodyType() throws IOException {
        if (this.getNonBlockingBody() != null) {
            return this.getNonBlockingBody().getBodyType();
        }
        return BodyType.NO_BODY;
    }

    static final String getContentTypeByFileExtension(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            String extension = name.substring(pos + 1, name.length());
            String mimeType = HttpUtils.getMimeTypeMapping().get(extension);
            if (mimeType != null) {
                return mimeType;
            }
        }
        return "application/octet-stream";
    }

    public String toString() {
        if (this.bodyDataSource.get() == null) {
            return this.getMessageHeader().toString() + "\r\n";
        }
        return this.getMessageHeader().toString() + "\r\n" + this.bodyDataSource.toString();
    }
}

