/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.individualsheets;

import ancestris.reports.FilterOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatIDOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.utils.PropUtils;
import ancestris.util.swing.DialogManager;
import genj.fo.Document;
import genj.gedcom.AbstractNote;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.time.PointInTime;
import genj.io.input.FileInput;
import genj.option.Multiline;
import genj.renderer.MediaRenderer;
import genj.report.Report;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReportIndividualSheets
extends Report {
    public MyFormattingOptions formattingOptions = new MyFormattingOptions();
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    @Multiline
    public int[] sectionSelector = IntStream.range(1, SECTIONS.length).toArray();
    public String[] sectionSelectors = SECTIONS;
    public boolean eventDepth = true;
    public MyFilterOptions filterOptions = new MyFilterOptions();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    private static final String[] SECTIONS = new String[]{NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.confidentiality"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.names"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.chronology"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.parents"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.siblings"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.families"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.relations"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.aliases"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.identifiers"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.notes"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.sources"), NbBundle.getMessage(ReportIndividualSheets.class, (String)"section.changes")};
    private static final int WARNING_LIMIT = 300;
    private static final File[] SEX_ICONS = new File[]{MediaRenderer.getFileFromResource(ReportIndividualSheets.class, (String)"u.gif"), MediaRenderer.getFileFromResource(ReportIndividualSheets.class, (String)"m.gif"), MediaRenderer.getFileFromResource(ReportIndividualSheets.class, (String)"f.gif"), MediaRenderer.getFileFromResource(ReportIndividualSheets.class, (String)"u.gif")};
    private static final File UNFOUND_MEDIA = MediaRenderer.getFileFromResource(ReportIndividualSheets.class, (String)"medno.png");
    private static final String[] SEX_COLORS = new String[]{"#000000", "#0000ff", "#ff78d0", "#000000"};
    private static final String SECTION_COLOR = "#1aa02d";
    private static final String IMAGE_ATTR = "px,content-height=scale-to-fit";
    private static final String INDENT_SMALL_ATTR = "margin-left=20pt";
    private static final String INDENT1_ATTR = "margin-left=100pt";
    private static final String INDENT2_ATTR = "margin-left=120pt";
    private static final String SPACE_AFTER_ATTR = "space-after=0.2cm";
    private static final Map<String, File> tag2file = new HashMap<String, File>();
    private Gedcom gedcom = null;
    private static final String UNKNOWN = "?";

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        this.gedcom = gedcom;
        List<Indi> indis = this.scope.getScope(gedcom, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Entity entity) {
        this.gedcom = entity.getGedcom();
        List<Indi> indis = this.scope.getScope(entity, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Indi[] indis) {
        if (indis.length == 0) {
            return null;
        }
        this.gedcom = indis[0].getGedcom();
        List<Indi> indisList = Arrays.asList(indis);
        return this.main(indisList);
    }

    private Document main(List<Indi> indis) {
        Collections.sort(indis, new PropertyComparator("INDI:NAME"));
        ArrayList<Indi> filteredIndis = new ArrayList<Indi>();
        for (Indi indi : indis) {
            if (!this.filterOptions.common.matchRecord((Property)indi, indi.getName(), PropUtils.getStringFromIndi(indi))) continue;
            filteredIndis.add(indi);
        }
        Collections.sort(filteredIndis, new PropertyComparator("INDI:NAME"));
        if (filteredIndis.size() > 300 && DialogManager.OK_OPTION != DialogManager.create((String)this.translate("TITL_SizeWarning"), (String)this.translate("MSG_SizeWarning", new Object[]{filteredIndis.size()})).setMessageType(2).setOptionType(2).setDialogId("report.SummaryOfRecords").show()) {
            return null;
        }
        Document doc = this.formattingOptions.common.createDocument(this.translate("name"));
        String number = String.valueOf(filteredIndis.size());
        String title = this.translate("title", new Object[]{this.gedcom.getDisplayName()});
        doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.common.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.common.includeTOC) {
            doc.addTOC(2, false, false);
            doc.nextParagraph("space-before=1cm");
        }
        doc.addText(this.scope.getMainMessage(), "font-weight=bold");
        doc.nextParagraph();
        doc.addText("\u2219  " + this.translate("subtitle", new Object[]{number}));
        if (this.scope.isLimited()) {
            doc.nextParagraph("space-before=1cm");
            for (String[] scopeLine : this.scope.getMessages()) {
                doc.nextParagraph();
                doc.addText("\u2219  " + scopeLine[0]);
                if (scopeLine[1].isBlank()) continue;
                doc.addText(" : " + scopeLine[1], "font-weight=bold");
            }
        }
        if (this.filterOptions.common.isFilterOn()) {
            doc.nextParagraph("space-before=1cm");
            doc.addText(this.filterOptions.common.getMainMessage(), "font-weight=bold");
            for (String[] filterLine : this.filterOptions.common.getMessages()) {
                doc.nextParagraph();
                doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                doc.addText(" : " + filterLine[1], "font-weight=bold");
            }
            doc.nextParagraph("space-before=1cm");
        }
        Pattern tagFilter = null;
        try {
            if (this.filterOptions.filterProperties.length() > 0) {
                tagFilter = Pattern.compile(this.filterOptions.filterProperties);
            }
        }
        catch (IllegalArgumentException e) {
            this.println(this.translate("noregex", new Object[]{e.getMessage()}));
        }
        if (this.formattingOptions.generatePageBreak) {
            doc.nextPage();
        }
        String letter = "";
        for (Indi indi : filteredIndis) {
            String newLetter;
            String lastname = indi.getLastName();
            if (lastname.isEmpty()) {
                lastname = UNKNOWN;
            }
            if (!(newLetter = lastname.substring(0, 1).toUpperCase()).equals(letter)) {
                letter = newLetter;
                if (this.formattingOptions.common.includeTOC) {
                    doc.addTOCEntry(letter);
                }
            }
            this.exportIndi(indi, doc, tagFilter);
            doc.nextParagraph();
            doc.addText("\u00a0");
            doc.nextParagraph();
            doc.addLink("^^^", "title");
            if (!this.formattingOptions.generatePageBreak) continue;
            doc.nextPage();
        }
        if (this.formattingOptions.generatePersonIndex) {
            doc.nextPage();
        }
        this.println(" ");
        this.println(this.translate("exportedListOf", new Object[]{filteredIndis.size()}));
        return doc;
    }

    /*
     * WARNING - void declaration
     */
    private void exportIndi(Indi indi, Document doc, Pattern tagFilter) {
        this.println(this.translate("exporting", new Object[]{indi.toString()}));
        String indiId = indi.getId();
        Object fullname = indi.toString(false);
        if (this.dataFormatOptions.id.displayId != 0) {
            fullname = (String)fullname + " (" + this.dataFormatOptions.id.getId(indi) + ")";
        }
        int heightText = this.formattingOptions.common.getTitleSize() - 2;
        int heightIcon = this.formattingOptions.common.getTitleSize() - 4;
        doc.startSection(SEX_ICONS[indi.getSex()], "height=" + heightIcon + IMAGE_ATTR, (String)fullname, indi.getLinkAnchor(), 2, false, false, "font-size=" + heightText + ",text-align=left, space-before=0cm, space-after=0.5cm, color=" + SEX_COLORS[indi.getSex()]);
        doc.setIndexesTitleAttributes("font-size=" + heightText);
        String section = this.translate("section.confidentiality");
        if (this.isSectionSelected(section)) {
            this.startSection(doc, section, indiId);
            this.addInfo(doc, indi.getProperty("RESN"), this.translate("public"));
        }
        if (this.isSectionSelected(section = this.translate("section.names"))) {
            this.startSection(doc, section, indiId);
        }
        for (Property p : indi.getProperties("NAME")) {
            if (this.isSectionSelected(section)) {
                doc.nextParagraph();
                this.addInfo(doc, p, "");
            }
            if (!this.formattingOptions.generatePersonIndex || !(p instanceof PropertyName)) continue;
            PropertyName propertyName = (PropertyName)p;
            doc.addIndexTerm("a. " + this.translate("index.names"), propertyName.getLastName(), propertyName.getFirstName());
        }
        section = this.translate("section.chronology");
        if (this.isSectionSelected(section)) {
            this.startSection(doc, section, indiId);
            doc.startTable("width=100%, border-style=none, border-color=black, border=0, space-before=1cm");
            int counter = 0;
            List objes = indi.getAllProperties("OBJE");
            for (Object obje : objes) {
                String title;
                String parentTag;
                if (obje instanceof PropertyMedia) {
                    PropertyMedia propertyMedia = (PropertyMedia)obje;
                    parentTag = propertyMedia.getParent().getTag();
                    Media mediaEntity = null;
                    if (!propertyMedia.getTargetEntity().isPresent()) continue;
                    mediaEntity = (Media)propertyMedia.getTargetEntity().get();
                    if (counter > 0 && counter % 6 == 0) {
                        doc.nextTableRow();
                    }
                    ++counter;
                    doc.nextTableCell("text-align=center");
                    doc.addText(mediaEntity.getTitle() + (String)(parentTag.equals("INDI") ? "" : " (" + Gedcom.getName((String)parentTag) + ")"));
                    doc.nextParagraph();
                    doc.addText("\u00a0");
                    doc.nextParagraph();
                    List files = mediaEntity.getAllProperties("FILE");
                    boolean isFileOk = false;
                    for (Property file : files) {
                        PropertyFile pFile;
                        Optional input;
                        if (!(file instanceof PropertyFile) || !(input = (pFile = (PropertyFile)file).getInput()).isPresent() || !(input.get() instanceof FileInput)) continue;
                        File f = ((FileInput)input.get()).getFile();
                        doc.addImage(f, "", true);
                        doc.nextParagraph();
                        doc.addText("\u00a0");
                        doc.nextParagraph();
                        isFileOk = true;
                    }
                    if (isFileOk) continue;
                    doc.addImage(UNFOUND_MEDIA, "");
                    continue;
                }
                parentTag = obje.getParent().getTag();
                Property pTitle = obje.getProperty("TITL");
                String string = title = pTitle != null ? pTitle.getValue() : "";
                if (counter > 0 && counter % 6 == 0) {
                    doc.nextTableRow();
                }
                ++counter;
                doc.nextTableCell("text-align=center");
                doc.addText(title + (String)(parentTag.equals("INDI") ? "" : " (" + Gedcom.getName((String)parentTag) + ")"));
                doc.nextParagraph();
                List files = obje.getAllProperties("FILE");
                boolean isFileOk = false;
                for (Property file : files) {
                    PropertyFile pFile;
                    Optional input;
                    if (!(file instanceof PropertyFile) || !(input = (pFile = (PropertyFile)file).getInput()).isPresent() || !(input.get() instanceof FileInput)) continue;
                    File f = ((FileInput)input.get()).getFile();
                    doc.addImage(f, "", true);
                    doc.nextParagraph();
                    doc.addText("\u00a0");
                    doc.nextParagraph();
                    isFileOk = true;
                }
                if (isFileOk) continue;
                doc.addImage(UNFOUND_MEDIA, "");
            }
            doc.endTable();
            ArrayList<Event> events = new ArrayList<Event>();
            for (Property p : indi.getProperties()) {
                if (!p.isEvent() || p.getTag().equals("NO") || tagFilter != null && tagFilter.matcher(p.getTag()).matches()) continue;
                events.add(new Event(p));
            }
            Collections.sort(events);
            if (!events.isEmpty()) {
                for (Event event : events) {
                    doc.nextParagraph();
                    this.addEvent(doc, event.p, "", 0, tagFilter);
                }
            } else {
                doc.addText(this.translate("noevent"), "");
            }
        }
        section = this.translate("section.parents");
        Family family = new Family(indi);
        if (this.isSectionSelected(section)) {
            this.startSection(doc, section, indiId);
            doc.startTable("width=100%, border-style=none, border-color=black, border=0");
            String fileAttr = "height=80px,content-height=scale-to-fit";
            String span2 = "number-columns-spanned=2";
            String span4 = "number-columns-spanned=4";
            String string = "border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none, border-bottom-width=0, border-bottom-style=none, border-right-width=1,  border-right-style=solid, border-style=solid";
            String borderRightBottom = "border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none,  border-right-width=1,  border-right-style=solid, border-bottom-width=1, border-bottom-style=solid, border-style=solid";
            doc.nextTableRow("text-align=center", "");
            doc.addText("\u00a0");
            doc.nextTableCell("");
            doc.addText("\u00a0");
            doc.nextTableCell("");
            doc.addText("\u00a0");
            doc.nextTableCell("");
            doc.addText("\u00a0");
            doc.nextTableCell("");
            doc.addText("\u00a0");
            doc.nextTableCell("");
            doc.addText("\u00a0");
            doc.nextTableCell("");
            doc.addText("\u00a0");
            doc.nextTableCell("");
            doc.addText("\u00a0");
            doc.nextTableRow("text-align=center", span2);
            if (!family.noGen2Photo) {
                doc.addImage(family.ffFile, fileAttr);
            }
            doc.nextParagraph();
            doc.addText(family.ffName);
            doc.nextParagraph();
            doc.addText(family.ffDate);
            doc.nextTableCell(span2);
            if (!family.noGen2Photo) {
                doc.addImage(family.fmFile, fileAttr);
            }
            doc.nextParagraph();
            doc.addText(family.fmName);
            doc.nextParagraph();
            doc.addText(family.fmDate);
            doc.nextTableCell(span2);
            if (!family.noGen2Photo) {
                doc.addImage(family.mfFile, fileAttr);
            }
            doc.nextParagraph();
            doc.addText(family.mfName);
            doc.nextParagraph();
            doc.addText(family.mfDate);
            doc.nextTableCell(span2);
            if (!family.noGen2Photo) {
                doc.addImage(family.mmFile, fileAttr);
            }
            doc.nextParagraph();
            doc.addText(family.mmName);
            doc.nextParagraph();
            doc.addText(family.mmDate);
            doc.nextTableRow("", string);
            doc.addText("\u00a0");
            doc.nextTableCell(span2 + "," + borderRightBottom);
            doc.addText("\u00a0");
            doc.nextTableCell(span2 + "," + string);
            doc.addText("\u00a0");
            doc.nextTableCell(span2 + "," + borderRightBottom);
            doc.addText("\u00a0");
            doc.nextTableCell("");
            doc.addText("\u00a0");
            doc.nextTableRow("", span2 + "," + string);
            doc.addText("\u00a0");
            doc.nextTableCell(span4 + "," + string);
            doc.addText("\u00a0");
            doc.nextTableCell(span2);
            doc.addText("\u00a0");
            doc.nextTableRow("text-align=center", span4);
            if (!family.noGen1Photo) {
                doc.addImage(family.fFile, fileAttr);
            }
            doc.nextParagraph();
            doc.addText(family.fName);
            doc.nextParagraph();
            doc.addText(family.fDate);
            doc.nextTableCell(span4);
            if (!family.noGen1Photo) {
                doc.addImage(family.mFile, fileAttr);
            }
            doc.nextParagraph();
            doc.addText(family.mName);
            doc.nextParagraph();
            doc.addText(family.mDate);
            doc.endTable();
        }
        if (this.isSectionSelected(section = this.translate("section.siblings"))) {
            void var13_50;
            Indi[] siblings;
            Indi[] indiArray;
            this.startSection(doc, section, indiId);
            if (family.famc != null) {
                indiArray = family.famc.getChildren(true);
            } else {
                Indi[] indiArray2 = new Indi[1];
                indiArray = indiArray2;
                indiArray2[0] = indi;
            }
            Indi[] span2 = siblings = indiArray;
            int span4 = span2.length;
            boolean bl = false;
            while (var13_50 < span4) {
                Indi sibling = span2[var13_50];
                doc.nextParagraph(INDENT1_ATTR);
                fullname = sibling.toString(false);
                if (this.dataFormatOptions.id.displayId != 0) {
                    fullname = (String)fullname + " (" + this.dataFormatOptions.id.getId(indi) + ")";
                }
                doc.addImage(SEX_ICONS[sibling.getSex()], "height=" + (this.formattingOptions.common.getTextSize() + 2) + IMAGE_ATTR);
                doc.addText((String)fullname, indi.equals(sibling) ? "font-weight=bold" : "");
                ++var13_50;
            }
        }
        if (this.isSectionSelected(section = this.translate("section.families"))) {
            void var13_52;
            int i = 1;
            Fam[] span2 = family.famss;
            int span4 = span2.length;
            boolean bl = false;
            while (var13_52 < span4) {
                Fam fams = span2[var13_52];
                Indi spouse = fams.getOtherSpouse(indi);
                this.startSection(doc, section + " (" + i + ")", indiId);
                ++i;
                doc.nextParagraph(INDENT1_ATTR);
                Object object = fullname = spouse != null ? spouse.toString(false) : UNKNOWN;
                if (this.dataFormatOptions.id.displayId != 0) {
                    fullname = (String)fullname + " (" + this.dataFormatOptions.id.getId(indi) + ")";
                }
                doc.addImage(SEX_ICONS[spouse != null ? spouse.getSex() : 0], "height=" + (this.formattingOptions.common.getTextSize() + 2) + IMAGE_ATTR);
                doc.addText((String)fullname);
                Object famEvents = new ArrayList();
                for (Property p : fams.getProperties()) {
                    if (!p.isEvent() || p.getTag().equals("NO") || tagFilter != null && tagFilter.matcher(p.getTag()).matches()) continue;
                    famEvents.add(new Event(p));
                }
                Collections.sort(famEvents);
                if (!famEvents.isEmpty()) {
                    Iterator files = famEvents.iterator();
                    while (files.hasNext()) {
                        Event event = (Event)files.next();
                        doc.nextParagraph(INDENT1_ATTR);
                        this.addEvent(doc, event.p, "", 100, tagFilter);
                    }
                } else {
                    doc.addText(this.translate("noevent"), "");
                }
                Indi[] children = fams.getChildren(true);
                if (children.length > 0) {
                    doc.nextParagraph(INDENT1_ATTR);
                    this.addImage(doc, "images/Child");
                    doc.addText("\u00a0");
                    doc.addText(Gedcom.getName((String)"CHIL.s"), "font-weight=bold");
                }
                for (Indi child : children) {
                    doc.nextParagraph(INDENT2_ATTR);
                    fullname = child.toString(false);
                    if (this.dataFormatOptions.id.displayId != 0) {
                        fullname = (String)fullname + " (" + this.dataFormatOptions.id.getId(indi) + ")";
                    }
                    doc.addImage(SEX_ICONS[child.getSex()], "height=" + (this.formattingOptions.common.getTextSize() + 2) + IMAGE_ATTR);
                    doc.addText("\u00a0");
                    doc.addText((String)fullname);
                }
                ++var13_52;
            }
        }
        if (this.isSectionSelected(section = this.translate("section.relations"))) {
            this.startSection(doc, section, indiId);
            boolean existAssos = false;
            ArrayList<PropertyAssociation> assos = new ArrayList<PropertyAssociation>();
            assos.addAll(indi.getProperties(PropertyAssociation.class));
            for (Fam fams : family.famss) {
                assos.addAll(fams.getProperties(PropertyAssociation.class));
            }
            if (!assos.isEmpty()) {
                existAssos = true;
                doc.nextParagraph();
                doc.addText(this.translate(indi.getGedcom().isGrammar7() ? "section.relations.from" : "section.relations.to"), "font-weight=bold");
                for (Property property : assos) {
                    PropertyAssociation assoProp = (PropertyAssociation)property;
                    String entityTag = assoProp.getWitness().getTag();
                    entityTag = switch (entityTag) {
                        case "INDI" -> "Indi";
                        case "FAM" -> "Fam";
                        default -> "Association";
                    };
                    doc.nextParagraph(SPACE_AFTER_ATTR);
                    this.addImage(doc, "images/" + entityTag);
                    doc.addText("\u00a0");
                    doc.addText(assoProp.getDisplayValue());
                }
            }
            assos.clear();
            for (Property property : indi.getProperties(PropertyXRef.class)) {
                PropertyXRef xrefProp = (PropertyXRef)property;
                Object target = xrefProp.getTarget();
                if (!(target instanceof PropertyAssociation)) continue;
                PropertyAssociation assoProp = (PropertyAssociation)target;
                assos.add(assoProp);
            }
            if (!assos.isEmpty()) {
                existAssos = true;
                doc.nextParagraph();
                doc.addText(this.translate(indi.getGedcom().isGrammar7() ? "section.relations.to" : "section.relations.from"), "font-weight=bold");
                for (PropertyAssociation propertyAssociation : assos) {
                    String entityTag = propertyAssociation.getBeneficiary().getTag();
                    entityTag = switch (entityTag) {
                        case "INDI" -> "Indi";
                        case "FAM" -> "Fam";
                        default -> "Association";
                    };
                    doc.nextParagraph(SPACE_AFTER_ATTR);
                    this.addImage(doc, "images/" + entityTag);
                    doc.addText("\u00a0");
                    doc.addText(propertyAssociation.getDisplayValue());
                }
            }
            if (!existAssos) {
                doc.nextParagraph();
                this.addImage(doc, "images/Association");
                doc.addText("\u00a0");
                doc.addText(this.translate("noassociations"));
            }
        }
        if (this.isSectionSelected(section = this.translate("section.aliases"))) {
            void var13_58;
            boolean first = true;
            Property[] assos = indi.getProperties("ALIA");
            int span4 = assos.length;
            boolean bl = false;
            while (var13_58 < span4) {
                Property p = assos[var13_58];
                if (first) {
                    this.startSection(doc, section, indiId);
                    first = false;
                }
                doc.nextParagraph();
                doc.addImage(this.getTagFile(p), "height=" + (this.formattingOptions.common.getTextSize() - 2) + IMAGE_ATTR);
                doc.addText("\u00a0");
                doc.addText(p.getDisplayValue());
                ++var13_58;
            }
        }
        if (this.isSectionSelected(section = this.translate("section.identifiers"))) {
            this.startSection(doc, section, indiId);
            doc.nextParagraph();
            doc.addText(this.translate("section.id.gedcom"), "font-weight=bold");
            doc.nextParagraph();
            this.addImage(doc, "images/Gedcom");
            doc.addText("\u00a0" + this.translate("section.id.id") + ": ", "font-weight=bold");
            doc.addLink(indi.getId(), indi.getLinkAnchor());
            ArrayList<Property> ids = new ArrayList<Property>();
            ids.addAll(Arrays.asList(indi.getProperties("UID")));
            ids.addAll(Arrays.asList(indi.getProperties("EXID")));
            ids.addAll(Arrays.asList(indi.getProperties("REFN")));
            if (!ids.isEmpty()) {
                for (Property p : ids) {
                    doc.nextParagraph();
                    this.addImage(doc, "images/Code");
                    doc.addText("\u00a0");
                    doc.addText(p.getPropertyName() + ": ", "font-weight=bold");
                    doc.addText(p.getDisplayValue());
                }
            }
            ArrayList<Property> sosas = new ArrayList<Property>();
            sosas.addAll(Arrays.asList(indi.getProperties("_SOSADABOVILLE")));
            sosas.addAll(Arrays.asList(indi.getProperties("_SOSA")));
            sosas.addAll(Arrays.asList(indi.getProperties("_DABOVILLE")));
            if (!sosas.isEmpty()) {
                doc.nextParagraph();
                doc.addText(this.translate("section.id.sosas"), "font-weight=bold");
                for (Property property : sosas) {
                    doc.nextParagraph();
                    this.addImage(doc, "images/Sosa");
                    doc.addText("\u00a0");
                    doc.addText(property.getPropertyName() + ": ", "font-weight=bold");
                    doc.addText(property.getDisplayValue());
                }
            }
            boolean first = true;
            for (Property p : indi.getProperties()) {
                String tag = p.getTag();
                if (!tag.startsWith("_") || tag.matches("(_SOSADABOVILLE|_SOSA|_DABOVILLE)")) continue;
                if (first) {
                    doc.nextParagraph();
                    doc.addText(this.translate("section.id.usertags"), "font-weight=bold");
                    first = false;
                }
                doc.nextParagraph();
                this.addImage(doc, "images/Tag");
                doc.addText("\u00a0");
                doc.addText(p.getPropertyName() + ": ", "font-weight=bold");
                doc.addText(p.getDisplayValue());
            }
        }
        if (this.isSectionSelected(section = this.translate("section.notes"))) {
            void var13_62;
            ArrayList notes = new ArrayList();
            notes.addAll(indi.getAllProperties("NOTE"));
            notes.addAll(indi.getAllProperties("SNOTE"));
            Fam[] sosas = family.famss;
            int first = sosas.length;
            boolean bl = false;
            while (var13_62 < first) {
                Fam fams = sosas[var13_62];
                notes.addAll(fams.getAllProperties("NOTE"));
                notes.addAll(fams.getAllProperties("SNOTE"));
                ++var13_62;
            }
            if (!notes.isEmpty()) {
                this.startSection(doc, section, indiId);
                for (Property note : notes) {
                    doc.nextParagraph();
                    doc.addImage(this.getTagFile(note), "height=" + (this.formattingOptions.common.getTextSize() - 2) + IMAGE_ATTR);
                    doc.addText("\u00a0");
                    if (note instanceof PropertyXRef) {
                        PropertyXRef propertyXRef = (PropertyXRef)note;
                        Entity entity = (Entity)propertyXRef.getTargetEntity().get();
                        String parentTag = note.getParent().getTag();
                        doc.addText(entity.getId(), "font-weight=bold");
                        doc.addAnchor(entity.getId());
                        doc.addText((String)(parentTag.equals("INDI") ? "" : " (" + Gedcom.getName((String)parentTag) + ")"), "font-weight=bold");
                        if (!(entity instanceof AbstractNote)) continue;
                        AbstractNote noteEntity = (AbstractNote)entity;
                        doc.nextParagraph("margin-left=20pt,space-after=0.2cm");
                        doc.addText(noteEntity.getValue(), "font-style=italic");
                        doc.addText("\u00a0");
                        continue;
                    }
                    doc.addText(this.translate("dedicated_note") + " (" + Gedcom.getName((String)note.getParent().getTag()) + ")", "font-weight=bold");
                    doc.nextParagraph("margin-left=20pt,space-after=0.2cm");
                    doc.addText(note.getDisplayValue(), "font-style=italic");
                    doc.addAnchor(String.valueOf(note.hashCode()));
                }
            }
        }
        if (this.isSectionSelected(section = this.translate("section.sources"))) {
            void var13_65;
            ArrayList sources = new ArrayList();
            sources.addAll(indi.getAllProperties("SOUR"));
            Fam[] sosas = family.famss;
            int note = sosas.length;
            boolean bl = false;
            while (var13_65 < note) {
                Fam fams = sosas[var13_65];
                sources.addAll(fams.getAllProperties("SOUR"));
                ++var13_65;
            }
            if (!sources.isEmpty()) {
                this.startSection(doc, section, indiId);
                for (Property source : sources) {
                    doc.nextParagraph();
                    doc.addImage(this.getTagFile(source), "height=" + (this.formattingOptions.common.getTextSize() - 2) + IMAGE_ATTR);
                    doc.addText("\u00a0");
                    if (source instanceof PropertyXRef) {
                        PropertyXRef propertyXRef = (PropertyXRef)source;
                        Entity entity = (Entity)propertyXRef.getTargetEntity().get();
                        String parentTag = source.getParent().getTag();
                        doc.addText(entity.getId(), "font-weight=bold");
                        doc.addAnchor(entity.getId());
                        doc.addText((String)(parentTag.equals("INDI") ? "" : " (" + Gedcom.getName((String)parentTag) + ")"), "font-weight=bold");
                        if (!(entity instanceof Source)) continue;
                        Source sourceEntity = (Source)entity;
                        doc.nextParagraph(INDENT_SMALL_ATTR);
                        doc.addText(sourceEntity.getTitle(), "font-style=italic, font-weight=bold");
                        doc.addText("\u00a0");
                        doc.nextParagraph("margin-left=20pt,space-after=0.2cm");
                        doc.addText(sourceEntity.getText(), "font-style=italic");
                        doc.addText("\u00a0");
                        continue;
                    }
                    doc.addText(this.translate("dedicated_source") + " (" + Gedcom.getName((String)source.getParent().getTag()) + ")", "font-weight=bold");
                    doc.nextParagraph("margin-left=20pt,space-after=0.2cm");
                    doc.addText(source.getDisplayValue(), "font-style=italic");
                    doc.addAnchor(String.valueOf(source.hashCode()));
                }
            }
        }
        if (this.isSectionSelected(section = this.translate("section.changes"))) {
            Property chan;
            this.startSection(doc, section, indiId);
            Property crea = indi.getProperty("CREA");
            if (crea != null) {
                doc.nextParagraph();
                doc.addImage(this.getTagFile(crea), "height=" + (this.formattingOptions.common.getTextSize() - 2) + IMAGE_ATTR);
                doc.addText("\u00a0");
                doc.addText(crea.getPropertyName() + ": ", "font-weight=bold");
                doc.addText(crea.getDisplayValue());
            }
            if ((chan = indi.getProperty("CHAN")) != null) {
                doc.nextParagraph();
                doc.addImage(this.getTagFile(chan), "height=" + (this.formattingOptions.common.getTextSize() - 2) + IMAGE_ATTR);
                doc.addText("\u00a0");
                doc.addText(chan.getPropertyName() + ": ", "font-weight=bold");
                doc.addText(chan.getDisplayValue());
            }
        }
    }

    private boolean isSectionSelected(String section) {
        for (int i = 0; i < this.sectionSelector.length; ++i) {
            if (!SECTIONS[this.sectionSelector[i]].equals(section)) continue;
            return true;
        }
        return false;
    }

    private void startSection(Document doc, String name, String id) {
        doc.startSection(name, id + "+" + name, 3, false, false, "font-weight=bold, font-size=" + (this.formattingOptions.common.getTextSize() + 2) + ",text-align=left, space-before=0.6cm, space-after=0.1cm, color=#1aa02d");
    }

    private String getIndiName(Indi indi) {
        Object fullname = indi.getName();
        if (this.dataFormatOptions.id.displayId != 0) {
            fullname = (String)fullname + " (" + this.dataFormatOptions.id.getId(indi) + ")";
        }
        return fullname;
    }

    private String getIndiDates(Indi indi) {
        return this.dataFormatOptions.date.getDate((Property)indi.getBirthDate()) + " - " + this.dataFormatOptions.date.getDate((Property)indi.getDeathDate());
    }

    private File getIndiFile(Indi indi) {
        PropertyFile pFile;
        Optional input;
        Property file;
        Property obje = indi.getProperty("OBJE");
        if (obje != null && obje instanceof PropertyMedia) {
            PropertyFile pFile2;
            Optional input2;
            Property file2;
            PropertyMedia pMedia = (PropertyMedia)obje;
            Media mediaEntity = null;
            if (pMedia.getTargetEntity().isPresent() && (file2 = (mediaEntity = (Media)pMedia.getTargetEntity().get()).getProperty("FILE")) != null && file2 instanceof PropertyFile && (input2 = (pFile2 = (PropertyFile)file2).getInput()).isPresent() && input2.get() instanceof FileInput) {
                File f = ((FileInput)input2.get()).getFile();
                return f;
            }
        } else if (obje != null && (file = obje.getProperty("FILE")) != null && file instanceof PropertyFile && (input = (pFile = (PropertyFile)file).getInput()).isPresent() && input.get() instanceof FileInput) {
            File f = ((FileInput)input.get()).getFile();
            return f;
        }
        return UNFOUND_MEDIA;
    }

    private void addInfo(Document doc, Property p, String defaultText) {
        if (p != null) {
            doc.addImage(this.getTagFile(p), "height=" + (this.formattingOptions.common.getTextSize() - 2) + IMAGE_ATTR);
            doc.addText("\u00a0");
            doc.addText(p.getDisplayValue());
        } else {
            doc.addText(defaultText);
        }
    }

    private void addEvent(Document doc, Property p, String defaultText, int margin, Pattern tagFilter) {
        if (p != null) {
            String id;
            String index;
            Property prop;
            doc.addImage(this.getTagFile(p), "height=" + (this.formattingOptions.common.getTextSize() - 2) + IMAGE_ATTR);
            doc.addText("\u00a0");
            doc.addText(Gedcom.getName((String)p.getTag()) + ":", "font-weight=bold");
            doc.addText("\u00a0");
            String description = p.getDisplayValue();
            if (!description.isBlank()) {
                doc.addText(p.getDisplayValue());
                doc.addText("\u00a0");
            }
            if ((prop = p.getProperty("TYPE")) != null) {
                doc.addText("(" + prop.getDisplayValue() + ")");
                doc.addText("\u00a0");
            }
            boolean isDate = false;
            prop = p.getProperty("DATE");
            if (prop != null) {
                doc.addText(this.dataFormatOptions.date.getDate(prop), "font-weight=bold");
                doc.addText("\u00a0");
                isDate = true;
            }
            boolean isPlace = false;
            prop = p.getProperty("PLAC");
            if (prop != null) {
                if (this.formattingOptions.generatePlaceIndex > 0) {
                    index = this.formattingOptions.generatePlaceIndex == 1 ? this.translate("index.places") : this.translate("index.places.of", new Object[]{prop.getParent().getPropertyName()});
                    String ctry = ((PropertyPlace)prop).getCountry();
                    String city = ((PropertyPlace)prop).getCity();
                    if (!ctry.isBlank() || !city.isBlank()) {
                        doc.addIndexTerm("b. " + index, ctry.isBlank() ? UNKNOWN : ctry, city.isBlank() ? UNKNOWN : city);
                    }
                }
                if (isDate) {
                    doc.addText("- ");
                }
                doc.addText(this.dataFormatOptions.place.getPlace(prop));
                doc.addText("\u00a0");
                isPlace = true;
            }
            if ((prop = p.getProperty("ADDR")) != null) {
                if (this.formattingOptions.generatePlaceIndex > 0) {
                    String city;
                    index = this.formattingOptions.generatePlaceIndex == 1 ? this.translate("index.places") : this.translate("index.places.of", new Object[]{prop.getParent().getPropertyName()});
                    Property pCtry = prop.getProperty("CTRY");
                    String ctry = pCtry != null ? pCtry.getDisplayValue() : UNKNOWN;
                    Property pCity = prop.getProperty("CITY");
                    String string = city = pCity != null ? pCity.getDisplayValue() : "";
                    if (!ctry.isBlank() || !city.isBlank()) {
                        doc.addIndexTerm("b. " + index, ctry.isBlank() ? UNKNOWN : ctry, city.isBlank() ? UNKNOWN : city);
                    }
                }
                if (isPlace) {
                    doc.addText("- ");
                }
                doc.addText(this.dataFormatOptions.place.getPlace(prop));
                doc.addText("\u00a0");
            }
            ArrayList notes = new ArrayList();
            notes.addAll(p.getAllProperties("NOTE"));
            notes.addAll(p.getAllProperties("SNOTE"));
            if (!notes.isEmpty()) {
                for (Property note : notes) {
                    this.addImage(doc, "images/Note");
                    if (note instanceof PropertyXRef) {
                        PropertyXRef xref = (PropertyXRef)note;
                        Entity entity = (Entity)xref.getTargetEntity().get();
                        id = entity.getId();
                        doc.addLink("(" + id + ")", id);
                    } else {
                        String id2 = String.valueOf(note.hashCode());
                        doc.addLink("(" + Gedcom.getName((String)"NOTE") + ")", id2);
                    }
                    doc.addText("\u00a0");
                }
            }
            ArrayList sources = new ArrayList();
            sources.addAll(p.getAllProperties("SOUR"));
            if (!sources.isEmpty()) {
                for (Property source : sources) {
                    this.addImage(doc, "images/Source");
                    if (source instanceof PropertyXRef) {
                        PropertyXRef xref = (PropertyXRef)source;
                        Entity entity = (Entity)xref.getTargetEntity().get();
                        String id3 = entity.getId();
                        doc.addLink("(" + id3 + ")", id3);
                    } else {
                        id = String.valueOf(source.hashCode());
                        doc.addLink("(" + Gedcom.getName((String)"SOUR") + ")", id);
                    }
                    doc.addText("\u00a0");
                }
            }
            if (this.eventDepth) {
                this.displayRecursiveContent(doc, p, 2, margin, tagFilter);
            }
        } else {
            doc.addText(defaultText);
        }
    }

    private void displayRecursiveContent(Document doc, Property parent, int indent, int margin, Pattern tagFilter) {
        for (Property p : parent.getProperties()) {
            if (tagFilter != null && tagFilter.matcher(p.getTag()).matches()) continue;
            doc.nextParagraph("margin-left=" + (margin + indent * 10) + "pt");
            doc.addImage(this.getTagFile(p), "height=" + (this.formattingOptions.common.getTextSize() - 2) + IMAGE_ATTR);
            doc.addText("\u00a0");
            doc.addText(Gedcom.getName((String)p.getTag()) + ":", "font-weight=bold");
            doc.addText("\u00a0");
            String description = p.getDisplayValue();
            if (p instanceof PropertyPlace) {
                PropertyPlace pPlace = (PropertyPlace)p;
                description = this.dataFormatOptions.place.getPlace((Property)pPlace);
            } else if (p instanceof PropertyDate) {
                PropertyDate pDate = (PropertyDate)p;
                description = this.dataFormatOptions.date.getDate((Property)pDate);
            }
            if (!description.isBlank()) {
                doc.addText(description);
                doc.addText("\u00a0");
            }
            this.displayRecursiveContent(doc, p, indent + 1, margin, tagFilter);
        }
    }

    private File getTagFile(Property p) {
        String tag = p.getTag();
        File file = tag2file.get(tag);
        if (file == null) {
            try {
                file = MediaRenderer.getFileFromResource(Gedcom.class, (String)(p.getMetaProperty().getImageName() + ".png"));
            }
            catch (Exception e) {
                file = MediaRenderer.getFileFromResource(Gedcom.class, (String)"images/Attribute.png");
            }
            tag2file.put(tag, file);
        }
        return file;
    }

    private void addImage(Document doc, String name) {
        try {
            doc.addImage(MediaRenderer.getFileFromResource(Gedcom.class, (String)(name + ".png")), "height=" + (this.formattingOptions.common.getTextSize() - 2) + IMAGE_ATTR);
        }
        catch (Exception e) {
            System.err.println("Error getting Gedcom resource name=" + name + ".png");
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public class MyFormattingOptions {
        public FormattingOptions common = new FormattingOptions();
        public boolean generatePageBreak = true;
        public boolean generatePersonIndex = true;
        public int generatePlaceIndex = 1;
        public String[] generatePlaceIndexs = new String[]{ReportIndividualSheets.this.translate("place.index.none"), ReportIndividualSheets.this.translate("place.index.one"), ReportIndividualSheets.this.translate("place.index.each")};
    }

    public class MyFilterOptions {
        public FilterOptions common = new FilterOptions();
        public String filterProperties = "CROP|TOP|LEFT|HEIGHT|WIDTH";
    }

    public class MyDataFormatOptions {
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
        public FormatIDOptions id = new FormatIDOptions();
    }

    private class Event
    implements Comparable<Event> {
        private Property p;
        private int julianDay = Integer.MAX_VALUE;

        private Event(Property p) {
            this.p = p;
            Property pDate = p.getProperty("DATE");
            if (pDate != null && pDate instanceof PropertyDate) {
                PropertyDate propDate = (PropertyDate)pDate;
                PointInTime pit = propDate.getStart();
                try {
                    this.julianDay = pit.getJulianDay();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        @Override
        public int compareTo(Event o) {
            return Integer.compare(this.julianDay, o.julianDay);
        }
    }

    private class Family {
        private File ffFile = UNFOUND_MEDIA;
        private String ffName = "?";
        private String ffDate = "\u00a0";
        private File fmFile = UNFOUND_MEDIA;
        private String fmName = "?";
        private String fmDate = "\u00a0";
        private File mfFile = UNFOUND_MEDIA;
        private String mfName = "?";
        private String mfDate = "\u00a0";
        private File mmFile = UNFOUND_MEDIA;
        private String mmName = "?";
        private String mmDate = "\u00a0";
        private File fFile = UNFOUND_MEDIA;
        private String fName = "?";
        private String fDate = "\u00a0";
        private File mFile = UNFOUND_MEDIA;
        private String mName = "?";
        private String mDate = "\u00a0";
        private boolean noGen2Photo = false;
        private boolean noGen1Photo = false;
        private Fam famc = null;
        private Fam[] famss = null;

        public Family(Indi indi) {
            this.famc = indi.getFamilyWhereBiologicalChild();
            if (this.famc != null) {
                Indi mother;
                Indi father = this.famc.getHusband();
                if (father != null) {
                    this.fName = ReportIndividualSheets.this.getIndiName(father);
                    this.fDate = ReportIndividualSheets.this.getIndiDates(father);
                    this.fFile = ReportIndividualSheets.this.getIndiFile(father);
                    Fam ffamc = father.getFamilyWhereBiologicalChild();
                    if (ffamc != null) {
                        Indi fathermother;
                        Indi fatherfather = ffamc.getHusband();
                        if (fatherfather != null) {
                            this.ffName = ReportIndividualSheets.this.getIndiName(fatherfather);
                            this.ffDate = ReportIndividualSheets.this.getIndiDates(fatherfather);
                            this.ffFile = ReportIndividualSheets.this.getIndiFile(fatherfather);
                        }
                        if ((fathermother = ffamc.getWife()) != null) {
                            this.fmName = ReportIndividualSheets.this.getIndiName(fathermother);
                            this.fmDate = ReportIndividualSheets.this.getIndiDates(fathermother);
                            this.fmFile = ReportIndividualSheets.this.getIndiFile(fathermother);
                        }
                    }
                }
                if ((mother = this.famc.getWife()) != null) {
                    this.mName = ReportIndividualSheets.this.getIndiName(mother);
                    this.mDate = ReportIndividualSheets.this.getIndiDates(mother);
                    this.mFile = ReportIndividualSheets.this.getIndiFile(mother);
                    Fam mfamc = mother.getFamilyWhereBiologicalChild();
                    if (mfamc != null) {
                        Indi mothermother;
                        Indi motherfather = mfamc.getHusband();
                        if (motherfather != null) {
                            this.mfName = ReportIndividualSheets.this.getIndiName(motherfather);
                            this.mfDate = ReportIndividualSheets.this.getIndiDates(motherfather);
                            this.mfFile = ReportIndividualSheets.this.getIndiFile(motherfather);
                        }
                        if ((mothermother = mfamc.getWife()) != null) {
                            this.mmName = ReportIndividualSheets.this.getIndiName(mothermother);
                            this.mmDate = ReportIndividualSheets.this.getIndiDates(mothermother);
                            this.mmFile = ReportIndividualSheets.this.getIndiFile(mothermother);
                        }
                    }
                }
            }
            this.noGen2Photo = UNFOUND_MEDIA.equals(this.ffFile) && UNFOUND_MEDIA.equals(this.fmFile) && UNFOUND_MEDIA.equals(this.mfFile) && UNFOUND_MEDIA.equals(this.mmFile);
            this.noGen1Photo = UNFOUND_MEDIA.equals(this.fFile) && UNFOUND_MEDIA.equals(this.mFile);
            this.famss = indi.getFamiliesWhereSpouse(true);
        }
    }
}

