/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractEdge;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.graph.implementations.AbstractNode;
import org.graphstream.graph.implementations.AdjacencyListNode;

public class MultiNode
extends AdjacencyListNode {
    protected HashMap<AbstractNode, List<AbstractEdge>> neighborMap = new HashMap(4 * INITIAL_EDGE_CAPACITY / 3 + 1);

    public MultiNode(AbstractGraph graph, String id) {
        super(graph, id);
    }

    @Override
    protected <T extends Edge> T locateEdge(Node opposite, char type) {
        List<AbstractEdge> l = this.neighborMap.get(opposite);
        if (l == null) {
            return null;
        }
        for (AbstractEdge e : l) {
            char etype = this.edgeType(e);
            if (type == '\u0000' && etype == '\u0002' || type == '\u0002' && etype == '\u0000') continue;
            return (T)e;
        }
        return null;
    }

    @Override
    protected void removeEdge(int i) {
        AbstractNode opposite = (AbstractNode)this.edges[i].getOpposite(this);
        List<AbstractEdge> l = this.neighborMap.get(opposite);
        l.remove(this.edges[i]);
        if (l.isEmpty()) {
            this.neighborMap.remove(opposite);
        }
        super.removeEdge(i);
    }

    @Override
    protected boolean addEdgeCallback(AbstractEdge edge) {
        AbstractNode opposite = (AbstractNode)edge.getOpposite(this);
        List<AbstractEdge> l = this.neighborMap.get(opposite);
        if (l == null) {
            l = new LinkedList<AbstractEdge>();
            this.neighborMap.put(opposite, l);
        }
        l.add(edge);
        return super.addEdgeCallback(edge);
    }

    @Override
    protected void clearCallback() {
        this.neighborMap.clear();
        super.clearCallback();
    }

    public <T extends Edge> Collection<T> getEdgeSetBetween(Node node) {
        List<AbstractEdge> l = this.neighborMap.get(node);
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    public <T extends Edge> Collection<T> getEdgeSetBetween(String id) {
        return this.getEdgeSetBetween(this.graph.getNode(id));
    }

    public <T extends Edge> Collection<T> getEdgeSetBetween(int index) {
        return this.getEdgeSetBetween(this.graph.getNode(index));
    }
}

