; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-linux | FileCheck %s

; This is a case where we would incorrectly conclude that LBB0_1 could only
; be reached via fall through and would therefore omit the label.

@g = dso_local global i32 0

define dso_local void @xyz() {
; CHECK-LABEL: xyz:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $g, %eax
; CHECK-NEXT:    movq %rax, %xmm0
; CHECK-NEXT:    xorpd %xmm1, %xmm1
; CHECK-NEXT:    ucomisd %xmm1, %xmm0
; CHECK-NEXT:    jne .LBB0_1
; CHECK-NEXT:    jnp .LBB0_2
; CHECK-NEXT:    .p2align 4, 0x90
; CHECK-NEXT:  .LBB0_1: # %foo
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ucomisd %xmm1, %xmm0
; CHECK-NEXT:    ja .LBB0_1
; CHECK-NEXT:  .LBB0_2: # %bar
; CHECK-NEXT:    retq
entry:
  br i1 fcmp oeq (double bitcast (i64 ptrtoint (i32* @g to i64) to double), double 0.000000e+00), label %bar, label %foo

foo:
  br i1 fcmp ogt (double bitcast (i64 ptrtoint (i32* @g to i64) to double), double 0.000000e+00), label %foo, label %bar

bar:
  ret void
}
