// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

/*
Package datatransfer is a generated protocol buffer package.

It is generated from these files:
	google/cloud/bigquery/datatransfer/v1/datatransfer.proto
	google/cloud/bigquery/datatransfer/v1/transfer.proto

It has these top-level messages:
	DataSourceParameter
	DataSource
	GetDataSourceRequest
	ListDataSourcesRequest
	ListDataSourcesResponse
	CreateTransferConfigRequest
	UpdateTransferConfigRequest
	GetTransferConfigRequest
	DeleteTransferConfigRequest
	GetTransferRunRequest
	DeleteTransferRunRequest
	ListTransferConfigsRequest
	ListTransferConfigsResponse
	ListTransferRunsRequest
	ListTransferRunsResponse
	ListTransferLogsRequest
	ListTransferLogsResponse
	CheckValidCredsRequest
	CheckValidCredsResponse
	ScheduleTransferRunsRequest
	ScheduleTransferRunsResponse
	TransferConfig
	TransferRun
	TransferMessage
*/
package datatransfer

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf4 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf5 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf6 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"
import google_protobuf7 "github.com/golang/protobuf/ptypes/wrappers"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Parameter type.
type DataSourceParameter_Type int32

const (
	// Type unspecified.
	DataSourceParameter_TYPE_UNSPECIFIED DataSourceParameter_Type = 0
	// String parameter.
	DataSourceParameter_STRING DataSourceParameter_Type = 1
	// Integer parameter (64-bits).
	// Will be serialized to json as string.
	DataSourceParameter_INTEGER DataSourceParameter_Type = 2
	// Double precision floating point parameter.
	DataSourceParameter_DOUBLE DataSourceParameter_Type = 3
	// Boolean parameter.
	DataSourceParameter_BOOLEAN DataSourceParameter_Type = 4
	// Record parameter.
	DataSourceParameter_RECORD DataSourceParameter_Type = 5
	// Page ID for a Google+ Page.
	DataSourceParameter_PLUS_PAGE DataSourceParameter_Type = 6
)

var DataSourceParameter_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "STRING",
	2: "INTEGER",
	3: "DOUBLE",
	4: "BOOLEAN",
	5: "RECORD",
	6: "PLUS_PAGE",
}
var DataSourceParameter_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"STRING":           1,
	"INTEGER":          2,
	"DOUBLE":           3,
	"BOOLEAN":          4,
	"RECORD":           5,
	"PLUS_PAGE":        6,
}

func (x DataSourceParameter_Type) String() string {
	return proto.EnumName(DataSourceParameter_Type_name, int32(x))
}
func (DataSourceParameter_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

// The type of authorization needed for this data source.
type DataSource_AuthorizationType int32

const (
	// Type unspecified.
	DataSource_AUTHORIZATION_TYPE_UNSPECIFIED DataSource_AuthorizationType = 0
	// Use OAuth 2 authorization codes that can be exchanged
	// for a refresh token on the backend.
	DataSource_AUTHORIZATION_CODE DataSource_AuthorizationType = 1
	// Return an authorization code for a given Google+ page that can then be
	// exchanged for a refresh token on the backend.
	DataSource_GOOGLE_PLUS_AUTHORIZATION_CODE DataSource_AuthorizationType = 2
)

var DataSource_AuthorizationType_name = map[int32]string{
	0: "AUTHORIZATION_TYPE_UNSPECIFIED",
	1: "AUTHORIZATION_CODE",
	2: "GOOGLE_PLUS_AUTHORIZATION_CODE",
}
var DataSource_AuthorizationType_value = map[string]int32{
	"AUTHORIZATION_TYPE_UNSPECIFIED": 0,
	"AUTHORIZATION_CODE":             1,
	"GOOGLE_PLUS_AUTHORIZATION_CODE": 2,
}

func (x DataSource_AuthorizationType) String() string {
	return proto.EnumName(DataSource_AuthorizationType_name, int32(x))
}
func (DataSource_AuthorizationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{1, 0}
}

// Represents how the data source supports data auto refresh.
type DataSource_DataRefreshType int32

const (
	// The data source won't support data auto refresh, which is default value.
	DataSource_DATA_REFRESH_TYPE_UNSPECIFIED DataSource_DataRefreshType = 0
	// The data source supports data auto refresh, and runs will be scheduled
	// for the past few days. Does not allow custom values to be set for each
	// transfer config.
	DataSource_SLIDING_WINDOW DataSource_DataRefreshType = 1
	// The data source supports data auto refresh, and runs will be scheduled
	// for the past few days. Allows custom values to be set for each transfer
	// config.
	DataSource_CUSTOM_SLIDING_WINDOW DataSource_DataRefreshType = 2
)

var DataSource_DataRefreshType_name = map[int32]string{
	0: "DATA_REFRESH_TYPE_UNSPECIFIED",
	1: "SLIDING_WINDOW",
	2: "CUSTOM_SLIDING_WINDOW",
}
var DataSource_DataRefreshType_value = map[string]int32{
	"DATA_REFRESH_TYPE_UNSPECIFIED": 0,
	"SLIDING_WINDOW":                1,
	"CUSTOM_SLIDING_WINDOW":         2,
}

func (x DataSource_DataRefreshType) String() string {
	return proto.EnumName(DataSource_DataRefreshType_name, int32(x))
}
func (DataSource_DataRefreshType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{1, 1}
}

// Represents which runs should be pulled.
type ListTransferRunsRequest_RunAttempt int32

const (
	// All runs should be returned.
	ListTransferRunsRequest_RUN_ATTEMPT_UNSPECIFIED ListTransferRunsRequest_RunAttempt = 0
	// Only latest run per day should be returned.
	ListTransferRunsRequest_LATEST ListTransferRunsRequest_RunAttempt = 1
)

var ListTransferRunsRequest_RunAttempt_name = map[int32]string{
	0: "RUN_ATTEMPT_UNSPECIFIED",
	1: "LATEST",
}
var ListTransferRunsRequest_RunAttempt_value = map[string]int32{
	"RUN_ATTEMPT_UNSPECIFIED": 0,
	"LATEST":                  1,
}

func (x ListTransferRunsRequest_RunAttempt) String() string {
	return proto.EnumName(ListTransferRunsRequest_RunAttempt_name, int32(x))
}
func (ListTransferRunsRequest_RunAttempt) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{13, 0}
}

// Represents a data source parameter with validation rules, so that
// parameters can be rendered in the UI. These parameters are given to us by
// supported data sources, and include all needed information for rendering
// and validation.
// Thus, whoever uses this api can decide to generate either generic ui,
// or custom data source specific forms.
type DataSourceParameter struct {
	// Parameter identifier.
	ParamId string `protobuf:"bytes,1,opt,name=param_id,json=paramId" json:"param_id,omitempty"`
	// Parameter display name in the user interface.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Parameter description.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Parameter type.
	Type DataSourceParameter_Type `protobuf:"varint,4,opt,name=type,enum=google.cloud.bigquery.datatransfer.v1.DataSourceParameter_Type" json:"type,omitempty"`
	// Is parameter required.
	Required bool `protobuf:"varint,5,opt,name=required" json:"required,omitempty"`
	// Can parameter have multiple values.
	Repeated bool `protobuf:"varint,6,opt,name=repeated" json:"repeated,omitempty"`
	// Regular expression which can be used for parameter validation.
	ValidationRegex string `protobuf:"bytes,7,opt,name=validation_regex,json=validationRegex" json:"validation_regex,omitempty"`
	// All possible values for the parameter.
	AllowedValues []string `protobuf:"bytes,8,rep,name=allowed_values,json=allowedValues" json:"allowed_values,omitempty"`
	// For integer and double values specifies minimum allowed value.
	MinValue *google_protobuf7.DoubleValue `protobuf:"bytes,9,opt,name=min_value,json=minValue" json:"min_value,omitempty"`
	// For integer and double values specifies maxminum allowed value.
	MaxValue *google_protobuf7.DoubleValue `protobuf:"bytes,10,opt,name=max_value,json=maxValue" json:"max_value,omitempty"`
	// When parameter is a record, describes child fields.
	Fields []*DataSourceParameter `protobuf:"bytes,11,rep,name=fields" json:"fields,omitempty"`
	// Description of the requirements for this field, in case the user input does
	// not fulfill the regex pattern or min/max values.
	ValidationDescription string `protobuf:"bytes,12,opt,name=validation_description,json=validationDescription" json:"validation_description,omitempty"`
	// URL to a help document to further explain the naming requirements.
	ValidationHelpUrl string `protobuf:"bytes,13,opt,name=validation_help_url,json=validationHelpUrl" json:"validation_help_url,omitempty"`
	// Cannot be changed after initial creation.
	Immutable bool `protobuf:"varint,14,opt,name=immutable" json:"immutable,omitempty"`
	// If set to true, schema should be taken from the parent with the same
	// parameter_id. Only applicable when parameter type is RECORD.
	Recurse bool `protobuf:"varint,15,opt,name=recurse" json:"recurse,omitempty"`
}

func (m *DataSourceParameter) Reset()                    { *m = DataSourceParameter{} }
func (m *DataSourceParameter) String() string            { return proto.CompactTextString(m) }
func (*DataSourceParameter) ProtoMessage()               {}
func (*DataSourceParameter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *DataSourceParameter) GetParamId() string {
	if m != nil {
		return m.ParamId
	}
	return ""
}

func (m *DataSourceParameter) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *DataSourceParameter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DataSourceParameter) GetType() DataSourceParameter_Type {
	if m != nil {
		return m.Type
	}
	return DataSourceParameter_TYPE_UNSPECIFIED
}

func (m *DataSourceParameter) GetRequired() bool {
	if m != nil {
		return m.Required
	}
	return false
}

func (m *DataSourceParameter) GetRepeated() bool {
	if m != nil {
		return m.Repeated
	}
	return false
}

func (m *DataSourceParameter) GetValidationRegex() string {
	if m != nil {
		return m.ValidationRegex
	}
	return ""
}

func (m *DataSourceParameter) GetAllowedValues() []string {
	if m != nil {
		return m.AllowedValues
	}
	return nil
}

func (m *DataSourceParameter) GetMinValue() *google_protobuf7.DoubleValue {
	if m != nil {
		return m.MinValue
	}
	return nil
}

func (m *DataSourceParameter) GetMaxValue() *google_protobuf7.DoubleValue {
	if m != nil {
		return m.MaxValue
	}
	return nil
}

func (m *DataSourceParameter) GetFields() []*DataSourceParameter {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *DataSourceParameter) GetValidationDescription() string {
	if m != nil {
		return m.ValidationDescription
	}
	return ""
}

func (m *DataSourceParameter) GetValidationHelpUrl() string {
	if m != nil {
		return m.ValidationHelpUrl
	}
	return ""
}

func (m *DataSourceParameter) GetImmutable() bool {
	if m != nil {
		return m.Immutable
	}
	return false
}

func (m *DataSourceParameter) GetRecurse() bool {
	if m != nil {
		return m.Recurse
	}
	return false
}

// Represents data source metadata. Metadata is sufficient to
// render UI and request proper OAuth tokens.
type DataSource struct {
	// Data source resource name.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Data source id.
	DataSourceId string `protobuf:"bytes,2,opt,name=data_source_id,json=dataSourceId" json:"data_source_id,omitempty"`
	// User friendly data source name.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// User friendly data source description string.
	Description string `protobuf:"bytes,4,opt,name=description" json:"description,omitempty"`
	// Data source client id which should be used to receive refresh token.
	// When not supplied, no offline credentials are populated for data transfer.
	ClientId string `protobuf:"bytes,5,opt,name=client_id,json=clientId" json:"client_id,omitempty"`
	// Api auth scopes for which refresh token needs to be obtained. Only valid
	// when `client_id` is specified. Ignored otherwise. These are scopes needed
	// by a data source to prepare data and ingest them into BigQuery,
	// e.g., https://www.googleapis.com/auth/bigquery
	Scopes []string `protobuf:"bytes,6,rep,name=scopes" json:"scopes,omitempty"`
	// Transfer type. Currently supports only batch transfers,
	// which are transfers that use the BigQuery batch APIs (load or
	// query) to ingest the data.
	TransferType TransferType `protobuf:"varint,7,opt,name=transfer_type,json=transferType,enum=google.cloud.bigquery.datatransfer.v1.TransferType" json:"transfer_type,omitempty"`
	// Indicates whether the data source supports multiple transfers
	// to different BigQuery targets.
	SupportsMultipleTransfers bool `protobuf:"varint,8,opt,name=supports_multiple_transfers,json=supportsMultipleTransfers" json:"supports_multiple_transfers,omitempty"`
	// The number of seconds to wait for an update from the data source
	// before BigQuery marks the transfer as failed.
	UpdateDeadlineSeconds int32 `protobuf:"varint,9,opt,name=update_deadline_seconds,json=updateDeadlineSeconds" json:"update_deadline_seconds,omitempty"`
	// Default data transfer schedule.
	// Examples of valid schedules include:
	// `1st,3rd monday of month 15:30`,
	// `every wed,fri of jan,jun 13:15`, and
	// `first sunday of quarter 00:00`.
	DefaultSchedule string `protobuf:"bytes,10,opt,name=default_schedule,json=defaultSchedule" json:"default_schedule,omitempty"`
	// Specifies whether the data source supports a user defined schedule, or
	// operates on the default schedule.
	// When set to `true`, user can override default schedule.
	SupportsCustomSchedule bool `protobuf:"varint,11,opt,name=supports_custom_schedule,json=supportsCustomSchedule" json:"supports_custom_schedule,omitempty"`
	// Data source parameters.
	Parameters []*DataSourceParameter `protobuf:"bytes,12,rep,name=parameters" json:"parameters,omitempty"`
	// Url for the help document for this data source.
	HelpUrl string `protobuf:"bytes,13,opt,name=help_url,json=helpUrl" json:"help_url,omitempty"`
	// Indicates the type of authorization.
	AuthorizationType DataSource_AuthorizationType `protobuf:"varint,14,opt,name=authorization_type,json=authorizationType,enum=google.cloud.bigquery.datatransfer.v1.DataSource_AuthorizationType" json:"authorization_type,omitempty"`
	// Specifies whether the data source supports automatic data refresh for the
	// past few days, and how it's supported.
	// For some data sources, data might not be complete until a few days later,
	// so it's useful to refresh data automatically.
	DataRefreshType DataSource_DataRefreshType `protobuf:"varint,15,opt,name=data_refresh_type,json=dataRefreshType,enum=google.cloud.bigquery.datatransfer.v1.DataSource_DataRefreshType" json:"data_refresh_type,omitempty"`
	// Default data refresh window on days.
	// Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
	DefaultDataRefreshWindowDays int32 `protobuf:"varint,16,opt,name=default_data_refresh_window_days,json=defaultDataRefreshWindowDays" json:"default_data_refresh_window_days,omitempty"`
	// Disables backfilling and manual run scheduling
	// for the data source.
	ManualRunsDisabled bool `protobuf:"varint,17,opt,name=manual_runs_disabled,json=manualRunsDisabled" json:"manual_runs_disabled,omitempty"`
	// The minimum interval for scheduler to schedule runs.
	MinimumScheduleInterval *google_protobuf4.Duration `protobuf:"bytes,18,opt,name=minimum_schedule_interval,json=minimumScheduleInterval" json:"minimum_schedule_interval,omitempty"`
}

func (m *DataSource) Reset()                    { *m = DataSource{} }
func (m *DataSource) String() string            { return proto.CompactTextString(m) }
func (*DataSource) ProtoMessage()               {}
func (*DataSource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *DataSource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DataSource) GetDataSourceId() string {
	if m != nil {
		return m.DataSourceId
	}
	return ""
}

func (m *DataSource) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *DataSource) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DataSource) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *DataSource) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *DataSource) GetTransferType() TransferType {
	if m != nil {
		return m.TransferType
	}
	return TransferType_TRANSFER_TYPE_UNSPECIFIED
}

func (m *DataSource) GetSupportsMultipleTransfers() bool {
	if m != nil {
		return m.SupportsMultipleTransfers
	}
	return false
}

func (m *DataSource) GetUpdateDeadlineSeconds() int32 {
	if m != nil {
		return m.UpdateDeadlineSeconds
	}
	return 0
}

func (m *DataSource) GetDefaultSchedule() string {
	if m != nil {
		return m.DefaultSchedule
	}
	return ""
}

func (m *DataSource) GetSupportsCustomSchedule() bool {
	if m != nil {
		return m.SupportsCustomSchedule
	}
	return false
}

func (m *DataSource) GetParameters() []*DataSourceParameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *DataSource) GetHelpUrl() string {
	if m != nil {
		return m.HelpUrl
	}
	return ""
}

func (m *DataSource) GetAuthorizationType() DataSource_AuthorizationType {
	if m != nil {
		return m.AuthorizationType
	}
	return DataSource_AUTHORIZATION_TYPE_UNSPECIFIED
}

func (m *DataSource) GetDataRefreshType() DataSource_DataRefreshType {
	if m != nil {
		return m.DataRefreshType
	}
	return DataSource_DATA_REFRESH_TYPE_UNSPECIFIED
}

func (m *DataSource) GetDefaultDataRefreshWindowDays() int32 {
	if m != nil {
		return m.DefaultDataRefreshWindowDays
	}
	return 0
}

func (m *DataSource) GetManualRunsDisabled() bool {
	if m != nil {
		return m.ManualRunsDisabled
	}
	return false
}

func (m *DataSource) GetMinimumScheduleInterval() *google_protobuf4.Duration {
	if m != nil {
		return m.MinimumScheduleInterval
	}
	return nil
}

// A request to get data source info.
type GetDataSourceRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/dataSources/{data_source_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetDataSourceRequest) Reset()                    { *m = GetDataSourceRequest{} }
func (m *GetDataSourceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDataSourceRequest) ProtoMessage()               {}
func (*GetDataSourceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GetDataSourceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list supported data sources and their data transfer settings.
type ListDataSourcesRequest struct {
	// The BigQuery project id for which data sources should be returned.
	// Must be in the form: `projects/{project_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListDataSourcesRequest` list results. For multiple-page
	// results, `ListDataSourcesResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListDataSourcesRequest) Reset()                    { *m = ListDataSourcesRequest{} }
func (m *ListDataSourcesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDataSourcesRequest) ProtoMessage()               {}
func (*ListDataSourcesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListDataSourcesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDataSourcesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDataSourcesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Returns list of supported data sources and their metadata.
type ListDataSourcesResponse struct {
	// List of supported data sources and their transfer settings.
	DataSources []*DataSource `protobuf:"bytes,1,rep,name=data_sources,json=dataSources" json:"data_sources,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListDataSourcesRequest.page_token`
	// to request the next page of list results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListDataSourcesResponse) Reset()                    { *m = ListDataSourcesResponse{} }
func (m *ListDataSourcesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDataSourcesResponse) ProtoMessage()               {}
func (*ListDataSourcesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ListDataSourcesResponse) GetDataSources() []*DataSource {
	if m != nil {
		return m.DataSources
	}
	return nil
}

func (m *ListDataSourcesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to create a data transfer configuration. If new credentials are
// needed for this transfer configuration, an authorization code must be
// provided. If an authorization code is provided, the transfer configuration
// will be associated with the user id corresponding to the
// authorization code. Otherwise, the transfer configuration will be associated
// with the calling user.
type CreateTransferConfigRequest struct {
	// The BigQuery project id where the transfer configuration should be created.
	// Must be in the format /projects/{project_id}/locations/{location_id}
	// If specified location and location of the destination bigquery dataset
	// do not match - the request will fail.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Data transfer configuration to create.
	TransferConfig *TransferConfig `protobuf:"bytes,2,opt,name=transfer_config,json=transferConfig" json:"transfer_config,omitempty"`
	// Optional OAuth2 authorization code to use with this transfer configuration.
	// This is required if new credentials are needed, as indicated by
	// `CheckValidCreds`.
	// In order to obtain authorization_code, please make a
	// request to
	// https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?client_id=<datatransferapiclientid>&scope=<data_source_scopes>&redirect_uri=<redirect_uri>
	//
	// * client_id should be OAuth client_id of BigQuery DTS API for the given
	//   data source returned by ListDataSources method.
	// * data_source_scopes are the scopes returned by ListDataSources method.
	// * redirect_uri is an optional parameter. If not specified, then
	//   authorization code is posted to the opener of authorization flow window.
	//   Otherwise it will be sent to the redirect uri. A special value of
	//   urn:ietf:wg:oauth:2.0:oob means that authorization code should be
	//   returned in the title bar of the browser, with the page text prompting
	//   the user to copy the code and paste it in the application.
	AuthorizationCode string `protobuf:"bytes,3,opt,name=authorization_code,json=authorizationCode" json:"authorization_code,omitempty"`
}

func (m *CreateTransferConfigRequest) Reset()                    { *m = CreateTransferConfigRequest{} }
func (m *CreateTransferConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateTransferConfigRequest) ProtoMessage()               {}
func (*CreateTransferConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CreateTransferConfigRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTransferConfigRequest) GetTransferConfig() *TransferConfig {
	if m != nil {
		return m.TransferConfig
	}
	return nil
}

func (m *CreateTransferConfigRequest) GetAuthorizationCode() string {
	if m != nil {
		return m.AuthorizationCode
	}
	return ""
}

// A request to update a transfer configuration. To update the user id of the
// transfer configuration, an authorization code needs to be provided.
type UpdateTransferConfigRequest struct {
	// Data transfer configuration to create.
	TransferConfig *TransferConfig `protobuf:"bytes,1,opt,name=transfer_config,json=transferConfig" json:"transfer_config,omitempty"`
	// Optional OAuth2 authorization code to use with this transfer configuration.
	// If it is provided, the transfer configuration will be associated with the
	// authorizing user.
	// In order to obtain authorization_code, please make a
	// request to
	// https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?client_id=<datatransferapiclientid>&scope=<data_source_scopes>&redirect_uri=<redirect_uri>
	//
	// * client_id should be OAuth client_id of BigQuery DTS API for the given
	//   data source returned by ListDataSources method.
	// * data_source_scopes are the scopes returned by ListDataSources method.
	// * redirect_uri is an optional parameter. If not specified, then
	//   authorization code is posted to the opener of authorization flow window.
	//   Otherwise it will be sent to the redirect uri. A special value of
	//   urn:ietf:wg:oauth:2.0:oob means that authorization code should be
	//   returned in the title bar of the browser, with the page text prompting
	//   the user to copy the code and paste it in the application.
	AuthorizationCode string `protobuf:"bytes,3,opt,name=authorization_code,json=authorizationCode" json:"authorization_code,omitempty"`
	// Required list of fields to be updated in this request.
	UpdateMask *google_protobuf6.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateTransferConfigRequest) Reset()                    { *m = UpdateTransferConfigRequest{} }
func (m *UpdateTransferConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateTransferConfigRequest) ProtoMessage()               {}
func (*UpdateTransferConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *UpdateTransferConfigRequest) GetTransferConfig() *TransferConfig {
	if m != nil {
		return m.TransferConfig
	}
	return nil
}

func (m *UpdateTransferConfigRequest) GetAuthorizationCode() string {
	if m != nil {
		return m.AuthorizationCode
	}
	return ""
}

func (m *UpdateTransferConfigRequest) GetUpdateMask() *google_protobuf6.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// A request to get data transfer information.
type GetTransferConfigRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetTransferConfigRequest) Reset()                    { *m = GetTransferConfigRequest{} }
func (m *GetTransferConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTransferConfigRequest) ProtoMessage()               {}
func (*GetTransferConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetTransferConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to delete data transfer information. All associated transfer runs
// and log messages will be deleted as well.
type DeleteTransferConfigRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteTransferConfigRequest) Reset()                    { *m = DeleteTransferConfigRequest{} }
func (m *DeleteTransferConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTransferConfigRequest) ProtoMessage()               {}
func (*DeleteTransferConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *DeleteTransferConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to get data transfer run information.
type GetTransferRunRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetTransferRunRequest) Reset()                    { *m = GetTransferRunRequest{} }
func (m *GetTransferRunRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTransferRunRequest) ProtoMessage()               {}
func (*GetTransferRunRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *GetTransferRunRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to delete data transfer run information.
type DeleteTransferRunRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteTransferRunRequest) Reset()                    { *m = DeleteTransferRunRequest{} }
func (m *DeleteTransferRunRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTransferRunRequest) ProtoMessage()               {}
func (*DeleteTransferRunRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *DeleteTransferRunRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to list data transfers configured for a BigQuery project.
type ListTransferConfigsRequest struct {
	// The BigQuery project id for which data sources
	// should be returned: `projects/{project_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// When specified, only configurations of requested data sources are returned.
	DataSourceIds []string `protobuf:"bytes,2,rep,name=data_source_ids,json=dataSourceIds" json:"data_source_ids,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransfersRequest` list results. For multiple-page
	// results, `ListTransfersResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListTransferConfigsRequest) Reset()                    { *m = ListTransferConfigsRequest{} }
func (m *ListTransferConfigsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTransferConfigsRequest) ProtoMessage()               {}
func (*ListTransferConfigsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ListTransferConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTransferConfigsRequest) GetDataSourceIds() []string {
	if m != nil {
		return m.DataSourceIds
	}
	return nil
}

func (m *ListTransferConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransferConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The returned list of pipelines in the project.
type ListTransferConfigsResponse struct {
	// Output only. The stored pipeline transfer configurations.
	TransferConfigs []*TransferConfig `protobuf:"bytes,1,rep,name=transfer_configs,json=transferConfigs" json:"transfer_configs,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListTransferConfigsRequest.page_token`
	// to request the next page of list results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTransferConfigsResponse) Reset()                    { *m = ListTransferConfigsResponse{} }
func (m *ListTransferConfigsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTransferConfigsResponse) ProtoMessage()               {}
func (*ListTransferConfigsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ListTransferConfigsResponse) GetTransferConfigs() []*TransferConfig {
	if m != nil {
		return m.TransferConfigs
	}
	return nil
}

func (m *ListTransferConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to list data transfer runs. UI can use this method to show/filter
// specific data transfer runs. The data source can use this method to request
// all scheduled transfer runs.
type ListTransferRunsRequest struct {
	// Name of transfer configuration for which transfer runs should be retrieved.
	// Format of transfer configuration resource name is:
	// `projects/{project_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// When specified, only transfer runs with requested states are returned.
	States []TransferState `protobuf:"varint,2,rep,packed,name=states,enum=google.cloud.bigquery.datatransfer.v1.TransferState" json:"states,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransferRunsRequest` list results. For multiple-page
	// results, `ListTransferRunsResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Indicates how run attempts are to be pulled.
	RunAttempt ListTransferRunsRequest_RunAttempt `protobuf:"varint,5,opt,name=run_attempt,json=runAttempt,enum=google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest_RunAttempt" json:"run_attempt,omitempty"`
}

func (m *ListTransferRunsRequest) Reset()                    { *m = ListTransferRunsRequest{} }
func (m *ListTransferRunsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTransferRunsRequest) ProtoMessage()               {}
func (*ListTransferRunsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *ListTransferRunsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTransferRunsRequest) GetStates() []TransferState {
	if m != nil {
		return m.States
	}
	return nil
}

func (m *ListTransferRunsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransferRunsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTransferRunsRequest) GetRunAttempt() ListTransferRunsRequest_RunAttempt {
	if m != nil {
		return m.RunAttempt
	}
	return ListTransferRunsRequest_RUN_ATTEMPT_UNSPECIFIED
}

// The returned list of pipelines in the project.
type ListTransferRunsResponse struct {
	// Output only. The stored pipeline transfer runs.
	TransferRuns []*TransferRun `protobuf:"bytes,1,rep,name=transfer_runs,json=transferRuns" json:"transfer_runs,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListTransferRunsRequest.page_token`
	// to request the next page of list results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTransferRunsResponse) Reset()                    { *m = ListTransferRunsResponse{} }
func (m *ListTransferRunsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTransferRunsResponse) ProtoMessage()               {}
func (*ListTransferRunsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ListTransferRunsResponse) GetTransferRuns() []*TransferRun {
	if m != nil {
		return m.TransferRuns
	}
	return nil
}

func (m *ListTransferRunsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to get user facing log messages associated with data transfer run.
type ListTransferLogsRequest struct {
	// Transfer run name in the form:
	// `projects/{project_id}/transferConfigs/{config_Id}/runs/{run_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransferLogsRequest` list results. For multiple-page
	// results, `ListTransferLogsResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Message types to return. If not populated - INFO, WARNING and ERROR
	// messages are returned.
	MessageTypes []TransferMessage_MessageSeverity `protobuf:"varint,6,rep,packed,name=message_types,json=messageTypes,enum=google.cloud.bigquery.datatransfer.v1.TransferMessage_MessageSeverity" json:"message_types,omitempty"`
}

func (m *ListTransferLogsRequest) Reset()                    { *m = ListTransferLogsRequest{} }
func (m *ListTransferLogsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTransferLogsRequest) ProtoMessage()               {}
func (*ListTransferLogsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ListTransferLogsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTransferLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransferLogsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTransferLogsRequest) GetMessageTypes() []TransferMessage_MessageSeverity {
	if m != nil {
		return m.MessageTypes
	}
	return nil
}

// The returned list transfer run messages.
type ListTransferLogsResponse struct {
	// Output only. The stored pipeline transfer messages.
	TransferMessages []*TransferMessage `protobuf:"bytes,1,rep,name=transfer_messages,json=transferMessages" json:"transfer_messages,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `GetTransferRunLogRequest.page_token`
	// to request the next page of list results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTransferLogsResponse) Reset()                    { *m = ListTransferLogsResponse{} }
func (m *ListTransferLogsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTransferLogsResponse) ProtoMessage()               {}
func (*ListTransferLogsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ListTransferLogsResponse) GetTransferMessages() []*TransferMessage {
	if m != nil {
		return m.TransferMessages
	}
	return nil
}

func (m *ListTransferLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to determine whether the user has valid credentials. This method
// is used to limit the number of OAuth popups in the user interface. The
// user id is inferred from the API call context.
// If the data source has the Google+ authorization type, this method
// returns false, as it cannot be determined whether the credentials are
// already valid merely based on the user id.
type CheckValidCredsRequest struct {
	// The data source in the form:
	// `projects/{project_id}/dataSources/{data_source_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *CheckValidCredsRequest) Reset()                    { *m = CheckValidCredsRequest{} }
func (m *CheckValidCredsRequest) String() string            { return proto.CompactTextString(m) }
func (*CheckValidCredsRequest) ProtoMessage()               {}
func (*CheckValidCredsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *CheckValidCredsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A response indicating whether the credentials exist and are valid.
type CheckValidCredsResponse struct {
	// If set to `true`, the credentials exist and are valid.
	HasValidCreds bool `protobuf:"varint,1,opt,name=has_valid_creds,json=hasValidCreds" json:"has_valid_creds,omitempty"`
}

func (m *CheckValidCredsResponse) Reset()                    { *m = CheckValidCredsResponse{} }
func (m *CheckValidCredsResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckValidCredsResponse) ProtoMessage()               {}
func (*CheckValidCredsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *CheckValidCredsResponse) GetHasValidCreds() bool {
	if m != nil {
		return m.HasValidCreds
	}
	return false
}

// A request to schedule transfer runs for a time range.
type ScheduleTransferRunsRequest struct {
	// Transfer configuration name in the form:
	// `projects/{project_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Start time of the range of transfer runs. For example,
	// `"2017-05-25T00:00:00+00:00"`.
	StartTime *google_protobuf2.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// End time of the range of transfer runs. For example,
	// `"2017-05-30T00:00:00+00:00"`.
	EndTime *google_protobuf2.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
}

func (m *ScheduleTransferRunsRequest) Reset()                    { *m = ScheduleTransferRunsRequest{} }
func (m *ScheduleTransferRunsRequest) String() string            { return proto.CompactTextString(m) }
func (*ScheduleTransferRunsRequest) ProtoMessage()               {}
func (*ScheduleTransferRunsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *ScheduleTransferRunsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ScheduleTransferRunsRequest) GetStartTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ScheduleTransferRunsRequest) GetEndTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// A response to schedule transfer runs for a time range.
type ScheduleTransferRunsResponse struct {
	// The transfer runs that were scheduled.
	Runs []*TransferRun `protobuf:"bytes,1,rep,name=runs" json:"runs,omitempty"`
}

func (m *ScheduleTransferRunsResponse) Reset()                    { *m = ScheduleTransferRunsResponse{} }
func (m *ScheduleTransferRunsResponse) String() string            { return proto.CompactTextString(m) }
func (*ScheduleTransferRunsResponse) ProtoMessage()               {}
func (*ScheduleTransferRunsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ScheduleTransferRunsResponse) GetRuns() []*TransferRun {
	if m != nil {
		return m.Runs
	}
	return nil
}

func init() {
	proto.RegisterType((*DataSourceParameter)(nil), "google.cloud.bigquery.datatransfer.v1.DataSourceParameter")
	proto.RegisterType((*DataSource)(nil), "google.cloud.bigquery.datatransfer.v1.DataSource")
	proto.RegisterType((*GetDataSourceRequest)(nil), "google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest")
	proto.RegisterType((*ListDataSourcesRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest")
	proto.RegisterType((*ListDataSourcesResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse")
	proto.RegisterType((*CreateTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest")
	proto.RegisterType((*UpdateTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest")
	proto.RegisterType((*GetTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest")
	proto.RegisterType((*DeleteTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest")
	proto.RegisterType((*GetTransferRunRequest)(nil), "google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest")
	proto.RegisterType((*DeleteTransferRunRequest)(nil), "google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest")
	proto.RegisterType((*ListTransferConfigsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest")
	proto.RegisterType((*ListTransferConfigsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse")
	proto.RegisterType((*ListTransferRunsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest")
	proto.RegisterType((*ListTransferRunsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse")
	proto.RegisterType((*ListTransferLogsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest")
	proto.RegisterType((*ListTransferLogsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse")
	proto.RegisterType((*CheckValidCredsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest")
	proto.RegisterType((*CheckValidCredsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse")
	proto.RegisterType((*ScheduleTransferRunsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest")
	proto.RegisterType((*ScheduleTransferRunsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse")
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.DataSourceParameter_Type", DataSourceParameter_Type_name, DataSourceParameter_Type_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.DataSource_AuthorizationType", DataSource_AuthorizationType_name, DataSource_AuthorizationType_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.DataSource_DataRefreshType", DataSource_DataRefreshType_name, DataSource_DataRefreshType_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest_RunAttempt", ListTransferRunsRequest_RunAttempt_name, ListTransferRunsRequest_RunAttempt_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for DataTransferService service

type DataTransferServiceClient interface {
	// Retrieves a supported data source and returns its settings,
	// which can be used for UI rendering.
	GetDataSource(ctx context.Context, in *GetDataSourceRequest, opts ...grpc.CallOption) (*DataSource, error)
	// Lists supported data sources and returns their settings,
	// which can be used for UI rendering.
	ListDataSources(ctx context.Context, in *ListDataSourcesRequest, opts ...grpc.CallOption) (*ListDataSourcesResponse, error)
	// Creates a new data transfer configuration.
	CreateTransferConfig(ctx context.Context, in *CreateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Updates a data transfer configuration.
	// All fields must be set, even if they are not updated.
	UpdateTransferConfig(ctx context.Context, in *UpdateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Deletes a data transfer configuration,
	// including any associated transfer runs and logs.
	DeleteTransferConfig(ctx context.Context, in *DeleteTransferConfigRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error)
	// Returns information about a data transfer config.
	GetTransferConfig(ctx context.Context, in *GetTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Returns information about all data transfers in the project.
	ListTransferConfigs(ctx context.Context, in *ListTransferConfigsRequest, opts ...grpc.CallOption) (*ListTransferConfigsResponse, error)
	// Creates transfer runs for a time range [start_time, end_time].
	// For each date - or whatever granularity the data source supports - in the
	// range, one transfer run is created.
	// Note that runs are created per UTC time in the time range.
	ScheduleTransferRuns(ctx context.Context, in *ScheduleTransferRunsRequest, opts ...grpc.CallOption) (*ScheduleTransferRunsResponse, error)
	// Returns information about the particular transfer run.
	GetTransferRun(ctx context.Context, in *GetTransferRunRequest, opts ...grpc.CallOption) (*TransferRun, error)
	// Deletes the specified transfer run.
	DeleteTransferRun(ctx context.Context, in *DeleteTransferRunRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error)
	// Returns information about running and completed jobs.
	ListTransferRuns(ctx context.Context, in *ListTransferRunsRequest, opts ...grpc.CallOption) (*ListTransferRunsResponse, error)
	// Returns user facing log messages for the data transfer run.
	ListTransferLogs(ctx context.Context, in *ListTransferLogsRequest, opts ...grpc.CallOption) (*ListTransferLogsResponse, error)
	// Returns true if valid credentials exist for the given data source and
	// requesting user.
	// Some data sources doesn't support service account, so we need to talk to
	// them on behalf of the end user. This API just checks whether we have OAuth
	// token for the particular user, which is a pre-requisite before user can
	// create a transfer config.
	CheckValidCreds(ctx context.Context, in *CheckValidCredsRequest, opts ...grpc.CallOption) (*CheckValidCredsResponse, error)
}

type dataTransferServiceClient struct {
	cc *grpc.ClientConn
}

func NewDataTransferServiceClient(cc *grpc.ClientConn) DataTransferServiceClient {
	return &dataTransferServiceClient{cc}
}

func (c *dataTransferServiceClient) GetDataSource(ctx context.Context, in *GetDataSourceRequest, opts ...grpc.CallOption) (*DataSource, error) {
	out := new(DataSource)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetDataSource", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListDataSources(ctx context.Context, in *ListDataSourcesRequest, opts ...grpc.CallOption) (*ListDataSourcesResponse, error) {
	out := new(ListDataSourcesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListDataSources", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CreateTransferConfig(ctx context.Context, in *CreateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CreateTransferConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) UpdateTransferConfig(ctx context.Context, in *UpdateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/UpdateTransferConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteTransferConfig(ctx context.Context, in *DeleteTransferConfigRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error) {
	out := new(google_protobuf5.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetTransferConfig(ctx context.Context, in *GetTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferConfigs(ctx context.Context, in *ListTransferConfigsRequest, opts ...grpc.CallOption) (*ListTransferConfigsResponse, error) {
	out := new(ListTransferConfigsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferConfigs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ScheduleTransferRuns(ctx context.Context, in *ScheduleTransferRunsRequest, opts ...grpc.CallOption) (*ScheduleTransferRunsResponse, error) {
	out := new(ScheduleTransferRunsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ScheduleTransferRuns", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetTransferRun(ctx context.Context, in *GetTransferRunRequest, opts ...grpc.CallOption) (*TransferRun, error) {
	out := new(TransferRun)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferRun", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteTransferRun(ctx context.Context, in *DeleteTransferRunRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error) {
	out := new(google_protobuf5.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferRun", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferRuns(ctx context.Context, in *ListTransferRunsRequest, opts ...grpc.CallOption) (*ListTransferRunsResponse, error) {
	out := new(ListTransferRunsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferRuns", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferLogs(ctx context.Context, in *ListTransferLogsRequest, opts ...grpc.CallOption) (*ListTransferLogsResponse, error) {
	out := new(ListTransferLogsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferLogs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CheckValidCreds(ctx context.Context, in *CheckValidCredsRequest, opts ...grpc.CallOption) (*CheckValidCredsResponse, error) {
	out := new(CheckValidCredsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CheckValidCreds", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for DataTransferService service

type DataTransferServiceServer interface {
	// Retrieves a supported data source and returns its settings,
	// which can be used for UI rendering.
	GetDataSource(context.Context, *GetDataSourceRequest) (*DataSource, error)
	// Lists supported data sources and returns their settings,
	// which can be used for UI rendering.
	ListDataSources(context.Context, *ListDataSourcesRequest) (*ListDataSourcesResponse, error)
	// Creates a new data transfer configuration.
	CreateTransferConfig(context.Context, *CreateTransferConfigRequest) (*TransferConfig, error)
	// Updates a data transfer configuration.
	// All fields must be set, even if they are not updated.
	UpdateTransferConfig(context.Context, *UpdateTransferConfigRequest) (*TransferConfig, error)
	// Deletes a data transfer configuration,
	// including any associated transfer runs and logs.
	DeleteTransferConfig(context.Context, *DeleteTransferConfigRequest) (*google_protobuf5.Empty, error)
	// Returns information about a data transfer config.
	GetTransferConfig(context.Context, *GetTransferConfigRequest) (*TransferConfig, error)
	// Returns information about all data transfers in the project.
	ListTransferConfigs(context.Context, *ListTransferConfigsRequest) (*ListTransferConfigsResponse, error)
	// Creates transfer runs for a time range [start_time, end_time].
	// For each date - or whatever granularity the data source supports - in the
	// range, one transfer run is created.
	// Note that runs are created per UTC time in the time range.
	ScheduleTransferRuns(context.Context, *ScheduleTransferRunsRequest) (*ScheduleTransferRunsResponse, error)
	// Returns information about the particular transfer run.
	GetTransferRun(context.Context, *GetTransferRunRequest) (*TransferRun, error)
	// Deletes the specified transfer run.
	DeleteTransferRun(context.Context, *DeleteTransferRunRequest) (*google_protobuf5.Empty, error)
	// Returns information about running and completed jobs.
	ListTransferRuns(context.Context, *ListTransferRunsRequest) (*ListTransferRunsResponse, error)
	// Returns user facing log messages for the data transfer run.
	ListTransferLogs(context.Context, *ListTransferLogsRequest) (*ListTransferLogsResponse, error)
	// Returns true if valid credentials exist for the given data source and
	// requesting user.
	// Some data sources doesn't support service account, so we need to talk to
	// them on behalf of the end user. This API just checks whether we have OAuth
	// token for the particular user, which is a pre-requisite before user can
	// create a transfer config.
	CheckValidCreds(context.Context, *CheckValidCredsRequest) (*CheckValidCredsResponse, error)
}

func RegisterDataTransferServiceServer(s *grpc.Server, srv DataTransferServiceServer) {
	s.RegisterService(&_DataTransferService_serviceDesc, srv)
}

func _DataTransferService_GetDataSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetDataSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetDataSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetDataSource(ctx, req.(*GetDataSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListDataSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListDataSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListDataSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListDataSources(ctx, req.(*ListDataSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CreateTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CreateTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CreateTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CreateTransferConfig(ctx, req.(*CreateTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_UpdateTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).UpdateTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/UpdateTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).UpdateTransferConfig(ctx, req.(*UpdateTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteTransferConfig(ctx, req.(*DeleteTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetTransferConfig(ctx, req.(*GetTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferConfigs(ctx, req.(*ListTransferConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ScheduleTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScheduleTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ScheduleTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ScheduleTransferRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ScheduleTransferRuns(ctx, req.(*ScheduleTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetTransferRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetTransferRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetTransferRun(ctx, req.(*GetTransferRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteTransferRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteTransferRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteTransferRun(ctx, req.(*DeleteTransferRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferRuns(ctx, req.(*ListTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferLogs(ctx, req.(*ListTransferLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CheckValidCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckValidCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CheckValidCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CheckValidCreds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CheckValidCreds(ctx, req.(*CheckValidCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataTransferService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.datatransfer.v1.DataTransferService",
	HandlerType: (*DataTransferServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDataSource",
			Handler:    _DataTransferService_GetDataSource_Handler,
		},
		{
			MethodName: "ListDataSources",
			Handler:    _DataTransferService_ListDataSources_Handler,
		},
		{
			MethodName: "CreateTransferConfig",
			Handler:    _DataTransferService_CreateTransferConfig_Handler,
		},
		{
			MethodName: "UpdateTransferConfig",
			Handler:    _DataTransferService_UpdateTransferConfig_Handler,
		},
		{
			MethodName: "DeleteTransferConfig",
			Handler:    _DataTransferService_DeleteTransferConfig_Handler,
		},
		{
			MethodName: "GetTransferConfig",
			Handler:    _DataTransferService_GetTransferConfig_Handler,
		},
		{
			MethodName: "ListTransferConfigs",
			Handler:    _DataTransferService_ListTransferConfigs_Handler,
		},
		{
			MethodName: "ScheduleTransferRuns",
			Handler:    _DataTransferService_ScheduleTransferRuns_Handler,
		},
		{
			MethodName: "GetTransferRun",
			Handler:    _DataTransferService_GetTransferRun_Handler,
		},
		{
			MethodName: "DeleteTransferRun",
			Handler:    _DataTransferService_DeleteTransferRun_Handler,
		},
		{
			MethodName: "ListTransferRuns",
			Handler:    _DataTransferService_ListTransferRuns_Handler,
		},
		{
			MethodName: "ListTransferLogs",
			Handler:    _DataTransferService_ListTransferLogs_Handler,
		},
		{
			MethodName: "CheckValidCreds",
			Handler:    _DataTransferService_CheckValidCreds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/datatransfer/v1/datatransfer.proto",
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/datatransfer/v1/datatransfer.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 2233 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0x4f, 0x73, 0x1b, 0x49,
	0x15, 0x67, 0xfc, 0x5f, 0x4f, 0xb6, 0x24, 0x77, 0x1c, 0x67, 0x22, 0x67, 0x17, 0xef, 0x14, 0x49,
	0x79, 0x0d, 0x48, 0x58, 0xd9, 0x2c, 0xbb, 0xce, 0x6e, 0x52, 0xb2, 0x24, 0x3b, 0x02, 0xdb, 0x72,
	0x46, 0x72, 0x02, 0xa9, 0x14, 0x43, 0x47, 0xd3, 0x96, 0x67, 0x3d, 0x9a, 0x99, 0x4c, 0xcf, 0x38,
	0x71, 0xa8, 0x5c, 0xf8, 0x0a, 0x1c, 0xa0, 0x8a, 0x0f, 0x00, 0xc5, 0x05, 0x8e, 0x7c, 0x00, 0x8a,
	0x02, 0xae, 0x1c, 0xf8, 0x53, 0x14, 0x1c, 0xa0, 0xa8, 0xe2, 0x02, 0x5f, 0x80, 0x03, 0xd5, 0x3d,
	0x3d, 0xd2, 0x48, 0x1a, 0xdb, 0x92, 0x4c, 0xd5, 0x9e, 0x3c, 0xdd, 0xef, 0xbd, 0xee, 0xf7, 0xeb,
	0xf7, 0xa7, 0x7f, 0x2d, 0xc3, 0x47, 0x2d, 0xdb, 0x6e, 0x99, 0x24, 0xdf, 0x34, 0x6d, 0x5f, 0xcf,
	0xbf, 0x30, 0x5a, 0x2f, 0x7d, 0xe2, 0x9e, 0xe5, 0x75, 0xec, 0x61, 0xcf, 0xc5, 0x16, 0x3d, 0x22,
	0x6e, 0xfe, 0x74, 0xa3, 0x67, 0x9c, 0x73, 0x5c, 0xdb, 0xb3, 0xd1, 0xed, 0xc0, 0x32, 0xc7, 0x2d,
	0x73, 0xa1, 0x65, 0xae, 0x47, 0xf3, 0x74, 0x23, 0x7b, 0x4b, 0x6c, 0x80, 0x1d, 0x23, 0x8f, 0x2d,
	0xcb, 0xf6, 0xb0, 0x67, 0xd8, 0x16, 0x0d, 0x16, 0xc9, 0x7e, 0x30, 0xdc, 0xf6, 0xbd, 0x5b, 0x67,
	0xdf, 0x15, 0x56, 0x7c, 0xf4, 0xc2, 0x3f, 0xca, 0xeb, 0xbe, 0xcb, 0x97, 0x15, 0xf2, 0x95, 0x7e,
	0x39, 0x69, 0x3b, 0xde, 0x99, 0x10, 0xae, 0xf6, 0x0b, 0x8f, 0x0c, 0x62, 0xea, 0x5a, 0x1b, 0xd3,
	0x13, 0xa1, 0xf1, 0xc5, 0x7e, 0x0d, 0xcf, 0x68, 0x13, 0xea, 0xe1, 0xb6, 0x73, 0xde, 0xfe, 0xaf,
	0x5c, 0xec, 0x38, 0xc4, 0x15, 0xa8, 0x94, 0x9f, 0xce, 0xc0, 0xb5, 0x32, 0xf6, 0x70, 0xdd, 0xf6,
	0xdd, 0x26, 0x39, 0xc0, 0x2e, 0x6e, 0x13, 0x8f, 0xb8, 0xe8, 0x26, 0xcc, 0x39, 0x6c, 0xa0, 0x19,
	0xba, 0x2c, 0xad, 0x4a, 0x6b, 0x09, 0x75, 0x96, 0x8f, 0xab, 0x3a, 0x7a, 0x0f, 0xe6, 0x75, 0x83,
	0x3a, 0x26, 0x3e, 0xd3, 0x2c, 0xdc, 0x26, 0xf2, 0x04, 0x17, 0x27, 0xc5, 0xdc, 0x3e, 0x6e, 0x13,
	0xb4, 0x0a, 0x49, 0x9d, 0xd0, 0xa6, 0x6b, 0x38, 0x0c, 0xaa, 0x3c, 0x29, 0x34, 0xba, 0x53, 0xa8,
	0x0e, 0x53, 0xde, 0x99, 0x43, 0xe4, 0xa9, 0x55, 0x69, 0x2d, 0x55, 0x78, 0x98, 0x1b, 0x2a, 0x42,
	0xb9, 0x18, 0x4f, 0x73, 0x8d, 0x33, 0x87, 0xa8, 0x7c, 0x31, 0x94, 0x85, 0x39, 0x97, 0xbc, 0xf4,
	0x0d, 0x97, 0xe8, 0xf2, 0xf4, 0xaa, 0xb4, 0x36, 0xa7, 0x76, 0xc6, 0x81, 0xcc, 0x21, 0xd8, 0x23,
	0xba, 0x3c, 0x13, 0xca, 0x82, 0x31, 0x7a, 0x1f, 0x32, 0xa7, 0xd8, 0x34, 0x74, 0x1e, 0x18, 0xcd,
	0x25, 0x2d, 0xf2, 0x5a, 0x9e, 0xe5, 0x3e, 0xa7, 0xbb, 0xf3, 0x2a, 0x9b, 0x46, 0xb7, 0x21, 0x85,
	0x4d, 0xd3, 0x7e, 0x45, 0x74, 0xed, 0x14, 0x9b, 0x3e, 0xa1, 0xf2, 0xdc, 0xea, 0xe4, 0x5a, 0x42,
	0x5d, 0x10, 0xb3, 0x4f, 0xf8, 0x24, 0xfa, 0x18, 0x12, 0x6d, 0xc3, 0x0a, 0x54, 0xe4, 0xc4, 0xaa,
	0xb4, 0x96, 0x2c, 0xdc, 0x0a, 0x31, 0x86, 0xa1, 0xc8, 0x95, 0x6d, 0xff, 0x85, 0x49, 0xb8, 0x85,
	0x3a, 0xd7, 0x36, 0x2c, 0xfe, 0xc5, 0x4d, 0xf1, 0x6b, 0x61, 0x0a, 0x43, 0x99, 0xe2, 0xd7, 0x81,
	0xa9, 0x0a, 0x33, 0x3c, 0x43, 0xa8, 0x9c, 0x5c, 0x9d, 0x5c, 0x4b, 0x16, 0x36, 0xc7, 0x3f, 0x56,
	0x55, 0xac, 0x84, 0xee, 0xc1, 0x72, 0xe4, 0x6c, 0xa2, 0x51, 0x9d, 0xe7, 0x27, 0x74, 0xbd, 0x2b,
	0x2d, 0x47, 0xe2, 0x9b, 0x83, 0x6b, 0x11, 0xb3, 0x63, 0x62, 0x3a, 0x9a, 0xef, 0x9a, 0xf2, 0x02,
	0xb7, 0x59, 0xec, 0x8a, 0x1e, 0x11, 0xd3, 0x39, 0x74, 0x4d, 0x74, 0x0b, 0x12, 0x46, 0xbb, 0xed,
	0x7b, 0xf8, 0x85, 0x49, 0xe4, 0x14, 0x8f, 0x4f, 0x77, 0x02, 0xc9, 0x30, 0xeb, 0x92, 0xa6, 0xef,
	0x52, 0x22, 0xa7, 0xb9, 0x2c, 0x1c, 0x2a, 0x06, 0x4c, 0xb1, 0x04, 0x40, 0x4b, 0x90, 0x69, 0x7c,
	0xfb, 0xa0, 0xa2, 0x1d, 0xee, 0xd7, 0x0f, 0x2a, 0xa5, 0xea, 0x76, 0xb5, 0x52, 0xce, 0x7c, 0x01,
	0x01, 0xcc, 0xd4, 0x1b, 0x6a, 0x75, 0x7f, 0x27, 0x23, 0xa1, 0x24, 0xcc, 0x56, 0xf7, 0x1b, 0x95,
	0x9d, 0x8a, 0x9a, 0x99, 0x60, 0x82, 0x72, 0xed, 0x70, 0x6b, 0xb7, 0x92, 0x99, 0x64, 0x82, 0xad,
	0x5a, 0x6d, 0xb7, 0x52, 0xdc, 0xcf, 0x4c, 0x31, 0x81, 0x5a, 0x29, 0xd5, 0xd4, 0x72, 0x66, 0x1a,
	0x2d, 0x40, 0xe2, 0x60, 0xf7, 0xb0, 0xae, 0x1d, 0x14, 0x77, 0x2a, 0x99, 0x19, 0xe5, 0xbf, 0x09,
	0x80, 0xee, 0x49, 0x21, 0x04, 0x53, 0x3c, 0xfd, 0x83, 0xea, 0xe0, 0xdf, 0xe8, 0x4b, 0x90, 0x62,
	0x67, 0xab, 0x51, 0xae, 0xc2, 0x6a, 0x27, 0x28, 0x8e, 0x79, 0xbd, 0x63, 0x17, 0x53, 0x40, 0x93,
	0x97, 0x16, 0xd0, 0xd4, 0x60, 0x01, 0xad, 0x40, 0xa2, 0x69, 0x1a, 0xc4, 0xf2, 0xd8, 0x2e, 0xd3,
	0x5c, 0x3e, 0x17, 0x4c, 0x54, 0x75, 0xb4, 0x0c, 0x33, 0xb4, 0x69, 0x3b, 0x84, 0xca, 0x33, 0x3c,
	0x3b, 0xc5, 0x08, 0x7d, 0x0b, 0x16, 0xc2, 0xb8, 0x6b, 0xbc, 0xfc, 0x66, 0x79, 0xf9, 0xdd, 0x1d,
	0x32, 0x4f, 0x1a, 0xe2, 0x9b, 0x97, 0xdc, 0xbc, 0x17, 0x19, 0xa1, 0x07, 0xb0, 0x42, 0x7d, 0xc7,
	0xb1, 0x5d, 0x8f, 0x6a, 0x6d, 0xdf, 0xf4, 0x0c, 0xc7, 0x24, 0x5a, 0xa8, 0xc1, 0x8a, 0x84, 0x45,
	0xed, 0x66, 0xa8, 0xb2, 0x27, 0x34, 0xc2, 0x05, 0x29, 0xfa, 0x10, 0x6e, 0xf8, 0x8e, 0x8e, 0x3d,
	0xa2, 0xe9, 0x04, 0xeb, 0xa6, 0x61, 0x11, 0x8d, 0x92, 0xa6, 0x6d, 0xe9, 0x94, 0x97, 0xcf, 0xb4,
	0x7a, 0x3d, 0x10, 0x97, 0x85, 0xb4, 0x1e, 0x08, 0x59, 0xe9, 0xea, 0xe4, 0x08, 0xfb, 0xa6, 0xa7,
	0xd1, 0xe6, 0x31, 0xd1, 0x7d, 0x33, 0x28, 0x9a, 0x84, 0x9a, 0x16, 0xf3, 0x75, 0x31, 0x8d, 0x3e,
	0x02, 0xb9, 0xe3, 0x62, 0xd3, 0xa7, 0x9e, 0xdd, 0xee, 0x9a, 0x24, 0xb9, 0x7f, 0xcb, 0xa1, 0xbc,
	0xc4, 0xc5, 0x1d, 0xcb, 0x67, 0x00, 0x4e, 0x58, 0x18, 0x54, 0x9e, 0xbf, 0x72, 0x6d, 0x45, 0x56,
	0x63, 0x8d, 0xb6, 0xaf, 0x3a, 0x66, 0x8f, 0x45, 0x4d, 0xb8, 0x80, 0xb0, 0xef, 0x1d, 0xdb, 0xae,
	0xf1, 0x26, 0x28, 0x23, 0x1e, 0xb2, 0x14, 0x0f, 0x59, 0x69, 0xe4, 0xed, 0x73, 0xc5, 0xe8, 0x5a,
	0x3c, 0x84, 0x8b, 0xb8, 0x7f, 0x0a, 0xb5, 0x61, 0x91, 0x67, 0xb0, 0x4b, 0x8e, 0x5c, 0x42, 0x8f,
	0x83, 0x2d, 0xd3, 0x7c, 0xcb, 0xe2, 0xe8, 0x5b, 0xb2, 0x4f, 0x35, 0x58, 0x89, 0x6f, 0x98, 0xd6,
	0x7b, 0x27, 0xd0, 0x36, 0xac, 0x86, 0xe1, 0xeb, 0xd9, 0xf6, 0x95, 0x61, 0xe9, 0xf6, 0x2b, 0x4d,
	0xc7, 0x67, 0x54, 0xce, 0xf0, 0xf8, 0xdf, 0x12, 0x7a, 0x91, 0x25, 0x9f, 0x72, 0xa5, 0x32, 0x3e,
	0xa3, 0xe8, 0x6b, 0xb0, 0xd4, 0xc6, 0x96, 0x8f, 0x4d, 0xcd, 0xf5, 0x2d, 0xaa, 0xe9, 0x06, 0x65,
	0x7d, 0x43, 0x97, 0x17, 0x79, 0x5c, 0x51, 0x20, 0x53, 0x7d, 0x8b, 0x96, 0x85, 0x04, 0x1d, 0xc2,
	0xcd, 0xb6, 0x61, 0x19, 0x6d, 0xbf, 0x9b, 0x05, 0x9a, 0x61, 0x79, 0xc4, 0x3d, 0xc5, 0xa6, 0x8c,
	0x78, 0xdb, 0xbd, 0x39, 0xd8, 0x76, 0xc5, 0xe5, 0xad, 0xde, 0x10, 0xb6, 0x61, 0x8a, 0x54, 0x85,
	0xa5, 0x42, 0x61, 0x71, 0xe0, 0x9c, 0x91, 0x02, 0xef, 0x16, 0x0f, 0x1b, 0x8f, 0x6a, 0x6a, 0xf5,
	0x59, 0xb1, 0x51, 0xad, 0xed, 0x6b, 0x31, 0xad, 0x6a, 0x19, 0x50, 0xaf, 0x4e, 0xa9, 0x56, 0xae,
	0x64, 0x24, 0x66, 0xbb, 0x53, 0xab, 0xed, 0xec, 0x56, 0x34, 0xde, 0x8b, 0x62, 0x74, 0x26, 0x94,
	0x26, 0xa4, 0xfb, 0x4e, 0x1a, 0xbd, 0x07, 0xef, 0x94, 0x8b, 0x8d, 0xa2, 0xa6, 0x56, 0xb6, 0xd5,
	0x4a, 0xfd, 0x51, 0xdc, 0x8e, 0x08, 0x52, 0xf5, 0xdd, 0x6a, 0xb9, 0xba, 0xbf, 0xa3, 0x3d, 0xad,
	0xee, 0x97, 0x6b, 0x4f, 0x33, 0x12, 0xba, 0x09, 0xd7, 0x4b, 0x87, 0xf5, 0x46, 0x6d, 0x4f, 0xeb,
	0x13, 0x4d, 0x28, 0xeb, 0xb0, 0xb4, 0x43, 0xbc, 0x6e, 0x70, 0x55, 0xf2, 0xd2, 0x27, 0xd4, 0x8b,
	0xeb, 0x83, 0x8a, 0x09, 0xcb, 0xbb, 0x06, 0x8d, 0x28, 0xd3, 0x50, 0x7b, 0x19, 0x66, 0x1c, 0xec,
	0x12, 0xcb, 0x13, 0xfa, 0x62, 0x84, 0xde, 0x61, 0x25, 0xd6, 0x22, 0x9a, 0x67, 0x9f, 0x90, 0x90,
	0x30, 0x24, 0xd8, 0x4c, 0x83, 0x4d, 0xb0, 0x6e, 0xc7, 0xc5, 0xd4, 0x78, 0x13, 0x70, 0x86, 0x69,
	0x75, 0x8e, 0x4d, 0xd4, 0x8d, 0x37, 0x44, 0xf9, 0xa1, 0x04, 0x37, 0x06, 0xb6, 0xa3, 0x8e, 0x6d,
	0x51, 0x82, 0x1a, 0x30, 0x1f, 0xe9, 0xc8, 0x54, 0x96, 0x78, 0xf1, 0x6e, 0x8c, 0x9c, 0xca, 0x6a,
	0xb2, 0xdb, 0xc2, 0x29, 0xba, 0x03, 0x69, 0x8b, 0xbc, 0xf6, 0xb4, 0x88, 0xcb, 0x41, 0xa3, 0x5f,
	0x60, 0xd3, 0x07, 0xa1, 0xdb, 0xca, 0xaf, 0x24, 0x58, 0x29, 0xb9, 0x8c, 0x64, 0x84, 0x9d, 0xae,
	0x64, 0x5b, 0x47, 0x46, 0xeb, 0xb2, 0xd3, 0xf8, 0x0e, 0xa4, 0x3b, 0x7d, 0xba, 0xc9, 0x2d, 0xf8,
	0xfa, 0xc9, 0xc2, 0xbd, 0x11, 0x3b, 0xb5, 0xd8, 0x2e, 0xe5, 0xf5, 0x8c, 0xd1, 0x57, 0xfb, 0x3b,
	0x4b, 0xd3, 0xd6, 0xc3, 0x7b, 0xa8, 0xb7, 0x29, 0x94, 0x6c, 0x9d, 0x28, 0xff, 0x92, 0x60, 0xe5,
	0x90, 0xb7, 0xdf, 0x78, 0x18, 0x31, 0xee, 0x4a, 0x9f, 0x9f, 0xbb, 0xe8, 0x3e, 0x24, 0xc5, 0x5d,
	0xc2, 0x98, 0x32, 0x4f, 0x97, 0x64, 0x21, 0x3b, 0x50, 0xcc, 0xdb, 0x8c, 0xe0, 0xec, 0x61, 0x7a,
	0xa2, 0x42, 0xa0, 0xce, 0xbe, 0x95, 0x1c, 0xc8, 0x3b, 0xc4, 0x8b, 0xc7, 0x19, 0x97, 0xea, 0x1b,
	0xb0, 0x52, 0x26, 0x26, 0x39, 0xef, 0x68, 0xe2, 0x4c, 0xbe, 0x0c, 0xd7, 0x23, 0x5b, 0xa8, 0xbe,
	0x75, 0x91, 0x72, 0x0e, 0xe4, 0xde, 0xf5, 0x2f, 0xd1, 0xff, 0x91, 0x04, 0x59, 0x56, 0x0c, 0xbd,
	0xee, 0x5c, 0x5a, 0x7f, 0x77, 0x20, 0xdd, 0xcb, 0x5c, 0xa8, 0x3c, 0x11, 0x10, 0xdb, 0x28, 0x75,
	0xa1, 0x57, 0xaa, 0xd3, 0x9f, 0x48, 0xb0, 0x12, 0xeb, 0x9a, 0xa8, 0xd5, 0xef, 0x42, 0xa6, 0x2f,
	0x8d, 0xc2, 0x7a, 0x1d, 0x33, 0x8f, 0xd2, 0xbd, 0x79, 0x34, 0x7c, 0xdd, 0xfe, 0x75, 0x22, 0xe8,
	0x28, 0x91, 0x33, 0xbf, 0xf4, 0x04, 0x77, 0x61, 0x86, 0x7a, 0xd8, 0x23, 0xc1, 0xc1, 0xa5, 0x0a,
	0x1f, 0x8c, 0xe8, 0x73, 0x9d, 0x19, 0xab, 0x62, 0x8d, 0xab, 0x9c, 0x33, 0xfa, 0x0c, 0x92, 0xae,
	0x6f, 0x69, 0xd8, 0xf3, 0xd8, 0x63, 0x92, 0x93, 0xc3, 0x54, 0xa1, 0x3a, 0xa4, 0x3b, 0xe7, 0xc0,
	0xce, 0xa9, 0xbe, 0x55, 0x0c, 0x16, 0x54, 0xc1, 0xed, 0x7c, 0x2b, 0xf7, 0x00, 0xba, 0x12, 0xb4,
	0x02, 0x37, 0xd4, 0xc3, 0x7d, 0xad, 0xd8, 0x68, 0x54, 0xf6, 0x0e, 0x1a, 0x83, 0x64, 0x7c, 0xb7,
	0xd8, 0xa8, 0xd4, 0x1b, 0x19, 0x49, 0xf9, 0xb1, 0x04, 0xf2, 0xe0, 0x4e, 0x22, 0x0f, 0x9e, 0x46,
	0x58, 0x2a, 0xbb, 0xce, 0x45, 0x12, 0x14, 0x46, 0x3c, 0x50, 0x56, 0x28, 0x1d, 0x92, 0xca, 0x36,
	0x18, 0x3a, 0xfc, 0x7f, 0x96, 0x7a, 0xc3, 0xbf, 0x6b, 0xb7, 0x46, 0xbc, 0xc0, 0xa6, 0x2e, 0x0c,
	0xd8, 0x74, 0x5f, 0xc0, 0x4e, 0x60, 0xa1, 0x4d, 0x28, 0xe5, 0xe6, 0x67, 0x21, 0x6b, 0x4f, 0x15,
	0xb6, 0x47, 0x04, 0xbc, 0x17, 0xac, 0x91, 0x13, 0x7f, 0xeb, 0xe4, 0x94, 0xb8, 0x86, 0x77, 0xa6,
	0xce, 0x8b, 0xc5, 0x19, 0x31, 0xa0, 0xac, 0x0a, 0xe5, 0x41, 0x70, 0xe2, 0xe8, 0x9b, 0xb0, 0xd8,
	0x39, 0x7a, 0x61, 0x15, 0x1e, 0xff, 0x87, 0xe3, 0x79, 0xa3, 0x76, 0x6a, 0x5a, 0x4c, 0x0c, 0x1f,
	0x86, 0xaf, 0xc0, 0x72, 0xe9, 0x98, 0x34, 0x4f, 0x9e, 0xb0, 0xd7, 0x62, 0xc9, 0x25, 0x3a, 0xbd,
	0xa8, 0xf1, 0x15, 0xe1, 0xc6, 0x80, 0xb6, 0x40, 0x75, 0x07, 0xd2, 0xc7, 0x98, 0x6a, 0xfc, 0xd5,
	0xa9, 0x35, 0x99, 0x88, 0x5b, 0xce, 0xa9, 0x0b, 0xc7, 0x98, 0x76, 0xf5, 0x79, 0x83, 0x0a, 0x19,
	0xdd, 0x28, 0xa5, 0xff, 0x31, 0x00, 0xf5, 0xb0, 0xeb, 0x69, 0x9e, 0x21, 0x7e, 0x0f, 0x89, 0xbb,
	0x6f, 0x1a, 0xe1, 0x4f, 0x33, 0x6a, 0x82, 0x6b, 0xb3, 0x31, 0xba, 0x07, 0x73, 0xc4, 0xd2, 0x03,
	0xc3, 0xc9, 0x4b, 0x0d, 0x67, 0x89, 0xa5, 0xb3, 0x91, 0x72, 0x04, 0xb7, 0xe2, 0x1d, 0x15, 0x88,
	0xb7, 0x61, 0xea, 0x8a, 0x95, 0xc3, 0xed, 0x0b, 0x7f, 0xbc, 0x1e, 0xfc, 0x3c, 0xd4, 0x69, 0x52,
	0xc4, 0x3d, 0x35, 0x9a, 0x04, 0xfd, 0x52, 0x82, 0x85, 0x1e, 0x36, 0x88, 0xee, 0x0f, 0xb9, 0x47,
	0x1c, 0x87, 0xcc, 0x8e, 0xce, 0xc7, 0x94, 0xaf, 0x7f, 0xff, 0xf7, 0xff, 0xf8, 0xc1, 0xc4, 0x06,
	0xca, 0xe7, 0x4f, 0x37, 0xf2, 0xdf, 0x63, 0x19, 0xf0, 0xa9, 0xe3, 0xda, 0x9f, 0x91, 0xa6, 0x47,
	0xf3, 0xeb, 0x79, 0xd3, 0x6e, 0x06, 0x3f, 0xde, 0xe5, 0xd7, 0xf3, 0x11, 0xe2, 0x96, 0x5f, 0x7f,
	0x8b, 0x7e, 0x2b, 0x41, 0xba, 0x8f, 0x2d, 0xa2, 0x4f, 0x47, 0x68, 0x8e, 0x83, 0xa4, 0x36, 0xfb,
	0x60, 0x5c, 0xf3, 0x20, 0x5a, 0x7d, 0x58, 0x82, 0xa4, 0x3a, 0x07, 0xcd, 0xdb, 0x28, 0x1c, 0xf4,
	0x37, 0x09, 0x96, 0xe2, 0xf8, 0x25, 0xda, 0x1a, 0xd2, 0xa3, 0x0b, 0xc8, 0x69, 0x76, 0xbc, 0x4b,
	0x57, 0xd9, 0xe5, 0x60, 0xb6, 0x95, 0xbb, 0xc3, 0x80, 0xe9, 0xbb, 0xa0, 0x37, 0xfb, 0x79, 0x24,
	0xfa, 0x8f, 0x04, 0x4b, 0x71, 0xd4, 0x73, 0x68, 0x84, 0x17, 0xf0, 0xd6, 0x71, 0x11, 0x3e, 0xe7,
	0x08, 0x9f, 0x14, 0x4a, 0x1c, 0x61, 0x9f, 0xc7, 0xb9, 0x8b, 0x52, 0xb1, 0x0f, 0x6e, 0x7e, 0xfd,
	0xed, 0x20, 0xe2, 0x9f, 0x4b, 0xb0, 0x14, 0xc7, 0x28, 0x87, 0x46, 0x7c, 0x01, 0x1d, 0xcd, 0x2e,
	0x0f, 0x34, 0x97, 0x4a, 0xdb, 0xf1, 0xce, 0x94, 0xfb, 0x1c, 0xd2, 0xbd, 0xf5, 0xbb, 0x97, 0x56,
	0xd3, 0x20, 0x04, 0xf4, 0x1b, 0x09, 0x16, 0x07, 0x38, 0x33, 0x7a, 0x38, 0x7c, 0x43, 0xf8, 0xbf,
	0x46, 0x47, 0x40, 0x41, 0x63, 0x41, 0xf9, 0x93, 0x04, 0xd7, 0x62, 0x28, 0x2a, 0x2a, 0x8e, 0xc1,
	0x9e, 0x7a, 0x99, 0x77, 0x76, 0xeb, 0x2a, 0x4b, 0x88, 0x46, 0xd1, 0x8b, 0x6d, 0xb4, 0xda, 0x42,
	0xff, 0x96, 0x60, 0x29, 0xee, 0xd2, 0x18, 0x3a, 0xb1, 0x2e, 0xb8, 0x1a, 0xb3, 0xa5, 0x2b, 0xad,
	0x21, 0xe0, 0xed, 0x71, 0x78, 0x3b, 0xca, 0xd6, 0xe5, 0xf0, 0xe2, 0x4a, 0x29, 0xfc, 0x1d, 0x87,
	0xad, 0xb9, 0x29, 0xad, 0xa3, 0x5f, 0x4b, 0x90, 0xea, 0x7d, 0x68, 0xa1, 0x4f, 0x46, 0x4f, 0xca,
	0xee, 0x7b, 0x2b, 0x3b, 0xc6, 0x3d, 0xaa, 0x6c, 0x71, 0x4c, 0x9f, 0xa0, 0xcd, 0xd1, 0xd3, 0x31,
	0xcf, 0xae, 0x60, 0x96, 0x95, 0xbf, 0x90, 0x60, 0x71, 0xe0, 0x11, 0x38, 0x74, 0x81, 0x9d, 0xf7,
	0x7c, 0x3c, 0xb7, 0x19, 0x08, 0x97, 0xd7, 0xaf, 0xe2, 0xf2, 0x1f, 0x24, 0xc8, 0xf4, 0x13, 0x7c,
	0xf4, 0xe0, 0x6a, 0x6f, 0x90, 0xec, 0xc3, 0xb1, 0xed, 0x45, 0x82, 0xf5, 0x06, 0x63, 0xd4, 0x04,
	0xe3, 0xe0, 0xd0, 0x3f, 0xfb, 0x90, 0x31, 0xfe, 0x3c, 0x16, 0xb2, 0xc8, 0xab, 0x62, 0x2c, 0x64,
	0x51, 0xe2, 0xae, 0x3c, 0xe6, 0xc8, 0xbe, 0x89, 0xaa, 0xe3, 0x20, 0x0b, 0xa3, 0xd6, 0x91, 0x70,
	0x4c, 0x7f, 0x91, 0x20, 0xdd, 0xc7, 0xa8, 0x87, 0x26, 0x4a, 0xf1, 0xbc, 0x7d, 0x68, 0xa2, 0x74,
	0x0e, 0x91, 0x57, 0xbe, 0xc1, 0x51, 0x96, 0x95, 0x87, 0x23, 0x92, 0xbe, 0xcd, 0x66, 0xef, 0x82,
	0x9b, 0xd2, 0xfa, 0xd6, 0xdf, 0x25, 0x78, 0xbf, 0x69, 0xb7, 0x87, 0xf3, 0x68, 0x6b, 0x31, 0xca,
	0x82, 0x0f, 0x58, 0xbd, 0x1c, 0x48, 0xcf, 0x1e, 0x0b, 0xdb, 0x96, 0x6d, 0x62, 0xab, 0x95, 0xb3,
	0xdd, 0x56, 0xbe, 0x45, 0x2c, 0x5e, 0x4d, 0xf9, 0x40, 0x84, 0x1d, 0x83, 0x5e, 0xf2, 0x1f, 0xe3,
	0xfb, 0xd1, 0xf1, 0xcf, 0x26, 0x6e, 0xef, 0x04, 0x6b, 0x96, 0xb8, 0x3f, 0x5b, 0x46, 0xeb, 0x31,
	0xf7, 0x27, 0xba, 0x7d, 0xee, 0xc9, 0xc6, 0xef, 0x42, 0xbd, 0xe7, 0x5c, 0xef, 0x79, 0xa8, 0xf7,
	0x3c, 0xaa, 0xf7, 0xfc, 0xc9, 0xc6, 0x8b, 0x19, 0xee, 0xcd, 0xdd, 0xff, 0x05, 0x00, 0x00, 0xff,
	0xff, 0xa8, 0x04, 0x35, 0x66, 0x3d, 0x1f, 0x00, 0x00,
}
