//
// BAGEL - Parallel electron correlation program.
// Filename: _spin2root_6.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root6(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[6] = {2.111413585358230e+00,7.026018149250148e-01,4.320708798707306e+00,7.485045658702520e+00,1.192096697299598e+01,
    1.845926316931095e+01};
  constexpr double aw[6] = {3.326244946046376e-01,1.516227523450486e-01,1.582847754169486e-01,2.141478108631498e-02,7.202345275522768e-04,
    3.156109066429148e-06};
  constexpr double x[2304] = {  1.753898249821826e-01, -5.365834224456515e-03,  1.113427896072529e-04, -1.731775036470972e-06,  1.730171126324275e-08,
  3.017429896035392e-11, -6.275733462428301e-12,  1.668833097305327e-13, -2.575509806094628e-15,  1.351975006434887e-17,  5.782990154822236e-19, -2.252071285565989e-20,
  4.914236793575537e-01, -1.256057032026019e-02,  1.639841753579186e-04, -1.367281777645388e-07, -4.243923673365225e-08,  7.739192541789510e-10,  1.693643771833336e-12,
 -3.362627650613017e-13,  5.536482788550405e-15,  4.259976716738348e-17, -3.355773022403107e-18,  4.572868374744003e-20,  9.005312641672009e-01, -1.700841233570506e-02,
  4.713806377010221e-05,  3.206140085974227e-06, -2.621394891144299e-08, -1.028020052834947e-09,  1.466746250993118e-11,  3.809592881323789e-13, -8.458622274740462e-15,
 -1.434525262286096e-16,  4.840093510051019e-18,  5.021698286390297e-20,  1.331708363069783e+00, -1.551888248046778e-02, -1.317574500590415e-04,  1.861399612303603e-06,
  5.724533751586087e-08, -6.304759421316727e-11, -2.377725861317125e-11, -2.376069106486472e-13,  8.220665975278874e-15,  2.098134524735722e-16, -1.656322118115720e-18,
 -1.278839059006725e-19,  1.703834809409949e+00, -8.917070562129328e-03, -1.657298905708560e-04, -1.765873969517703e-06,  6.019664310083067e-09,  7.227116323712397e-10,
  1.516904572809979e-11,  8.711352203665949e-14, -4.250738529142338e-15, -1.486767693360025e-16, -1.955401669946531e-18,  1.812557337316119e-20,  1.941008867465685e+00,
 -2.040985316964583e-03, -5.146275027500621e-05, -1.101011420687924e-06, -2.073403494130042e-08, -3.397970592338144e-10, -4.569459053847205e-12, -3.888474845962648e-14,
  2.644682495433421e-16,  2.270953988026383e-17,  6.755665425408472e-19,  1.465511118578810e-20,  1.555830040024080e-01, -4.553511116021671e-03,  9.221981250228321e-05,
 -1.456875159093903e-06,  1.673173522939080e-08, -7.311582609655803e-11, -2.661371776672417e-12,  9.511920498500221e-14, -1.860670744183535e-15,  2.222668220310514e-17,
 -2.963240436756694e-20, -6.923807797411245e-21,  4.437800082890393e-01, -1.126562702931850e-02,  1.587793541542052e-04, -6.925515371073571e-07, -2.721057994543365e-08,
  7.221976926903218e-10, -5.170937367624711e-12, -1.561923762261247e-13,  5.184067449220492e-15, -4.738315577592446e-17, -1.158059658663142e-18,  4.488485344248156e-20,
  8.334835398088083e-01, -1.648596602310787e-02,  8.248714684217431e-05,  2.644389075935538e-06, -4.256338490840747e-08, -5.819576977995057e-10,  2.104828706745662e-11,
  6.698191622794198e-14, -9.962332991706974e-15,  5.565738974853164e-17,  4.242096724500719e-18, -6.702583397564630e-20,  1.267687771660227e+00, -1.646833020836790e-02,
 -1.040718602084616e-04,  2.734587342553015e-06,  4.991964129107115e-08, -6.775654430512345e-10, -2.576741572059357e-11,  1.224549046607214e-13,  1.323149154489679e-14,
  3.430743157363391e-17, -6.701743201708884e-18, -7.028341873010235e-20,  1.665384567649542e+00, -1.032480449564344e-02, -1.857999744501940e-04, -1.533660422215625e-06,
  2.420984907700525e-08,  1.095246919928770e-09,  1.480751149474506e-11, -1.466648799331846e-13, -1.059736348713042e-14, -1.857063669117216e-16,  8.383736059662154e-19,
  1.178348277826852e-19,  1.931929151626317e+00, -2.511732456821807e-03, -6.690986685930137e-05, -1.493423281882512e-06, -2.870589731050352e-08, -4.605958150855865e-10,
 -5.371254094268361e-12, -1.063771724485925e-14,  1.758763516567306e-15,  6.653821842944724e-17,  1.620725682980931e-18,  2.888036935841912e-20,  1.387400090207354e-01,
 -3.881261238384101e-03,  7.628626225776347e-05, -1.203542577693365e-06,  1.481471659061963e-08, -1.110374511514466e-10, -7.156131146870974e-13,  4.771423565834435e-14,
 -1.131741816510260e-15,  1.743321101741202e-17, -1.605667493709699e-19, -6.159961840543521e-23,  4.011962716965671e-01, -1.003498810564165e-02,  1.483080284165382e-04,
 -1.020284403069739e-06, -1.427258328374757e-08,  5.625519368218999e-10, -7.521823746303771e-12, -2.311398772841346e-14,  3.052759940438841e-15, -6.169161474539624e-17,
  2.549093569931353e-19,  1.963055109098729e-20,  7.690431585409260e-01, -1.571142102026438e-02,  1.098388014126914e-04,  1.897732158742904e-06, -4.917360461609796e-08,
 -8.745532949668367e-11,  1.895731095709725e-11, -1.936681509075127e-13, -5.740388538299404e-15,  1.544090518067201e-16,  6.249532906565037e-19, -7.759049223696621e-20,
  1.200374677221610e+00, -1.715730567970404e-02, -6.701531018917084e-05,  3.393312611145323e-06,  3.070693396929958e-08, -1.207796512884656e-09, -1.661433418582704e-11,
  5.109006025252570e-13,  9.369967596316703e-15, -2.423874024039390e-16, -5.700618535507074e-18,  1.215111105990085e-19,  1.621007629276880e+00, -1.187645468188218e-02,
 -2.010999826359194e-04, -9.539146047466313e-07,  4.911345864568431e-08,  1.357370386022768e-09,  5.063019676232383e-12, -5.741423691059249e-13, -1.513271644665072e-14,
 -1.706127393985239e-17,  8.186596119104618e-18,  1.944657675644427e-19,  1.920686160411234e+00, -3.127249248848395e-03, -8.791332336965509e-05, -2.033370682877909e-06,
 -3.918694046496230e-08, -5.839938745311939e-10, -4.416320216235636e-12,  9.919635808903462e-14,  5.660937966265175e-15,  1.602105438447601e-16,  3.107737598099746e-18,
  3.406823566838374e-20,  1.243495361450199e-01, -3.324884440113299e-03,  6.319073589476498e-05, -9.848186529991088e-07,  1.251158859537902e-08, -1.157359931036586e-10,
  1.991375882886850e-13,  2.035299788244735e-14, -6.119627759732791e-16,  1.182382767855923e-17, -1.060023246269881e-19,  1.852563815592259e-21,  3.633472720476372e-01,
 -8.900588692520139e-03,  1.350337811115031e-04, -1.168492631669033e-06, -4.830491404135085e-09,  3.833540827164041e-10, -7.113191357525477e-12,  4.234516090429904e-14,
  1.170964342375407e-15, -3.983460294361357e-17,  7.186614938570069e-19,  3.105543210738337e-21,  7.080802546180294e-01, -1.475497745137937e-02,  1.279074844390221e-04,
  1.119531069373576e-06, -4.689753256358937e-08,  2.868506060559065e-10,  1.179882248974797e-11, -2.893366116459108e-13, -4.087740752406841e-16,  1.275698052254206e-16,
 -1.518493506865587e-18, -1.798657328140764e-20,  1.130940326950331e+00, -1.752414725390049e-02, -2.420051288480604e-05,  3.675068066550861e-06,  3.858434573912041e-09,
 -1.410321528895735e-09,  3.371771653228722e-13,  6.402512472031349e-13, -1.782366575779505e-15, -3.238592512042970e-16,  2.183152888304594e-18,  1.951420736737750e-19,
  1.570233309303013e+00, -1.351560856940744e-02, -2.069320847858838e-04,  4.924994644102539e-08,  7.589813805424686e-08,  1.233337817438271e-09, -1.734296167212352e-11,
 -9.895833278858399e-13, -8.020035415321208e-15,  4.508971386971357e-16,  1.374529306716320e-17, -8.794574581737396e-21,  1.906599756634566e+00, -3.939735113453811e-03,
 -1.164761745589919e-04, -2.758169810823773e-06, -5.157001717191344e-08, -6.299345311302375e-10,  1.949976348108421e-12,  3.990257281946474e-13,  1.393834326469678e-14,
  3.030897654517454e-16,  3.526314786071572e-18, -3.885224370626594e-20,  1.119907795815793e-01, -2.863400110839867e-03,  5.249892401934927e-05, -8.027325906298253e-07,
  1.028096054113609e-08, -1.059631696443887e-10,  5.538765644170852e-13,  6.907120290410149e-15, -2.455262921910590e-16,  8.883375641397916e-18, -5.546335864364054e-20,
 -9.203689499227805e-23,  3.298154925027342e-01, -7.877195290486668e-03,  1.207723617443868e-04, -1.193255133829916e-06,  1.242455603957139e-09,  2.299756968572693e-10,
 -5.578449631039071e-12,  6.247709203565868e-14,  2.555401681068127e-16, -1.182350635781356e-17,  5.978076482670528e-19, -8.499159060502531e-21,  6.511746244408712e-01,
 -1.369021384837687e-02,  1.370713734459292e-04,  4.277212653829461e-07, -3.897625369554954e-08,  4.751289542636107e-10,  4.116263937732116e-12, -2.413882362374341e-13,
  3.019579190866551e-15,  6.333680815723821e-17, -1.495600715105669e-18,  8.996291718794660e-21,  1.060734529661532e+00, -1.754241009058636e-02,  1.935741745957287e-05,
  3.517441531025045e-06, -2.289056630715539e-08, -1.203337278941767e-09,  1.592131864342845e-11,  4.283759030131932e-13, -1.011622546879562e-14, -1.027847791300007e-16,
  7.546649045931940e-18,  1.792415333406238e-20,  1.512895077433142e+00, -1.514637732453097e-02, -1.983406225882679e-04,  1.428624603591733e-06,  9.408530307148681e-08,
  4.742312809821101e-10, -4.549180016357073e-11, -8.893734022482876e-13,  1.674545760319282e-14,  8.506698635611109e-16,  2.458336527192531e-18, -5.145727897202500e-19,
  1.888746559948047e+00, -5.018881668202692e-03, -1.549195926396581e-04, -3.676693749035503e-06, -6.248936941849013e-08, -3.877541753013833e-10,  2.116434076251061e-11,
  1.039774549140467e-12,  2.638063078509168e-14,  3.397059993486239e-16, -4.071794951981190e-18, -3.687833097650995e-19,  1.013198960309226e-01, -2.479299559091291e-03,
  4.378565818222421e-05, -6.544156662515640e-07,  8.306898754026660e-09, -9.095829861897614e-11,  6.819576794194572e-13,  3.669737804474636e-15,  2.404267852323303e-17,
  5.563043817464409e-18, -1.347630073089987e-19, -3.323947912900629e-21,  3.001492638450836e-01, -6.967649385154237e-03,  1.067024536005500e-04, -1.143246209276097e-06,
  4.648478211675489e-09,  1.177592029084290e-10, -3.750893134729921e-12,  6.753325284540823e-14,  1.409511581478469e-16,  1.462831119343002e-18, -1.611984713768388e-21,
 -1.762856583548677e-20,  5.986254341785725e-01, -1.258296724149166e-02,  1.387875253436745e-04, -1.165890653127825e-07, -2.896931965553964e-08,  5.054417864364150e-10,
 -1.025754482776572e-12, -1.192410712010597e-13,  4.286579901578246e-15,  7.511219322864026e-18, -1.439926655054745e-18, -9.624505556330194e-21,  9.911309233820302e-01,
 -1.722661649481719e-02,  5.865177449105900e-05,  2.982816366517729e-06, -4.236071925295884e-08, -7.152477719198727e-10,  2.323105935470184e-11,  1.010627665165902e-13,
 -8.823380720933936e-15,  1.470322564309778e-16,  3.482590027310381e-18, -1.781869562839379e-19,  1.449281242746212e+00, -1.663863805390022e-02, -1.720638285305358e-04,
  2.943527229447191e-06,  9.106639076008430e-08, -8.280928332842191e-10, -5.844109595380439e-11,  1.050464319840217e-13,  4.281868323790605e-14,  4.129481117725468e-16,
 -2.481997709984387e-17, -5.679849114394265e-19,  1.865888412695023e+00, -6.452070336878750e-03, -2.051739591453611e-04, -4.699224972419347e-06, -6.227303462876416e-08,
  5.741431685102743e-10,  6.347502015716448e-11,  2.005711566521623e-12,  3.010338599231046e-14, -3.352347780218239e-16, -3.482768937302378e-17, -1.060724899413459e-18,
  9.205654780855851e-02, -2.158299061470582e-03,  3.667308412452556e-05, -5.351308961004601e-07,  6.660800366224221e-09, -7.313107322492384e-11,  8.163882966587426e-13,
  6.293318103851061e-15,  8.889316076728951e-17, -3.017605817065961e-18, -2.901692665201935e-19, -2.696075318021633e-21,  2.739010037633904e-01, -6.167490741453338e-03,
  9.349340982498505e-05, -1.054267848356214e-06,  6.259328903953921e-09,  5.094851657304613e-11, -1.797952389194157e-12,  7.132731963255921e-14,  2.581658642059946e-18,
 -1.417122745641215e-17, -7.463251148213317e-19, -1.281293315351084e-20,  5.504951770634066e-01, -1.148538789210214e-02,  1.349342290060840e-04, -5.014222904991696e-07,
 -1.929746703664339e-08,  4.560849170719057e-10, -2.489056472006708e-12,  1.001125066327906e-14,  3.375565929818456e-15, -6.268646546196805e-17, -2.096843117854383e-18,
 -1.258972601348561e-20,  9.233721312153668e-01, -1.662663690880185e-02,  9.000640311160365e-05,  2.221355535271553e-06, -5.100293282539648e-08, -1.501989908374422e-10,
  2.300136150191352e-11, -8.599743314650539e-14, -3.034770696556107e-15,  1.198567752547826e-16, -4.605616931786866e-18, -1.468476327282506e-19,  1.380230083620512e+00,
 -1.785082647061188e-02, -1.287828541838349e-04,  4.195773452517960e-06,  6.154712714784658e-08, -2.034675485184100e-09, -3.567682902108961e-11,  1.484049574162526e-12,
  3.560486037059264e-14, -8.689718386494292e-16, -3.275540819440887e-17,  3.030414940146302e-19,  1.836418246122708e+00, -8.334450702980415e-03, -2.668394684344036e-04,
 -5.500162737979195e-06, -3.053478029818618e-08,  2.857115689539828e-09,  1.288162267858712e-10,  2.407179481863226e-12, -1.945246283396993e-14, -2.762463893607730e-15,
 -8.501695446580164e-17, -7.691727378228994e-19,  8.397187124824597e-02, -1.888892862621425e-03,  3.084630528672572e-05, -4.391309024093492e-07,  5.409315372569032e-09,
 -5.128624624130823e-11,  9.992508803198074e-13,  5.027037270863941e-15, -2.413505504382056e-16, -1.511640709390122e-17, -2.507575189546809e-19,  6.150633124824573e-21,
  2.506493015727523e-01, -5.468380228407208e-03,  8.147096086810572e-05, -9.476403832186512e-07,  7.005789193355380e-09,  3.107471820547765e-11,  7.795889167972057e-14,
  5.674955948693176e-14, -1.122621170539193e-15, -4.849336799116075e-17, -7.472082544612956e-19,  1.791843264765179e-20,  5.066679437778735e-01, -1.043455782483638e-02,
  1.273558259808519e-04, -7.401715286498342e-07, -1.069836637119374e-08,  4.092373395632476e-10, -1.154485097710109e-12,  6.527737807382706e-14, -4.230469939638272e-16,
 -1.454759779150962e-16, -1.607452251493704e-18,  4.752649406503287e-20,  8.584548626426685e-01, -1.581387158407339e-02,  1.117617843927686e-04,  1.410290899719764e-06,
 -4.872689337786027e-08,  3.644257890713777e-10,  1.957153571445465e-11, -1.590074796936904e-13, -3.083800493671451e-15, -1.354201220656146e-16, -6.447162070012987e-18,
  8.651671422766285e-20,  1.307104401640508e+00, -1.866626831031806e-02, -7.397542776321123e-05,  4.824449545206853e-06,  1.616979041367018e-08, -2.300521992435988e-09,
  1.555450047046553e-11,  1.912431529610686e-12, -1.362417200400289e-14, -1.657415097497094e-15, -1.870761481653952e-18,  9.513474774377766e-19,  1.798388501473955e+00,
 -1.073594175961115e-02, -3.332864216736295e-04, -5.343367434420824e-06,  6.214149430286032e-08,  6.571164007959004e-09,  1.677598448925759e-10, -4.712968397887352e-13,
 -1.788882443588550e-13, -5.705979196880977e-15, -2.074968025039867e-17,  4.915459265371610e-18,  7.687845198295995e-02, -1.661798709569839e-03,  2.606647844391657e-05,
 -3.594594584724334e-07,  4.627972716088944e-09, -2.704171938033181e-11,  9.407020031789496e-13, -1.252860798748038e-14, -8.573878215586185e-16, -1.485096897284791e-17,
  3.959243102968551e-19,  2.380490519605206e-20,  2.300100515204115e-01, -4.860143502463834e-03,  7.079392260253392e-05, -8.300291901209224e-07,  7.746297629750028e-09,
  4.618987131987325e-11,  8.738878852082352e-13, -1.040320996857468e-14, -3.072713518034945e-15, -4.649587071131391e-17,  1.280926824839493e-18,  7.607229034142100e-20,
  4.669078556415436e-01, -9.453534398501771e-03,  1.177134342123783e-04, -8.468442340522487e-07, -2.672272233727647e-09,  3.967879326979180e-10, -3.585896162812647e-13,
 -3.836215779129033e-14, -6.001944486469066e-15, -1.328490675645487e-16,  3.200595457857198e-18,  1.764688932188468e-19,  7.970769645927821e-01, -1.486462590201105e-02,
  1.243259083665229e-04,  7.127026124873819e-07, -3.718417677909568e-08,  7.635663981174445e-10,  1.272015814579902e-11, -3.724957750627816e-13, -1.083760983398905e-14,
 -2.234253364194647e-16,  4.441826522155443e-18,  4.096428870810414e-19,  1.231624247766838e+00, -1.902538062217114e-02, -1.593628352474309e-05,  4.751990864763458e-06,
 -2.225401532312762e-08, -1.387500977834880e-09,  5.440546908420775e-11,  5.900743955986679e-13, -6.446165425450030e-14, -8.915696006477022e-16,  3.960111121914268e-17,
  8.914113424529504e-19,  1.749744783905995e+00, -1.363048073370001e-02, -3.864411610323561e-04, -3.097466619155930e-06,  2.286315221765429e-07,  9.610176896758711e-09,
  4.565774137677606e-11, -9.056044317385609e-12, -3.225931208310525e-13,  4.011274664510375e-16,  3.755361288688090e-16,  1.099568137256978e-17,  7.062273385795910e-02,
 -1.469296097436449e-03,  2.218290531530079e-05, -2.886917692332280e-07,  4.266946040232765e-09, -1.210485897741697e-11,  1.600688849385233e-13, -4.322832712090915e-14,
 -8.302453533129685e-16,  2.386747922000739e-17,  1.482701781187352e-18,  1.430635290251486e-20,  2.116421728933944e-01, -4.331450275600205e-03,  6.161060807042767e-05,
 -6.978723944494376e-07,  8.794097372476279e-09,  5.153903921065018e-11, -9.338362085686555e-13, -1.184459827179563e-13, -2.934418726263238e-15,  7.847324846357325e-17,
  4.797971367398291e-18,  4.741860142207458e-20,  4.309125337302110e-01, -8.552605786662473e-03,  1.075530928224142e-04, -8.273825160323854e-07,  4.964024467699748e-09,
  3.504603424265715e-10, -4.568607779616771e-12, -2.655706580257885e-13, -6.412184139852449e-15,  1.667566697084546e-16,  1.141559064925578e-17,  1.135336238300441e-19,
  7.396492029362368e-01, -1.384467536223633e-02,  1.298547864857138e-04,  2.521865616033694e-07, -1.993140824792097e-08,  8.992419986896312e-10, -3.307081484625608e-12,
 -7.749615708365631e-13, -1.087084463091360e-14,  3.545430984914100e-16,  2.376343603344788e-17,  2.857350754563283e-19,  1.155618163193036e+00, -1.893246659228266e-02,
  3.826994880951922e-05,  4.246037295527834e-06, -3.689317236822322e-08, -1.334811678867736e-10,  3.983179820192286e-11, -1.607302711384473e-12, -5.920092099697208e-14,
  1.394689078136747e-15,  7.021061638814378e-17,  1.988349385619554e-19,  1.688911317007663e+00, -1.679401544401931e-02, -3.954099030266269e-04,  2.051957522870843e-06,
  4.057255844757858e-07,  6.633740309785317e-09, -3.250560580536995e-10, -1.551216314504787e-11,  4.302544508695058e-14,  2.050261002615414e-14,  4.326307440792073e-16,
 -1.564441657865822e-17,  6.508014863981774e-02, -1.304548708325375e-03,  1.911969385558238e-05, -2.225999398080742e-07,  3.954603236715080e-09, -2.457820691638349e-11,
 -1.210291685446011e-12, -4.461411911602869e-14,  1.051178934034562e-15,  7.287965389485567e-17,  2.649180432998728e-19, -7.863377952935915e-20,  1.952525659043145e-01,
 -3.869607080007839e-03,  5.410700326331058e-05, -5.514100399904909e-07,  9.293308288347522e-09, -1.731617855328482e-11, -4.871629805402809e-12, -1.300354259917724e-13,
  3.211664033667896e-15,  2.380887142551654e-16,  8.922696269538708e-19, -2.555327839315013e-19,  3.983626218295686e-01, -7.730065097388259e-03,  9.830536201095823e-05,
 -7.006844760951732e-07,  1.018994795491007e-08,  1.371726084068120e-10, -1.333421565896342e-11, -2.861349983589852e-13,  7.531703990113077e-15,  5.503619164609637e-16,
  2.357224004176821e-18, -6.021652423927009e-19,  6.863614101484985e-01, -1.279785339813627e-02,  1.315257445102068e-04,  6.498342881860140e-08, -4.626159921471202e-09,
  5.387806979267272e-10, -2.660435128016237e-11, -7.310655278765659e-13,  1.876640081911020e-14,  1.174326299419285e-15,  5.116832165170630e-18, -1.318279781938549e-18,
  1.080809197289955e+00, -1.843248655643654e-02,  8.571140039666388e-05,  3.667959547422469e-06, -3.448851875022190e-08,  1.336947126832040e-10, -2.041741851894642e-11,
 -2.188565035093379e-12,  3.581278987422015e-14,  3.458709888051528e-15,  3.821259997345248e-18, -3.663492654469423e-18,  1.615729427258940e+00, -1.974180275262656e-02,
 -3.292075295190166e-04,  9.045764776679342e-06,  4.291903947198757e-07, -5.469845042291332e-09, -6.167725057067359e-10, -1.053983996447237e-12,  8.210084552681572e-13,
  1.324135275536094e-14, -9.384881160869706e-16, -3.244737183759029e-17,  6.015240559272220e-02, -1.161249639875952e-03,  1.680587310899991e-05, -1.651630919654473e-07,
  3.100971119690532e-09, -6.250843379570014e-11, -1.624784388818242e-12,  2.513976809431517e-14,  2.878784062776709e-15,  1.169234606302608e-18, -3.671072249458727e-18,
 -5.022080280380984e-20,  1.806014183329674e-01, -3.460763499862918e-03,  4.834757148406607e-05, -4.127703243748833e-07,  7.575405632759540e-09, -1.587713350119076e-10,
 -5.883612055621869e-12,  9.097248955549509e-14,  9.204415379270335e-15,  4.857295272852552e-18, -1.199013840693574e-17, -1.652578596960866e-19,  3.689660275593171e-01,
 -6.974398586445846e-03,  9.090383295073809e-05, -5.350901990015590e-07,  9.300332499103180e-09, -2.342727038474911e-10, -1.521252313518349e-11,  2.289980254847170e-13,
  2.140681309965692e-14,  6.341004440233195e-18, -2.828171187779031e-17, -3.945141074812564e-19,  6.372783323272739e-01, -1.174322088140465e-02,  1.320896472548220e-04,
  3.722760092043026e-08, -1.382416336021862e-09, -2.402807392688201e-10, -3.279999664828151e-11,  4.504434232982166e-13,  4.784281534408013e-14, -3.430753611500668e-17,
 -6.276126756487203e-17, -8.581834897166508e-19,  1.008716095768914e+00, -1.758017294744982e-02,  1.263697985244294e-04,  3.093819591851464e-06, -4.054533269481418e-08,
 -8.548908181772038e-10, -4.880439879267723e-11,  6.164304780309524e-13,  1.180097089501013e-13, -1.149663367047433e-16, -1.701732962586897e-16, -1.774295755909423e-18,
  1.532329849125369e+00, -2.183788826093780e-02, -1.855639081724551e-04,  1.427941011284204e-05,  1.854762966597473e-07, -1.752699940059098e-08, -2.695802426272612e-10,
  2.387530687439570e-11,  4.481745555043942e-13, -3.299958124972256e-14, -7.706552165298717e-16,  4.509629742663435e-17,  5.576479909362908e-02, -1.033993878373984e-03,
  1.507457560051727e-05, -1.272508367108093e-07,  1.568007542531001e-09, -8.365623486689598e-11,  1.673306455345479e-13,  8.923271414382494e-14,  3.544922175721928e-16,
 -1.223693986535064e-16, -8.666029725779109e-19,  1.602585426293117e-19,  1.675030909462338e-01, -3.092019936202404e-03,  4.399566936655021e-05, -3.232062807414703e-07,
  3.354431453524516e-09, -2.393918847790023e-10,  1.346010026244254e-13,  2.945676309980174e-13,  1.000567938898381e-15, -3.978608331550729e-16, -2.746363548300510e-18,
  5.274499321136898e-19,  3.424851868392716e-01, -6.270791292252130e-03,  8.516585924871694e-05, -4.401098146243953e-07,  1.854690572565349e-09, -4.528909401160432e-10,
 -7.768093582042482e-13,  6.967345951928205e-13,  1.912660791877538e-15, -9.377413082842024e-16, -5.971982417032047e-18,  1.264382456603007e-18,  5.924203903611076e-01,
 -1.068570256439587e-02,  1.321253562162627e-04, -5.889714095058649e-08, -1.221440007076847e-08, -7.221247766117883e-10, -2.472814660182894e-12,  1.475007984501147e-12,
  3.345335252217769e-15, -2.080609272740791e-15, -1.032869148636169e-17,  2.873776420982585e-18,  9.406347183652429e-01, -1.643339374622052e-02,  1.588663683038211e-04,
  2.257700255479795e-06, -6.594173365256480e-08, -1.443302169443851e-09,  1.142129166778700e-11,  3.058600648279261e-12,  2.844279697813681e-15, -5.166330712022565e-15,
 -7.593823637684022e-18,  7.715063068556593e-18,  1.443129185597335e+00, -2.261426926536945e-02, -8.453840634925355e-06,  1.433233493606907e-05, -1.723224759808198e-07,
 -1.555582400112389e-08,  4.043116496604608e-10,  1.770600313352226e-11, -7.465464484989501e-13, -1.916094084292985e-14,  1.251662844709990e-15,  1.830535614043900e-17,
  5.186078702234151e-02, -9.192004251268607e-04,  1.364585131520669e-05, -1.145086862477605e-07,  1.270174618055631e-10, -5.234122110649087e-11,  2.194753298506818e-12,
  3.703358947219493e-14, -3.042135139924474e-15, -3.024302981102924e-17,  4.305236321002426e-18,  1.039343052280565e-20,  1.558152046352527e-01, -2.755005212727970e-03,
  4.028924052795962e-05, -3.049610820766767e-07, -7.695820468146119e-10, -1.464289070646956e-10,  6.789206550028759e-12,  1.209477530739117e-13, -9.947762338456015e-15,
 -9.286345647021274e-17,  1.408625434097980e-17,  2.604970014005141e-20,  3.187310625329146e-01, -5.610748131223557e-03,  7.977796191669135e-05, -4.775470269543783e-07,
 -5.903251726482177e-09, -2.606554920635614e-10,  1.481143819379295e-11,  2.781961669158596e-13, -2.343001551084303e-14, -1.949581909093824e-16,  3.341751539549023e-17,
  2.325227782052167e-20,  5.517810282747286e-01, -9.635900106434316e-03,  1.297959536325618e-04, -3.596981564245853e-07, -2.412695417500081e-08, -3.397693452585867e-10,
  2.990115646983362e-11,  5.417883387582133e-13, -5.072747449405785e-14, -3.319509912112606e-16,  7.423002939469581e-17, -1.308107459827688e-19,  8.775866669299651e-01,
 -1.507398844528225e-02,  1.787994294405340e-04,  1.013804919474906e-06, -8.576263995704147e-08, -2.895385673418502e-10,  7.355410866980089e-11,  7.190613445812230e-13,
 -1.179147894290031e-13, -2.117546879365685e-16,  1.828290394957738e-16, -1.496663287981474e-18,  1.353533838563843e+00, -2.206041717279473e-02,  1.387650940863722e-04,
  9.728795077693625e-06, -3.616079043478962e-07, -2.885784480429738e-09,  5.319670319449904e-10, -7.580447302201154e-12, -5.780097479716131e-13,  2.219771490482751e-14,
  3.808026383708104e-16, -3.877252133815518e-17,  4.839358475367861e-02, -8.155555108739069e-04,  1.225914783499370e-05, -1.178359941343029e-07, -3.660389057255548e-10,
  1.897507769999746e-12,  1.925616442803103e-12, -4.790670561898196e-14, -1.550566105591330e-15,  8.648521604864006e-17,  5.512626664844963e-19, -1.199448029225463e-19,
  1.454161218949067e-01, -2.447700736342857e-03,  3.648943861362405e-05, -3.313484170395423e-07, -1.979913362599122e-09,  2.176270095725214e-11,  5.933880721824234e-12,
 -1.539652657912467e-13, -4.930372447242314e-15,  2.828001266515472e-16,  1.565902458895301e-18, -3.909677079696188e-19,  2.975256013274599e-01, -4.997316154456945e-03,
  7.337477780914528e-05, -5.932621157258919e-07, -7.364191973157780e-09,  1.057149729976370e-10,  1.273193418852525e-11, -3.571699032270187e-13, -1.099232704931556e-14,
  6.678587377229506e-16,  2.675614375919273e-18, -9.183358820998452e-19,  5.152772148804700e-01, -8.621611348566316e-03,  1.230716673385890e-04, -7.591957918980069e-07,
 -2.344259598607420e-08,  3.842229596187949e-10,  2.420076042574006e-11, -7.835665556835006e-13, -2.114219721106013e-14,  1.460686115728210e-15,  1.636223011697206e-18,
 -1.985702329461125e-18,  8.201958306802989e-01, -1.361807085159565e-02,  1.828524241781927e-04, -3.092771833503588e-07, -7.433935208205920e-08,  1.327921387342850e-09,
  4.818114246331097e-11, -2.059594240762692e-12, -3.339222450522811e-14,  3.472168197830242e-15, -1.985920913345643e-17, -4.487273559459250e-18,  1.268112257929800e+00,
 -2.058202784564814e-02,  2.208725471086277e-04,  4.075139963590821e-06, -3.163744967330517e-07,  6.012801863580795e-09,  1.846649310073374e-10, -1.322649770138693e-11,
  1.598928054975612e-13,  1.243427152735838e-14, -5.650554131618029e-16, -2.210080759738317e-19,  4.531843423455131e-02, -7.232213668940550e-04,  1.081795329303079e-05,
 -1.213984440172283e-07,  8.458403952049848e-12,  2.921377947666831e-11,  3.368308379767015e-13, -5.195389718261563e-14,  9.776946701543056e-16,  3.656677294403794e-17,
 -2.057336751460787e-18,  7.547735679881935e-21,  1.361833042019940e-01, -2.172153301307607e-03,  3.235809715543968e-05, -3.534749110688974e-07, -5.227426991611847e-10,
  1.037294206183018e-10,  8.653661447629056e-13, -1.642017848274981e-13,  3.214372123064819e-15,  1.146487975098643e-16, -6.699066360300933e-18,  3.106536979515524e-20,
  2.786627422095001e-01, -4.440547835190676e-03,  6.566181872469995e-05, -6.814096916752117e-07, -3.118265720854096e-09,  2.727975949624384e-10,  1.185761927778543e-12,
 -3.668906347267705e-13,  7.713550943558202e-15,  2.495486762013389e-16, -1.569653183484958e-17,  1.006430229972038e-19,  4.826941942254677e-01, -7.679107272275538e-03,
  1.120442581238292e-04, -1.049481179474467e-06, -1.192599552807500e-08,  6.708148190272038e-10, -1.774552193802669e-14, -7.381179562993458e-13,  1.761918947830644e-14,
  4.603286415489784e-16, -3.378345595373925e-17,  3.282779362643865e-19,  7.686001864516826e-01, -1.218799180232031e-02,  1.730286626734848e-04, -1.243827439719414e-06,
 -4.106718104536982e-08,  1.774061368929918e-09, -8.421886513151858e-12, -1.552434193021955e-12,  4.730739609369351e-14,  6.539722160451128e-16, -7.665328527051067e-17,
  1.314043987518035e-18,  1.189519654840077e+00, -1.869535969829840e-02,  2.438403196498802e-04,  1.043106781592496e-07, -1.775953796445073e-07,  6.845246906171943e-09,
 -7.557432460210258e-11, -4.863610689680328e-12,  2.646996767141601e-13, -3.809983683625489e-15, -1.741959782688697e-16,  1.050072037049859e-17,  4.258947248285574e-02,
 -6.424574659459607e-04,  9.381512858345759e-06, -1.165703546945605e-07,  5.772402216875697e-10,  2.406862172568344e-11, -5.843498890486036e-13, -1.345652226125301e-14,
  1.089480437049514e-15, -1.973609744426106e-17, -5.521802966579019e-19,  3.781224101649279e-20,  1.279855645191343e-01, -1.930239300182930e-03,  2.813463586055447e-05,
 -3.454359249211063e-07,  1.457115891136998e-09,  8.306746236540092e-11, -2.002551549220492e-12, -3.998428626753397e-14,  3.466969811403488e-15, -6.533648922123063e-17,
 -1.690901388443481e-18,  1.218194499604792e-19,  2.618986963307530e-01, -3.948399476248006e-03,  5.736242023429557e-05, -6.890322732387022e-07,  1.955025877515817e-09,
  2.102490043361336e-10, -5.045026421661334e-12, -7.920854728421403e-14,  7.821102650137955e-15, -1.579929025406701e-16, -3.511816585387173e-18,  2.797694527965802e-19,
  4.536874407381729e-01, -6.835382494824939e-03,  9.873206899086919e-05, -1.138757854909618e-06,  1.756384039376437e-10,  4.931497573713262e-10, -1.190144307909310e-11,
 -1.235129170184665e-13,  1.588394276458372e-14, -3.613914784816964e-16, -5.824990134091228e-18,  5.790602527349484e-19,  7.225097683906204e-01, -1.087207173954241e-02,
  1.552628556514582e-04, -1.639638991041973e-06, -1.021799790594772e-08,  1.225361251239855e-09, -3.057480824886753e-11, -1.133108170970333e-13,  3.321486101025911e-14,
 -9.422102114894399e-16, -5.057689634072189e-18,  1.195272499465911e-18,  1.118592098678306e+00, -1.677833824327846e-02,  2.321522763603120e-04, -1.771543290478913e-06,
 -6.556162915388601e-08,  4.199040713232199e-09, -1.189394809938139e-10,  8.073995473169731e-13,  8.826954196991082e-14, -4.332701554508963e-15,  7.870096721289907e-17,
  1.378404893599709e-18,  4.016115066488087e-02, -5.728124774307753e-04,  8.051300967740067e-06, -1.043120867635903e-07,  9.050978956622783e-10,  8.723590082562115e-12,
 -5.942152790406561e-13,  8.451040853346356e-15,  2.931075332642758e-16, -1.847786705832613e-17,  3.648297823079613e-19,  4.838291148813762e-21,  1.206892116527649e-01,
 -1.721238584689486e-03,  2.417509000898783e-05, -3.116282964754872e-07,  2.601771258424467e-09,  3.169240997791913e-11, -1.964297122263327e-12,  2.881615503598880e-14,
  8.912050163404504e-16, -5.878287046815295e-17,  1.201337261249496e-18,  1.395142179569061e-20,  2.469716465258423e-01, -3.521766988104858e-03,  4.939817589252947e-05,
 -6.310086584090194e-07,  4.891552271398389e-09,  8.511989431032173e-11, -4.691162506076270e-12,  7.227015120678095e-14,  1.843762104930302e-15, -1.323479512146824e-16,
  2.872030642075724e-18,  2.527131900399526e-20,  4.278400041930641e-01, -6.099491988317031e-03,  8.535796615367872e-05, -1.072866963777423e-06,  7.145515258946633e-09,
  2.108527520330787e-10, -1.028577106812099e-11,  1.704593610537502e-13,  3.148197000477046e-15, -2.667980496447459e-16,  6.408638401715514e-18,  2.688476508053893e-20,
  6.813792824664003e-01, -9.709845311521642e-03,  1.352872329068529e-04, -1.646255030074992e-06,  7.183583647747713e-09,  5.428800940424242e-10, -2.378869496023133e-11,
  4.425331753054085e-13,  4.113859423675224e-15, -5.428095343213485e-16,  1.572446516068026e-17, -5.936013889666264e-20,  1.055040582308831e+00, -1.501855622862045e-02,
  2.069000583552300e-04, -2.291971690716740e-06, -7.173517364224962e-09,  1.813818612901907e-09, -7.565391359451052e-11,  1.776762923673843e-12, -8.832032091195660e-15,
 -1.227839205175693e-15,  5.817149244517968e-17, -1.257421347558039e-18,  3.799115310108977e-02, -5.131541848972214e-04,  6.889943550781760e-06, -8.911692611394656e-08,
  9.593749922947716e-10, -2.148303977641919e-12, -3.054790796241928e-13,  1.008627514856116e-14, -1.064988953546100e-16, -4.546073557050243e-18,  2.578050609927071e-19,
 -5.675100971055697e-21,  1.141684184834024e-01, -1.542055289435443e-03,  2.069878153937527e-05, -2.671799967774366e-07,  2.839143088464372e-09, -4.160456259064156e-12,
 -1.008577518357170e-12,  3.290089709279796e-14, -3.640222051520132e-16, -1.386386654275209e-17,  8.171159042421820e-19, -1.850089381601917e-20,  2.336289961454895e-01,
 -3.155446124382305e-03,  4.233408621993223e-05, -5.444824351537488e-07,  5.650680911306200e-09, -1.192441905330076e-13, -2.398922454120818e-12,  7.708016862952639e-14,
 -9.175746683890636e-16, -2.881853185135497e-17,  1.826176934690674e-18, -4.342705431482466e-20,  4.047292928788281e-01, -5.465940391645366e-03,  7.326996158719070e-05,
 -9.364837703168197e-07,  9.308130801460465e-09,  2.551756078718519e-11, -5.202641089303717e-12,  1.649423643773925e-13, -2.184652169647403e-15, -4.958012764188437e-17,
  3.625695280015842e-18, -9.372694475586800e-20,  6.445830001210704e-01, -8.703968790489900e-03,  1.164913470379953e-04, -1.471187427777082e-06,  1.335078575165205e-08,
  1.215297955657118e-10, -1.169411396527869e-11,  3.705312331727721e-13, -5.762130396607102e-15, -6.617916602890837e-17,  7.106777427230282e-18, -2.148310712972402e-19,
  9.981027393461143e-01, -1.347312528391902e-02,  1.796292697851461e-04, -2.199235662941820e-06,  1.468731032617312e-08,  5.357968448143362e-10, -3.390721501512573e-11,
  1.133252446644449e-12, -2.353533154000487e-14,  1.138911588020172e-16,  1.370922249037900e-17, -6.477564873225298e-19,  3.604236394873492e-02, -4.620567086574044e-04,
  5.910174903213829e-06, -7.442123862695500e-08,  8.635587131343751e-10, -6.567742892939778e-12, -8.392067998995809e-14,  5.583875637342145e-15, -1.408027844685123e-16,
  1.281407081080412e-18,  5.461568735697674e-20, -2.995201572425086e-21,  1.083121450448527e-01, -1.388530854342070e-03,  1.775896299289141e-05, -2.234490270763620e-07,
  2.580432748194563e-09, -1.890165899723088e-11, -2.893328830480370e-13,  1.806776905954031e-14, -4.564109343906999e-16,  4.380064949852224e-18,  1.658524598284741e-19,
 -9.443326140285206e-21,  2.216453245025451e-01, -2.841388740005167e-03,  3.633439377643203e-05, -4.565527411097413e-07,  5.227705945825090e-09, -3.565540557060820e-11,
 -7.276971621569941e-13,  4.172981842687783e-14, -1.059263664281874e-15,  1.104765830161028e-17,  3.417529570081526e-19, -2.089775015178013e-20,  3.839702566306596e-01,
 -4.922198227275406e-03,  6.292452175913009e-05, -7.888397847793248e-07,  8.899148614252190e-09, -5.266070118278163e-11, -1.675059539053963e-12,  8.711936175979049e-14,
 -2.238079374182464e-15,  2.634470726715845e-17,  5.765611210514667e-19, -4.072230440797678e-20,  6.115244411995486e-01, -7.838922002176873e-03,  1.001582938976890e-04,
 -1.250238899500469e-06,  1.370392702258127e-08, -5.612132261664067e-11, -3.963307961842364e-12,  1.867571733508501e-13, -4.942145610516932e-15,  6.957224019229130e-17,
  7.212203733466222e-19, -7.659407013163513e-20,  9.469235746290066e-01, -1.213708474013905e-02,  1.548847806783625e-04, -1.913392520056820e-06,  1.942197457836768e-08,
  2.411002153532612e-11, -1.161254575429176e-11,  5.077200363630001e-13, -1.466047298701983e-14,  2.802775723078336e-16, -1.591178020085385e-18, -1.260151281602252e-19,
  3.428336172773022e-02, -4.181231059189194e-04,  5.095457088752300e-06, -6.171992187301100e-08,  7.223140915488039e-10, -7.162433774088457e-12,  1.807309632488235e-14,
  2.035731901094490e-15, -7.882024737010106e-17,  1.711475373636599e-18, -1.509427534955227e-20, -5.263912277160591e-22,  1.030261337352503e-01, -1.256513266900347e-03,
  1.531200219398608e-05, -1.854191672256552e-07,  2.166138010082904e-09, -2.125053688591191e-11,  4.110769431993515e-14,  6.631575933241238e-15, -2.528771391582484e-16,
  5.525578273426048e-18, -5.127372967226935e-20, -1.584057416494953e-21,  2.108283521474959e-01, -2.571264835827589e-03,  3.133194544547260e-05, -3.792295402586118e-07,
  4.416580339121371e-09, -4.250422541684054e-11,  3.640146830340860e-14,  1.544373203170168e-14, -5.765245415619738e-16,  1.274419978766726e-17, -1.281504740094517e-19,
 -3.205043005896610e-21,  3.652316024769695e-01, -4.454336461394936e-03,  5.427287327878480e-05, -6.563674164263883e-07,  7.603747149935273e-09, -7.071834107996590e-11,
 -8.018252285077207e-14,  3.245861453417349e-14, -1.182168047509679e-15,  2.668316692370484e-17, -3.018224362148962e-19, -5.190605168320117e-21,  5.816813846137711e-01,
 -7.094050904519643e-03,  8.642137354323256e-05, -1.043636696231560e-06,  1.197163094946918e-08, -1.039776316017051e-10, -5.613838742093510e-13,  6.940625925584052e-14,
 -2.472178305527205e-15,  5.810572068021948e-17, -7.823679421931196e-19, -5.565069347627833e-21,  9.007153818675727e-01, -1.098460777237670e-02,  1.337666009018912e-04,
 -1.609932842441958e-06,  1.803203057184542e-08, -1.283147098929719e-10, -2.577119626497846e-12,  1.809886849842746e-13, -6.454801227854429e-15,  1.672947754652829e-16,
 -3.019762981431840e-18,  2.089312712521993e-20,  3.268796920671195e-02, -3.801361920288003e-04,  4.419551419583263e-06, -5.127038416359630e-08,  5.867709322457815e-10,
 -6.277663304934990e-12,  4.803101124806769e-14,  3.571525374710264e-16, -3.078448649556145e-17,  9.399364991175198e-19, -1.855964074662170e-20,  1.703586193255824e-22,
  9.823177080733171e-02, -1.142359878068088e-03,  1.328120743951676e-05, -1.540585627862950e-07,  1.762028841284767e-09, -1.878267909242527e-11,  1.401065026727704e-13,
  1.251533493619675e-15, -9.871180188836423e-17,  3.001166845658739e-18, -5.972862377786682e-20,  5.726139668291819e-22,  2.010173943925444e-01, -2.337674683073549e-03,
  2.717760615687689e-05, -3.152029001246644e-07,  3.601140245469630e-09, -3.814189254467550e-11,  2.715396578967289e-13,  3.203962099910279e-15, -2.245497025562163e-16,
  6.790897250205189e-18, -1.370415696877286e-19,  1.408438434218664e-21,  3.482355174857852e-01, -4.049697804505921e-03,  4.708009343969841e-05, -5.458843608084364e-07,
  6.225102263059032e-09, -6.521322541717631e-11,  4.255324958283573e-13,  7.473405552845678e-15, -4.574083773020979e-16,  1.377268951921609e-17, -2.846252847817099e-19,
  3.243771904311840e-21,  5.546129926428824e-01, -6.449678289393280e-03,  7.497748114098743e-05, -8.689365511858179e-07,  9.875962372503816e-09, -1.013560980880880e-10,
  5.453237834179241e-13,  1.768568527787169e-14, -9.392842235961518e-16,  2.833211016564850e-17, -6.115195655745091e-19,  8.139598476270243e-21,  8.588015098129337e-01,
 -9.987056828510612e-03,  1.160867450903566e-04, -1.343944671529487e-06,  1.515783676566540e-08, -1.479075134179648e-10,  3.511006416684860e-13,  4.979709645147157e-14,
 -2.313118767182660e-15,  7.173508331547286e-17, -1.707296240651675e-18,  2.955804157210170e-20,  3.123445397666262e-02, -3.470902825553838e-04,  3.856701691821157e-06,
 -4.282209227185065e-08,  4.730951465330654e-10, -5.089684582420601e-12,  4.840064137247625e-14, -2.131883905631385e-16, -8.234757496490953e-18,  3.718401133939627e-19,
 -9.824625579823157e-21,  1.817631555057059e-22,  9.386376268286298e-02, -1.043053083364483e-03,  1.158987427573915e-05, -1.286820111351772e-07,  1.421362458662726e-09,
 -1.527186458535601e-11,  1.441969614223722e-13, -5.847415816424356e-16, -2.684244471779968e-17,  1.183612925993126e-18, -3.126786515716155e-20,  5.832367470618365e-22,
  1.920788913622763e-01, -2.134459636984708e-03,  2.371690794053582e-05, -2.633148309429868e-07,  2.907373277922943e-09, -3.116909101327265e-11,  2.906191337278371e-13,
 -9.966072359598222e-16, -6.247271094916264e-17,  2.662229975351880e-18, -7.038145907724255e-20,  1.331649052757007e-21,  3.327507851527670e-01, -3.697661546935858e-03,
  4.108598176757598e-05, -4.561154039032743e-07,  5.033048317483792e-09, -5.375660291691399e-11,  4.904253409250283e-13, -1.136849441628595e-15, -1.307059624740531e-16,
  5.337342224488003e-18, -1.416068121710692e-19,  2.744123115193277e-21,  5.299514758447634e-01, -5.889029949283839e-03,  6.543407953433615e-05, -7.263092153417957e-07,
  8.005716221989752e-09, -8.493145874135063e-11,  7.434266744251709e-13, -8.156690489891286e-17, -2.753111180236095e-16,  1.071803934821546e-17, -2.876119591916485e-19,
  5.816131339238433e-21,  8.206140608265934e-01, -9.118969289561777e-03,  1.013194167713429e-04, -1.124276660066813e-06,  1.236226322853330e-08, -1.291397894845241e-10,
  1.017001051009576e-12,  6.227017652424504e-15, -6.823643379492786e-16,  2.545954653874280e-17, -7.094762513130861e-19,  1.573648669987559e-20,  2.990471756552103e-02,
 -3.181707856154361e-04,  3.385092433457544e-06, -3.600623564271829e-08,  3.823239802107002e-10, -4.019462355706733e-12,  4.029656392647136e-14, -3.243340973684271e-16,
 -2.407465335221473e-19,  1.117216690278336e-19, -3.848193280007665e-21,  9.177972425823346e-23,  8.986772520184803e-02, -9.561462399133542e-04,  1.017265212834858e-05,
 -1.082025615989463e-07,  1.148843977458364e-09, -1.207278573481525e-11,  1.207483151803322e-13, -9.584192030653151e-16, -1.366857101772020e-18,  3.575364825207490e-19,
 -1.219671292411700e-20,  2.913664312858362e-22,  1.839015684111249e-01, -1.956617654902711e-03,  2.081686020157752e-05, -2.214175332877962e-07,  2.350625766526824e-09,
 -2.468325597103847e-11,  2.458627574607460e-13, -1.903567158294886e-15, -5.093503140157360e-18,  8.099298152429768e-19, -2.724752365123896e-20,  6.531312724264320e-22,
  3.185846800001518e-01, -3.389575879616147e-03,  3.606231598599168e-05, -3.835655657085198e-07,  4.071225749420123e-09, -4.269721168920190e-11,  4.223619214152941e-13,
 -3.129560816381500e-15, -1.557156581267424e-17,  1.635493117865794e-18, -5.408568129465052e-20,  1.305557374532806e-21,  5.073900136708580e-01, -5.398365460909206e-03,
  5.743396650480119e-05, -6.108521711453571e-07,  6.481439713748603e-09, -6.782380089447806e-11,  6.625637883425663e-13, -4.501399153918439e-15, -4.446456897172486e-17,
  3.294021098253162e-18, -1.070092661925813e-19,  2.622929721982033e-21,  7.856783486592180e-01, -8.359204229440018e-03,  8.893401303197657e-05, -9.457925927511999e-07,
  1.002789596503961e-08, -1.044261442206103e-10,  9.912295489736269e-13, -5.269895976348419e-15, -1.401277423694331e-16,  7.687949712284701e-18, -2.475553192093948e-19,
  6.320450298531844e-21,  2.868359859693085e-02, -2.927201367819285e-04,  2.987229686569970e-06, -3.048268398065749e-08,  3.108782833244204e-10, -3.159365188394265e-12,
  3.153978326425926e-14, -2.907315156950375e-16,  1.799309111463868e-18,  1.890515425337281e-20, -1.203403206100252e-21,  3.519945576934991e-23,  8.619809747727132e-02,
 -8.796636331556186e-04,  8.977027542949066e-06, -9.160433726746500e-08,  9.342086099611875e-10, -9.492724497491323e-12,  9.468948890003131e-14, -8.692469365016538e-16,
  5.223681918247931e-18,  6.336076639577627e-20, -3.819334991759391e-21,  1.112369391027892e-22,  1.763921955109769e-01, -1.800106970594964e-03,  1.837020776060435e-05,
 -1.874544091752646e-07,  1.911646157291886e-09, -1.941992252258288e-11,  1.934456714078680e-13, -1.763116046239739e-15,  1.003912064849141e-17,  1.529847017509111e-19,
 -8.542930414515030e-21,  2.473319395934247e-22,  3.055757046645179e-01, -3.118442596992952e-03,  3.182388818402226e-05, -3.247369841890097e-07,  3.311443979358704e-09,
 -3.362645130263835e-11,  3.341927949980827e-13, -3.009153355413935e-15,  1.550239601990323e-17,  3.333297367181413e-19, -1.694997097342185e-20,  4.874501479696637e-22,
  4.866714302825356e-01, -4.966549380825563e-03,  5.068387212298763e-05, -5.171815539163326e-07,  5.273312199055580e-09, -5.351061016934427e-11,  5.296617462196713e-13,
 -4.664883565042307e-15,  1.929394700437984e-17,  7.287049486759538e-19, -3.332865554650363e-20,  9.536933360655013e-22,  7.535962473968552e-01, -7.690553188489479e-03,
  7.848229257777681e-05, -8.008184640258386e-07,  8.163571691409126e-09, -8.271498596583765e-11,  8.115444144150395e-13, -6.789486194137373e-15,  1.109758830374502e-17,
  1.835905819675949e-18, -7.501680471257944e-20,  2.159633632256468e-21,  2.755831040712545e-02, -2.702054575036870e-04,  2.649322568289008e-06, -2.597564739388874e-08,
  2.546364429232244e-10, -2.493228906012895e-12,  2.425619135475946e-14, -2.290896617054581e-16,  1.903067811892385e-18, -7.070657807348888e-21, -2.686828255964856e-22,
  1.111688051722604e-23,  8.281645413054370e-02, -8.120039826280375e-04,  7.961572540909453e-06, -7.806027744217677e-08,  7.652115336653365e-10, -7.492098421004278e-12,
  7.286998199492027e-14, -6.872918669770970e-16,  5.669645105005589e-18, -1.941495502553735e-20, -8.671081125711995e-22,  3.511493640792506e-23,  1.694721415384668e-01,
 -1.661651112319874e-03,  1.629222865977875e-05, -1.597390911800141e-07,  1.565878014071312e-09, -1.533014982683168e-11,  1.490370392608257e-13, -1.402394786729299e-15,
  1.142828675373132e-17, -3.324318016735144e-20, -1.986576024946387e-21,  7.796115416411342e-23,  2.935876440821763e-01, -2.878586572679816e-03,  2.822408555293424e-05,
 -2.767258606560103e-07,  2.712619090301805e-09, -2.655354533528079e-11,  2.579560578230628e-13, -2.417879207294301e-15,  1.929802233098848e-17, -3.880775632202606e-20,
 -4.060603402115013e-21,  1.530357054334295e-22,  4.675787920224984e-01, -4.584545840886542e-03,  4.495073393630821e-05, -4.407224977407805e-07,  4.320074453232018e-09,
 -4.227958758697673e-11,  4.101950807688253e-13, -3.818599668530483e-15,  2.933056503033741e-17, -8.452573661292318e-21, -8.249329852730797e-21,  2.963099858855316e-22,
  7.240318664471564e-01, -7.099032809797452e-03,  6.960483645170086e-05, -6.824407641735767e-07,  6.689047985016111e-09, -6.543478944368273e-11,  6.331110382433569e-13,
 -5.806628859884018e-15,  4.069111186243508e-17,  1.704807354888150e-19, -1.906567284205947e-20,  6.502510606536702e-22,  2.651799661920884e-02, -2.501920414663991e-04,
  2.360511156377223e-06, -2.227081156513850e-08,  2.101081365287661e-10, -1.981462537824793e-12,  1.864571292799349e-14, -1.735866410574421e-16,  1.542723439435080e-18,
 -1.120063105449115e-20,  2.381681611838200e-24,  2.755946889861690e-24,  7.969017034646751e-02, -7.518609597365762e-04,  7.093655524936623e-06, -6.692679047964762e-08,
  6.314021298004491e-10, -5.954470171661845e-12,  5.602727160137086e-14, -5.213642731705044e-16,  4.623461737835437e-18, -3.317436380534659e-20, -9.251490704560365e-24,
  8.773598990747548e-24,  1.630746446655771e-01, -1.538576943110124e-03,  1.451616075959341e-05, -1.369561483612482e-07,  1.292070612616885e-09, -1.218465621288616e-11,
  1.146322848106605e-13, -1.065894713770794e-15,  9.416975929891871e-18, -6.618022668904854e-20, -7.688453586233127e-23,  1.969806038232640e-23,  2.825048430468574e-01,
 -2.665377182425094e-03,  2.514729099850093e-05, -2.372579358372327e-07,  2.238325861981793e-09, -2.110736486926999e-11,  1.985296582842103e-13, -1.843672127726330e-15,
  1.618736582348579e-17, -1.097546898112360e-19, -3.004685811892547e-22,  3.919645062460005e-23,  4.499279038390859e-01, -4.244980551638267e-03,  4.005052446636412e-05,
 -3.778656127101289e-07,  3.564809309884456e-09, -3.361392615047592e-11,  3.160351082145356e-13, -2.928486694719941e-15,  2.543101057903960e-17, -1.611218158368427e-19,
 -9.511762249304683e-22,  7.693887565495628e-23,  6.966999909910959e-01, -6.573226214548118e-03,  6.201703859091111e-05, -5.851125874483158e-07,  5.519898534341391e-09,
 -5.204244795438513e-11,  4.888923265214536e-13, -4.509502296557279e-15,  3.823500271327076e-17, -2.039107483445630e-19, -3.081050122116824e-21,  1.697297905921877e-22,
  2.555338095028919e-02, -2.323226634271801e-04,  2.112198508858998e-06, -1.920335828515264e-08,  1.745874295017488e-10, -1.587079307707227e-12,  1.441699768378184e-14,
 -1.304783310500179e-16,  1.161208347952470e-18, -9.640543804571638e-21,  5.819673818826719e-23,  3.051411005352726e-25,  7.679136965477766e-02, -6.981610597013988e-04,
  6.347442484208354e-06, -5.770868870709859e-08,  5.246585775791479e-10, -4.769366788361717e-12,  4.332371083376207e-14, -3.920361996686603e-16,  3.486485268611242e-18,
 -2.884869245116255e-20,  1.706154831210953e-22,  1.049773144681736e-24,  1.571426596998554e-01, -1.428687706448919e-03,  1.298914177903923e-05, -1.180926458664517e-07,
  1.073638463357680e-09, -9.759759292730681e-12,  8.865125617399389e-14, -8.020068885860751e-16,  7.123768124695675e-18, -5.860613225284226e-20,  3.341307602388045e-22,
  2.616325742510515e-24,  2.722284786053405e-01, -2.475008894999833e-03,  2.250193725450923e-05, -2.045795634425235e-07,  1.859931169893266e-09, -1.690726006754812e-11,
  1.535634967584786e-13, -1.388693517765442e-15,  1.231031553502625e-17, -1.003081191995729e-19,  5.359118129003226e-22,  5.879475358494300e-24,  4.335613769735701e-01,
 -3.941792824839388e-03,  3.583743620261211e-05, -3.258210770372876e-07,  2.962189396023979e-09, -2.692658605452922e-11,  2.445363709137027e-13, -2.209852849845993e-15,
  1.952206655504981e-17, -1.563941930645536e-19,  7.341142595245406e-22,  1.314977875513075e-23,  6.713569105109144e-01, -6.103749063597382e-03,  5.549320335127501e-05,
 -5.045240228289871e-07,  4.586839804418341e-09, -4.169330608488677e-11,  3.785493738429157e-13, -3.416113905338260e-15,  2.996155706832394e-17, -2.312700742280367e-19,
  7.426698491454657e-22,  3.310556780062864e-23,  2.465649002524649e-02, -2.163016448668040e-04,  1.897528806938100e-06, -1.664626289360676e-08,  1.460303974734712e-10,
 -1.281017427222684e-12,  1.123492708903099e-14, -9.841275009766737e-17,  8.570004781354937e-19, -7.279292743956896e-21,  5.591665915927590e-23, -2.562397292287166e-25,
  7.409609098726663e-02, -6.500157298008596e-04,  5.702330982945025e-06, -5.002427321691115e-08,  4.388410534471442e-10, -3.849626017772146e-12,  3.376217643466112e-14,
 -2.957276513201760e-16,  2.574666886367400e-18, -2.184555685292323e-20,  1.669731307979320e-22, -7.359809441438163e-25,  1.516271537220605e-01, -1.330165109444537e-03,
  1.166901254413139e-05, -1.023675863944145e-07,  8.980258312338688e-10, -7.877697731817304e-12,  6.908847090993977e-14, -6.051093017518515e-16,  5.266134041883190e-18,
 -4.460031484809063e-20,  3.379679359893382e-22, -1.386672928531532e-24,  2.626736078685157e-01, -2.304331775302535e-03,  2.021499146108310e-05, -1.773380402460646e-07,
  1.555708113575864e-09, -1.364700348044109e-11,  1.196835607465555e-13, -1.048115026279348e-15,  9.115678059281267e-18, -7.697172275163359e-20,  5.749333692666378e-22,
 -2.061681463422207e-24,  4.183439282596663e-01, -3.669965987612498e-03,  3.219516026857285e-05, -2.824352572813152e-07,  2.477678014312161e-09, -2.173461169203091e-11,
  1.906048117440555e-13, -1.668850410737069e-15,  1.449853242749984e-17, -1.217920495132782e-19,  8.867046672766728e-22, -2.340720211629148e-24,  6.477931433295527e-01,
 -5.682833290088770e-03,  4.985324873124908e-05, -4.373425548417212e-07,  3.836605984857895e-09, -3.365502926597960e-11,  2.951221541239677e-13, -2.582874796917272e-15,
  2.238970527167495e-17, -1.860675724532930e-19,  1.279888573313976e-21, -5.418056973571277e-25,  2.382043241370924e-02, -2.018825711615323e-04,  1.710992123032495e-06,
 -1.450097306790986e-08,  1.228982737384582e-10, -1.041574242572450e-12,  8.826849345269614e-15, -7.477417642527304e-17,  6.321799008301278e-19, -5.298101896004462e-21,
  4.285801255472075e-23, -3.008750186498135e-25,  7.158362466338077e-02, -6.066844610115379e-04,  5.141762995058281e-06, -4.357738734342125e-08,  3.693259392200496e-10,
 -3.130070577428357e-12,  2.652581068191414e-14, -2.247029165321741e-16,  1.899617183697267e-18, -1.591455181238931e-20,  1.285391869706597e-22, -8.958058012087336e-25,
  1.464857473074579e-01, -1.241493806267092e-03,  1.052188958134529e-05, -8.917494952232852e-08,  7.557731688127603e-10, -6.405242415957022e-12,  5.428108366226620e-14,
 -4.598102170505121e-16,  3.886712064407306e-18, -3.254270747476630e-20,  2.621499467264705e-22, -1.803948212827422e-24,  2.537668142025450e-01, -2.150720693663774e-03,
  1.822775557362579e-05, -1.544835799198067e-07,  1.309275024051792e-09, -1.109620919836514e-11,  9.403402230057193e-14, -7.965244947343915e-16,  6.731568596585158e-18,
 -5.630804923512104e-20,  4.516398569995885e-22, -3.042488346914447e-24,  4.041586316084735e-01, -3.425319166418106e-03,  2.903021329355386e-05, -2.460363920184606e-07,
  2.085200610200577e-09, -1.767221631130103e-11,  1.497604490407030e-13, -1.268482563594882e-15,  1.071656937581333e-17, -8.949563813687202e-20,  7.125183108376812e-22,
 -4.619819755726278e-24,  6.258276329341761e-01, -5.304004957838927e-03,  4.495242267897722e-05, -3.809800326909225e-07,  3.228870183060009e-09, -2.736482311809472e-11,
  2.318945034666466e-13, -1.963926249251875e-15,  1.658082498314676e-17, -1.380135645445905e-19,  1.081977364826347e-21, -6.433363099680322e-24,  2.303922112478182e-02,
 -1.888587643404476e-04,  1.548126675385864e-06, -1.269041522425367e-08,  1.040267522789254e-10, -8.527330508443708e-13,  6.989929001384534e-15, -5.729024208943756e-17,
  4.692586811071590e-19, -3.832215385914682e-21,  3.090782204710361e-23, -2.374877111167068e-25,  6.923597896502180e-02, -5.675461581096672e-04,  4.652330273947636e-06,
 -3.813641598754473e-08,  3.126144728205924e-10, -2.562578052386132e-12,  2.100566860580269e-14, -1.721641407541141e-16,  1.410148096796705e-18, -1.151474289825493e-20,
  9.282309634722895e-23, -7.117025847534745e-25,  1.416816229542762e-01, -1.161402813742209e-03,  9.520334853815024e-06, -7.804077279686199e-08,  6.397212236402754e-10,
 -5.243952197380061e-12,  4.298507535210546e-14, -3.523067901398698e-16,  2.885537900600686e-18, -2.355781319021143e-20,  1.897444321817419e-22, -1.449516450785620e-24,
  2.454443162494521e-01, -2.011973843634167e-03,  1.649269700358299e-05, -1.351951204399556e-07,  1.108230772630317e-09, -9.084438289449601e-12,  7.446571205508395e-14,
 -6.103164505129068e-16,  4.998442931015507e-18, -4.079545866354014e-20,  3.281330638776330e-22, -2.491748579404697e-24,  3.909039064199816e-01, -3.204345682567639e-03,
  2.626689337636063e-05, -2.153168642882423e-07,  1.765010196435219e-09, -1.446821464076608e-11,  1.185965493881003e-13, -9.719930545065696e-16,  7.959746926233441e-18,
 -6.493161624847955e-20,  5.210571581560688e-22, -3.916182708003281e-24,  6.053030847968291e-01, -4.961834083844996e-03,  4.067350395182294e-05, -3.334117648957065e-07,
  2.733065640770131e-09, -2.240358410062125e-11,  1.836421584134207e-13, -1.505042372294003e-15,  1.232252135780933e-17, -1.004201592848862e-19,  8.020876829841940e-22,
 -5.900810294656816e-24,  2.230762993150118e-02, -1.770558351162681e-04,  1.405293562414929e-06, -1.115382603614633e-08,  8.852799802492238e-11, -7.026468637155649e-13,
  5.576879095939000e-15, -4.426190340078447e-17,  3.512232350222839e-19, -2.784284118408941e-21,  2.197791113644527e-23, -1.705461609594719e-25,  6.703744837257766e-02,
 -5.320767576883763e-04,  4.223097430204778e-06, -3.351875744827008e-08,  2.660386200597503e-10, -2.111548915993589e-12,  1.675927371488432e-14, -1.330128420497664e-16,
  1.055465138244762e-18, -8.366800196070517e-21,  6.603329399624217e-23, -5.120602718925240e-25,  1.371826415416076e-01, -1.088819710393257e-03,  8.641970645015538e-06,
 -6.859138881604722e-08,  5.444103467645764e-10, -4.320985572418355e-12,  3.429546899438436e-14, -2.721913521242796e-16,  2.159831531743767e-18, -1.712026246176976e-20,
  1.350818104399563e-22, -1.046286621538625e-24,  2.376504373142523e-01, -1.886233399672227e-03,  1.497104939740741e-05, -1.188253364797995e-07,  9.431175458092087e-10,
 -7.485524689184253e-12,  5.941224877316658e-14, -4.715332141917688e-16,  3.741538580420245e-18, -2.965519264723140e-20,  2.338830482163657e-22, -1.808158314181607e-24,
  3.784910798837034e-01, -3.004086693134552e-03,  2.384345981935950e-05, -1.892457274447158e-07,  1.502044679381488e-09, -1.192172874392679e-11,  9.462212003643859e-14,
 -7.509773991586883e-16,  5.958709330216508e-18, -4.722110450492406e-20,  3.721505248872252e-22, -2.867990060344033e-24,  5.860821917077740e-01, -4.651738988743282e-03,
  3.692088910504514e-05, -2.930413857763603e-07,  2.325871516168021e-09, -1.846043939413207e-11,  1.465193193645123e-13, -1.162853647515725e-15,  9.226268541571613e-18,
 -7.309378485352651e-20,  5.752305923184486e-22, -4.404958248475963e-24  };
  constexpr double w[2304] = {  3.020381505541043e-03, -3.454170970985592e-04,  2.460936878710723e-05, -1.381657743919550e-06,  6.647116766247480e-08,
 -2.855485743760081e-09,  1.121827454358694e-10, -4.093123635419386e-12,  1.401742291051554e-13, -4.540349381268162e-15,  1.398948702253739e-16, -4.115082656531725e-18,
  1.839286325568009e-02, -3.137370803041570e-03,  3.209046581443735e-04, -2.486172054625294e-05,  1.594936287007786e-06, -8.872983539918665e-08,  4.401537678087741e-09,
 -1.983123146511580e-10,  8.221378517353337e-12, -3.166277389689851e-13,  1.141138235636970e-14, -3.867058647710886e-16,  4.471100426920558e-02, -1.083783880912454e-02,
  1.491952225991090e-03, -1.492206458362673e-04,  1.196279151847520e-05, -8.098687218498213e-07,  4.780563670291876e-08, -2.513998005845866e-09,  1.196035178674300e-10,
 -5.207182275314868e-12,  2.093143946781251e-13, -7.814551149127714e-15,  6.503581047904604e-02, -2.052257293750576e-02,  3.545701980058587e-03, -4.310112775876721e-04,
  4.091239104627699e-05, -3.209235718419216e-06,  2.155211915468644e-07, -1.269345115765647e-08,  6.671629068698081e-10, -3.170719377414330e-11,  1.376635956064256e-12,
 -5.498470466310872e-14,  6.228273736434056e-02, -2.338865297313616e-02,  4.726713028125704e-03, -6.581633490934278e-04,  7.026224267716221e-05, -6.102511494519180e-06,
  4.477637016336848e-07, -2.848498670747414e-08,  1.601179031251506e-09, -8.068412919751866e-11,  3.686299296876985e-12, -1.538972769611714e-13,  3.294537015705722e-02,
 -1.356788429087512e-02,  2.990344851285145e-03, -4.492270266448595e-04,  5.121663119416594e-05, -4.708616280075292e-06,  3.629103757086428e-07, -2.409151313978017e-08,
  1.405105723864294e-09, -7.310262674954865e-11,  3.433575745237496e-12, -1.468079100820680e-13,  1.948258267576935e-03, -2.003336322937495e-04,  1.291186025893002e-05,
 -6.601721532860667e-07,  2.909762492198959e-08, -1.151192676643237e-09,  4.184520013956442e-11, -1.418507687848916e-12,  4.530586795533266e-14, -1.373483561164143e-15,
  3.974060611544334e-17, -1.101361838127128e-18,  9.560678602668807e-03, -1.434842952867666e-03,  1.315949562453350e-04, -9.262404467059070e-06,  5.451675192346241e-07,
 -2.804570706009915e-08,  1.295015257270422e-09, -5.462241125821903e-11,  2.130630231266827e-12, -7.755807287000968e-14,  2.652953418492834e-15, -8.565997548860150e-17,
  1.725640935668040e-02, -3.730417808730944e-03,  4.665830006197208e-04, -4.296834300646730e-05,  3.204070482997641e-06, -2.034053267760968e-07,  1.133533905418603e-08,
 -5.660087676355854e-10,  2.569627497372998e-11, -1.072265646993447e-12,  4.147316337482180e-14, -1.495169772285016e-15,  1.793316381893843e-02, -5.230758224711109e-03,
  8.443292029727067e-04, -9.682182129817338e-05,  8.737769556153739e-06, -6.557955963970791e-07,  4.236141204352809e-08, -2.410511302262472e-09,  1.228757102421233e-10,
 -5.682349212509898e-12,  2.407536885485192e-13, -9.407950422169854e-15,  1.261581904972629e-02, -4.555784953402023e-03,  8.885644736940523e-04, -1.199762643283390e-04,
  1.247124191770672e-05, -1.058338047817963e-06,  7.609384830293913e-08, -4.755104069768477e-09,  2.631028708336200e-10, -1.307324739065902e-11,  5.898702366733440e-13,
 -2.435289135447157e-14,  5.435661831132962e-03, -2.212317817524988e-03,  4.820466686843055e-04, -7.167529119253992e-05,  8.097272086497752e-06, -7.383691927234644e-07,
  5.649375001852682e-08, -3.725645440517380e-09,  2.160002586824122e-10, -1.117687626387596e-11,  5.223717046380472e-13, -2.223362210907066e-14,  1.312583940858010e-03,
 -1.222645813041009e-04,  7.169240336896211e-06, -3.352850092010460e-07,  1.358577004062990e-08, -4.963799617480165e-10,  1.673008921594483e-11, -5.277777641803037e-13,
  1.573918759691712e-14, -4.468944981715458e-16,  1.214622649255510e-17, -3.170969006519190e-19,  5.387253939151411e-03, -7.121661563845139e-04,  5.859507745710508e-05,
 -3.746799834549269e-06,  2.022213635225971e-07, -9.610504214189668e-09,  4.125086352111647e-10, -1.626070385325043e-11,  5.955972913923932e-13, -2.044613300483972e-14,
  6.621520874557517e-16, -2.031701205049702e-17,  7.452118215139514e-03, -1.423133918121672e-03,  1.606778455533135e-04, -1.354877553356875e-05,  9.349114509761257e-07,
 -5.538484340759502e-08,  2.900263205166045e-09, -1.368884343597370e-10,  5.904532263690150e-12, -2.351575071447552e-13,  8.716127324254000e-15, -3.022473438700821e-16,
  5.545890608772853e-03, -1.473062198266383e-03,  2.197295875939260e-04, -2.355776626808433e-05,  2.005831381592275e-06, -1.430760259601988e-07,  8.836684027077493e-09,
 -4.832264491752675e-10,  2.377457248122581e-11, -1.065143611054015e-12,  4.386401776088590e-14, -1.670931342299019e-15,  2.762298434095305e-03, -9.485740604433174e-04,
  1.769554589369117e-04, -2.299965395172794e-05,  2.313762026369677e-06, -1.908674255192911e-07,  1.338872804934465e-08, -8.187581044440378e-10,  4.444712410372591e-11,
 -2.171572630496006e-12,  9.652390349715804e-14, -3.932171064353792e-15,  9.222875227344357e-04, -3.696789373073776e-04,  7.939070232419774e-05, -1.165407782260405e-05,
  1.301808568570289e-06, -1.175324091890432e-07,  8.913467726390220e-09, -5.832055114219153e-10,  3.357361487022471e-11, -1.726184984051371e-12,  8.020975760904924e-14,
 -3.395995270943756e-15,  9.171263961941823e-04, -7.794312970686340e-05,  4.181489705799486e-06, -1.796800617811323e-07,  6.717789062442039e-09, -2.273610733317531e-10,
  7.123074551551358e-12, -2.095444489621958e-13,  5.844240316884416e-15, -1.556030667552193e-16,  3.976267179536552e-18, -9.783836784466552e-20,  3.253369840765678e-03,
 -3.799976684804895e-04,  2.810059334940794e-05, -1.634288642410776e-06,  8.092736263194466e-08, -3.553165270004946e-09,  1.417119949301291e-10, -5.216540499212531e-12,
  1.792196721210635e-13, -5.793853651576476e-15,  1.773486153246651e-16, -5.161199813973328e-18,  3.573318424075835e-03, -5.985678070563353e-04,  6.072563460856908e-05,
 -4.669682337244808e-06,  2.970229953637049e-07, -1.635713148244156e-08,  8.018125154704361e-10, -3.563647423018347e-11,  1.454948537757716e-12, -5.509859595045557e-14,
  1.949867712747471e-15, -6.480190983308031e-17,  1.934875958224606e-03, -4.608581155733781e-04,  6.285117553127632e-05, -6.245251198773895e-06,  4.979309221800500e-07,
 -3.353054436009749e-08,  1.968184022980880e-09, -1.028655114438475e-10,  4.860286458772644e-12, -2.099890827060415e-13,  8.369904219718219e-15, -3.096114767379663e-16,
  6.639731566702513e-04, -2.137776723416869e-04,  3.773148036161461e-05, -4.679733280001390e-06,  4.523425111626248e-07, -3.605275185149777e-08,  2.454564233768591e-09,
 -1.462360343556011e-10,  7.758531692432935e-12, -3.714601418628584e-13,  1.621701490591929e-14, -6.501888742103024e-16,  1.621780510954558e-04, -6.370409576631046e-05,
  1.342749327279895e-05, -1.939299867357453e-06,  2.135963561347499e-07, -1.904878651252393e-08,  1.429122246504847e-09, -9.261883963712689e-11,  5.286718264629473e-12,
 -2.697560486262771e-13,  1.244903228779636e-14, -5.238280921673684e-16,  6.607915709343518e-04, -5.158241962354974e-05,  2.545605191145271e-06, -1.009563329971620e-07,
  3.495528492773267e-09, -1.099373084710484e-10,  3.210165487964523e-12, -8.825700452458956e-14,  2.306928491516112e-15, -5.767886373168810e-17,  1.387356639039151e-18,
 -3.221701104632264e-20,  2.083997804759644e-03, -2.160332739053477e-04,  1.439947477006436e-05, -7.632290087407567e-07,  3.472361816031630e-08, -1.409675274205560e-09,
  5.226216007448317e-11, -1.796507165974659e-12,  5.787171574396664e-14, -1.760663765719470e-15,  5.088962435484252e-17, -1.402940679838022e-18,  1.883919789194715e-03,
 -2.755549420864562e-04,  2.505337154256277e-05, -1.752602954191402e-06,  1.024966766102855e-07, -5.233002257421686e-09,  2.394442462775060e-10, -9.991638393133863e-12,
  3.849463804715286e-13, -1.381849008660480e-14,  4.654288863931395e-16, -1.477738060847471e-17,  7.627412311864528e-04, -1.605065877669089e-04,  1.982071545141798e-05,
 -1.810902223940584e-06,  1.342605404883050e-07, -8.481736817304714e-09,  4.704387564411940e-10, -2.337371986379970e-11,  1.055338788816635e-12, -4.376800968270760e-14,
  1.681248652509770e-15, -6.014962111167406e-17,  1.780475346399828e-04, -5.282295231933367e-05,  8.710251656013981e-06, -1.020592305297448e-06,  9.400540886666701e-08,
 -7.188632277752214e-09,  4.721825423591798e-10, -2.726484972260205e-11,  1.407356276925931e-12, -6.576888575848103e-14,  2.810385299693181e-15, -1.105538640761383e-16,
  2.986806440446859e-05, -1.141559975345160e-05,  2.347943399085906e-06, -3.321003797849508e-07,  3.593148208204119e-08, -3.155605312423453e-09,  2.336123189520960e-10,
 -1.496431761417603e-11,  8.454197670064042e-13, -4.274510246791196e-14,  1.956601234879613e-15, -8.172866882256973e-17,  4.886706728574226e-04, -3.525624354913549e-05,
  1.608719640448007e-06, -5.914320756227036e-08,  1.903227450978993e-09, -5.580043684671163e-11,  1.523175770640507e-12, -3.921082144268018e-14,  9.629514099988013e-16,
 -2.265956432965633e-17,  5.131582113909932e-19, -1.126778036887059e-20,  1.403229565178444e-03, -1.297994452420320e-04,  7.825498667082444e-06, -3.790196709385717e-07,
  1.587449457673513e-08, -5.967676051693958e-10,  2.058722335037045e-11, -6.612508613967157e-13,  1.997805808264066e-14, -5.719693222845084e-16,  1.560497482799089e-17,
 -4.072770045129365e-19,  1.080308388864887e-03, -1.376871204117034e-04,  1.120912767256945e-05, -7.126144505067885e-07,  3.826889772658945e-08, -1.808505185732859e-09,
  7.710009995860901e-11, -3.014400488841605e-12,  1.093427025241910e-13, -3.711643316744604e-15,  1.186819976540113e-16, -3.590378241341740e-18,  3.387194494468462e-04,
 -6.213106447715069e-05,  6.892260608444791e-06, -5.751516370558876e-07,  3.941631341177541e-08, -2.323109388334642e-09,  1.211196425779556e-10, -5.692656941075863e-12,
  2.444632864314881e-13, -9.688890183664759e-15,  3.571624612008697e-16, -1.230934412250042e-17,  5.406545853099892e-05, -1.448137153159659e-05,  2.200167465802035e-06,
 -2.408898116022508e-07,  2.095223557822136e-08, -1.525431924819813e-09,  9.602559243014858e-11, -5.342759011951769e-12,  2.669451549051866e-13, -1.212168542437449e-14,
  5.049640392563668e-16, -1.942096530629548e-17,  5.844764484148021e-06, -2.150914640390191e-06,  4.282162559614420e-07, -5.894527277257994e-08,  6.233719927391565e-09,
 -5.369572066229652e-10,  3.909567322555972e-11, -2.468477626155240e-12,  1.377123942229325e-13, -6.886030106188472e-15,  3.121142550301193e-16, -1.292363689559911e-17,
  3.695236080189500e-04, -2.478122341951700e-05,  1.050428864374959e-06, -3.595248896958228e-08,  1.079095915397110e-09, -2.956988770439466e-11,  7.575238178480593e-13,
 -1.828601301649949e-14,  4.223732285284055e-16, -9.405952829803813e-18,  2.004020320207967e-19, -4.154847536014061e-21,  9.855211739401883e-04, -8.182991785928846e-05,
  4.479778392644495e-06, -1.988675818517683e-07,  7.686262068738973e-09, -2.680650069894282e-10,  8.618270794547636e-12, -2.589287833917664e-13,  7.342208368628668e-15,
 -1.979122480444077e-16,  5.097604136338799e-18, -1.259390098060821e-19,  6.664962917314026e-04, -7.402442305707976e-05,  5.399439247440214e-06, -3.120291333891743e-07,
  1.538425169957680e-08, -6.725717702938158e-10,  2.668881569574792e-11, -9.764932365253856e-13,  3.329978631882579e-14, -1.067026381757830e-15,  3.233008043438609e-17,
 -9.300016120595286e-19,  1.682676893635062e-04, -2.660034840636541e-05,  2.635586384280063e-06, -1.998712111506336e-07,  1.260234756028807e-08, -6.898402973920329e-10,
  3.365928463043587e-11, -1.490119843174091e-12,  6.060912022192739e-14, -2.286247307973250e-15,  8.055968093940973e-17, -2.664396662036691e-18,  1.880754868250979e-05,
 -4.445353174693626e-06,  6.135399631698519e-07, -6.206642525515352e-08,  5.050041167357324e-09, -3.472213508252604e-10,  2.079916701263320e-11, -1.108109503048184e-12,
  5.329288403936438e-14, -2.339754306346390e-15,  9.459847116724864e-17, -3.542956043963177e-18,  1.239196647510270e-06, -4.323226105673363e-07,  8.238266831319877e-08,
 -1.094316920052902e-08,  1.123722447708756e-09, -9.443647037239609e-11,  6.733459286269168e-12, -4.175805191714949e-13,  2.293670478426374e-14, -1.131438449443610e-15,
  5.067457851542557e-17, -2.076255839454046e-18,  2.848354505354797e-04, -1.784929147703008e-05,  7.058585830541767e-07, -2.258045648771485e-08,  6.347731173719419e-10,
 -1.627138215352616e-11,  3.930956285133167e-13, -8.937915542032125e-15,  1.929341978527553e-16, -4.105139025926617e-18,  8.299904656853323e-20, -1.592722941520705e-21,
  7.172574044927481e-04, -5.379167004303666e-05,  2.684984175693331e-06, -1.095992643985929e-07,  3.919748770209065e-09, -1.270817984158996e-10,  3.814775415706361e-12,
 -1.073701829990799e-13,  2.860088034802809e-15, -7.265631698084832e-17,  1.767797909011614e-18, -4.134900026614102e-20,  4.378725723124321e-04, -4.245669551648973e-05,
  2.779787630765407e-06, -1.462006174475847e-07,  6.622235247052056e-09, -2.679473161433104e-10,  9.893920772174934e-12, -3.385994051202066e-13,  1.084894456427640e-14,
 -3.277646704563962e-16,  9.398193836040465e-18, -2.567275906657143e-19,  9.259141847686577e-05, -1.250226846235618e-05,  1.102813310964544e-06, -7.575270820190077e-08,
  4.379967576058296e-09, -2.219590207329474e-10,  1.010035938062437e-11, -4.197237721161497e-13,  1.611374873510033e-14, -5.764599012807171e-16,  1.934851161496920e-17,
 -6.119876919712586e-19,  7.540678579633577e-06, -1.535285030373219e-06,  1.900063842269961e-07, -1.757083462537276e-08,  1.325270221550225e-09, -8.536904349015909e-11,
  4.831431110028645e-12, -2.448898227891159e-13,  1.127077883784376e-14, -4.759004105274615e-16,  1.858496850510593e-17, -6.748793228714390e-19,  2.920504648876744e-07,
 -9.438836029708497e-08,  1.695692509615886e-08, -2.149285307439501e-09,  2.124542871435462e-10, -1.730030537241647e-11,  1.201307297347979e-12, -7.284251239762646e-14,
  3.924526704038265e-15, -1.903804004452849e-16,  8.403117716874455e-18, -3.399148023951815e-19,  2.232307866074564e-04, -1.313540554951836e-05,  4.865469618657569e-07,
 -1.458899633716475e-08,  3.865170908419081e-10, -9.259182733877867e-12,  2.109395830020640e-13, -4.602185045498145e-15,  9.138367947093449e-17, -1.832281611494100e-18,
  3.760750941655327e-20, -6.240577976268857e-22,  5.380067508928948e-04, -3.667164885099506e-05,  1.675924459561282e-06, -6.310477724504800e-08,  2.094866960746923e-09,
 -6.326593016010962e-11,  1.776502737945776e-12, -4.695124624753526e-14,  1.175767968436504e-15, -2.817684381331900e-17,  6.488796309141324e-19, -1.435439722924525e-20,
  3.035061144700847e-04, -2.577178936272732e-05,  1.518692432598480e-06, -7.285032383260982e-08,  3.034311386923926e-09, -1.138001062880948e-10,  3.912090185319850e-12,
 -1.251621303236521e-13,  3.770111278292253e-15, -1.073559064187513e-16,  2.908399513957650e-18, -7.544598367172871e-20,  5.579508311577390e-05, -6.392645545049523e-06,
  5.015875769775205e-07, -3.116513960283760e-08,  1.648650810565214e-09, -7.721228230274743e-11,  3.269058485494420e-12, -1.271610376500483e-13,  4.596488097002219e-15,
 -1.555056415079403e-16,  4.956529486001291e-18, -1.495103404364735e-19,  3.482398118474979e-06, -5.961626020113554e-07,  6.548292170128054e-08, -5.485280421035122e-09,
  3.803820748864093e-10, -2.279104177602639e-11,  1.210436270215120e-12, -5.800652933621428e-14,  2.540136408972839e-15, -1.026006869140375e-16,  3.851015998665829e-18,
 -1.349724302425039e-19,  7.896747534161925e-08, -2.286107493433671e-08,  3.797111713508754e-09, -4.526985988291687e-10,  4.260491462469289e-11, -3.332585237652215e-12,
  2.237869603404710e-13, -1.319166279854762e-14,  6.938228376509295e-16, -3.296803972030097e-17,  1.429281294495834e-18, -5.691892512191628e-20,  1.774970310616028e-04,
 -9.850651706231758e-06,  3.432576782599566e-07, -9.649682777392160e-09,  2.430042980098652e-10, -5.464267088109070e-12,  1.149014402295334e-13, -2.488626431838401e-15,
  4.706045918867964e-17, -7.553563959344504e-19,  1.830248929223835e-20, -3.368008139855593e-22,  4.140332073390026e-04, -2.580653771124162e-05,  1.084462578013230e-06,
 -3.777383936816118e-08,  1.167985023251207e-09, -3.293849203785592e-11,  8.657749744340713e-13, -2.156388247098766e-14,  5.086733141542813e-16, -1.146544327637255e-17,
  2.516582501588184e-19, -5.271126451114076e-21,  2.201540924155187e-04, -1.643862305392311e-05,  8.744477405155377e-07, -3.839322561575553e-08,  1.471124196125954e-09,
 -5.123586537525942e-11,  1.644554110902524e-12, -4.909694440820794e-14,  1.390407734531746e-15, -3.747527925539269e-17,  9.552140735581883e-19, -2.347405269379071e-20,
  3.638847617636544e-05, -3.522096499165752e-06,  2.460153478302839e-07, -1.384434326566675e-08,  6.686472176058671e-10, -2.892756736033008e-11,  1.139046549574820e-12,
 -4.135623814610682e-14,  1.405133005940075e-15, -4.490822799898194e-17,  1.354536279326219e-18, -3.887738801755537e-20,  1.839213563021045e-06, -2.587119989489148e-07,
  2.505802488525453e-08, -1.889462401387588e-09,  1.196061624072824e-10, -6.626683779841902e-12,  3.283888568079852e-13, -1.479185469049718e-14,  6.130644036549033e-16,
 -2.356869072021115e-17,  8.460006899114914e-19, -2.849025400813327e-20,  2.535399623507927e-08, -6.274079789773772e-09,  9.417566958312811e-10, -1.038163639327990e-10,
  9.179405583831216e-12, -6.824904904929651e-13,  4.394083779844733e-14, -2.500280995116019e-15,  1.276239989807194e-16, -5.910780935361930e-18,  2.506512844325075e-19,
 -9.792475494423003e-21,  1.429366309166008e-04, -7.509116295130351e-06,  2.476108480004606e-07, -6.506973248500325e-09,  1.564400450393561e-10, -3.393426600692787e-12,
  6.305583477551997e-14, -1.305258845332314e-15,  2.949321804390881e-17, -3.191438548611800e-19,  3.415791456380242e-21, -3.348796487656954e-22,  3.256782825770436e-04,
 -1.866992100921444e-05,  7.247300050459711e-07, -2.340374468530555e-08,  6.762029769051797e-10, -1.788771441750442e-11,  4.394224240502259e-13, -1.032596798172704e-14,
  2.323413630728506e-16, -4.869759388185634e-18,  1.006244907632844e-19, -2.123641970070034e-21,  1.659502156038418e-04, -1.095171768056290e-05,  5.269982450228846e-07,
 -2.129914849993966e-08,  7.512632407004835e-10, -2.426086544648185e-11,  7.327692096645744e-13, -2.044369211597088e-14,  5.378911245720472e-16, -1.388336359642138e-17,
  3.379344514105354e-19, -7.556742407257659e-21,  2.539310324282069e-05, -2.072590244388489e-06,  1.289013812026416e-07, -6.607402942592875e-09,  2.907270694232609e-10,
 -1.159401722098885e-11,  4.263581980652879e-13, -1.442261293035087e-14,  4.578703770303810e-16, -1.388207197842599e-17,  3.963499562399675e-19, -1.069007215211984e-20,
  1.097154652202121e-06, -1.242656949198048e-07,  1.057336246545508e-08, -7.168990797342942e-10,  4.115702361819736e-11, -2.098182974994005e-12,  9.670160167174271e-14,
 -4.072261605128328e-15,  1.589087576200241e-16, -5.794214282499866e-18,  1.979462482044602e-19, -6.371081827907711e-21,  9.949640917217701e-09, -1.983031398206985e-09,
  2.629125786680856e-10, -2.631927336563043e-11,  2.153337522390523e-12, -1.503736427912128e-13,  9.190917917527232e-15, -5.005607710192651e-16,  2.462307887408368e-17,
 -1.104988943506416e-18,  4.559991198264208e-20, -1.740209267585608e-21,  1.164212883360076e-04, -5.802690692047508e-06,  1.825424780144311e-07, -4.475295322033040e-09,
  1.012520038971028e-10, -2.222334738478852e-12,  3.803174076041604e-14, -5.441900442699841e-16,  1.750848049504728e-17, -4.026361094497445e-19, -4.618432137749493e-21,
  6.552301577474641e-23,  2.610435689232388e-04, -1.383543316319155e-05,  4.986145322738269e-07, -1.495854666704599e-08,  4.042335029473860e-10, -1.010916348520295e-11,
  2.326489451035222e-13, -5.073890302681041e-15,  1.111456680975292e-16, -2.267771251206171e-18,  3.891090106979749e-20, -8.087359240140974e-22,  1.292032377859008e-04,
 -7.585257927222819e-06,  3.301539644554791e-07, -1.236988537179308e-08,  4.039313178564771e-10, -1.198078780885920e-11,  3.416271805416831e-13, -9.148351607827115e-15,
  2.190694940540641e-16, -5.163876297597419e-18,  1.316254668923724e-19, -2.837950403841122e-21,  1.875524871471944e-05, -1.294045956143460e-06,  7.135674048597342e-08,
 -3.367352622626802e-09,  1.353953223956831e-10, -4.923203686462816e-12,  1.699789392088886e-13, -5.434208885731616e-15,  1.584341397387997e-16, -4.492942793029714e-18,
  1.263312485900912e-19, -3.187049104024702e-21,  7.272197484189261e-07, -6.542289374516465e-08,  4.859796087278241e-09, -2.984495145730420e-10,  1.548030566811951e-11,
 -7.201818754364397e-13,  3.088526996425008e-14, -1.215163487370356e-15,  4.423442193992862e-17, -1.524077302218630e-18,  4.972198562545302e-20, -1.515735923389533e-21,
  4.824813578968121e-09, -7.265277047369348e-10,  8.338913512599572e-11, -7.475404133180991e-12,  5.567820918663204e-13, -3.604494644918277e-14,  2.070798573431829e-15,
 -1.069338483244418e-16,  5.026039913205092e-18, -2.171217351151311e-19,  8.670174626867795e-21, -3.213641143345373e-22,  9.582588926766792e-05, -4.532701964860139e-06,
  1.372412229863299e-07, -3.165466733178760e-09,  6.496543504275210e-11, -1.443448065638848e-12,  2.828763059361924e-14, -2.358917561728602e-16,  1.844970252975085e-18,
 -3.794182484561359e-19,  7.992420412198660e-21,  3.447630588557096e-22,  2.126800079292154e-04, -1.046818407056954e-05,  3.521125563347874e-07, -9.846847539390757e-09,
  2.481698309690254e-10, -5.894627659394227e-12,  1.299188832546917e-13, -2.576571927433777e-15,  5.134317229261322e-17, -1.169151364619687e-18,  2.101808228550754e-20,
 -1.343122521091778e-22,  1.033388380543410e-04, -5.443609100761074e-06,  2.138206364171510e-07, -7.453156029913361e-09,  2.290372673166849e-10, -6.204318223828772e-12,
  1.616562212713292e-13, -4.309388263314238e-15,  1.024666842778814e-16, -1.908337739515628e-18,  4.121256210731063e-20, -1.398248833007649e-21,  1.450852359374548e-05,
 -8.542613528021711e-07,  4.129501775926061e-08, -1.810132997573853e-09,  6.783598736510387e-11, -2.217112312821872e-12,  7.010202171281559e-14, -2.200902159316853e-15,
  6.124869722601272e-17, -1.473698064091239e-18,  3.889368414164613e-20, -1.163160364034064e-21,  5.253751986203939e-07, -3.754012479325809e-08,  2.393782753644298e-09,
 -1.349462172410758e-10,  6.385919306297048e-12, -2.669121729307286e-13,  1.055934297132073e-14, -3.946554582743984e-16,  1.340690012515826e-17, -4.227664589257213e-19,
  1.320691133874867e-20, -3.990303889999044e-22,  2.843578999275951e-09, -3.080218716050155e-10,  2.993532552002915e-11, -2.398264970966605e-12,  1.605521614890415e-13,
 -9.474992612525076e-15,  5.068741008778444e-16, -2.466208267200551e-17,  1.096169862153949e-18, -4.511742586322032e-20,  1.736464882326037e-21, -6.231503897944525e-23,
  7.967270786931719e-05, -3.571009517367563e-06,  1.046529683730236e-07, -2.322345173585026e-09,  4.234139493959670e-11, -8.469643333746983e-13,  2.102625195374158e-14,
 -3.127357172094854e-16, -3.790543435934720e-18,  8.249539936623244e-20,  1.028962416776327e-20, -2.736787148332188e-22,  1.757774488427517e-04, -8.064399043913948e-06,
  2.543730558480826e-07, -6.671488357781757e-09,  1.564289187667420e-10, -3.489989947993517e-12,  7.554633730189928e-14, -1.455141846914218e-15,  2.307786689570895e-17,
 -4.439698915590137e-19,  1.419977714427661e-20, -2.527459759007359e-22,  8.449611492848151e-05, -4.036737519927944e-06,  1.428606905892181e-07, -4.605532233212842e-09,
  1.356533340211756e-10, -3.456647575910554e-12,  7.825916584888705e-14, -1.907916167653609e-15,  5.225673565574625e-17, -1.090371086160920e-18,  9.301768713497722e-21,
 -1.132021428860696e-22,  1.163687260470193e-05, -5.952020593203257e-07,  2.486964530481745e-08, -1.005589763938164e-09,  3.629533678087798e-11, -1.093097114894118e-12,
  2.959641859311388e-14, -8.705015184445052e-16,  2.673483120290936e-17, -6.333687046649572e-19,  9.845193426886796e-21, -2.438517950721592e-22,  4.052701499765815e-07,
 -2.346220179704904e-08,  1.247419033873944e-09, -6.474308357287678e-11,  2.888664861009704e-12, -1.087393305656539e-13,  3.792333780111359e-15, -1.341622374438768e-16,
  4.549866929690578e-18, -1.323175986147924e-19,  3.435237477538865e-21, -1.010902144525924e-22,  1.955121298461644e-09, -1.510243566754961e-10,  1.195273795550772e-11,
 -8.633224149536156e-13,  5.228109786484074e-14, -2.760545008751302e-15,  1.346590298993060e-16, -6.166383934218475e-18,  2.601562452820907e-19, -1.004561610830265e-20,
  3.640812533547464e-22, -1.269201661340814e-23,  6.690138624204891e-05, -2.834866320512338e-06,  8.037081290844170e-08, -1.756145137055380e-09,  2.968805989474668e-11,
 -4.562301574082393e-13,  1.141988486550906e-14, -3.358797623973229e-16,  2.986546916718457e-18,  1.929290703897659e-19, -4.246210625934184e-21, -2.171851624392237e-22,
  1.471365921929391e-04, -6.311825358654266e-06,  1.873135053234736e-07, -4.641018494193815e-09,  1.018409773012261e-10, -2.093793228838736e-12,  4.338153325260739e-14,
 -8.868451285223498e-16,  1.433004925884719e-17, -1.242218581866656e-19,  2.171197419398317e-21, -2.033996604091770e-22,  7.033081907028027e-05, -3.082688834765573e-06,
  9.862379466685626e-08, -2.901295927373790e-09,  8.180734161846151e-11, -2.064243474553611e-12,  4.286152945567339e-14, -7.903579774199700e-16,  2.009558516143750e-17,
 -6.640061468205822e-19,  1.322580419469757e-20,  7.196611217956469e-23,  9.589573795051553e-06, -4.360865844812025e-07,  1.567149430817220e-08, -5.679602141059639e-10,
  1.998116965398593e-11, -5.973026458297936e-13,  1.423535919639250e-14, -3.162964265783698e-16,  9.660743629895053e-18, -3.309559297176912e-19,  6.933546625192676e-21,
 -8.227910066998378e-24,  3.273848769188323e-07, -1.594326600543718e-08,  6.891805042245883e-10, -3.200723574975876e-11,  1.388995570968851e-12, -4.997497151105244e-14,
  1.508003814967885e-15, -4.472551028707114e-17,  1.514720844214353e-18, -5.014914155177645e-20,  1.244158261355133e-21, -2.073941506159003e-23,  1.492348044542721e-09,
 -8.591172192198205e-11,  5.231348844177620e-12, -3.381666069910174e-13,  1.914148849948592e-14, -9.152633558872048e-16,  3.929354375956155e-17, -1.632971128670023e-18,
  6.637652325961897e-20, -2.499368423461326e-21,  8.395170936784103e-23, -2.610512343849920e-24,  5.672497660592035e-05, -2.268731195230873e-06,  6.188613255346163e-08,
 -1.342176720748027e-09,  2.262018775651650e-11, -2.792731137701615e-13,  4.096004382169970e-15, -1.724540461377757e-16,  5.801985676632785e-18, -3.658168922108940e-20,
 -4.555442118351452e-21,  1.369073360031538e-22,  1.245689165742083e-04, -5.011238798576718e-06,  1.401784239008024e-07, -3.297560591168115e-09,  6.861664943652958e-11,
 -1.302668421797637e-12,  2.434128888869500e-14, -4.953613856850733e-16,  1.005203063603464e-17, -1.313925812745534e-19, -6.981170079106848e-22,  3.888202392264111e-23,
  5.938524039990515e-05, -2.413516529820820e-06,  7.046243892024472e-08, -1.873229479327071e-09,  4.931195632608960e-11, -1.246867835512274e-12,  2.687192365001887e-14,
 -4.280830714664818e-16,  5.480409626918422e-18, -1.786855547341305e-19,  8.833269772888557e-21, -2.154935603940190e-22,  8.059418386941698e-06, -3.333419703140467e-07,
  1.043308947125358e-08, -3.277722167632952e-10,  1.087488552618970e-11, -3.361416983377415e-13,  8.284660335511530e-15, -1.467840356356409e-16,  2.369945229917963e-18,
 -9.206279089174115e-20,  4.272636198739279e-21, -1.007744103915481e-22,  2.726532918849536e-07, -1.165332710246427e-08,  4.108569778854564e-10, -1.615841621562397e-11,
  6.723317476133871e-13, -2.469715071341904e-14,  7.223578372817137e-16, -1.706173920869411e-17,  4.217109376849042e-19, -1.505147524452293e-20,  5.554832420450717e-22,
 -1.333613213033339e-23,  1.212560687353010e-09, -5.620749762503946e-11,  2.538817664480922e-12, -1.392080556460060e-13,  7.520286493270103e-15, -3.453675726876365e-16,
  1.337132840331866e-17, -4.715527067398622e-19,  1.696064809237748e-20, -6.376606270346614e-22,  2.258709782944451e-23, -6.764704171177707e-25,  4.854638650301479e-05,
 -1.832310423309763e-06,  4.778089961004068e-08, -1.020886045086843e-09,  1.772630821611292e-11, -2.201027837533684e-13,  1.489102896992408e-15, -3.078782628486969e-17,
  2.695291225965393e-18, -9.902407200110219e-20,  8.654380140055171e-22,  6.914092990025175e-23,  1.065401739555713e-04, -4.031225378622785e-06,  1.064265160192860e-07,
 -2.380499067314199e-09,  4.745064236974875e-11, -8.530312698807238e-13,  1.424930696873769e-14, -2.505089190072751e-16,  5.349664995399515e-18, -1.154133820409116e-19,
  1.363122496411629e-21,  2.652749258452139e-23,  5.073290852560163e-05, -1.928005747605354e-06,  5.199780546466001e-08, -1.252470688776507e-09,  2.993756463809235e-11,
 -7.299237078918924e-13,  1.675351200842116e-14, -3.056421992034372e-16,  3.205652110033537e-18, -1.072756441111101e-21,  9.243344138217001e-22, -1.055765410127473e-22,
  6.871652153274391e-06, -2.630995167178009e-07,  7.353440330349820e-09, -1.980260652488085e-10,  5.842364685868581e-12, -1.801555943995750e-13,  4.923835530449652e-15,
 -9.945748570522749e-17,  1.107489546311004e-18, -2.959395984431477e-21,  5.803691669284603e-22, -5.045857536541663e-23,  2.316011747525220e-07, -8.991334116570118e-09,
  2.678618232974730e-10, -8.550810919917343e-12,  3.192868975612633e-13, -1.194237269388072e-14,  3.765127547357751e-16, -8.993625252457508e-18,  1.545670208624859e-19,
 -2.698859275760644e-21,  1.184912449268349e-22, -5.845126860245970e-24,  1.020087579033712e-09, -4.096369196921713e-11,  1.408708350017849e-12, -6.031219831040264e-14,
  2.998246420010023e-15, -1.377611644991046e-16,  5.280164699878721e-18, -1.682121674968109e-19,  4.825018035730528e-21, -1.482169848004709e-22,  5.336457968745409e-24,
 -1.920833245591191e-25,  4.191043248525256e-05, -1.494567021214956e-06,  3.709255041136333e-08, -7.706964796965346e-10,  1.364942285185400e-11, -1.879128211877438e-13,
  1.369593569911436e-15,  8.829368067917157e-18,  1.566015241788021e-19, -3.830649165409523e-20,  1.511595947983901e-21, -2.057767958841365e-23,  9.195382946888735e-05,
 -3.282357103583203e-06,  8.190719962630060e-08, -1.741274677992529e-09,  3.332687074633145e-11, -5.793017495194356e-13,  9.089832163502977e-15, -1.340955312449896e-16,
  2.293457509328179e-18, -5.485230637741930e-20,  1.334302170872666e-21, -1.817640733047592e-23,  4.376785809805274e-05, -1.564980024451945e-06,  3.942373357654728e-08,
 -8.711114168563151e-10,  1.872685111696757e-11, -4.188965841378751e-13,  9.637932922937701e-15, -2.028614936004157e-16,  3.123721562917855e-18, -1.373168233127787e-20,
 -7.275412066374085e-22,  7.700655865061535e-24,  5.923788748967152e-06, -2.124246534218382e-07,  5.437475597635844e-09, -1.278276101978362e-10,  3.215989659811222e-12,
 -9.141852743750864e-14,  2.632233002622172e-15, -6.432727620436290e-17,  1.070479860936070e-18, -4.443744776982778e-21, -2.731735749065829e-22,  1.573704147041475e-24,
  1.993739841385860e-07, -7.187382484893305e-09,  1.894003043448040e-10, -4.938502166271330e-12,  1.529987387038904e-13, -5.436080856275854e-15,  1.835855453635082e-16,
 -5.060955523366560e-18,  9.993312503914046e-20, -1.079426048315244e-21,  1.626136171235779e-24, -4.797748087182330e-25,  8.751116300947253e-10, -3.194500930719251e-11,
  9.004409537961293e-13, -2.883559706282612e-14,  1.202276105366692e-15, -5.389960091891779e-17,  2.147651208688572e-18, -7.054120641224162e-20,  1.879711106666602e-21,
 -4.280260267789049e-23,  1.048656640550225e-24, -3.623651006956693e-26,  3.647195219697264e-05, -1.231381016761640e-06,  2.903652605885556e-08, -5.805041861717888e-10,
  1.023877259482023e-11, -1.524167118407016e-13,  1.551042757251364e-15,  1.384678033641037e-18, -3.907256117550241e-19,  7.223964502058666e-22,  4.593655224795330e-22,
 -1.946940923554221e-23,  8.001430588766602e-05, -2.702425114795444e-06,  6.386416614643937e-08, -1.290027347114437e-09,  2.365459322031177e-11, -3.994062070870589e-13,
  6.129556311005597e-15, -8.366843220506257e-17,  1.073847261421758e-18, -1.840107159563550e-20,  5.208246609868556e-22, -1.459417977209673e-23,  3.807895702930370e-05,
 -1.286873659109286e-06,  3.052760915838852e-08, -6.276730344138698e-10,  1.225772253631081e-11, -2.450835516047706e-13,  5.249238073844546e-15, -1.152843422183235e-16,
  2.253755541796737e-18, -2.980689692805607e-20, -4.273297162334777e-23,  1.406765766923017e-23,  5.152451294321833e-06, -1.743052468335226e-07,  4.161550458189934e-09,
 -8.811163542143783e-11,  1.892589471865943e-12, -4.620302566815123e-14,  1.273591521090800e-15, -3.436540935179456e-17,  7.639126763314957e-19, -1.079920953033434e-20,
 -2.104755452294060e-23,  5.597923990355808e-24,  1.733290876375857e-07, -5.874534396451233e-09,  1.418968112327443e-10, -3.163038328167420e-12,  7.857464823351705e-14,
 -2.405053275667422e-15,  8.080604970606420e-17, -2.484679489649669e-18,  6.126529110634411e-20, -1.031313923976410e-21,  5.514090871865758e-24,  2.418473611437153e-25,
  7.599201819591549e-10, -2.586519715624461e-11,  6.417547013207943e-13, -1.598772600755359e-14,  5.096774703661434e-16, -2.045445303954952e-17,  8.272678716050056e-19,
 -2.915233962386525e-20,  8.422238499900602e-22, -1.923635128299275e-23,  3.414053657768501e-25, -5.627109884426234e-27,  3.197053698871039e-05, -1.024386629768633e-06,
  2.295933202493561e-08, -4.390589144136392e-10,  7.558973701212996e-12, -1.160243286260290e-13,  1.435754346521103e-15, -8.528358228292615e-18, -1.946362883291907e-19,
  6.917933707483935e-21, -3.881661601556518e-23, -4.514609823724886e-24,  7.013673386524343e-05, -2.247557911062219e-06,  5.041493919008171e-08, -9.681992185746413e-10,
  1.696570793450591e-11, -2.770219640053483e-13,  4.190761540203350e-15, -5.693064608120768e-17,  6.631235923457169e-19, -7.014230882201470e-21,  1.236776815397515e-22,
 -4.411188588173633e-24,  3.337646684030964e-05, -1.069779943627579e-06,  2.403001837595788e-08, -4.648813288534033e-10,  8.392354701844545e-12, -1.506657254800141e-13,
  2.873075661692510e-15, -5.970187134330166e-17,  1.261254548781087e-18, -2.325487132441686e-20,  2.761395800161192e-22,  1.442015146502793e-24,  4.515764626427020e-06,
 -1.447882943989923e-07,  3.260000800260366e-09, -6.384396116452719e-11,  1.209013819415335e-12, -2.477621136702386e-14,  5.962975874811429e-16, -1.591941641217975e-17,
  4.044302691343639e-19, -8.342995003847442e-21,  1.060862275152438e-22,  5.521231132722146e-25,  1.518869977732709e-07, -4.872887253414646e-09,  1.101815483950673e-10,
 -2.205370710811047e-12,  4.523809930721433e-14, -1.111374947352539e-15,  3.350246320622185e-17, -1.059389567683120e-18,  2.996859333327283e-20, -6.766822174096608e-22,
  1.020120378338647e-23, -2.159514689431268e-26,  6.656745099417665e-10, -2.138520146826643e-11,  4.881828829955907e-13, -1.025693120165982e-14,  2.463497618108991e-16,
 -7.905397384146971e-18,  3.007059459072128e-19, -1.103088277430363e-20,  3.500222971695241e-22, -9.115307501757607e-24,  1.844992384994608e-25, -2.602702236054774e-27,
  2.820965621879611e-05, -8.598953986381729e-07,  1.834552888426658e-08, -3.348980720135675e-10,  5.561003118450910e-12, -8.492301787245532e-14,  1.143536609140823e-15,
 -1.131737469498146e-17, -4.995067139754981e-22,  3.555299286024539e-21, -9.195558900415361e-23,  7.331493601087216e-25,  6.188555942759047e-05, -1.886485381815517e-06,
  4.025874081739427e-08, -7.361082069060668e-10,  1.231343472082459e-11, -1.933812106310558e-13,  2.860928608003331e-15, -3.907671463904460e-17,  4.674272025201504e-19,
 -4.436981060449052e-21,  3.229345496585661e-23, -6.138087543665598e-25,  2.944944468885601e-05, -8.977785717344996e-07,  1.916842943956045e-08, -3.514591381038346e-10,
  5.953743019131849e-12, -9.790757708339613e-14,  1.655934306274230e-15, -3.059780376634770e-17,  6.211293823839420e-19, -1.268874626149393e-20,  2.240320357589418e-22,
 -2.534231921328946e-24,  3.984339490395785e-06, -1.214772113978361e-07,  2.595747125674696e-09, -4.781486760310849e-11,  8.269838270447087e-13, -1.459955311715183e-14,
  2.924619488239678e-16, -6.963826023918584e-18,  1.794650360896955e-19, -4.315026923950709e-21,  8.416032187344161e-23, -1.026117333135881e-24,  1.340061944294842e-07,
 -4.086436425937406e-09,  8.744452618676475e-11, -1.624090982914183e-12,  2.912298927372544e-14, -5.746938120692263e-16,  1.414101010776150e-17, -4.158195386795501e-19,
  1.235553151876420e-20, -3.248673935465023e-22,  6.857747401465318e-24, -9.760628059662035e-26,  5.872465286766580e-10, -1.791497354805576e-11,  3.845622411335272e-13,
 -7.273746142402792e-15,  1.408161881801272e-16, -3.386689432488738e-18,  1.082553187281742e-19, -3.864254692952374e-21,  1.295443698056746e-22, -3.758170899690341e-24,
  9.008776380913682e-26, -1.674185366947172e-27,  2.504012762916868e-05, -7.278136076132416e-07,  1.480909779136340e-08, -2.581250266876267e-10,  4.111730017327372e-12,
 -6.118775164398088e-14,  8.410704659593235e-16, -9.913415209412261e-18,  7.168235894210604e-20,  7.711292214403939e-22, -4.560528208727264e-23,  1.023070408268438e-24,
  5.493218277214537e-05, -1.596670826355838e-06,  3.249103780724459e-08, -5.666470058862964e-10,  9.051945762128150e-12, -1.362980805243745e-13,  1.953747376340191e-15,
 -2.645851939543900e-17,  3.272774543796917e-19, -3.399821660557220e-21,  2.360086928234841e-23, -2.049650075078550e-26,  2.614042049316914e-05, -7.598178462891099e-07,
  1.546414548782728e-08, -2.699608484244180e-10,  4.333644017114062e-12, -6.656573076058042e-14,  1.019841572554792e-15, -1.652123286957590e-17,  2.986324636280081e-19,
 -5.938650633882351e-21,  1.177084409652092e-22, -2.014807915947489e-24,  3.536619742715051e-06, -1.028014094763021e-07,  2.092802194128032e-09, -3.659393246440062e-11,
  5.922119179023964e-13, -9.393876012877116e-15,  1.586398830099350e-16, -3.145208356010032e-18,  7.389070515430539e-20, -1.832650710370394e-21,  4.190813929499009e-23,
 -7.839436056069732e-25,  1.189462921047075e-07, -3.457685679613158e-09,  7.042252616882520e-11, -1.234910509591757e-12,  2.027115990627361e-14, -3.394629755772966e-16,
  6.605621734042440e-18, -1.626629731728588e-19,  4.622579505329813e-21, -1.291750990447576e-22,  3.184988596349683e-24, -6.384369673607807e-26,  5.212350797454504e-10,
 -1.515369735921567e-11,  3.089344165061495e-13, -5.451135639983497e-15,  9.226994972760723e-17, -1.721923616100586e-18,  4.195897689185468e-20, -1.315490520447602e-21,
  4.387714222629681e-23, -1.354809269874229e-24,  3.637603106223161e-26, -8.155543130674450e-28,  2.234766597351788e-05, -6.206987646320983e-07,  1.206924617480665e-08,
 -2.011201220667969e-10,  3.068757403053320e-12, -4.405869284665111e-14,  5.977357309771509e-16, -7.448862640529704e-18,  7.600928045072683e-20, -3.130720744827290e-22,
 -1.264970756342260e-23,  4.800839714627632e-25,  4.902551312788455e-05, -1.361671240767110e-06,  2.647791640842656e-08, -4.413078584475591e-10,  6.740535440584410e-12,
 -9.722139236026624e-14,  1.342417648249795e-15, -1.776368233464137e-17,  2.216131721908980e-19, -2.481662840127933e-21,  2.182480838163228e-23, -7.861445163409074e-26,
  2.332959914922125e-05, -6.479773016070413e-07,  1.260063164121088e-08, -2.100832845129211e-10,  3.214469319768354e-12, -4.672980348333930e-14,  6.644636891952345e-16,
 -9.631085211992421e-18,  1.511430089768961e-19, -2.685855955727029e-21,  5.233707624962423e-23, -1.008213798953092e-24,  3.156327917273644e-06, -8.766748526487236e-08,
  1.704925746175980e-09, -2.844051027607610e-11,  4.364339952585669e-13, -6.427036016906212e-15,  9.571417530260903e-17, -1.572234536151991e-18,  3.098799499695666e-20,
 -7.146234569448652e-22,  1.702372494133326e-23, -3.716887938305731e-25,  1.061556228263335e-07, -2.948534074360354e-09,  5.734987617504814e-11, -9.575675076245725e-13,
  1.476928546275322e-14, -2.224079639298527e-16,  3.569918709256485e-18, -6.933212248344210e-20,  1.696731434085692e-21, -4.628564492072430e-23,  1.219054015808822e-24,
 -2.838014783781713e-26,  4.651813193273812e-10, -1.292109327902776e-11,  2.513910378844490e-13, -4.205769683278286e-15,  6.557840513979222e-17, -1.034811800003967e-18,
  1.909981779121807e-20, -4.702701090863637e-22,  1.427055454519907e-23, -4.445588830928713e-25,  1.273528128389691e-26, -3.193720424181679e-28,  2.004378980675993e-05,
 -5.330260968035060e-07,  9.923669316381887e-09, -1.583560758867693e-10,  2.315512534443723e-12, -3.195402800423075e-14,  4.210310222491240e-16, -5.260743701769621e-18,
  5.960272630832318e-20, -5.155063420108254e-22,  8.316198180532489e-26,  1.431770541752387e-25,  4.397134233222655e-05, -1.169334449143523e-06,  2.177038820939254e-08,
 -3.474198940814398e-10,  5.081812334086747e-12, -7.024732942055635e-14,  9.320425474748756e-16, -1.194096781493413e-17,  1.469785314554122e-19, -1.696021173417257e-21,
  1.714177109732909e-23, -1.220197188454559e-25,  2.092448100858242e-05, -5.564477292964148e-07,  1.035995721236376e-08, -1.653449562289465e-10,  2.419993066219522e-12,
 -3.354899016462866e-14,  4.504112981730604e-16, -6.011501805259580e-18,  8.335062316977832e-20, -1.276646818142702e-21,  2.234291298320748e-23, -4.260360916735835e-25,
  2.830930959754342e-06, -7.528353900083399e-08,  1.401663113307545e-09, -2.237429647892133e-11,  3.277919209809886e-13, -4.565882799622851e-15,  6.248365064257107e-17,
 -8.877432968525669e-19,  1.433135396901800e-20, -2.806599940302021e-22,  6.320037847229028e-24, -1.444101679052975e-25,  9.521156968357051e-08, -2.531991763618951e-09,
  4.714363264402900e-11, -7.527555413974933e-13,  1.104688961119862e-14, -1.551460779720556e-16,  2.193235331732757e-18, -3.432239119388557e-20,  6.676175122196776e-22,
 -1.609922436160248e-23,  4.198636726611780e-25, -1.044693588018904e-26,  4.172228532232295e-10, -1.109543471668929e-11,  2.066046799094941e-13, -3.300887144641376e-15,
  4.861437377279105e-17, -6.946840160351478e-19,  1.048595100399096e-20, -1.939145843571901e-22,  4.780231314369929e-24, -1.391205126582022e-25,  4.054741080579929e-27,
 -1.084061282572672e-28,  1.805925839571215e-05, -4.606532513056149e-07,  8.226246402440665e-09, -1.259179174936223e-10,  1.766590033144613e-12, -2.341824920068982e-14,
  2.977026232013044e-16, -3.640536819499030e-18,  4.216333563296101e-20, -4.342837007761773e-22,  3.070455100694167e-24,  1.656952909670144e-26,  3.961774677739615e-05,
 -1.010564653022635e-06,  1.804648809739620e-08, -2.762398802574827e-10,  3.875997565527036e-12, -5.141094446529398e-14,  6.552456422336388e-16, -8.092708842242672e-18,
  9.697689573792707e-20, -1.116363223130512e-21,  1.194583522655330e-23, -1.083796998678665e-25,  1.885274971983033e-05, -4.808938337898295e-07,  8.587752880997743e-09,
 -1.314578660539587e-10,  1.844875199312386e-12, -2.449468403157186e-14,  3.135677342537710e-16, -3.937963038377736e-18,  4.982780545565848e-20, -6.662301765621088e-22,
  1.000454691904523e-23, -1.723395824121049e-25,  2.550640308840517e-06, -6.506149024386091e-08,  1.161868950217203e-09, -1.778631187866945e-11,  2.496906309660912e-13,
 -3.320592269708443e-15,  4.281518397951724e-17, -5.522486040392539e-19,  7.570880414761553e-21, -1.207893221845288e-22,  2.342969475621372e-24, -5.126837549508152e-26,
  8.578464403697398e-08, -2.188188922020377e-09,  3.907713415801943e-11, -5.982578933961630e-13,  8.403064931525950e-15, -1.120653795375424e-16,  1.462906243106957e-18,
 -1.972340607382117e-20,  3.041382298911941e-22, -5.914513461213404e-24,  1.394557925304166e-25, -3.468541359967777e-27,  3.759132996119429e-10, -9.588791912278987e-12,
  1.712424095710477e-13, -2.622117884296433e-15,  3.687065258525110e-17, -4.945959883148884e-19,  6.623220950193429e-21, -9.729031132678969e-23,  1.810048860510165e-24,
 -4.420173051086296e-26,  1.227074227864977e-27, -3.353432618574297e-29,  1.633932999142022e-05, -4.004400627816925e-07,  6.870537005934537e-09, -1.010432840695433e-10,
  1.362146737005700e-12, -1.735772450214494e-14,  2.124791715178795e-16, -2.517219762485349e-18,  2.878524749638469e-20, -3.103172635154042e-22,  2.899625371149912e-24,
 -1.573743412824759e-26,  3.584462965457736e-05, -8.784709429811423e-07,  1.507234553875118e-08, -2.216664086330642e-10,  2.988349380848442e-12, -3.808758984851185e-14,
  4.666596825381454e-16, -5.549063242203560e-18,  6.431857981360203e-20, -7.251485759667755e-22,  7.838997992372143e-24, -7.791498026063997e-26,  1.705725011173471e-05,
 -4.180347315008189e-07,  7.172429325618417e-09, -1.054846271104105e-10,  1.422152617873731e-12, -1.813175979394595e-14,  2.224983584895848e-16, -2.662496583291521e-18,
  3.156322707786147e-20, -3.814642223869687e-22,  4.947111785379982e-24, -7.297884549280969e-26,  2.307722145391069e-06, -5.655707459324945e-08,  9.703794883175108e-10,
 -1.427153629165925e-11,  1.924284125508704e-13, -2.454672298977465e-15,  3.019767944740590e-17, -3.650797074881604e-19,  4.483901905450502e-21, -5.978894470945000e-23,
  9.447256367297132e-25, -1.806659820715552e-26,  7.761467165551055e-08, -1.902161399200015e-09,  3.263647958794516e-11, -4.800018590641883e-13,  6.473090644753103e-15,
 -8.264746525520166e-17,  1.021132116788415e-18, -1.256189845937698e-20,  1.633623696160753e-22, -2.496563250288165e-24,  4.832044859194717e-26, -1.106689856509646e-27,
  3.401119622961547e-10, -8.335385327313257e-12,  1.430158381753420e-13, -2.103510564828844e-15,  2.837627476848066e-17, -3.629749074599843e-19,  4.524555008527116e-21,
 -5.765339059295176e-23,  8.333614077832219e-25, -1.557385953000420e-26,  3.731939819535977e-28, -9.849971859628754e-30,  1.484030945332128e-05, -3.499800358790388e-07,
  5.778163854601955e-09, -8.177131525812128e-11,  1.060775128439347e-12, -1.300948088215017e-14,  1.533644822655445e-16, -1.753927121144191e-18,  1.951744083664346e-20,
 -2.098331415189257e-22,  2.111730448328561e-24, -1.783577386204665e-26,  3.255613264229702e-05, -7.677735211380360e-07,  1.267592863380875e-08, -1.793872403849601e-10,
  2.327117631552459e-12, -2.854178092636333e-14,  3.365712871942354e-16, -3.854229407889763e-18,  4.310863298725229e-20, -4.717392965687156e-22,  5.026474610612826e-24,
 -5.118912605385277e-26,  1.549236522421464e-05, -3.653575267811588e-07,  6.032048679686075e-09, -8.536457273757026e-11,  1.107419015359874e-12, -1.358372745530880e-14,
  1.602646897263031e-16, -1.839389967375581e-18,  2.075132902916373e-20, -2.337945487092993e-22,  2.714268642083893e-24, -3.427105273895690e-26,  2.096004557965374e-06,
 -4.943022331944533e-08,  8.160928065310926e-10, -1.154925851887106e-11,  1.498306053241844e-13, -1.838142365846619e-15,  2.170501016215590e-17, -2.500238270780726e-19,
  2.860125861902400e-21, -3.370509895004230e-23,  4.394640545952136e-25, -6.872954787126244e-27,  7.049405985317195e-08, -1.662466498093639e-09,  2.744733665193571e-11,
 -3.884343573815008e-13,  5.039465184364455e-15, -6.184208903428568e-17,  7.312740823485321e-19, -8.476172256111497e-21,  9.924612831855874e-23, -1.254966763517070e-24,
  1.904866632677741e-26, -3.647649232753710e-28,  3.089090218843545e-10, -7.285024697207981e-12,  1.202760001759035e-13, -1.702166545787270e-15,  2.208560489429294e-17,
 -2.711763547263964e-19,  3.215833605810117e-21, -3.774758808652033e-23,  4.627516945639966e-25, -6.624714353145072e-27,  1.237828088578354e-28, -2.887285522848663e-30,
  1.352700811959148e-05, -3.074097704812937e-07,  4.890761287371277e-09, -6.669595447877619e-11,  8.337522063045335e-13, -9.853911589117127e-15,  1.119703842078668e-16,
 -1.235397929587327e-18,  1.330525433645801e-20, -1.398717432812317e-22,  1.419540547183828e-24, -1.336489927481665e-26,  2.967505978361748e-05, -6.743844071202244e-07,
  1.072917522582593e-08, -1.463152302163102e-10,  1.829061476646349e-12, -2.161761695665393e-14,  2.456654755146242e-16, -2.711701425218478e-18,  2.925860079362824e-20,
 -3.096535950414648e-22,  3.213878114498021e-24, -3.247859660058821e-26,  1.412135982603716e-05, -3.209167901451749e-07,  5.105652930324501e-09, -6.962653349665382e-11,
  8.703935681481758e-13, -1.028746700181585e-14,  1.169272053230444e-16, -1.291643080601678e-18,  1.397986766803792e-20, -1.496333483957015e-22,  1.610594779007869e-24,
 -1.803669036400129e-26,  1.910517475332045e-06, -4.341771255095715e-08,  6.907578655854028e-10, -9.419975709166178e-12,  1.177589984918562e-13, -1.391900674029780e-15,
  1.582449027563601e-17, -1.750208965940470e-19,  1.903853856411676e-21, -2.074840751772417e-23,  2.359512957848349e-25, -3.017080281365027e-27,  6.425564880403959e-08,
 -1.460250100233114e-09,  2.323198013165592e-11, -3.168187923012717e-13,  3.960599753118531e-15, -4.681778747650982e-17,  5.325066632416379e-19, -5.901841306772076e-21,
  6.474717951688175e-23, -7.269455513980803e-25,  8.987028274784371e-27, -1.353862431189617e-28,  2.815719441548536e-10, -6.398900019713696e-12,  1.018039120010914e-13,
 -1.388323418423186e-15,  1.735608655775320e-17, -2.051976190519476e-19,  2.335986213691769e-21, -2.599828521679551e-23,  2.901134630114028e-25, -3.449055591036409e-27,
  4.904352081421154e-29, -9.104127438434343e-31,  1.237085386704058e-05, -2.712723897998799e-07,  4.164389252539333e-09, -5.479748700685175e-11,  6.609752287870329e-13,
 -7.537892088300026e-15,  8.265489232254286e-17, -8.803036701475144e-19,  9.162864327418086e-21, -9.347623892813314e-23,  9.324025336900385e-25, -8.961251658225051e-27,
  2.713873051331992e-05, -5.951075300104395e-07,  9.135686202826920e-09, -1.202127531942078e-10,  1.450024809116414e-12, -1.653645600573159e-14,  1.813317594931284e-16,
 -1.931526053534899e-18,  2.011738644682318e-20, -2.057298569139750e-22,  2.069676860210889e-24, -2.044702613930421e-26,  1.291440628840525e-05, -2.831915971657876e-07,
  4.347364943495670e-09, -5.720520468150613e-11,  6.900189493914374e-13, -7.869223098764956e-15,  8.629485105002080e-17, -9.194279905479180e-19,  9.586273962502443e-21,
 -9.843762604409721e-23,  1.004512150538135e-24, -1.037083886519647e-26,  1.747225422267772e-06, -3.831376743469895e-08,  5.881669365598174e-10, -7.739451293689701e-12,
  9.335478409957653e-14, -1.064666429349207e-15,  1.167619334715263e-17, -1.244529531392937e-19,  1.299816895471971e-21, -1.343600824167490e-23,  1.402319809072411e-25,
 -1.545133986754155e-27,  5.876371426643508e-08, -1.288591192562183e-09,  1.978157775938111e-11, -2.602979142739808e-13,  3.139775815202014e-15, -3.580847502918482e-17,
  3.927638335552130e-19, -4.189118458314694e-21,  4.387875797052470e-23, -4.586355664179297e-25,  4.965432201220557e-27, -6.020383803962456e-29,  2.575059711265086e-10,
 -5.646680659016035e-12,  8.668401826930852e-14, -1.140641506496865e-15,  1.375878539799018e-17, -1.569231826730840e-19,  1.721656025564344e-21, -1.838678875662379e-23,
  1.937026728910626e-25, -2.069561115011525e-27,  2.399499909860199e-29, -3.388610883419524e-31,  1.134846946951157e-05, -2.404185665540616e-07,  3.565625610348229e-09,
 -4.532798593016780e-11,  5.282169524941536e-13, -5.819693753173100e-15,  6.165262283428989e-17, -6.344446320096642e-19,  6.383467166213932e-21, -6.304729784855179e-23,
  6.119537516962442e-25, -5.811641015868621e-27,  2.489586070359951e-05, -5.274215312279811e-07,  7.822140157680439e-09, -9.943889432474212e-11,  1.158783472393749e-12,
 -1.276705490661235e-14,  1.352526930409933e-16, -1.391898530559936e-18,  1.400746878851381e-20, -1.384633060648307e-22,  1.348146295617503e-24, -1.293813021904651e-26,
  1.184710021144213e-05, -2.509821134782046e-07,  3.722292627455101e-09, -4.731961738779563e-11,  5.514261854846008e-13, -6.075428171371146e-15,  6.436331899004962e-17,
 -6.624192538333125e-19,  6.668615925116031e-21, -6.601280967393157e-23,  6.461109875360151e-25, -6.309622983163185e-27,  1.602826657684206e-06, -3.395605803280144e-08,
  5.035991752272943e-10, -6.402001219885268e-12,  7.460400817916378e-14, -8.219650927484449e-16,  8.708133162067385e-18, -8.963389805130981e-20,  9.028537191761973e-22,
 -8.957864273980246e-24,  8.841651358760359e-26, -8.872747342187418e-28,  5.390720997579175e-08, -1.142030139778441e-09,  1.693734421066909e-11, -2.153159018841465e-13,
  2.509128595461478e-15, -2.764502268218371e-17,  2.928906123017334e-19, -3.015368815108564e-21,  3.040121654333915e-23, -3.027927847649186e-25,  3.030732262810327e-27,
 -3.176855577213058e-29,  2.362244902992438e-10, -5.004441673644333e-12,  7.422041681962313e-14, -9.435268723734024e-16,  1.099516777880820e-17, -1.211438274618097e-19,
  1.283578058540347e-21, -1.321990604283174e-23,  1.335290717950256e-25, -1.340049882763992e-27,  1.378288483900493e-29, -1.563827015523172e-31,  1.044059208207204e-05,
 -2.139339819865733e-07,  3.068802470510845e-09, -3.773292059344276e-11,  4.252917587369875e-13, -4.532061489106998e-15,  4.643774600823411e-17, -4.622231565007537e-19,
  4.498999850748940e-21, -4.301010497749836e-23,  4.048661408345020e-25, -3.751839513409510e-27,  2.290419222029800e-05, -4.693206101322330e-07,  6.732227556138757e-09,
 -8.277711318257915e-11,  9.329896929360784e-13, -9.942276701071960e-15,  1.018737419301327e-16, -1.014024991904615e-18,  9.870542274835669e-21, -9.438795174897898e-23,
  8.894648899213227e-25, -8.274303954555428e-27,  1.089933237184391e-05, -2.233338451747291e-07,  3.203639976153954e-09, -3.939083602839196e-11,  4.439783655561874e-13,
 -4.731197723408048e-15,  4.847851577055567e-17, -4.825535601917166e-19,  4.697698835055135e-21, -4.494329544069650e-23,  4.242995955338659e-25, -3.972664279431591e-27,
  1.474600549021943e-06, -3.021544802141760e-08,  4.334292335329795e-10, -5.329294267399956e-12,  6.006705986095171e-14, -6.400974926453081e-16,  6.558842684275097e-18,
 -6.528885951311212e-20,  6.357032668171756e-22, -6.086420012321478e-24,  5.762979551793393e-26, -5.451710035300071e-28,  4.959463398128089e-08, -1.016223740380940e-09,
  1.457734724761701e-11, -1.792379684345853e-13,  2.020211273306476e-15, -2.152817904894044e-17,  2.205937020380377e-19, -2.195992499401871e-21,  2.138808531031500e-23,
 -2.050339079851602e-25,  1.950932154779032e-27, -1.877212079442718e-29,  2.173265345799705e-10, -4.453150798890183e-12,  6.387877322592764e-14, -7.854311171049720e-16,
  8.852686322008830e-18, -9.433807550718168e-20,  9.666779991297978e-22, -9.624303816730897e-24,  9.378946179963255e-26, -9.013109439615088e-28,  8.658828450321326e-30,
 -8.607610324415025e-32,  9.631243991763271e-06, -1.910855790837274e-07,  2.654029068028937e-09, -3.159695243384003e-11,  3.448256547286916e-13, -3.557920619271735e-15,
  3.529882468518359e-17, -3.401996645238013e-19,  3.206355116308545e-21, -2.968677700692473e-23,  2.708368435292690e-25, -2.438192335738306e-27,  2.112867373549327e-05,
 -4.191966125572180e-07,  5.822312706381374e-09, -6.931624831948909e-11,  7.564660261078526e-13, -7.805238151318968e-15,  7.743734363261531e-17, -7.463211882233155e-19,
  7.034156621675911e-21, -6.513314243450572e-23,  5.944352272463708e-25, -5.358611195187205e-27,  1.005442302455454e-05, -1.994815257193411e-07,  2.770642193589995e-09,
 -3.298526418659065e-11,  3.599766708031684e-13, -3.714250267514581e-15,  3.684986904863315e-17, -3.551518704221118e-19,  3.347454528377237e-21, -3.100056302367596e-23,
  2.830987799856244e-25, -2.557852109984570e-27,  1.360290447727441e-06, -2.698840234578153e-08,  3.748477761797038e-10, -4.462666816560593e-12,  4.870223241808994e-14,
 -5.025112594597119e-16,  4.985530430429710e-18, -4.805007070247912e-20,  4.529157557747523e-22, -4.195425674222719e-24,  3.835043639391773e-26, -3.477701729691150e-28,
  4.575008934278852e-08, -9.076898398091612e-10,  1.260710114513523e-11, -1.500910393037030e-13,  1.637982268872433e-15, -1.690076338628435e-17,  1.676768801182722e-19,
 -1.616081399204948e-21,  1.523436061493713e-23, -1.411739232201425e-25,  1.292576071665399e-27, -1.179257514684243e-29,  2.004795191589323e-10, -3.977549011570920e-12,
  5.524504137322111e-14, -6.577075635850093e-16,  7.177733275487313e-18, -7.406018801865881e-20,  7.347745446132095e-22, -7.082036692435645e-24,  6.677149529654069e-26,
 -6.192303988226858e-28,  5.687561744581998e-30, -5.250198860343794e-32  };
  int offset = -6;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 6;
    if (std::isnan(t)) {
      fill_n(rr+offset, 6, 0.5);
      fill_n(ww+offset, 6, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 6; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=6; ++j) {
        const int boxof = it*72+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
