#ifndef BALL_STRUCTURE_BONDORDERS_BONDORDERASSIGNMENT_H
#define BALL_STRUCTURE_BONDORDERS_BONDORDERASSIGNMENT_H

#ifndef BALL_COMMON_GLOBAL_H
# include <BALL/COMMON/global.h>
#endif

#ifndef BALL_DATATYPE_HASHMAP_H
# include <BALL/DATATYPE/hashMap.h>
#endif

#ifndef BALL_STRUCTURE_BONDORDERS_PARTIALBONDORDERASSIGNMENT_H
# include <BALL/STRUCTURE/BONDORDERS/partialBondOrderAssignment.h>
#endif

namespace BALL
{
	class AssignBondOrderProcessor;
	class AtomContainer;
	class Atom;
	class Bond;

	/** \brief A solution to the bond order assignment problem.
	 *  
	 *  This class represents a full bond order assignment as it
	 *  is generated by the \link AssignBondOrderProcessor AssignBondOrderProcessor \endlink
	 *  through a \link BondOrderAssignmentStrategy BondOrderAssignmentStrategy \endlink.
	 * 
	 */
	class BALL_EXPORT BondOrderAssignment
		: public PartialBondOrderAssignment
	{
		friend class AssignBondOrderProcessor;

		public:
			// Default constructor
			BondOrderAssignment(AssignBondOrderProcessor* abop);

			// Destructor
			virtual ~BondOrderAssignment();

			// 
			void clear();

			/// Apply the solution to the AtomContainer
			bool apply();

			// 
			int getNumberOfNodeExpansions() const {return node_expansions;}

			//
			int getQueueSize() const {return queue_size;}

			// denotes whether the problem could be solved or not  
			bool valid;

			// the result : the set of bond orders for _ALL_ original bonds
			HashMap<Bond*, int> bond_order_map;

			// the result part2: the atoms with n additional hydrogens
			HashMap<Atom*, int> number_of_virtual_hydrogens;

			// the virtual atoms and bonds that should be deleted when the next 
			// solution is applied
			vector<Atom*> atoms_to_delete;
			//vector<Bond*> bonds_to_delete;

			float total_charge;
			int node_expansions;
			int queue_size;
			
			AtomContainer* ac;
	};
}
#endif // BALL_STRUCTURE_BONDORDERS_BONDORDERASSIGNMENT_H

