/*

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */
package org.apache.batik.apps.svgbrowser;

/**
 * Represents abstract undoable/redoable command. Concrete commands should
 * extend this class
 *
 * @version $Id: AbstractUndoableCommand.java 1733416 2016-03-03 07:07:13Z gadams $
 */
public abstract class AbstractUndoableCommand implements UndoableCommand {

    /**
     * The command name.
     */
    protected String name;

    public void execute() {
    }

    public void undo() {
    }

    public void redo() {
    }

    public String getName() {
        return name;
    }

    /**
     * Sets the command name.
     *
     * @param name
     *            Name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    public boolean shouldExecute() {
        return true;
    }
}
