/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.Serializable;

public class IntTable
implements Serializable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public IntTable() {
        this.table = new Entry[11];
    }

    public IntTable(int n) {
        this.table = new Entry[n];
    }

    public IntTable(IntTable intTable) {
        this.count = intTable.count;
        this.table = new Entry[intTable.table.length];
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = intTable.table[i];
            Entry entry2 = null;
            if (entry == null) continue;
            this.table[i] = entry2 = new Entry(entry.hash, entry.key, entry.value, null);
            entry = entry.next;
            while (entry != null) {
                entry2 = entry2.next = new Entry(entry.hash, entry.key, entry.value, null);
                entry = entry.next;
            }
        }
    }

    public int size() {
        return this.count;
    }

    protected Entry find(Object object) {
        return null;
    }

    public int get(Object object) {
        int n = object == null ? 0 : object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && (entry.key == null && object == null || entry.key != null && entry.key.equals(object))) {
                return entry.value;
            }
            entry = entry.next;
        }
        return 0;
    }

    public int put(Object object, int n) {
        int n2 = object == null ? 0 : object.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && (entry.key == null && object == null || entry.key != null && entry.key.equals(object))) {
                int n4 = entry.value;
                entry.value = n;
                return n4;
            }
            entry = entry.next;
        }
        int n5 = this.table.length;
        if (this.count++ >= n5 * 3 >>> 2) {
            this.rehash();
            n3 = n2 % this.table.length;
        }
        this.table[n3] = new Entry(n2, object, n, this.table[n3]);
        return 0;
    }

    public int inc(Object object) {
        int n = object == null ? 0 : object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && (entry.key == null && object == null || entry.key != null && entry.key.equals(object))) {
                return entry.value++;
            }
            entry = entry.next;
        }
        int n3 = this.table.length;
        if (this.count++ >= n3 * 3 >>> 2) {
            this.rehash();
            n2 = n % this.table.length;
        }
        this.table[n2] = new Entry(n, object, 1, this.table[n2]);
        return 0;
    }

    public int dec(Object object) {
        int n = object == null ? 0 : object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && (entry.key == null && object == null || entry.key != null && entry.key.equals(object))) {
                return entry.value--;
            }
            entry = entry.next;
        }
        int n3 = this.table.length;
        if (this.count++ >= n3 * 3 >>> 2) {
            this.rehash();
            n2 = n % this.table.length;
        }
        this.table[n2] = new Entry(n, object, -1, this.table[n2]);
        return 0;
    }

    public int remove(Object object) {
        int n = object == null ? 0 : object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = null;
        Entry entry2 = this.table[n2];
        while (entry2 != null) {
            if (entry2.hash == n && (entry2.key == null && object == null || entry2.key != null && entry2.key.equals(object))) {
                int n3 = entry2.value;
                if (entry == null) {
                    this.table[n2] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                --this.count;
                return n3;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        return 0;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.count = 0;
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i = entryArray.length - 1; i >= 0; --i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n = entry2.hash % this.table.length;
                entry2.next = this.table[n];
                this.table[n] = entry2;
            }
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public Object key;
        public int value;
        public Entry next;

        public Entry(int n, Object object, int n2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = n2;
            this.next = entry;
        }
    }
}

