/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.apache.batik.util.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSupport
implements XMLConstants {
    protected XMLSupport() {
    }

    public static String getXMLLang(Element element) {
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (attr != null) {
            return attr.getNodeValue();
        }
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1 || (attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang")) == null) continue;
            return attr.getNodeValue();
        }
        return "en";
    }

    public static String getXMLSpace(Element element) {
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space");
        if (attr != null) {
            return attr.getNodeValue();
        }
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1 || (attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space")) == null) continue;
            return attr.getNodeValue();
        }
        return "default";
    }

    public static String defaultXMLSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    bl = false;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    if (bl) continue block4;
                    stringBuffer.append(' ');
                    bl = true;
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                    bl = false;
                }
            }
        }
        return stringBuffer.toString().trim();
    }

    public static String preserveXMLSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuffer.append(' ');
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

