package bin;

import java.util.ArrayList;

import fileIO.ByteStreamWriter;
import ml.CellNet;
import shared.Tools;
import structures.ByteBuilder;
import structures.FloatList;
import tax.TaxTree;

public class Oracle implements Cloneable {

	public Oracle(float maxGCDif_, float maxDepthRatio_, float max3merDif_, float maxKmerDif_, float max5merDif_,
			float maxProduct_, float maxCovariance_, float minKmerProb_, int minEdgeWeight_) {
		maxGCDif0=maxGCDif_;
		maxDepthRatio0=maxDepthRatio_;
		maxTrimerDif0=max3merDif_;
		maxKmerDif0=maxKmerDif_;
		max5merDif0=max5merDif_;
		maxProduct0=maxProduct_;
		maxCovariance0=maxCovariance_;
		minEdgeWeight=minEdgeWeight_;
		stringency0=1;
		minKmerProb0=minKmerProb_;
		if(BinObject.net0small!=null) {networkSmall=BinObject.net0small.copy(false);}
		if(BinObject.net0mid!=null) {networkMid=BinObject.net0mid.copy(false);}
		if(BinObject.net0large!=null) {networkLarge=BinObject.net0large.copy(false);}
	}
	
	public Oracle(float stringency, int minEdgeWeight_) {
		maxTrimerDif0=Binner.maxTrimerDif2*stringency;
		maxKmerDif0=Binner.maxKmerDif2*stringency;
		max5merDif0=Binner.max5merDif2*stringency;
		maxDepthRatio0=1+((Binner.maxDepthRatio2-1)*stringency);
		maxGCDif0=Binner.maxGCDif2*stringency;
		maxProduct0=maxKmerDif0*maxDepthRatio0*Binner.productMult;
		maxCovariance0=Binner.maxCovariance2*stringency;
		minKmerProb0=Binner.minKmerProb2;
		minEdgeWeight=minEdgeWeight_;
		stringency0=stringency;
		if(BinObject.net0small!=null) {networkSmall=BinObject.net0small.copy(false);}
		if(BinObject.net0mid!=null) {networkMid=BinObject.net0mid.copy(false);}
		if(BinObject.net0large!=null) {networkLarge=BinObject.net0large.copy(false);}
	}
	
	void clear() {
		best=null;
		bestIdx=-1;
		score=topScore=-1;
	}
	
	/** Higher is more similar */
	static final float similarity(float ratio_, float gcDif_, 
			float simDif_, float covariance_, float kmerProb_, long edges_) {
		final float ratio=ratio_;
		final float gcDif=gcDif_+1f;
		final float simDif=simDif_*0.5f+1f;
		final float covariance=1+covariance_*32;
		float product=simDif*ratio*gcDif*covariance/kmerProb_;
		if(BinObject.verbose) {
			System.err.println(product+"="+simDif+"*"+ratio+"*"+gcDif+"*"+covariance+"/"+kmerProb_);
		}
		return 1f/product;
	}
	
	public final float similarity(Bin a, Bin b, float stringency0) {
		long size=Tools.min(a.size(), b.size());
		float sizeMult=Binner.sizeAdjustMult(size);
		float stringency=stringency0*sizeMult;

		if(a.maxDepth()==0 || b.maxDepth()==0) {
			stringency*=0.8f;//Has no effect...?  Maybe it will on coassemblies though.
		}
		float maxTrimerDif=maxTrimerDif0*stringency;
		float maxKmerDif=maxKmerDif0*stringency;
		float max5merDif=max5merDif0*stringency;
		float maxDepthRatio=1+((maxDepthRatio0-1)*stringency);
		float maxGCDif=maxGCDif0*stringency;
		float maxProduct=maxKmerDif*maxDepthRatio*Binner.productMult;
		maxProduct=Math.max(maxProduct, maxProduct0*sizeMult);
		float maxCovariance=maxCovariance0*stringency;
		float minProb=1-stringency0*(1-minKmerProb0);
		score=similarity(a, b, maxGCDif, maxDepthRatio, maxTrimerDif, maxKmerDif, max5merDif,
				maxProduct, maxCovariance, minProb);
		return score;
	}
	
	public static float edgeMult(long e1, long e2, long eT, float d1, float d2) {
		long minEdges=Tools.min(e1, e2);
		if(minEdges<Binner.minEdgeWeight) {return eT<Binner.minEdgeWeight ? 1f : Binner.goodTransEdgeMult;}
		long maxEdges=Tools.max(e1, e2);
		float depth=0.5f*(d1+d2);
		if(minEdges>Binner.lowDepthEdgeRatio*depth && maxEdges<Binner.highDepthEdgeRatio*depth) {
			return Binner.goodEdgeMult;
		}
		return eT<Binner.minEdgeWeight ? 1f : Binner.goodTransEdgeMult;
	}
	
	/** Higher is more similar */
	private final float similarity(Bin a, Bin b, float maxGCDif, float maxDepthRatio, float maxTrimerDif, 
			float maxKmerDif, float max5merDif, float maxProduct, float maxCovariance, float minKmerProb) {
//		if(bsw!=null) {return similarityB(a, b, maxGCDif, maxDepthRatio, maxKmerDif, maxProduct, maxCovariance);}
		fastComparisons++;
		
		if(BinObject.verbose || verbose2) {
			System.err.println("Comparing to "+b.id()+": "+
					"maxKmerDif="+maxKmerDif+", maxDepthRatio="+maxDepthRatio+
					", maxProduct="+maxProduct+", maxGCDif="+maxGCDif+
					", maxCovariance="+maxCovariance);
		}
		final boolean sameLabel=(a.labelTaxid>0 && a.labelTaxid==b.labelTaxid);
//		final boolean diffLabel=(a.labelTaxid<1 || a.labelTaxid!=b.labelTaxid);
		if(Binner.PERFECT_ORACLE) {return sameLabel ? 1-1f/b.size() : -1;}
		
		final float gcDif=Math.abs(a.gc()-b.gc());
		final float depthRatio=a.depthRatio(b);
		final long minlen=Math.min(a.size(), b.size());
		if(BinObject.verbose || verbose2) {
			System.err.println("gcdif="+gcDif);
			System.err.println("depthRatio="+depthRatio);
		}
		if(gcDif>maxGCDif*Binner.goodEdgeMult || 
				depthRatio>maxDepthRatio*Binner.goodEdgeMult) {
			return -1;
		}//Early exit before edge-tracking
		
		final long edges1=useEdges ? a.countEdgesTo(b) : 0;
		final long edges2=useEdges ? b.countEdgesTo(a) : 0;
		final long minEdges=Tools.min(edges1, edges2);
		if(BinObject.verbose || verbose2) {
			System.err.println("A: size="+minlen+", e1="+edges1+", e2="+edges2+", minWeight="+minEdgeWeight);
		}
		final long edgesT=(minEdges>=Binner.minEdgeWeight ? minEdges : a.transEdgesTo(b));
//		if(minEdges<1 && minlen<3000) {
//			return -1;
//		}//Doesn't help or even do much at minlen=3000
		float mult=edgeMult(edges1, edges2, edgesT, a.depthTotal(), b.depthTotal());
//		mult*=Math.sqrt(Binner.sizeAdjustMult(minlen));
//		if(minlen<3000) {mult*=0.0f;return -1;}
		
		if(BinObject.verbose || verbose2) {System.err.println("B: mult="+mult+", gcdif="+gcDif+", max="+(maxGCDif*mult));}
		if(gcDif>maxGCDif*mult*Binner.cutoffMultD) {return -1;}
		float covariance=a.covariance(b);
		if(BinObject.verbose || verbose2) {
			System.err.println("C: depthRatio="+depthRatio+", max="+(maxDepthRatio*mult)+
					", covariance="+covariance+", max="+(maxCovariance*mult));
		}
		if(gcDif>maxGCDif*mult*Binner.cutoffMultD || depthRatio>maxDepthRatio*mult*Binner.cutoffMultD || 
				covariance>maxCovariance*mult*Binner.cutoffMultD) {return -1;}
		if(!taxaOK(a.taxid(), b.taxid())) {return -1;}
		
		slowComparisons++;
		float tetramerDif=SimilarityMeasures.cosineDifference(a.tetramers, b.tetramers);
		float trimerDif=(SpectraCounter.countTrimers ? 
				SimilarityMeasures.cosineDifference(a.trimers, b.trimers) : 0);
		float pentamerDif=(a.numPentamers<BinObject.minPentamerSizeCompare ||
				b.numPentamers<BinObject.minPentamerSizeCompare ? 0 :
					SimilarityMeasures.cosineDifference(a.pentamers, b.pentamers));
//					SimilarityMeasures.euclideanDistance(a.pentamers, b.pentamers));
		final float product=tetramerDif*depthRatio;
		float kmerProb=KmerProb.prob(minlen, tetramerDif);
		kmerProb=1-(1-kmerProb)/mult;
		if(BinObject.verbose || verbose2) {
			System.err.println("D: kmerDif="+tetramerDif+", max="+(maxKmerDif*mult)+
					", product="+product+", max="+(maxProduct*mult));
		}
		
		if(tetramerDif>maxKmerDif*mult*Binner.cutoffMultA || trimerDif>maxTrimerDif*mult*Binner.cutoffMultA || 
				pentamerDif>max5merDif*mult*Binner.cutoffMultA || product>maxProduct*mult*Binner.cutoffMultB || 
				kmerProb<0.5f) {
			return -1;
		}
		
		final float similarity=similarity(depthRatio, gcDif, tetramerDif, covariance, kmerProb, Tools.min(edges1, edges2));
		final float netOutput=runNetwork(a, b, minEdges, edgesT, gcDif, depthRatio, covariance, tetramerDif, trimerDif, similarity, false);
		
		if(BinObject.verbose || verbose2) {
			System.err.println("E: similarity="+similarity+", netOutput="+netOutput);
		}
		
		CellNet network=getNetwork(minlen);
		float mult2=mult;
		if(network!=null) {
			netComparisons++;
//			if(netOutput<network.cutoff) {
////				return -1;
//				mult*=Binner.netMultLower;
//			}else 
			if(netOutput>Binner.netCutoffUpper) {
				mult2*=Binner.netMultUpper;
//				return netOutput;
			}else if(netOutput<Binner.netCutoffLower) {
				mult2*=Binner.netMultLower;
			}
			float ratio=netOutput/network.cutoff;
//			kmerDif=kmerDif*network.cutoff/netOutput;
			mult2=(float)(mult2*ratio*ratio);
		}
		if(BinObject.verbose || verbose2) {
			System.err.println("F: mult="+mult+", kmerDif="+tetramerDif+", max="+(maxKmerDif*mult)+
					", product="+product+", max="+(maxProduct*mult)+
					"\n   kmerProb="+kmerProb+", min="+(minKmerProb));
		}
		
		float ret=netOutput;
		if(trimerDif>maxTrimerDif*mult2 || tetramerDif>maxKmerDif*mult2 || pentamerDif>max5merDif*mult2 || 
				product>maxProduct*mult2 || kmerProb<minKmerProb) {ret=-1;}

		float mult3=(network==null ? mult : mult2*Binner.cutoffMultC);
		if(gcDif>maxGCDif*mult3 || depthRatio>maxDepthRatio*mult3 || covariance>maxCovariance*mult3) {ret=-1;}
		
		if(bsw!=null && canEmitVector(a, b, ret)) {
			if(sameLabel || Math.random()<=negativeEmitProb) {
				emitVector(a, b, bsw);
			}
		}
		
		if(Binner.BAN_BAD_MERGES && !sameLabel) {ret=-1;}
		return ret;
	}
	
	final float runNetwork(Bin a, Bin b, final long minEdges, final long transEdges, final float gcDif, 
			final float depthRatio, final float covariance, final float kmerDif, final float trimerDif,
			final float similarity, boolean includeAnswer) {
		CellNet network=getNetwork(Math.min(a.size(), b.size()));
		if(network==null) {return similarity;}
		if(vector==null) {vector=new FloatList();}
		toVector(a, b, minEdges, transEdges, gcDif, depthRatio,
				covariance, kmerDif, trimerDif, similarity, vector, false);
		network.applyInput(vector);
		float result=network.feedForward();
		return result;
	}
	
	static String header() {
		ByteBuilder bb=new ByteBuilder();
//		bb.append('#').append("aSize").tab().append("bSize");//0 1
//		bb.tab().append("aGC").tab().append("bGC");//2 3
//		bb.tab().append("gcDif");//4
//		bb.tab().append("depthRatio").tab().append("covariance");//5 6
//		bb.tab().append("aDepth").tab().append("bDepth");//7 8
//		bb.tab().append("numDepth").tab().append("kmerDif");//9 10
//		bb.tab().append("aEntrop").tab().append("bEntrop");//11 12
//		bb.tab().append("entDif");//13
//		bb.tab().append("aSpec").tab().append("bSpec");//14 15
//		bb.tab().append("specDif");//16
//		bb.tab().append("aContigs").tab().append("bContigs");//17 18
//		bb.tab().append("aEdgeW").tab().append("bEdgeW");//19 20
//		bb.tab().append("aEdges").tab().append("bEdges");//21 22
//		bb.tab().append("similarity");//23
//		bb.tab().append("sameTax");//24
		

		bb.append('#').append("aSize");//0
		bb.tab().append("bGC");//1
		bb.tab().append("gcDif");//2
		bb.tab().append("depthRatio").tab().append("covariance");//3 4
		bb.tab().append("bDepth");//5
		bb.tab().append("numDepth").tab().append("kmerDif");//6 7
		bb.tab().append("bEntrop");//8
		bb.tab().append("entDif");//9
		bb.tab().append("bSpec");//10
		bb.tab().append("specDif");//11
		bb.tab().append("minEdge");//12
		bb.tab().append("similarity");//13
		bb.tab().append("sameTax");//14
		
		return bb.toString();
	}
	
	FloatList toVector(Bin a, Bin b, FloatList list, boolean includeAnswer) {
		if(a.size()>b.size()) {return toVector(b, a, list, includeAnswer);}
		if(list==null) {list=new FloatList();}
		list.clear();
		long edges1=a.countEdgesTo(b);
		long edges2=b.countEdgesTo(a);
		long minEdges=Tools.min(edges1, edges2);
		final long edgesT=(minEdges>=Binner.minEdgeWeight ? minEdges : a.transEdgesTo(b));
		float gcDif=Math.abs(a.gc()-b.gc());
		float depthRatio=a.depthRatio(b);
		float covariance=a.covariance(b);
		float kmerDif=SimilarityMeasures.calculateDifferenceAverage(a.tetramers, b.tetramers);
		float trimerDif=(SpectraCounter.countTrimers ? 
				SimilarityMeasures.calculateDifferenceAverage(a.trimers, b.trimers) : 0f);
		
		long minlen=Math.min(a.size(), b.size());
		final float kmerProb=KmerProb.prob(minlen, kmerDif);
		float similarity=similarity(depthRatio, gcDif, kmerDif, covariance, kmerProb, Tools.min(edges1, edges2));
		
		return toVector(a, b, minEdges, edgesT, gcDif, depthRatio, covariance, kmerDif, trimerDif, similarity, list, includeAnswer);
	}
	
	FloatList toVector(Bin a, Bin b, final long minEdges, final long transEdges, final float gcDif, final float depthRatio,
			final float covariance, final float kmerDif, final float trimerDif, final float similarity,
			FloatList list, boolean includeAnswer) {
		if(a.size()>b.size()) {
			return toVector(b, a, minEdges, transEdges, gcDif, depthRatio, covariance, kmerDif, trimerDif, similarity, list, includeAnswer);
		}
		if(list==null) {list=new FloatList();}
		list.clear();
		float depth=0.5f*(a.depthTotal()+b.depthTotal()+0.5f);
		
		long minlen=Math.min(a.size(), b.size());
//		final float kmerProb=KmerProb.prob(minlen, kmerDif);
		
//		list.add(a.size());//-1
		if(printSizeInVector) {
			list.add(a.size());
			list.add(a.numContigs());
			list.add(b.size());
			list.add(b.numContigs());
		}
		list.add(0.1f*(float)Tools.log2(Tools.max(1, a.size()-64)));//0
//		list.add(0.1f*(float)Tools.log2(b.size()));
//		list.add(a.gc());
		list.add(b.gc());//1
		list.add(gcDif);//2
		list.add(kmerDif<0 || !Float.isFinite(kmerDif) ? 0 : kmerDif);//3
		list.add(trimerDif<0 || !Float.isFinite(trimerDif) ? 0 : trimerDif);//4
		list.add((float)(minEdges/depth));//5
		list.add((float)(transEdges/depth));//6
		list.add((float)(0.5f*Tools.log2(depthRatio)));//7
		list.add(covariance<0 || !Float.isFinite(covariance) ? 0 : (float)Math.sqrt(covariance));//8
//		list.add((float)(0.1f*Tools.log2(1+a.depthTotal())));
		list.add((float)(0.1f*Tools.log2(1+b.depthTotal())));//9
		list.add(a.numDepths()>1 ? 1 : 0);//10
		list.add(a.numDepths()>2 ? 1 : 0);//11
		list.add(a.numDepths()>3 ? 1 : 0);//12
		list.add(a.numDepths()>4 ? (0.2f*(a.numDepths()-4)) : 0);//13
//		list.add(a.entropy);
		list.add(8*(1-b.entropy));//14
		list.add(8*Tools.absdif(a.entropy, b.entropy));//15
//		list.add(a.strandedness-1);
		list.add(b.strandedness);//16
		list.add(8*Tools.absdif(a.strandedness, b.strandedness));//17
//		list.add((float)(0.5f*Tools.log2(a.numContigs())));
//		list.add((float)(0.5f*Tools.log2(b.numContigs())));
//		list.add(edges1/depth);
//		list.add(edges2/depth);
//		list.add(0.1f*a.numEdges()/(float)(Tools.max(b.numContigs(), 1)));
//		list.add(0.1f*b.numEdges()/(float)(Tools.max(b.numContigs(), 1)));
		list.add(1-similarity);//18
		if(includeAnswer) {
			assert(a.labelTaxid>0 && b.labelTaxid>0) : a.labelTaxid+", "+b.labelTaxid+", "+a.name();
			list.add(a.labelTaxid==b.labelTaxid ? 1 : 0);
		}
		list.shrink();
		for(float f : list.array) {
			assert(Float.isFinite(f)) : list;
		}
		return list;
	}
	
	private boolean taxaOK(int aTaxid, int bTaxid) {
		if(!allowHalfTaxID && (aTaxid<1 || bTaxid<1)) {return false;}
		if(!allowNoTaxID && aTaxid<1 && bTaxid<1) {return false;}
		if(taxlevel<0 || BinObject.tree==null || aTaxid==bTaxid || aTaxid<1 || bTaxid<1) {return true;}
		int commonAncestorLevel=BinObject.tree.commonAncestorLevel(aTaxid, bTaxid);
		return (commonAncestorLevel<=taxlevel);
	}
	
	
	protected Oracle clone() {
		try {
			Oracle clone=(Oracle) super.clone();
			clone.best=null;
			clone.vector=null;
			clone.networkSmall=(networkSmall==null ? null : networkSmall.copy(false));
			clone.networkMid=(networkMid==null ? null : networkMid.copy(false));
			clone.networkLarge=(networkLarge==null ? null : networkLarge.copy(false));
			return clone;
		} catch (CloneNotSupportedException e) {
			throw new RuntimeException(e);
		}
	}
	
	static boolean canEmitVector(Bin a, Bin b, float result) {
		long minSize=Math.min(a.size(), b.size());
		if(a.labelTaxid<1 || b.labelTaxid<1) {return false;}
		if(minSize<minEmitSize || minSize>maxEmitSize) {return false;}
		if(!a.pure() || !b.pure()) {return false;}
		boolean sameTID=(a.labelTaxid==b.labelTaxid);
		boolean merge=(result>0);
		final boolean ret;
		if(merge) {ret=(sameTID ? emitTP : emitFP);}
		else{ret=(sameTID ? emitFN : emitFP);}
//		assert(!ret) : result+", "+merge+", "+sameTID+", "+minSize;
		return ret;
	}
	
	void emitVector(Bin a, Bin b, ByteStreamWriter bsw) {
		assert(bsw!=null);
		long minlen=Tools.min(a.size(), b.size());
		float prob=(minlen/4000f)*(minlen/2000f);
		if(Math.random()>prob) {return;}
		if(vector==null) {vector=new FloatList();}
		toVector(a, b, vector, true);
		emitVector(vector, bsw);
	}
	
	static void emitVector(FloatList vector, ByteStreamWriter bsw) {
		assert(bsw!=null);
		ByteBuilder bb=new ByteBuilder();
		for(int i=0; i<vector.size(); i++) {
			if(i>0) {bb.tab();}
			bb.append(vector.get(i), 7, true);
		}
		synchronized(bsw) {
			bsw.print(bb.nl());
		}
	}
	
	private CellNet getNetwork(long size) {
		if(size<Binner.minNetSize) {return null;}
		if(size<Binner.midNetSize) {return networkSmall;}
		if(size<Binner.largeNetSize) {return networkMid;}
		return networkLarge;
	}
	
	Bin best=null;
	float score=-1;
	float topScore=-1;
	int bestIdx=-1;
	
	long fastComparisons=0;
	long slowComparisons=0;
	long netComparisons=0;

	final float maxTrimerDif0;
	final float maxKmerDif0;
	final float max5merDif0;
	final float maxDepthRatio0;
	final float maxGCDif0;
	final float maxProduct0;
	final float maxCovariance0;
	final float minKmerProb0;
	final int minEdgeWeight;
	
	final float stringency0;
	private FloatList vector;
	private CellNet networkSmall;
	private CellNet networkMid;
	private CellNet networkLarge;
	
	int taxlevel=TaxTree.SPECIES;
	boolean allowNoTaxID=true;
	boolean allowHalfTaxID=true;
	boolean useEdges=true;
	
	static ByteStreamWriter bsw;
	static boolean emitTP=true;
	static boolean emitFP=true;
	static boolean emitTN=true;
	static boolean emitFN=true;
	static int minEmitSize=0;
	static int maxEmitSize=2000000000;
	static double negativeEmitProb=1;
	static boolean printSizeInVector=false;
	boolean verbose2=false;
	
	
}
