/* $Id: stringhandling.h 1342 2012-02-10 18:34:09Z dreibh $
 *
 * BibTeX Converter
 * Copyright (C) 2010-2012 by Thomas Dreibholz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: dreibh@iem.uni-due.de
 */

#ifndef STRINGHANDLING_H
#define STRINGHANDLING_H

#include <stdarg.h>
#include <string>


std::string string2utf8(const std::string& string,
                        const std::string& nbsp = " ",
                        const bool         xmlStyle = false);

inline std::string string2xml(const std::string& string) {
   return(string2utf8(string, "&#160;", true));
}

std::string& removeBrackets(std::string& string);
std::string& trim(std::string& string);
std::string extractToken(std::string& string, const std::string& delimiters);
std::string processBackslash(const std::string& string);
std::string laTeXtoURL(const std::string& str);
std::string urlToLaTeX(const std::string& str);
std::string format(const char* fmt, ...);

#endif
