-- -----------------------------------------------------
-- Table bw_user
-- -----------------------------------------------------
* present ~
SELECT count(*) FROM information_schema.system_tables
WHERE table_schem='PUBLIC' AND table_name='BW_USER';
* if (*present == 0)
	CREATE TABLE bw_user (
	  iduser INT GENERATED BY DEFAULT AS IDENTITY,
	  login VARCHAR(45) NULL ,
	  password VARCHAR(45) NULL ,
	  auth_type VARCHAR(45) NULL ,
	  auth_key VARCHAR(128) NULL ,
	  mail_address VARCHAR(128) NULL ,
	  PRIMARY KEY (iduser) ,
	  CONSTRAINT uniqueLogin UNIQUE (login));
* end if


-- -----------------------------------------------------
-- Table bw_group
-- -----------------------------------------------------
* present ~
SELECT count(*) FROM information_schema.system_tables
WHERE table_schem='PUBLIC' AND table_name='BW_GROUP';
* if (*present == 0)
	CREATE TABLE bw_group (
	  idgroup INT GENERATED BY DEFAULT AS IDENTITY,
	  name VARCHAR(45) NULL ,
	  PRIMARY KEY (idgroup) ,
	  CONSTRAINT uniqueGroup UNIQUE (name));
* end if

-- -----------------------------------------------------
-- Table bw_user_has_group
-- -----------------------------------------------------
* present ~
SELECT count(*) FROM information_schema.system_tables
WHERE table_schem='PUBLIC' AND table_name='BW_USER_HAS_GROUP';
* if (*present == 0)
	CREATE TABLE bw_user_has_group (
	  iduser_has_group INT GENERATED BY DEFAULT AS IDENTITY,
	  ref_iduser INT NOT NULL ,
	  ref_idgroup INT NOT NULL ,
	  PRIMARY KEY (iduser_has_group) ,
	  CONSTRAINT fk_user_has_group_user1
	    FOREIGN KEY (ref_iduser )
	    REFERENCES bw_user (iduser )
	    ON DELETE NO ACTION
	    ON UPDATE NO ACTION,
	  CONSTRAINT fk_user_has_group_group1
	    FOREIGN KEY (ref_idgroup )
	    REFERENCES bw_group (idgroup )
	    ON DELETE NO ACTION
	    ON UPDATE NO ACTION);
* end if


-- -----------------------------------------------------
-- Table schema_version
-- -----------------------------------------------------
* present ~
SELECT count(*) FROM information_schema.system_tables
WHERE table_schem='PUBLIC' AND table_name='SCHEMA_VERSION';
* if (*present == 0)
	CREATE TABLE schema_version (
	  idschema_version INT GENERATED BY DEFAULT AS IDENTITY,
	  version VARCHAR(45) NULL ,
	  PRIMARY KEY (idschema_version));
* end if

