/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-22 20:09
 */
 
#include "PieceRequest.h"

CPieceRequest::CPieceRequest()
{
}

CPieceRequest::~CPieceRequest()
{
}

void CPieceRequest::alloc(unsigned int pieceIndex, unsigned int pieceLength, unsigned int maxRequestLength)
{
	_pieceIndex = pieceIndex;
	_pieceLength = pieceLength;
	_requestList.clear();
	
	unsigned int left = pieceLength;
	for(;left>0;)
	{
		int requestLength;
		if(left > maxRequestLength)
		{
			requestLength = maxRequestLength;
		}
		else
		{
			requestLength = left;
		}
		
		TRequest request;
		request.offset = pieceLength - left;
		request.length = requestLength;
		request.requested = false;
		request.data.clear();
		
		_requestList.push_back(request);
		
		left -= requestLength;
	}
	
}

unsigned int CPieceRequest::getPieceIndex()
{
	return _pieceIndex;
}

bool CPieceRequest::complete()
{
	TRequestList::iterator iter = _requestList.begin();
	for(; iter!= _requestList.end(); ++iter)
	{
		if(iter->data.size() != iter->length)
		{
			return false;
		}
	}
	
	return true;
}

std::string CPieceRequest::getPiece()
{
	if(!complete())
	{
		return "";
	}
	
	std::string result;
	TRequestList::iterator iter = _requestList.begin();
	for(; iter!= _requestList.end(); ++iter)
	{
		result += iter->data;
	}
	
	return result;	
}

bool CPieceRequest::getRequest(unsigned int& pieceIndex, unsigned int& offset, unsigned int& length)
{
	TRequestList::iterator iter = _requestList.begin();
	for(; iter!= _requestList.end(); ++iter)
	{
		if(!iter->requested
			&& iter->data.size() == 0)
		{
			pieceIndex = _pieceIndex;
			offset = iter->offset;
			length = iter->length;
			iter->requested = true;
			return true;
		}
	}	
	
	return false;
}

bool CPieceRequest::addPieceData(unsigned int offset, const char* data, size_t length)
{
	TRequestList::iterator iter = _requestList.begin();
	for(; iter!= _requestList.end(); ++iter)
	{
		if(iter->requested
			&& iter->offset == offset
			&& iter->length == length)
		{
			iter->data.clear();
			iter->data.append(data, length);
			return true;
		}	
	}
	
	return false;
}

unsigned int CPieceRequest::getPendingCount()
{
	unsigned int count = 0;
	
	TRequestList::iterator iter = _requestList.begin();
	for(; iter!= _requestList.end(); ++iter)
	{
		if(iter->requested
			&& iter->data.size() == 0)
		{
			count++;
		}	
	}
	
	return count;
}

bool CPieceRequest::cancelPendingRequest(unsigned int& pieceIndex, unsigned int& offset, unsigned int& length)
{
	TRequestList::iterator iter = _requestList.begin();
	for(; iter!= _requestList.end(); ++iter)
	{
		if(iter->requested
			&& iter->data.size() == 0)
		{
			pieceIndex = _pieceIndex;
			offset = iter->offset;
			length = iter->length;
			
			_requestList.erase(iter);
			
			return true;
		}	
	}
	
	return false;	
}


unsigned int  CPieceRequest::getPieceLength()
{
	return _pieceLength;
}

void CPieceRequest::clearRequest()
{
	TRequestList::iterator iter = _requestList.begin();
	for(; iter!= _requestList.end(); ++iter)
	{
		if(iter->requested
			&& iter->data.size() == 0)
		{
			iter->requested = false;
		}	
	}	
}

