/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-07 20:09
 */

#ifndef TCPTRACKER_H_
#define TCPTRACKER_H_

#include <string>
#include <pthread.h>
#include "BitStorm.h"

class CTCPTracker : public ITracker
{
public:
	CTCPTracker();
	virtual ~CTCPTracker();
private:
	std::string _url;
	std::string _tracker_response;
	TTrackerState _state;
	std::string _state_str;	
	
	unsigned int _complete_peer;
	unsigned int _total_peer;
	unsigned int _interval;
	unsigned int _nextUpdateTick;
	ITrackerManager* _trackerManager;
	
	TTrackerEvent _currentEvent;
	bool _startEventSend;
	bool _completeEventSend;
private:
	TTrackerEvent getCurrentEvent();
	std::string makeTrackerUrl(const char* event);	
	const char* event2Str(TTrackerEvent event);
	void parseResponse();
public:
	void addResponse(std::string content);	
public:
	void setTrackerManager(ITrackerManager* trackerManager);
	bool isProtocolSupported(const char* protocolName);
	void setUrl(const char* url);
	void update();
	void stop();
	TTrackerState getState();
	const std::string& getStateStr();
	unsigned int getSeedCount();
	unsigned int getPeerCount();	
	unsigned int getInterval();
	unsigned int getNextUpdateTick();

};

#endif /*TCPTRACKER_H_*/
