/*
 * Copyright 2011, Blender Foundation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contributor: Peter Schlaile
 *		Jeroen Bakker 
 *		Monique Dewanchand
 */

#include "COM_InpaintNode.h"
#include "DNA_scene_types.h"
#include "COM_ExecutionSystem.h"
#include "COM_InpaintOperation.h"
#include "BLI_math.h"

InpaintNode::InpaintNode(bNode *editorNode) : Node(editorNode)
{
	/* pass */
}

void InpaintNode::convertToOperations(ExecutionSystem *graph, CompositorContext *context)
{
	
	bNode *editorNode = this->getbNode();

	/* if (editorNode->custom1 == CMP_NODE_INPAINT_SIMPLE) { */
	if (true) {
		InpaintSimpleOperation *operation = new InpaintSimpleOperation();
		operation->setbNode(editorNode);
		operation->setIterations(editorNode->custom2);
		this->getInputSocket(0)->relinkConnections(operation->getInputSocket(0), 0, graph);
		this->getOutputSocket(0)->relinkConnections(operation->getOutputSocket(0));
		graph->addOperation(operation);
	}
}
