# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from os.path import isfile, join

try:
    from dbus import SessionBus as dbus_session, Interface as dbus_interface
    from dbus.exceptions import DBusException
    dbus_imported = True
except:
    dbus_imported = False

class GnomeMultimediaKeys(object):
    def __init__(self, extensions):
        gnome_keybinding = join('usr', 'bin', 'gnome-keybinding-properties')

        # Start only if dbus is properly imported and gnome-keybinding detected
        if dbus_imported and isfile(gnome_keybinding):
            try:
                bus = dbus_session()
                application = 'bluemindo'

                def on_dbus_key(app, key):
                    if app == application:
                        if key in ('Play', 'PlayPause'):
                            extensions.load_event('OnPlayPressed')
                        elif key == 'Next':
                            extensions.load_event('OnNextPressed')
                        elif key == 'Previous':
                            extensions.load_event('OnPreviousPressed')
                        elif key == 'Stop':
                            extensions.load_event('OnStopPressed')
 
                # Old GNOME API
                try:
                    obj = bus.get_object('org.g.SettingsDaemon',
                                         '/org/gnome/SettingsDaemon')
                    dbi = dbus_interface(obj, 'org.gnome.SettingsDaemon')
 
                    dbi.GrabMediaPlayerKeys(application, 0)
                    dbi.connect_to_signal('MediaPlayerKeyPressed', on_dbus_key)
 
                # Newer GNOME API
                except DBusException:
                    obj = bus.get_object('org.gnome.SettingsDaemon',
                                         '/org/gnome/SettingsDaemon/MediaKeys')
                    dbi = dbus_interface(obj,
                                         'org.gnome.SettingsDaemon.MediaKeys')
 
                    dbi.GrabMediaPlayerKeys(application, 0)
                    dbi.connect_to_signal('MediaPlayerKeyPressed', on_dbus_key)
 
            except DBusException, error:
                print ('\nDBus error!\nThis error is related to GNOME '
                       'multimedia keys and can be ignored if you do not want '
                       'to use them.\n-----------\n%s' % error)